/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.sax.delegates;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.SAXOutputter;
import com.elixirtech.sax.IBaseSAXOut;
import com.elixirtech.sax.ISAXOut;
import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class BaseDocumentSAXOut
implements IBaseSAXOut {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BaseDocumentSAXOut.class);

    @Override
    public String getTagName() {
        return "document";
    }

    @Override
    public void output(ISAXOut iSAXOut, Object object) {
        this.output(iSAXOut, object, this.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, Object object, String string) {
        AttributesImpl attributesImpl = new AttributesImpl();
        iSAXOut.startElement(string, attributesImpl);
        Document document = (Document)object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.add(document.getRootElement());
        SAXOutputter sAXOutputter = new SAXOutputter();
        sAXOutputter.setContentHandler(new Filter(iSAXOut.getContentHandler()));
        try {
            sAXOutputter.output(arrayList);
        }
        catch (JDOMException jDOMException) {
            m_Log.error((Object)("Can't write document: " + jDOMException), (Throwable)jDOMException);
        }
        iSAXOut.endElement(string);
    }

    private static class Filter
    implements ContentHandler {
        private ContentHandler m_Delegate;

        public Filter(ContentHandler contentHandler) {
            this.m_Delegate = contentHandler;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.m_Delegate.characters(cArray, n, n2);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.m_Delegate.endElement(string, string2, string3);
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
            this.m_Delegate.endPrefixMapping(string);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.m_Delegate.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
            this.m_Delegate.processingInstruction(string, string2);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.m_Delegate.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
            this.m_Delegate.skippedEntity(string);
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.m_Delegate.startElement(string, string2, string3, attributes);
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.m_Delegate.startPrefixMapping(string, string2);
        }
    }
}

