/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.scm;

import com.elixirtech.scm.Pair;
import com.elixirtech.scm.Primitive;
import com.elixirtech.scm.Procedure;
import com.elixirtech.scm.SchemeUtils;

public class Environment
extends SchemeUtils {
    public Object vars;
    public Object vals;
    public Environment parent;

    public Environment(Object object, Object object2, Environment environment) {
        this.vars = object;
        this.vals = object2;
        this.parent = environment;
        if (!this.numberArgsOK(object, object2)) {
            Environment.warn("wrong number of arguments: expected " + object + " got " + object2);
        }
    }

    public Environment() {
    }

    public Object lookup(String string) {
        Object object = this.vars;
        Object object2 = this.vals;
        while (object != null) {
            if (Environment.first(object) == string) {
                return Environment.first(object2);
            }
            if (object == string) {
                return object2;
            }
            object = Environment.rest(object);
            object2 = Environment.rest(object2);
        }
        if (this.parent != null) {
            return this.parent.lookup(string);
        }
        return Environment.error("Unbound variable: " + string);
    }

    public Object define(Object object, Object object2) {
        this.vars = Environment.cons(object, this.vars);
        this.vals = Environment.cons(object2, this.vals);
        if (object2 instanceof Procedure && ((Procedure)object2).name.equals("anonymous procedure")) {
            ((Procedure)object2).name = object.toString();
        }
        return object;
    }

    public Object set(Object object, Object object2) {
        if (!(object instanceof String)) {
            return Environment.error("Attempt to set a non-symbol: " + Environment.stringify(object));
        }
        String string = (String)object;
        Object object3 = this.vars;
        Object object4 = this.vals;
        while (object3 != null) {
            if (Environment.first(object3) == string) {
                return Environment.setFirst(object4, object2);
            }
            if (Environment.rest(object3) == string) {
                return Environment.setRest(object4, object2);
            }
            object3 = Environment.rest(object3);
            object4 = Environment.rest(object4);
        }
        if (this.parent != null) {
            return this.parent.set(string, object2);
        }
        return Environment.error("Unbound variable: " + string);
    }

    public Environment defPrim(String string, int n, int n2) {
        this.define(string, new Primitive(n, n2, n2));
        return this;
    }

    public Environment defPrim(String string, int n, int n2, int n3) {
        this.define(string, new Primitive(n, n2, n3));
        return this;
    }

    boolean numberArgsOK(Object object, Object object2) {
        return object == null && object2 == null || object instanceof String || object instanceof Pair && object2 instanceof Pair && this.numberArgsOK(((Pair)object).rest, ((Pair)object2).rest);
    }
}

