/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.svg;

import com.elixirtech.arch.Elixir;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.svg.SVGDocument;

public class ElxSVGFactory
extends SAXSVGDocumentFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVGDocument buildFromURI(String string) throws IOException {
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(ElxSVGFactory.getParser());
        if (string.startsWith("repository:")) {
            RMLRepository rMLRepository = (RMLRepository)Elixir.get(RMLRepository.class);
            RMLFileObject rMLFileObject = rMLRepository.getFileJ(string.substring(11));
            if (rMLFileObject == null) {
                throw new IOException("Can't read " + string);
            }
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(rMLFileObject.getInputStream());){
                SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument(string, (InputStream)bufferedInputStream);
                return sVGDocument;
            }
        }
        return sAXSVGDocumentFactory.createSVGDocument(string);
    }

    public static SVGDocument buildFromJDOM(Document document) throws IOException, JDOMException {
        XMLOutputter xMLOutputter = new XMLOutputter();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xMLOutputter.output(document, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString(StandardCharsets.UTF_8).replace("xmlns=\"\" ", "");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
        SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(ElxSVGFactory.getParser());
        return sAXSVGDocumentFactory.createSVGDocument("", (InputStream)byteArrayInputStream);
    }

    public ElxSVGFactory() {
        super(ElxSVGFactory.getParser());
        this.setValidating(false);
    }

    public SVGDocument getDocument() {
        SVGDocument sVGDocument = (SVGDocument)this.document;
        this.document = null;
        return sVGDocument;
    }

    private static String getParser() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }
}

