/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.tree.CellStructure;
import com.elixirtech.tree.TreeLayoutManager;
import com.elixirtech.tree.TreeModel;
import com.elixirtech.tree.TreeModelUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Iterator;
import javax.swing.JComponent;

public class HierarchicalTreeLayoutManager
extends TreeLayoutManager {
    private final TreeModel m_Model;
    private final int m_Direction;
    private final boolean m_TotalsAfter;

    public HierarchicalTreeLayoutManager(TreeModel treeModel, int n, boolean bl) {
        this.m_Model = treeModel;
        this.m_Direction = n;
        this.m_TotalsAfter = bl;
    }

    @Override
    protected void buildCellStructure(Container container) {
        Dimension dimension = TreeModelUtil.calcHorizontalCellStructureSize(this.m_Model);
        Dimension dimension2 = new Dimension(dimension.width, dimension.height);
        if (this.m_Direction == 1) {
            int n = this.m_Model.getMeasureCount();
            dimension2.width *= n;
            ++dimension2.height;
        } else {
            HierarchicalTreeLayoutManager.swapAxes(dimension);
            HierarchicalTreeLayoutManager.swapAxes(dimension2);
        }
        this.setupFixedWidths(dimension2);
        this.m_CellStructure = new CellStructure(new TreeCellModel(), dimension2.width, dimension2.height);
        if (this.m_Direction == 1) {
            this.buildHorizontalCellStructure(container, this.m_Model.getRoot(), 0, 0);
        } else {
            this.buildVerticalCellStructure(container, this.m_Model.getRoot(), 0, 0);
        }
    }

    private int buildHorizontalCellStructure(Container container, Object object, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("row<0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("col<0: " + n2);
        }
        int n3 = n++;
        int n4 = n2;
        CellStructure.Cell cell = this.m_CellStructure.addCell(n3, n4, object);
        boolean bl = this.m_Model.isShowTotals(object);
        int n5 = this.m_Model.getMeasureCount();
        int n6 = n2;
        if (bl && !this.m_TotalsAfter) {
            n2 += n5;
        }
        int n7 = n2;
        if (this.m_Model.hasChildren(object) && this.m_Model.isExpanded(object)) {
            for (Object object2 : this.m_Model.getChildren(object)) {
                n2 = this.buildHorizontalCellStructure(container, object2, n, n2);
                n7 = Math.max(n7, n2);
            }
            n2 = n7;
        }
        if (bl && this.m_TotalsAfter) {
            n6 = n2;
            n2 += n5;
        }
        if (bl) {
            int n8 = this.m_CellStructure.getRowCount() - 1;
            for (Object object2 : this.m_Model.getMeasures(object)) {
                this.m_CellStructure.addCell(n8, n6++, object2);
                if (container == null) continue;
                container.add(this.m_Model.getComponent(object2));
            }
        }
        cell.colSpan = n2 - n4;
        if (container != null) {
            container.add(this.m_Model.getComponent(object));
        }
        return n2;
    }

    private int buildVerticalCellStructure(Container container, Object object, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("row<0: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("col<0: " + n2);
        }
        int n3 = n++;
        int n4 = n2++;
        CellStructure.Cell cell = this.m_CellStructure.addCell(n3, n4, object);
        boolean bl = this.m_Model.isShowTotals(object);
        if (!bl || !this.m_TotalsAfter) {
            // empty if block
        }
        int n5 = n;
        if (this.m_Model.hasChildren(object) && this.m_Model.isExpanded(object)) {
            Iterator<? extends Object> iterator = this.m_Model.getChildren(object).iterator();
            while (iterator.hasNext()) {
                n = this.buildVerticalCellStructure(container, iterator.next(), n, n2);
                n5 = Math.max(n5, n);
            }
            n = n5;
        }
        if (bl && this.m_TotalsAfter) {
            ++n;
        }
        cell.rowSpan = n - n3;
        if (container != null) {
            container.add(this.m_Model.getComponent(object));
        }
        return n;
    }

    @Override
    protected void layoutCellStructure() {
        this.m_CellStructure.determineSizes();
        this.fixupParentSpans();
        this.m_CellStructure.applySizes();
    }

    private void fixupParentSpans() {
        if (this.m_Direction == 1) {
            int n = this.m_CellStructure.getRowCount();
            this.m_CellStructure.setRowSpans(n);
        } else if (this.m_Direction == 2) {
            int n = this.m_CellStructure.getColumnCount();
            this.m_CellStructure.setColumnSpans(n);
        }
    }

    private class TreeCellModel
    implements CellStructure.CellModel {
        private TreeCellModel() {
        }

        @Override
        public int getMinimumHeight(int n) {
            return Math.max(HierarchicalTreeLayoutManager.this.m_MinHeight, HierarchicalTreeLayoutManager.this.m_FixedHeights[n]);
        }

        @Override
        public int getHeight(Object object) {
            JComponent jComponent = HierarchicalTreeLayoutManager.this.m_Model.getComponent(object);
            return HierarchicalTreeLayoutManager.this.getSize((JComponent)jComponent).height;
        }

        @Override
        public int getMinimumWidth(int n) {
            return Math.max(HierarchicalTreeLayoutManager.this.m_MinWidth, HierarchicalTreeLayoutManager.this.m_FixedWidths[n]);
        }

        @Override
        public int getWidth(Object object) {
            JComponent jComponent = HierarchicalTreeLayoutManager.this.m_Model.getComponent(object);
            return HierarchicalTreeLayoutManager.this.getSize((JComponent)jComponent).width;
        }

        @Override
        public void setBounds(Object object, Rectangle rectangle) {
            JComponent jComponent = HierarchicalTreeLayoutManager.this.m_Model.getComponent(object);
            jComponent.setBounds(rectangle);
        }
    }
}

