/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.tree;

import com.elixirtech.tree.TNode;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TListener
implements MouseListener {
    JTree m_Tree;

    public TListener(JTree jTree) {
        this.m_Tree = jTree;
        this.m_Tree.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.doDoubleClick(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void doPopup(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            TNode tNode = (TNode)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = tNode.getPopupMenu();
            if (jPopupMenu != null) {
                jPopupMenu.show(this.m_Tree, point.x, point.y);
            }
            mouseEvent.consume();
        }
    }

    private void doDoubleClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            TNode tNode = (TNode)treePath.getLastPathComponent();
            tNode.doDoubleClick();
            mouseEvent.consume();
        }
    }
}

