/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ColorMap {
    private String m_Name;
    private Map<String, Color> m_Colors = new HashMap<String, Color>();
    private static ColorMap m_CurrentMap;
    private static Map<String, ColorMap> m_Maps;

    public static ColorMap current() {
        return m_CurrentMap;
    }

    public static void setCurrent(ColorMap colorMap) {
        m_CurrentMap = colorMap;
    }

    public static String[] getMapNames() {
        Set<String> set = m_Maps.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public static ColorMap lookup(String string) {
        return m_Maps.get(string);
    }

    public static void reset() {
        m_Maps.clear();
        m_CurrentMap = null;
    }

    public static Color translateTriple(String string) {
        String[] stringArray = StringUtil.arrayOfSubstrings(string.trim(), ',');
        if (stringArray.length != 3) {
            return null;
        }
        try {
            int n = 0xFF & Integer.parseInt(stringArray[0]);
            int n2 = 0xFF & Integer.parseInt(stringArray[1]);
            int n3 = 0xFF & Integer.parseInt(stringArray[2]);
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            ElxLoggerJ.getLogger(ColorMap.class).warn((Object)("ColorMap: Can't parse " + string));
            return null;
        }
    }

    public static Color getColor(String string) {
        if (m_CurrentMap == null || string == null) {
            return null;
        }
        Color color = ColorMap.m_CurrentMap.m_Colors.get(string);
        if (color != null) {
            return color;
        }
        return ColorMap.getColor(ColorMap.parent(string));
    }

    private static String parent(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public ColorMap(String string) {
        this.m_Name = string;
        m_Maps.put(this.m_Name, this);
        if (m_CurrentMap == null) {
            m_CurrentMap = this;
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public void setColor(String string, Color color) {
        this.m_Colors.put(string, color);
    }

    static {
        m_Maps = new HashMap<String, ColorMap>();
    }
}

