/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;

public final class StandardPaint
implements Paint {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StandardPaint.class);
    public static final BufferedImage EMPTY_IMAGE = StandardPaint.buildEmptyImage();
    private Image m_Image;
    private String m_Name;
    private Paint m_Paint;
    private static Map<String, StandardPaint> m_PaintMap = new TreeMap<String, StandardPaint>();
    private static ArrayList<StandardPaint> m_List = new ArrayList();
    public static final StandardPaint NONE = new StandardPaint("None", "none.png");
    public static final StandardPaint DIAG = new StandardPaint("Diag", "diag.png");
    public static final StandardPaint DIAG2 = new StandardPaint("Diag2", "diag2.png");
    public static final StandardPaint HORIZ = new StandardPaint("Horiz", "horiz.png");
    public static final StandardPaint HORIZ2 = new StandardPaint("Horiz2", "horiz2.png");
    public static final StandardPaint RDIAG = new StandardPaint("RDiag", "rdiag.png");
    public static final StandardPaint RDIAG2 = new StandardPaint("RDiag2", "rdiag2.png");
    public static final StandardPaint STITCH = new StandardPaint("Stitch", "stitch.png");
    public static final StandardPaint VERT = new StandardPaint("Vert", "vert.png");
    public static final StandardPaint VERT2 = new StandardPaint("Vert2", "vert2.png");
    public static final StandardPaint VWAVE = new StandardPaint("VWave", "vwave.png");
    public static final StandardPaint WAVE = new StandardPaint("Wave", "wave.png");

    public static Paint lookup(String string) {
        return StandardPaint.lookup(string, NONE);
    }

    public static Paint lookup(String string, Paint paint) {
        Paint paint2 = m_PaintMap.get(string.toLowerCase(Locale.ENGLISH));
        if (paint2 != null) {
            return paint2;
        }
        Color color = StandardColor.lookup(string, (Color)null);
        if (color != null) {
            return color;
        }
        return paint;
    }

    private StandardPaint(String string, String string2) {
        this.m_Name = string;
        try {
            this.m_Paint = StandardPaint.buildTexturedPaint(string2);
            this.m_Image = ((TexturePaint)this.m_Paint).getImage();
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Unable to load Paint: " + string2 + ": " + iOException));
            this.m_Paint = Color.WHITE;
            this.m_Image = EMPTY_IMAGE;
        }
        m_PaintMap.put(this.m_Name.toLowerCase(Locale.ENGLISH), this);
        m_List.add(this);
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return this.m_Paint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
    }

    @Override
    public int getTransparency() {
        return this.m_Paint.getTransparency();
    }

    public Image getIcon() {
        return this.m_Image;
    }

    public String getName() {
        return this.m_Name;
    }

    private static Paint buildTexturedPaint(String string) throws IOException {
        InputStream inputStream = StandardPaint.getInputStream(string);
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle2D.Float(0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return texturePaint;
    }

    private static InputStream getInputStream(String string) throws IOException {
        InputStream inputStream = StandardPaint.getContextInputStream(string);
        if (inputStream == null) {
            throw new IOException("Resource stream not found: resources/fill/" + string);
        }
        return inputStream;
    }

    private static InputStream getContextInputStream(String string) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream("resources/fill/" + string);
    }

    public static Collection<StandardPaint> getPaints() {
        return Collections.unmodifiableCollection(m_List);
    }

    private static BufferedImage buildEmptyImage() {
        try {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, 16, 16);
            graphics.dispose();
            return bufferedImage;
        }
        catch (Throwable throwable) {
            m_Log.warn((Object)("Unable to create a default empty image: " + throwable));
            return null;
        }
    }
}

