/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.collections;

import com.elixirtech.util.collections.AbstractMapEntry;
import com.elixirtech.util.collections.Transformer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BeanMap
extends AbstractMap<String, Object>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Object bean;
    transient Map<String, Method> readMethods = new HashMap<String, Method>();
    transient Map<String, Method> writeMethods = new HashMap<String, Method>();
    transient Map<String, Class<?>> types = new HashMap();
    public static final Object[] NULL_ARGUMENTS = new Object[0];
    public static final Map<Object, Transformer> defaultTransformers = new HashMap<Object, Transformer>();

    public BeanMap() {
    }

    public BeanMap(Object object) {
        this.bean = object;
        this.initialise();
    }

    @Override
    public String toString() {
        return "BeanMap<" + String.valueOf(this.bean) + ">";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BeanMap beanMap = (BeanMap)super.clone();
        if (this.bean == null) {
            return beanMap;
        }
        Object var2_2 = null;
        Class<?> clazz = null;
        try {
            clazz = this.bean.getClass();
            var2_2 = clazz.newInstance();
        }
        catch (Exception exception) {
            String string = clazz != null ? clazz.getName() : "<unknown>";
            throw new CloneNotSupportedException("Unable to instantiate the underlying bean \"" + string + "\": " + exception);
        }
        try {
            beanMap.setBean(var2_2);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to set bean in the cloned bean map: " + exception);
        }
        try {
            for (String string : this.readMethods.keySet()) {
                if (this.getWriteMethod(string) == null) continue;
                beanMap.put(string, this.get(string));
            }
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException("Unable to copy bean values to cloned bean map: " + exception);
        }
        return beanMap;
    }

    public void putAllWriteable(BeanMap beanMap) {
        for (String string : beanMap.readMethods.keySet()) {
            if (this.getWriteMethod(string) == null) continue;
            this.put(string, beanMap.get(string));
        }
    }

    @Override
    public void clear() {
        if (this.bean == null) {
            return;
        }
        Class<?> clazz = null;
        try {
            clazz = this.bean.getClass();
            this.bean = clazz.newInstance();
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Could not create new instance of class: " + clazz);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        Method method = this.getReadMethod(object);
        return method != null;
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Method method;
        if (this.bean != null && (method = this.getReadMethod(object)) != null) {
            try {
                return method.invoke(this.bean, NULL_ARGUMENTS);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarn(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarn(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logWarn(invocationTargetException);
            }
            catch (NullPointerException nullPointerException) {
                this.logWarn(nullPointerException);
            }
        }
        return null;
    }

    @Override
    public Object put(String string, Object object) throws IllegalArgumentException, ClassCastException {
        if (this.bean != null) {
            Object object2 = this.get(string);
            Method method = this.getWriteMethod(string);
            if (method == null) {
                throw new IllegalArgumentException("The bean of type: " + this.bean.getClass().getName() + " has no property called: " + string);
            }
            try {
                Object[] objectArray = this.createWriteMethodArguments(method, object);
                method.invoke(this.bean, objectArray);
                Object object3 = this.get(string);
                this.firePropertyChange(string, object2, object3);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logInfo(invocationTargetException);
                throw new IllegalArgumentException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logInfo(illegalAccessException);
                throw new IllegalArgumentException(illegalAccessException.getMessage());
            }
            return object2;
        }
        return null;
    }

    @Override
    public int size() {
        return this.readMethods.size();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.readMethods.keySet());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return BeanMap.this.entryIterator();
            }

            @Override
            public int size() {
                return BeanMap.this.readMethods.size();
            }
        });
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.readMethods.size());
        Iterator<Object> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Class<?> getType(String string) {
        return this.types.get(string);
    }

    public Iterator<String> keyIterator() {
        return this.readMethods.keySet().iterator();
    }

    public Iterator<Object> valueIterator() {
        final Iterator<String> iterator = this.keyIterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Object next() {
                Object e = iterator.next();
                return BeanMap.this.get(e);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Iterator<Map.Entry<String, Object>> entryIterator() {
        final Iterator<String> iterator = this.keyIterator();
        return new Iterator<Map.Entry<String, Object>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                String string = (String)iterator.next();
                Object object = BeanMap.this.get(string);
                return new MyMapEntry(BeanMap.this, string, object);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for BeanMap");
            }
        };
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object object) {
        this.bean = object;
        this.reinitialise();
    }

    public Method getReadMethod(String string) {
        return this.readMethods.get(string);
    }

    public Method getWriteMethod(String string) {
        return this.writeMethods.get(string);
    }

    protected Method getReadMethod(Object object) {
        return this.readMethods.get(object);
    }

    protected Method getWriteMethod(Object object) {
        return this.writeMethods.get(object);
    }

    protected void reinitialise() {
        this.readMethods.clear();
        this.writeMethods.clear();
        this.types.clear();
        this.initialise();
    }

    private void initialise() {
        if (this.getBean() == null) {
            return;
        }
        Class<?> clazz = this.getBean().getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            if (propertyDescriptorArray != null) {
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                    if (propertyDescriptor == null) continue;
                    String string = propertyDescriptor.getName();
                    Method method = propertyDescriptor.getReadMethod();
                    Method method2 = propertyDescriptor.getWriteMethod();
                    Class<?> clazz2 = propertyDescriptor.getPropertyType();
                    if (method != null) {
                        this.readMethods.put(string, method);
                    }
                    if (this.writeMethods != null) {
                        this.writeMethods.put(string, method2);
                    }
                    this.types.put(string, clazz2);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            this.logWarn(introspectionException);
        }
    }

    protected void firePropertyChange(Object object, Object object2, Object object3) {
    }

    protected Object[] createWriteMethodArguments(Method method, Object object) throws IllegalAccessException, ClassCastException {
        try {
            Object object2;
            Object[] objectArray;
            if (object != null && (objectArray = method.getParameterTypes()) != null && objectArray.length > 0 && !((Class)(object2 = objectArray[0])).isAssignableFrom(object.getClass())) {
                object = this.convertType((Class<?>)object2, object);
            }
            objectArray = new Object[]{object};
            return objectArray;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logInfo(invocationTargetException);
            throw new IllegalArgumentException(invocationTargetException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            this.logInfo(instantiationException);
            throw new IllegalArgumentException(instantiationException.getMessage());
        }
    }

    protected Object convertType(Class<?> clazz, Object object) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray = new Class[]{object.getClass()};
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{object};
            return constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Transformer transformer = this.getTypeTransformer(clazz);
            if (transformer != null) {
                return transformer.transform(object);
            }
            return object;
        }
    }

    protected Transformer getTypeTransformer(Class<?> clazz) {
        return defaultTransformers.get(clazz);
    }

    protected void logInfo(Exception exception) {
        System.out.println("INFO: Exception: " + exception);
    }

    protected void logWarn(Exception exception) {
        System.out.println("WARN: Exception: " + exception);
        exception.printStackTrace();
    }

    static {
        defaultTransformers.put(Boolean.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                String string = object.toString();
                if ("Yes".equals(string)) {
                    return Boolean.TRUE;
                }
                if ("No".equals(string)) {
                    return Boolean.FALSE;
                }
                return Boolean.valueOf(string);
            }
        });
        defaultTransformers.put(Character.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return new Character(object.toString().charAt(0));
            }
        });
        defaultTransformers.put(Byte.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Byte.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Short.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Short.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Integer.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Integer.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Long.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Long.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Float.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Float.valueOf(object.toString());
            }
        });
        defaultTransformers.put(Double.TYPE, new Transformer(){

            @Override
            public Object transform(Object object) {
                return Double.valueOf(object.toString());
            }
        });
    }

    protected static class MyMapEntry
    extends AbstractMapEntry<String, Object> {
        private BeanMap owner;

        protected MyMapEntry(BeanMap beanMap, String string, Object object) {
            super(string, object);
            this.owner = beanMap;
        }

        @Override
        public Object setValue(Object object) {
            String string = (String)this.getKey();
            Object object2 = this.owner.get(string);
            this.owner.put(string, object);
            Object object3 = this.owner.get(string);
            super.setValue(object3);
            return object2;
        }
    }
}

