/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.util.format;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.util.ClassUtil;
import com.elixirtech.util.FastDateFormat;
import com.elixirtech.util.format.IFormat;
import com.elixirtech.util.format.Percent100FormatWrapper;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class FormatUtil {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FormatUtil.class);

    public static boolean isNone(IFormat iFormat) {
        if (iFormat == null) {
            return true;
        }
        String string = iFormat.getType();
        return string == null || "None".equals(string);
    }

    public static boolean notNone(IFormat iFormat) {
        return !FormatUtil.isNone(iFormat);
    }

    public static NumberFormat getDefaultNumberFormatter(String string, Locale locale) {
        if (string.equals("Currency")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Number")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Percent")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            return decimalFormat;
        }
        if (string.equals("Percent100")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale);
            return new Percent100FormatWrapper(decimalFormat);
        }
        return null;
    }

    public static Format buildFormatter(IFormat iFormat, Locale locale) {
        String string;
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = Locale.getDefault();
        }
        if ((string = iFormat.getType()).equals("Currency")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
            FormatUtil.configNumberFormatter(decimalFormat, iFormat);
            return decimalFormat;
        }
        if (string.equals("Number")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale2);
            FormatUtil.configNumberFormatter(decimalFormat, iFormat);
            return decimalFormat;
        }
        if (string.equals("Percent")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale2);
            FormatUtil.configNumberFormatter(decimalFormat, iFormat);
            return decimalFormat;
        }
        if (string.equals("Percent100")) {
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getPercentInstance(locale2);
            FormatUtil.configNumberFormatter(decimalFormat, iFormat);
            return new Percent100FormatWrapper(decimalFormat);
        }
        if (string.equals("Date/Time")) {
            String string2 = iFormat.getCustomPattern();
            if (StringUtil.notEmpty(string2)) {
                ArgumentMap.ICallback iCallback = FormatUtil.getSubstitution();
                if (iCallback != null) {
                    string2 = ArgumentMap.substitute(string2, iCallback);
                }
                return new SimpleDateFormat(string2, locale2);
            }
            int n = FormatUtil.getStyle(iFormat.getDateFormat());
            int n2 = FormatUtil.getStyle(iFormat.getTimeFormat());
            Format format = null;
            if (n == -1) {
                if (n2 == -1) {
                    return new NullFormat();
                }
                format = FastDateFormat.getTimeInstance(n2, locale2);
            } else {
                format = n2 == -1 ? DateFormat.getDateInstance(n, locale2) : FastDateFormat.getDateTimeInstance(n, n2, locale2);
            }
            return format;
        }
        return null;
    }

    private static ArgumentMap.ICallback getSubstitution() {
        return (ArgumentMap.ICallback)ClassUtil.newInstance("com.elixirtech.report2.logical.ReportSubstitution");
    }

    private static void configNumberFormatter(NumberFormat numberFormat, IFormat iFormat) {
        String string = iFormat.getCustomPattern();
        if (StringUtil.notEmpty(string)) {
            ArgumentMap.ICallback iCallback = FormatUtil.getSubstitution();
            if (iCallback != null) {
                string = ArgumentMap.substitute(string, iCallback);
            }
            if (numberFormat instanceof DecimalFormat) {
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormat.applyPattern(string);
                decimalFormat.getDecimalFormatSymbols().setNaN("NaN");
            } else {
                m_Log.warn((Object)"Can only apply custom pattern to a DecimalFormat");
            }
        } else {
            try {
                numberFormat.setMinimumIntegerDigits(iFormat.getMinIntegerDigits());
                numberFormat.setMaximumIntegerDigits(iFormat.getMaxIntegerDigits());
                numberFormat.setMinimumFractionDigits(iFormat.getMinFractionDigits());
                numberFormat.setMaximumFractionDigits(iFormat.getMaxFractionDigits());
                numberFormat.setGroupingUsed(iFormat.isGroupingUsed());
                DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                decimalFormat.setGroupingSize(iFormat.getGroupingSize());
                decimalFormat.setDecimalSeparatorAlwaysShown(iFormat.isDecimalSeparatorAlwaysShown());
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setNaN("NaN");
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            }
            catch (Exception exception) {
                m_Log.warn((Object)("configNumberFormatter: " + exception));
            }
        }
    }

    private static int getStyle(String string) {
        if (string == null || string.equals("None")) {
            return -1;
        }
        if (string.equals("Full")) {
            return 0;
        }
        if (string.equals("Long")) {
            return 1;
        }
        if (string.equals("Medium")) {
            return 2;
        }
        if (string.equals("Short")) {
            return 3;
        }
        return 3;
    }

    private static class NullFormat
    extends Format {
        private NullFormat() {
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            return stringBuffer;
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            return null;
        }
    }
}

