/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.elixirtech.arch.ElxLoggerJ;
import com.java4less.rss.CC;
import com.java4less.rss.CC_A;
import com.java4less.rss.CC_C;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class BarCode {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(BarCode.class);
    public static final int UPCA = 1;
    public static final int EAN13 = 2;
    public static final int EAN8 = 3;
    public static final int UPCE = 4;
    public static final int EAN128 = 5;
    public static final int RSS14 = 6;
    public static final int RSSLIMITED = 7;
    public static final int RSSEXPANDED = 8;
    protected static int WHITE = 0;
    protected static int BLACK = 1;
    protected static int BLACK_GUARDBAR = 2;
    protected static int BLACK_SUPLEMENT = 3;
    protected static int EMPTY = -1;
    protected int barType = 2;
    protected String code = "";
    protected String secondaryCode = "";
    protected String humanReadableCode = null;
    protected String humanReadableSecondaryCode = null;
    protected int cccColumns = 4;
    protected boolean EANUPCPrintFlag = true;
    protected boolean EAN128WithCCC = false;
    protected int barHeight2D = 4;
    private String codeSup = "";
    protected boolean checkCharacter = true;
    protected String supplement = "";
    protected boolean guardBars = true;
    private String codeText = "";
    protected int barHeight = 0;
    protected Font textFont = new Font("Arial", 0, 11);
    protected Color fontColor = Color.black;
    protected Color barColor = Color.black;
    protected char UPCESytem = (char)49;
    protected boolean UPCEANSupplement2 = false;
    protected boolean UPCEANSupplement5 = false;
    protected int X = 1;
    public double H = 0.45;
    public int L = 0;
    private int supL = 0;
    protected int supSeparation = 10;
    protected double supHeight = 0.8;
    protected boolean processTilde = false;
    protected int currentX = 0;
    protected int currentY = 0;
    protected String[][] setUPCALeft = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCARight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEOdd = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setUPCEEven = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[] UPCESystem0 = new String[]{"EEEOOO", "EEOEOO", "EEOOEO", "EEOOOE", "EOEEOO", "EOOEEO", "EOOOEE", "EOEOEO", "EOEOOE", "EOOEOE"};
    protected String[] UPCESystem1 = new String[]{"OOOEEE", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    protected String[][] setEANLeftA = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[][] setEANLeftB = new String[][]{{"0", "1123"}, {"1", "1222"}, {"2", "2212"}, {"3", "1141"}, {"4", "2311"}, {"5", "1321"}, {"6", "4111"}, {"7", "2131"}, {"8", "3121"}, {"9", "2113"}};
    protected String[][] setEANRight = new String[][]{{"0", "3211"}, {"1", "2221"}, {"2", "2122"}, {"3", "1411"}, {"4", "1132"}, {"5", "1231"}, {"6", "1114"}, {"7", "1312"}, {"8", "1213"}, {"9", "3112"}};
    protected String[] setEANCode = new String[]{"AAAAA", "ABABB", "ABBAB", "ABBBA", "BAABB", "BBAAB", "BBBAA", "BABAB", "BABBA", "BBABA"};
    protected String[] fiveSuplement = new String[]{"EEOOO", "EOEOO", "EOOEO", "EOOOE", "OEEOO", "OOEEO", "OOOEE", "OEOEO", "OEOOE", "OOEOE"};
    protected String[] set128 = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131"};
    protected String[] set128A = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "\u0000", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u000e", "\u000f", "\u0010", "\u0011", "\u0012", "\u0013", "\u0014", "\u0015", "\u0016", "\u0017", "\u0018", "\u0019", "\u001a", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128B = new String[]{" ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "_92", "}", "~", "_95", "_96", "_97", "_98", "_99", "_100", "_101", "_102"};
    protected String[] set128C = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "_100", "_101", "_102"};
    private int leftGuardBar = 0;
    private int centerGuardBarStart = 0;
    private int centerGuardBarEnd = 0;
    private int rightGuardBar = 0;
    private int endOfCode = 0;
    private int startSuplement;
    private int endSuplement;
    private int suplementTopMargin;
    protected Dimension m_PaintSize;
    private int guardBarHeight = 0;

    public Dimension getPaintSize() {
        return this.m_PaintSize;
    }

    public int getCCCColumns() {
        return this.cccColumns;
    }

    public void setCCCColumns(int n) {
        this.cccColumns = n;
    }

    public boolean getEANUPCPrintFlag() {
        return this.EANUPCPrintFlag;
    }

    public void setEANUPCPrintFlag(boolean bl) {
        this.EANUPCPrintFlag = bl;
    }

    public boolean getEAN128WithCCC() {
        return this.EAN128WithCCC;
    }

    public void setEAN128WithCCC(boolean bl) {
        this.EAN128WithCCC = bl;
    }

    public int getBarHeight2D() {
        return this.barHeight2D;
    }

    public void setBarHeight2D(int n) {
        this.barHeight2D = n;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string.startsWith("(01)") ? string.substring(4) : string;
        if (this.code.length() > 13) {
            this.code = this.code.substring(0, 13);
        }
    }

    public String getSecondaryCode() {
        return this.secondaryCode;
    }

    public void setSecondaryCode(String string) {
        this.secondaryCode = string;
    }

    public String getHumanReadableCode() {
        return this.humanReadableCode;
    }

    public void setHumanReadableCode(String string) {
        this.humanReadableCode = string;
    }

    public int getSymbology() {
        return this.barType;
    }

    public void setSymbology(int n) {
        this.barType = n;
    }

    public String getBarType() {
        switch (this.barType) {
            case 1: {
                return "UPCA";
            }
            case 2: {
                return "EAN13";
            }
            case 3: {
                return "EAN8";
            }
            case 4: {
                return "UPCE";
            }
            case 5: {
                return "EAN128";
            }
            case 6: {
                return "RSS14";
            }
            case 7: {
                return "RSSLIMITED";
            }
            case 8: {
                return "RSSEXPANDED";
            }
        }
        return "";
    }

    public void setBarType(String string) {
        if ((string = string.toUpperCase()).compareTo("EAN13") == 0) {
            this.barType = 2;
        }
        if (string.compareTo("EAN8") == 0) {
            this.barType = 3;
        }
        if (string.compareTo("UPCA") == 0) {
            this.barType = 1;
        }
        if (string.compareTo("UPCE") == 0) {
            this.barType = 4;
        }
        if (string.compareTo("EAN128") == 0) {
            this.barType = 5;
        }
        if (string.compareTo("RSS14") == 0) {
            this.barType = 6;
        }
        if (string.compareTo("RSSLIMITED") == 0) {
            this.barType = 7;
        }
        if (string.compareTo("RSSEXPANDED") == 0) {
            this.barType = 8;
        }
    }

    public String getSuplement() {
        return this.supplement;
    }

    public void setSuplement(String string) {
        this.supplement = string;
    }

    public boolean getGuardBars() {
        return this.guardBars;
    }

    public void setGuardBars(boolean bl) {
        this.guardBars = bl;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void setBarHeight(int n) {
        this.barHeight = n;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public void setBarColor(Color color) {
        this.barColor = color;
    }

    public String getUPCESytem() {
        return "" + this.UPCESytem;
    }

    public void setUPCESytem(String string) {
        if (string.length() > 0) {
            this.UPCESytem = string.charAt(0);
        }
    }

    public boolean getUPCEANSupplement2() {
        return this.UPCEANSupplement2;
    }

    public void setUPCEANSupplement2(boolean bl) {
        this.UPCEANSupplement2 = bl;
    }

    public boolean getUPCEANSupplement5() {
        return this.UPCEANSupplement5;
    }

    public void setUPCEANSupplement5(boolean bl) {
        this.UPCEANSupplement5 = bl;
    }

    public int getX() {
        return this.X;
    }

    public void setX(int n) {
        this.X = n;
    }

    public double getH() {
        return this.H;
    }

    public void setH(double d) {
        this.H = d;
    }

    public int getSupSeparation() {
        return this.supSeparation;
    }

    public void setSupSeparation(int n) {
        this.supSeparation = n;
    }

    public double getSupHeight() {
        return this.supHeight;
    }

    public void setSupHeight(double d) {
        this.supHeight = d;
    }

    public String getName() {
        return "RBarCode-RSS";
    }

    public boolean getProcessTilde() {
        return this.processTilde;
    }

    public void setProcessTilde(boolean bl) {
        this.processTilde = bl;
    }

    public void paint(Graphics graphics) {
        if (this.processTilde) {
            this.code = this.applyTilde(this.code);
            this.secondaryCode = this.applyTilde(this.secondaryCode);
        }
        try {
            this.m_PaintSize = this.paintBarcode(graphics);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error painting barcode: " + exception), (Throwable)exception);
        }
    }

    protected int findChar(String[][] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.compareTo(stringArray[i][0]) != 0) continue;
            return i;
        }
        return -1;
    }

    public static String UPCEANCheck(String string) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (bl) {
                n += new Integer("" + string.charAt(i)).intValue();
            } else {
                n2 += new Integer("" + string.charAt(i)).intValue();
            }
            bl = !bl;
        }
        int n3 = (int)BarCode.mod(n2 = n * 3 + n2, 10.0);
        if (n3 != 0) {
            n3 = 10 - n3;
        }
        return "" + n3;
    }

    protected void paintUPCA(Graphics graphics) throws Exception {
        int n = 0;
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = this.code + BarCode.UPCEANCheck(this.code);
        }
        if (this.code.length() < 12) {
            throw new Exception("Code length must be 11 or 12");
        }
        this.calculateL(this.code);
        int[][] nArray = BarCode.createBarMap(this.L + this.supL, 1, EMPTY);
        int n2 = 0;
        this.codeText = this.code;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.leftGuardBar = n2;
        for (int i = 0; i < this.code.length(); ++i) {
            String string = "" + this.code.charAt(i);
            n = -1;
            if (i <= 5) {
                n = this.findChar(this.setUPCALeft, string);
                n2 += this.paintCharBarMap(nArray, "wbwb", this.setUPCALeft[n][1], n2, 0);
            } else {
                n = this.findChar(this.setUPCARight, string);
                n2 += this.paintCharBarMap(nArray, "bwbw", this.setUPCARight[n][1], n2, 0);
            }
            if (i != 5) continue;
            this.centerGuardBarStart = n2;
            n2 += this.paintGuardChar(nArray, "wbwbw", "nnnnn", n2, 0);
            this.centerGuardBarEnd = n2;
        }
        this.rightGuardBar = n2;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.endOfCode = n2;
        if (this.UPCEANSupplement2) {
            this.paintSup2(nArray, this.code.substring(1, 3), n2);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(nArray, this.code.substring(1, 6), n2);
        }
        BarCode.printBarMap(nArray, 0);
        this.renderEANUPC(graphics, nArray, 4);
    }

    protected void paintEAN13(Graphics graphics) throws Exception {
        int n = 0;
        if (this.code.length() == 12 && this.checkCharacter) {
            this.code = this.code + BarCode.UPCEANCheck(this.code);
            this.codeText = this.code;
        }
        if (this.code.length() < 13) {
            throw new Exception("Code length must be 12 or 13");
        }
        this.calculateL(this.code);
        int[][] nArray = BarCode.createBarMap(this.L + this.supL, 1, EMPTY);
        int n2 = 0;
        this.codeText = this.code;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.leftGuardBar = n2;
        String string = this.setEANCode[new Integer("" + this.code.charAt(0))];
        n = this.findChar(this.setEANLeftA, "" + this.code.charAt(1));
        n2 += this.paintCharBarMap(nArray, "wbwb", this.setEANLeftA[n][1], n2, 0);
        for (int i = 2; i < 12; ++i) {
            String string2 = "" + this.code.charAt(i);
            n = -1;
            if (i <= 6) {
                String[][] stringArray = this.setEANLeftA;
                if (string.charAt(i - 2) == 'B') {
                    stringArray = this.setEANLeftB;
                }
                n = this.findChar(stringArray, string2);
                n2 += this.paintCharBarMap(nArray, "wbwb", stringArray[n][1], n2, 0);
            } else {
                n = this.findChar(this.setEANRight, string2);
                n2 += this.paintCharBarMap(nArray, "bwbw", this.setEANRight[n][1], n2, 0);
            }
            if (i != 6) continue;
            this.centerGuardBarStart = n2;
            n2 += this.paintGuardChar(nArray, "wbwbw", "nnnnn", n2, 0);
            this.centerGuardBarEnd = n2;
        }
        n = this.findChar(this.setEANRight, "" + this.code.charAt(12));
        n2 += this.paintCharBarMap(nArray, "bwbw", this.setEANRight[n][1], n2, 0);
        this.rightGuardBar = n2;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.endOfCode = n2;
        if (this.UPCEANSupplement2) {
            this.paintSup2(nArray, this.code.substring(2, 4), n2);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(nArray, this.code.substring(2, 7), n2);
        }
        this.renderEANUPC(graphics, nArray, 4);
    }

    protected void paintEAN128(Graphics graphics) throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.calculateL("#" + this.code);
        int[][] nArray = BarCode.createBarMap(this.L + this.supL, 1, EMPTY);
        int n5 = 0;
        this.codeText = this.code;
        int n6 = 67;
        String[] stringArray = this.set128A;
        if (n6 == 66) {
            stringArray = this.set128B;
        }
        int n7 = 103;
        if (n6 == 66) {
            stringArray = this.set128B;
            n7 = 104;
        }
        if (n6 == 67) {
            stringArray = this.set128C;
            n7 = 105;
        }
        int n8 = n6;
        if (n6 == 66) {
            n5 += this.paintCharBarMap(nArray, "bwbwbw", "211214", n5, 0);
        }
        if (n6 == 67) {
            n5 += this.paintCharBarMap(nArray, "bwbwbw", "211232", n5, 0);
        }
        if (n6 != 66 && n6 != 67) {
            n5 += this.paintCharBarMap(nArray, "bwbwbw", "211412", n5, 0);
        }
        ++n4;
        int n9 = 1;
        boolean bl = true;
        for (n = 0; n < this.code.length(); ++n) {
            stringArray = this.set128A;
            if (n8 == 66) {
                stringArray = this.set128B;
            }
            if (n8 == 67) {
                stringArray = this.set128C;
            }
            Object object = "" + this.code.charAt(n);
            object = this.convertCode128ControlChar((String)object);
            if (this.barType == 5 && n == 0 && bl) {
                n2 = this.findInArray(this.set128C, "_102");
                n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                ++n4;
                n7 += n2 * n9;
                ++n9;
                bl = false;
            }
            if (n8 == 67) {
                var15_15 = 0;
                if (n < this.code.length() - 1 && this.isDigit((String)object) && this.isDigit("" + this.code.charAt(n + 1))) {
                    n2 = this.findInArray(this.set128C, (String)(object = (String)object + this.code.charAt(n + 1)));
                    if (n2 >= 0) {
                        n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                        ++n4;
                        n7 += n2 * n9;
                    }
                    var15_15 = 1;
                    ++n;
                }
                if (var15_15 == 0 && !this.isDigit((String)object) && (n2 = this.findInArray(this.set128C, (String)object)) >= 0) {
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                    ++n4;
                    n7 += n2 * n9;
                    var15_15 = 1;
                }
                if (var15_15 == 0 && this.isDigit((String)object)) {
                    n8 = 66;
                    if (n < this.code.length() - 1 && this.getNextControlChar(this.code, n + 1) < this.getNextLowerCase(this.code, n + 1)) {
                        n8 = 65;
                    }
                    n2 = this.findInArray(this.set128C, "_100");
                    if (n8 == 65) {
                        n2 = this.findInArray(this.set128C, "_101");
                    }
                    n7 += n2 * n9;
                    ++n9;
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                    ++n4;
                    n2 = this.findInArray(this.set128B, (String)object);
                    if (n2 >= 0) {
                        n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                        ++n4;
                        n7 += n2 * n9;
                    }
                    var15_15 = 1;
                }
                if (var15_15 == 0 && !this.isDigit((String)object)) {
                    n8 = this.calculateNextSet(this.code, n);
                    int n10 = 0;
                    if (n8 == 65) {
                        n10 = this.findInArray(stringArray, "_101");
                    }
                    if (n8 == 66) {
                        n10 = this.findInArray(stringArray, "_100");
                    }
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n10], n5, 0);
                    ++n4;
                    n7 += n10 * n9;
                    --n;
                }
            } else if (this.calculateNextSet(this.code, n) == 'C') {
                --n;
                var15_15 = 0;
                var15_15 = this.findInArray(this.set128B, "_99");
                if (n8 == 65) {
                    var15_15 = this.findInArray(this.set128A, "_99");
                }
                n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[var15_15], n5, 0);
                n7 += var15_15 * n9;
                ++n4;
                n8 = 67;
            } else {
                n2 = this.findInArray(stringArray, (String)object);
                if (n8 == 65 && n2 == -1 && this.findInArray(this.set128B, (String)object) >= 0) {
                    var15_15 = 0;
                    if (this.getNextControlChar(this.code, n) < this.getNextLowerCase(this.code, n)) {
                        var15_15 = this.findInArray(stringArray, "_98");
                    } else {
                        var15_15 = this.findInArray(stringArray, "_100");
                        n8 = 66;
                    }
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[var15_15], n5, 0);
                    ++n4;
                    n7 += var15_15 * n9;
                    ++n9;
                    stringArray = this.set128B;
                }
                if (n8 == 66 && n2 == -1 && this.findInArray(this.set128A, (String)object) >= 0) {
                    var15_15 = 0;
                    if (this.getNextControlChar(this.code, n) > this.getNextLowerCase(this.code, n)) {
                        var15_15 = this.findInArray(stringArray, "_98");
                    } else {
                        var15_15 = this.findInArray(stringArray, "_101");
                        n8 = 65;
                    }
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[var15_15], n5, 0);
                    ++n4;
                    n7 += var15_15 * n9;
                    ++n9;
                    stringArray = this.set128A;
                }
                if ((n2 = this.findInArray(stringArray, (String)object)) >= 0) {
                    n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n2], n5, 0);
                    ++n4;
                    n7 += n2 * n9;
                }
            }
            ++n9;
        }
        if (this.secondaryCode.length() > 0) {
            n = 0;
            if (!this.EAN128WithCCC) {
                if (n8 == 65) {
                    n = this.findInArray(this.set128A, "_100");
                }
                if (n8 == 66) {
                    n = this.findInArray(this.set128B, "_99");
                }
                if (n8 == 67) {
                    n = this.findInArray(this.set128C, "_101");
                }
            } else {
                if (n8 == 65) {
                    n = this.findInArray(this.set128A, "_99");
                }
                if (n8 == 66) {
                    n = this.findInArray(this.set128B, "_101");
                }
                if (n8 == 67) {
                    n = this.findInArray(this.set128C, "_100");
                }
            }
            n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n], n5, 0);
            ++n4;
            n7 += n * n9;
        }
        if (this.checkCharacter) {
            n3 = (int)BarCode.mod(n7, 103.0);
            n5 += this.paintCharBarMap(nArray, "bwbwbw", this.set128[n3], n5, 0);
            ++n4;
        }
        n5 += this.paintCharBarMap(nArray, "bwbwbwb", "2331112", n5, 0);
        this.endOfCode = n5;
        this.renderEAN128(graphics, nArray, ++n4);
    }

    protected void paintEAN8(Graphics graphics) throws Exception {
        int n = 0;
        if (this.code.length() == 7 && this.checkCharacter) {
            this.code = this.code + BarCode.UPCEANCheck(this.code);
        }
        if (this.code.length() < 8) {
            throw new Exception("Code length must be 7 or 8");
        }
        this.calculateL(this.code);
        int[][] nArray = BarCode.createBarMap(this.L + this.supL, 1, EMPTY);
        int n2 = 0;
        this.codeText = this.code;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.leftGuardBar = n2;
        for (int i = 0; i < 8; ++i) {
            String string = "" + this.code.charAt(i);
            n = -1;
            if (i <= 3) {
                n = this.findChar(this.setEANLeftA, string);
                n2 += this.paintCharBarMap(nArray, "wbwb", this.setEANLeftA[n][1], n2, 0);
            } else {
                n = this.findChar(this.setEANRight, string);
                n2 += this.paintCharBarMap(nArray, "bwbw", this.setEANRight[n][1], n2, 0);
            }
            if (i != 3) continue;
            this.centerGuardBarStart = n2;
            n2 += this.paintGuardChar(nArray, "wbwbw", "nnnnn", n2, 0);
            this.centerGuardBarEnd = n2;
        }
        this.rightGuardBar = n2;
        n2 += this.paintGuardChar(nArray, "bwb", "nnn", n2, 0);
        this.endOfCode = n2;
        if (this.UPCEANSupplement2) {
            this.paintSup2(nArray, this.code.substring(2, 4), n2);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(nArray, this.code.substring(2, 7), n2);
        }
        this.renderEANUPC(graphics, nArray, 3);
    }

    protected void paintUPCE(Graphics graphics) throws Exception {
        int n = 0;
        int n2 = 0;
        Object object = "";
        if (this.code.length() == 11 && this.checkCharacter) {
            this.code = this.code + BarCode.UPCEANCheck(this.code);
        }
        if (this.code.length() < 12) {
            return;
        }
        this.calculateL(this.code);
        int[][] nArray = BarCode.createBarMap(this.L + this.supL, 1, EMPTY);
        int n3 = 0;
        n2 = new Integer("" + this.code.charAt(11));
        if (this.code.substring(3, 6).compareTo("000") == 0 || this.code.substring(3, 6).compareTo("100") == 0 || this.code.substring(3, 6).compareTo("200") == 0) {
            object = this.code.substring(1, 3) + this.code.substring(8, 11) + this.code.charAt(3);
        }
        if (this.code.substring(3, 6).compareTo("300") == 0 || this.code.substring(3, 6).compareTo("400") == 0 || this.code.substring(3, 6).compareTo("500") == 0 || this.code.substring(3, 6).compareTo("600") == 0 || this.code.substring(3, 6).compareTo("700") == 0 || this.code.substring(3, 6).compareTo("800") == 0 || this.code.substring(3, 6).compareTo("900") == 0) {
            object = this.code.substring(1, 4) + this.code.substring(9, 11) + "3";
        }
        if (this.code.substring(4, 6).compareTo("10") == 0 || this.code.substring(4, 6).compareTo("20") == 0 || this.code.substring(4, 6).compareTo("30") == 0 || this.code.substring(4, 6).compareTo("40") == 0 || this.code.substring(4, 6).compareTo("50") == 0 || this.code.substring(4, 6).compareTo("60") == 0 || this.code.substring(4, 6).compareTo("70") == 0 || this.code.substring(4, 6).compareTo("80") == 0 || this.code.substring(4, 6).compareTo("90") == 0) {
            object = this.code.substring(1, 5) + this.code.substring(10, 11) + "4";
        }
        if (this.code.substring(5, 6).compareTo("0") != 0) {
            object = this.code.substring(1, 6) + this.code.substring(10, 11);
        }
        this.codeText = object;
        n3 += this.paintGuardChar(nArray, "bwb", "nnn", n3, 0);
        this.leftGuardBar = n3;
        String string = this.UPCESystem0[n2];
        if (this.UPCESytem == '1') {
            string = this.UPCESystem1[n2];
        }
        for (int i = 0; i < ((String)object).length(); ++i) {
            String string2 = "" + ((String)object).charAt(i);
            n = -1;
            String[][] stringArray = this.setUPCEOdd;
            if (string.charAt(i) == 'E') {
                stringArray = this.setUPCEEven;
            }
            n = this.findChar(stringArray, string2);
            Object object2 = "";
            for (int j = 0; j < stringArray[n][1].length(); ++j) {
                object2 = stringArray[n][1].charAt(j) + (String)object2;
            }
            n3 += this.paintCharBarMap(nArray, "wbwb", (String)object2, n3, 0);
        }
        this.rightGuardBar = n3;
        n3 += this.paintGuardChar(nArray, "wbwbwb", "nnnnnn", n3, 0);
        this.endOfCode = n3;
        if (this.UPCEANSupplement2) {
            this.paintSup2(nArray, ((String)object).substring(0, 2), n3);
        } else if (this.UPCEANSupplement5) {
            this.paintSup5(nArray, ((String)object).substring(0, 5), n3);
        }
        this.renderEANUPC(graphics, nArray, 2);
    }

    protected void paintSup2(int[][] nArray, String string, int n) {
        int n2;
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        if (this.codeSup.length() == 0) {
            this.codeSup = string;
        }
        if (string.length() != 2) {
            return;
        }
        this.startSuplement = n += this.supSeparation;
        try {
            n2 = Integer.valueOf(string);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        String string2 = "OO";
        if (BarCode.mod(n2, 4.0) == 1.0) {
            string2 = "OE";
        }
        if (BarCode.mod(n2, 4.0) == 2.0) {
            string2 = "EO";
        }
        if (BarCode.mod(n2, 4.0) == 3.0) {
            string2 = "EE";
        }
        n += this.paintCharBarMap(nArray, "bwb", "112", n, 0, BLACK_SUPLEMENT);
        String[][] stringArray = this.setUPCEOdd;
        if (string2.charAt(0) == 'E') {
            stringArray = this.setUPCEEven;
        }
        int n3 = this.findChar(stringArray, "" + string.charAt(0));
        n += this.paintCharBarMap(nArray, "wbwb", stringArray[n3][1], n, 0, BLACK_SUPLEMENT);
        n += this.paintCharBarMap(nArray, "wb", "11", n, 0, BLACK_SUPLEMENT);
        stringArray = this.setUPCEOdd;
        if (string2.charAt(1) == 'E') {
            stringArray = this.setUPCEEven;
        }
        n3 = this.findChar(stringArray, "" + string.charAt(1));
        n += this.paintCharBarMap(nArray, "wbwb", stringArray[n3][1], n, 0, BLACK_SUPLEMENT);
        this.endSuplement = n;
    }

    protected void paintSup5(int[][] nArray, String string, int n) {
        if (this.supplement.length() > 0) {
            string = this.supplement;
        }
        if (string.length() != 5) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (bl) {
                n2 += new Integer("" + string.charAt(i)).intValue();
            } else {
                n3 += new Integer("" + string.charAt(i)).intValue();
            }
            bl = !bl;
        }
        n3 = n2 * 3 + n3 * 9;
        String string2 = "" + n3;
        int n4 = new Integer("" + string2.charAt(string2.length() - 1));
        String string3 = this.fiveSuplement[n4];
        this.startSuplement = n += this.supSeparation;
        n += this.paintCharBarMap(nArray, "bwb", "112", n, 0, BLACK_SUPLEMENT);
        String[][] stringArray = null;
        for (int i = 0; i < 5; ++i) {
            stringArray = this.setUPCEOdd;
            if (string3.charAt(i) == 'E') {
                stringArray = this.setUPCEEven;
            }
            int n5 = this.findChar(stringArray, "" + string.charAt(i));
            n += this.paintCharBarMap(nArray, "wbwb", stringArray[n5][1], n, 0, BLACK_SUPLEMENT);
            if (i >= 4) continue;
            n += this.paintCharBarMap(nArray, "wb", "11", n, 0, BLACK_SUPLEMENT);
        }
        this.endSuplement = n;
    }

    protected int paintCharBarMap(int[][] nArray, String string, String string2, int n, int n2) {
        return this.paintCharBarMap(nArray, string, string2, n, n2, BLACK);
    }

    protected int paintCharBarMap(int[][] nArray, String string, String string2, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n5 = string2.charAt(i);
            if (n5 == 110) {
                n5 = 49;
            }
            if (n5 == 119) {
                throw new RuntimeException("Pattern w not supported");
            }
            int n6 = BarCode.addBarMap(nArray, n, n2, n5 - 48, c == 'b', false, n3);
            n += n6;
            n4 += n6;
        }
        return n4;
    }

    protected int paintGuardChar(int[][] nArray, String string, String string2, int n, int n2) {
        return this.paintCharBarMap(nArray, string, string2, n, n2, BLACK_GUARDBAR);
    }

    protected void calculateL(String string) {
        int n = string.length();
        if (this.barType == 1) {
            this.L = 95;
        }
        if (this.barType == 2) {
            this.L = 95;
        }
        if (this.barType == 3) {
            this.L = 67;
        }
        if (this.barType == 5) {
            if (this.checkCharacter) {
                ++n;
            }
            this.L = 11 * n + 35;
        }
        if (this.barType == 4) {
            this.L = 51;
        }
        if (this.barHeight == 0) {
            this.barHeight = (int)((double)this.L * this.H * (double)this.X);
        }
        this.supL = 0;
        if (this.UPCEANSupplement2) {
            this.supL = this.supSeparation + 4 + 7 + 2 + 7;
        } else if (this.UPCEANSupplement5) {
            this.supL = this.supSeparation + 4 + 35 + 2;
        }
    }

    protected Dimension paintBarcode(Graphics graphics) throws Exception {
        if (this.guardBarHeight == 0 && this.textFont != null) {
            graphics.setFont(this.textFont);
            this.guardBarHeight = graphics.getFontMetrics().getHeight();
        }
        if (this.barType == 3) {
            this.paintEAN8(graphics);
        }
        if (this.barType == 2) {
            this.paintEAN13(graphics);
        }
        if (this.barType == 1) {
            this.paintUPCA(graphics);
        }
        if (this.barType == 4) {
            this.paintUPCE(graphics);
        }
        if (this.barType == 5) {
            this.paintEAN128(graphics);
        }
        return null;
    }

    protected String buildCodeText() {
        if (this.humanReadableCode != null) {
            return this.humanReadableCode;
        }
        if (this.code.startsWith("(")) {
            return this.code;
        }
        Object object = this.code;
        while (((String)object).length() < 13) {
            object = "0" + (String)object;
        }
        return "(01)" + (String)object + BarCode.UPCEANCheck((String)object);
    }

    protected Dimension paintText(Graphics graphics, String string, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.textFont != null) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(this.fontColor);
            graphics.setFont(this.textFont);
            int n3 = graphics.getFontMetrics().getHeight();
            int n4 = graphics.getFontMetrics().stringWidth(string);
            int n5 = n - n4 / 2;
            graphics.drawString(string, n5, n2 + n3);
            this.currentY = n2 + n3 + 1;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            return new Dimension(n4, n3 + 1);
        }
        return new Dimension(0, 0);
    }

    protected void renderEAN128(Graphics graphics, int[][] nArray, int n) throws Exception {
        int n2;
        this.currentY = 0;
        this.currentX = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray[0].length && nArray[0][i] != EMPTY; ++i) {
            ++n4;
        }
        int[][] nArray2 = new int[1][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray2[0][n2] = nArray[0][n2];
        }
        if (this.secondaryCode.length() > 0) {
            int n5;
            int n6;
            int[][] nArray3 = null;
            if (this.EAN128WithCCC) {
                var8_10 = new CC_C();
                var8_10.setCode(this.secondaryCode);
                n6 = 1;
                n5 = (n * 11 + 22 - n6 - 5) / 17 - 4;
                if (n5 < 1) {
                    throw new RuntimeException("UCC-128 is too small");
                }
                ((CC_C)var8_10).PDFColumns = n5;
                nArray3 = ((CC_C)var8_10).paintPDF417();
            } else {
                var8_10 = new CC_A();
                var8_10.setCode(this.secondaryCode);
                ((CC_A)var8_10).PDFColumns = this.cccColumns;
                nArray3 = ((CC_A)var8_10).paintPDF417();
            }
            if (!this.EAN128WithCCC) {
                if (n < 9) {
                    throw new RuntimeException("Linear component is too short.");
                }
                int n7 = (int)(Math.floor((n - 9) / 2) * 11.0);
                if (n7 > 0) {
                    n7 += 2;
                }
                this.currentX = nArray2[0].length - (nArray3[0].length + n7 + 1);
            }
            BarCode.renderBarMap(graphics, this.currentX, this.currentY, nArray3, this.barHeight2D, nArray3.length, this.X, this.barColor);
            this.currentY += this.barHeight2D * nArray3.length;
            this.currentX = 0;
            int[][] nArray4 = BarCode.createBarMap(nArray2[0].length, 1, WHITE);
            for (n6 = 0; n6 < nArray2[0].length; ++n6) {
                nArray4[0][n6] = nArray2[0][n6] == BLACK ? WHITE : BLACK;
            }
            if (this.EAN128WithCCC) {
                n6 = 8;
                n5 = 1;
                this.currentX = n6 - n5;
            } else {
                this.currentX = 0;
            }
            BarCode.renderBarMap(graphics, this.currentX, this.currentY, nArray4, this.X, 1, this.X, this.barColor);
            this.currentY += this.X;
            n3 = this.currentX;
        }
        BarCode.renderBarMap(graphics, this.currentX, this.currentY, nArray2, this.barHeight, nArray2.length, this.X, this.barColor);
        this.currentY += this.barHeight;
        this.endOfCode += n3;
        n3 *= this.X;
        this.endOfCode *= this.X;
        if (this.textFont != null) {
            graphics.setColor(this.fontColor);
            graphics.setFont(this.textFont);
            if (this.humanReadableCode != null) {
                this.codeText = this.humanReadableCode;
            }
            n2 = graphics.getFontMetrics().getHeight();
            int n8 = (this.endOfCode - n3 - graphics.getFontMetrics().stringWidth(this.codeText)) / 2;
            if (n8 < 0) {
                n8 = 0;
            }
            graphics.drawString(this.codeText, n3 + n8, this.currentY + n2 + 4);
            this.currentY = this.currentY + n2 + 1;
        }
    }

    protected void renderEANUPC(Graphics graphics, int[][] nArray, int n) {
        Object object;
        this.currentY = 0;
        int n2 = 0;
        int n3 = 0;
        this.currentX = 0;
        int n4 = nArray[0].length - 1;
        int[][] nArray2 = null;
        int[][] nArray3 = null;
        if (this.secondaryCode.length() > 0) {
            object = new CC_A();
            ((CC)object).setCode(this.secondaryCode);
            ((CC_A)object).PDFColumns = n;
            nArray2 = ((CC_A)object).paintPDF417();
            BarCode.renderBarMap(graphics, this.currentX, this.currentY, nArray2, this.barHeight2D, nArray2.length, this.X, this.barColor);
            this.currentY += this.barHeight2D * nArray2.length;
            this.currentX = 0;
            nArray3 = BarCode.createBarMap(nArray[0].length + 2, 3, WHITE);
            nArray3[0][1] = BLACK;
            nArray3[0][n4 + 1] = BLACK;
            nArray3[1][0] = BLACK;
            nArray3[1][n4 + 2] = BLACK;
            nArray3[2][1] = BLACK;
            nArray3[2][n4 + 1] = BLACK;
            BarCode.renderBarMap(graphics, this.currentX + (nArray2[0].length - nArray3[0].length), this.currentY, nArray3, this.X * 2, 3, this.X, this.barColor);
            this.currentY += this.X * 6;
            this.currentX = nArray2[0].length - 1 - nArray[0].length;
            n2 = this.currentY;
            n3 = this.currentX;
        }
        object = new int[]{this.barHeight};
        BarCode.renderBarMap(graphics, this.currentX, this.currentY, nArray, (int[])object, nArray.length, this.X, 0, this.guardBarHeight, this.barColor);
        this.currentY += this.barHeight;
        this.currentX = nArray2 != null ? this.max(nArray2[0].length, ((void)nArray3[0]).length, nArray[0].length) : nArray[0].length;
        this.leftGuardBar += n3;
        this.centerGuardBarStart += n3;
        this.centerGuardBarEnd += n3;
        this.rightGuardBar += n3;
        this.endOfCode += n3;
        this.centerGuardBarStart *= this.X;
        this.centerGuardBarEnd *= this.X;
        this.leftGuardBar *= this.X;
        this.rightGuardBar *= this.X;
        this.endOfCode *= this.X;
        this.endSuplement *= this.X;
        this.startSuplement *= this.X;
        if (this.textFont != null) {
            int n5;
            graphics.setColor(this.fontColor);
            graphics.setFont(this.textFont);
            if (this.humanReadableCode != null) {
                this.codeText = this.humanReadableCode;
            }
            int n6 = graphics.getFontMetrics().getHeight();
            int n7 = graphics.getFontMetrics().stringWidth("X");
            if ((this.UPCEANSupplement2 || this.UPCEANSupplement5) && (this.barType == 3 || this.barType == 1 || this.barType == 4 || this.barType == 2)) {
                n5 = (this.endSuplement - this.startSuplement - graphics.getFontMetrics().stringWidth(this.codeSup)) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeSup, this.startSuplement + n5, n2 + this.suplementTopMargin - 2);
            }
            if (this.barType == 2 && this.guardBars && this.codeText.length() >= 13) {
                n5 = 0;
                graphics.drawString(this.codeText.substring(0, 1), n3 - n7, this.currentY + n6 + 1);
                n5 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 7))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(1, 7), this.leftGuardBar + n5, this.currentY + n6 + 1);
                n5 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(7, 13))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(7, 13), this.centerGuardBarEnd + n5, this.currentY + n6 + 1);
                this.currentY = this.currentY + n6 + 1;
                return;
            }
            if (this.barType == 1 && this.guardBars && this.codeText.length() >= 12) {
                n5 = 0;
                graphics.drawString(this.codeText.substring(0, 1), n3 - n7, this.currentY + n6 + 1);
                n5 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(1, 6))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(1, 6), this.leftGuardBar + n5, this.currentY + n6 + 1);
                n5 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(6, 11))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(6, 11), this.centerGuardBarEnd + n5, this.currentY + n6 + 1);
                graphics.drawString(this.codeText.substring(11, 12), this.endOfCode + 3, this.currentY + n6 + 1);
                this.currentY = this.currentY + n6 + 1;
                return;
            }
            if (this.barType == 3 && this.guardBars && this.codeText.length() >= 8) {
                n5 = 0;
                n5 = (this.centerGuardBarStart - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText.substring(0, 4))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(0, 4), this.leftGuardBar + n5, this.currentY + n6 + 1);
                n5 = (this.rightGuardBar - this.centerGuardBarEnd - graphics.getFontMetrics().stringWidth(this.codeText.substring(4, 8))) / 2;
                if (n5 < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText.substring(4, 8), this.centerGuardBarEnd + n5, this.currentY + n6 + 1);
                this.currentY = this.currentY + n6 + 1;
                return;
            }
            if (this.barType == 4 && this.guardBars) {
                n5 = 0;
                if (this.EANUPCPrintFlag) {
                    graphics.drawString(this.code.substring(0, 1), n3 - n7, this.currentY + n6 + 1);
                }
                if ((n5 = (this.rightGuardBar - this.leftGuardBar - graphics.getFontMetrics().stringWidth(this.codeText)) / 2) < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.codeText, this.leftGuardBar + n5, this.currentY + n6 + 1);
                this.currentY = this.barHeight + n6 + 1;
                return;
            }
        }
    }

    private int findInArray(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }

    private String convertCode128ControlChar(String string) {
        String string2 = "\u00ca";
        String string3 = "\u00c5";
        String string4 = "\u00c4";
        String string5 = "\u00c9";
        String string6 = "\u00c8";
        if (string.compareTo(string2) == 0) {
            string = "_102";
        }
        if (string.compareTo("#") == 0) {
            string = "_102";
        }
        if (string.compareTo(string5) == 0) {
            string = "_101";
        }
        if (string.compareTo(string6) == 0) {
            string = "_100";
        }
        if (string.compareTo(string3) == 0) {
            string = "_97";
        }
        if (string.compareTo(string4) == 0) {
            string = "_96";
        }
        return string;
    }

    private boolean isDigit(String string) {
        if (string.length() > 1) {
            return false;
        }
        return string.charAt(0) >= '0' && string.charAt(0) <= '9';
    }

    private int getNextLowerCase(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) < 'a' || string.charAt(i) > 'z') continue;
            return i;
        }
        return 9999;
    }

    private int getNextControlChar(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) >= ' ') continue;
            return i;
        }
        return 9999;
    }

    private char calculateNextSet(String string, int n) {
        if (string.length() >= n + 4 && this.isDigit("" + string.charAt(n)) && this.isDigit("" + string.charAt(n + 1)) && this.isDigit("" + string.charAt(n + 2)) && this.isDigit("" + string.charAt(n + 3))) {
            return 'C';
        }
        if (this.getNextControlChar(string, n) < this.getNextLowerCase(string, n)) {
            return 'A';
        }
        return 'B';
    }

    private String applyTilde(String string) {
        char c = '\u0000';
        int n = string.length();
        Object object = "";
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '~') {
                if (i >= n - 1) continue;
                char c2 = string.charAt(i + 1);
                if (c2 == '~') {
                    object = (String)object + "~";
                    ++i;
                    continue;
                }
                if (i >= n - 3) continue;
                String string2 = string.substring(i + 1, i + 4);
                int n2 = 0;
                try {
                    n2 = new Integer(string2);
                }
                catch (Exception exception) {
                    n2 = 0;
                }
                if (n2 > 255) {
                    n2 = 255;
                }
                object = (String)object + (char)n2;
                i += 3;
                continue;
            }
            object = (String)object + (char)c;
        }
        return object;
    }

    private int max(int n, int n2, int n3) {
        if (n >= n2 && n >= n3) {
            return n;
        }
        if (n2 >= n && n2 >= n3) {
            return n2;
        }
        return n3;
    }

    protected static int addBarMap(int[][] nArray, int n, int n2, int n3, boolean bl) {
        return BarCode.addBarMap(nArray, n, n2, n3, bl, false, BLACK);
    }

    protected static int[][] createBarMap(int n, int n2, int n3) {
        int[][] nArray = new int[n2][n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i][j] = n3;
            }
        }
        return nArray;
    }

    protected static void printBarMap(int[][] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.println("");
            for (int j = 0; j < nArray[0].length; ++j) {
                if (nArray[i][j] == BLACK) {
                    System.out.print("X");
                }
                if (nArray[i][j] == BLACK_SUPLEMENT) {
                    System.out.print("X");
                }
                if (nArray[i][j] == BLACK_GUARDBAR) {
                    System.out.print("X");
                }
                if (nArray[i][j] == WHITE) {
                    System.out.print(" ");
                }
                if (nArray[i][j] != EMPTY) continue;
                System.out.print("_");
            }
        }
    }

    protected static String barMapAsString(int[][] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < nArray[0].length; ++j) {
                if (nArray[i][j] == BLACK) {
                    stringBuffer.append("X");
                }
                if (nArray[i][j] == BLACK_SUPLEMENT) {
                    stringBuffer.append("X");
                }
                if (nArray[i][j] == BLACK_GUARDBAR) {
                    stringBuffer.append("X");
                }
                if (nArray[i][j] == WHITE) {
                    stringBuffer.append(" ");
                }
                if (nArray[i][j] != EMPTY) continue;
                stringBuffer.append("_");
            }
        }
        return stringBuffer.toString();
    }

    protected static Dimension renderBarMap(Graphics graphics, int n, int n2, int[][] nArray, int n3, int n4, int n5, Color color) {
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = n3;
        }
        return BarCode.renderBarMap(graphics, n, n2, nArray, nArray2, n4, n5, 0, 0, color);
    }

    protected static Dimension renderBarMap(Graphics graphics, int n, int n2, int[][] nArray, int[] nArray2, int n3, int n4, int n5, int n6, Color color) {
        int n7 = n;
        int n8 = n2;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < n3; ++i) {
            n7 = n;
            n9 = WHITE;
            n10 = 0;
            for (int j = 0; j < nArray[0].length; ++j) {
                if (n9 == BLACK && (nArray[i][j] == WHITE || nArray[i][j] == EMPTY)) {
                    n7 += BarCode.addBarAt(graphics, n7, n8, n10 * n4, nArray2[i], true, color);
                    n10 = 0;
                    n9 = WHITE;
                }
                if (n9 == WHITE && nArray[i][j] != WHITE && nArray[i][j] != EMPTY) {
                    n7 += BarCode.addBarAt(graphics, n7, n8, n10 * n4, nArray2[i], false, color);
                    n10 = 0;
                    n9 = nArray[i][j];
                }
                if (n9 == BLACK_GUARDBAR && (nArray[i][j] == WHITE || nArray[i][j] == EMPTY)) {
                    n7 += BarCode.addBarAt(graphics, n7, n8, n10 * n4, nArray2[i] + n6, true, color);
                    n10 = 0;
                    n9 = WHITE;
                }
                if (n9 == BLACK_SUPLEMENT && (nArray[i][j] == WHITE || nArray[i][j] == EMPTY)) {
                    n7 += BarCode.addBarAt(graphics, n7, n8 + (nArray2[i] - n5), n10 * n4, n5, true, color);
                    n10 = 0;
                    n9 = WHITE;
                }
                ++n10;
            }
            n7 = n9 == BLACK_GUARDBAR ? (n7 += BarCode.addBarAt(graphics, n7, n8, n10 * n4, nArray2[i] + n6, true, color)) : (n9 == BLACK_SUPLEMENT ? (n7 += BarCode.addBarAt(graphics, n7, n8 + (nArray2[i] - n5), n10 * n4, n5, true, color)) : (n7 += BarCode.addBarAt(graphics, n7, n8, n10 * n4, nArray2[i], n9 == BLACK, color)));
            n8 += nArray2[i];
        }
        return new Dimension(n7 - n, n8 - n2);
    }

    protected static int addBarAt(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Color color) {
        if (bl) {
            graphics.setColor(color);
            graphics.fillRect(n, n2, n3, n4);
        }
        return n3;
    }

    protected static int addBarMap(int[][] nArray, int n, int n2, int n3, boolean bl, boolean bl2, int n4) {
        int n5 = n4;
        if (bl2) {
            if (bl) {
                for (int i = n; i > n - n3; --i) {
                    nArray[n2][i] = n5;
                }
            } else {
                for (int i = n; i > n - n3; --i) {
                    nArray[n2][i] = WHITE;
                }
            }
        } else if (bl) {
            for (int i = n; i < n + n3; ++i) {
                nArray[n2][i] = n5;
            }
        } else {
            for (int i = n; i < n + n3; ++i) {
                nArray[n2][i] = WHITE;
            }
        }
        return n3;
    }

    protected static double mod(double d, double d2) {
        double d3 = d / d2;
        double d4 = Math.round(d3);
        if (d4 > d3) {
            d4 -= 1.0;
        }
        return d - d2 * d4;
    }
}

