/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rss;

import com.java4less.rss.BarCode;
import com.java4less.rss.CC;
import com.java4less.rss.CC_A;
import java.awt.Dimension;
import java.awt.Graphics;
import java.math.BigInteger;

public class RSS
extends BarCode {
    public static int FORMAT_REGULAR = 0;
    public static int FORMAT_TRUNCATED = 1;
    public static int FORMAT_STACKED = 2;
    public static int FORMAT_STACKED_OMNIDIRECTIONAL = 3;
    public static int FORMAT_LIMITED = 4;
    public static int FORMAT_EXPANDED = 5;
    public static int FORMAT_EXPANDED_STACKED = 6;
    private static int[][] tableInside_15_4 = new int[][]{{10, 7, 5, 2, 4, 335, 0}, {8, 5, 7, 4, 20, 1035, 336}, {6, 3, 9, 6, 48, 1515, 1036}, {4, 1, 11, 8, 81, 1596, 1516}};
    private static int[][] tableOutside_16_4 = new int[][]{{12, 8, 4, 1, 1, 160, 0}, {10, 6, 6, 3, 10, 960, 161}, {8, 4, 8, 5, 34, 2014, 961}, {6, 3, 10, 6, 70, 2714, 2015}, {4, 1, 12, 8, 126, 2840, 2715}};
    private static int[] finderPatternWidths = new int[]{3, 8, 2, 3, 5, 5, 3, 3, 7, 3, 1, 9, 2, 7, 4, 2, 5, 6, 2, 3, 8, 1, 5, 7, 1, 3, 9};
    private static int[] leftWeights = new int[]{1, 3, 9, 27, 2, 6, 18, 54, 4, 12, 36, 29, 8, 24, 72, 58};
    private static int[] rightWeights = new int[]{16, 48, 65, 37, 32, 17, 51, 74, 64, 34, 23, 69, 49, 68, 46, 59};
    protected int leftChecksum = 0;
    protected int rightChecksum = 0;
    protected boolean linkFlag = false;
    protected int format = FORMAT_REGULAR;
    private final int TABLE_GSUM = 6;
    private final int TABLE_RANGE = 5;
    private final int TABLE_TEVEN = 4;
    private final int TABLE_TODD = 4;
    private final int CHECKSUM_MOD = 79;
    private boolean debug = false;

    public RSS() {
        this.barType = 6;
    }

    public RSS(int n) {
        this.barType = 6;
        this.format = n;
    }

    public int getRSSFormat() {
        return this.format;
    }

    public void setRSSFormat(int n) {
        this.format = n;
    }

    protected Dimension paintStackedBarcode(Graphics graphics, int[] nArray) throws Exception {
        int n;
        int n2 = 0;
        int n3 = 0;
        int[][] nArray2 = null;
        int[] nArray3 = null;
        if (this.format == FORMAT_STACKED) {
            this.barHeight = this.X * 6;
            nArray2 = RSS.createBarMap(50, 3, 0);
            nArray3 = new int[]{5 * this.X, this.X, 7 * this.X};
        } else {
            nArray2 = RSS.createBarMap(50, 5, 0);
            nArray3 = new int[]{this.barHeight, this.X, this.X, this.X, this.barHeight};
        }
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, false);
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, true);
        boolean bl = true;
        for (n = 0; n < nArray.length / 2; ++n) {
            n2 += RSS.addBarMap(nArray2, n2, n3, nArray[n], !bl);
            bl = !bl;
        }
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, true);
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, false);
        n3 = this.format == FORMAT_STACKED ? 2 : 4;
        n2 = 0;
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, true);
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, false);
        for (n = nArray.length / 2; n < nArray.length; ++n) {
            n2 += RSS.addBarMap(nArray2, n2, n3, nArray[n], !bl);
            bl = !bl;
        }
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, false);
        n2 += RSS.addBarMap(nArray2, n2, n3, 1, true);
        if (this.format == FORMAT_STACKED) {
            this.paintStackedSeparator(nArray2);
        } else {
            this.paintStackedOmniDirectionalSeparator(nArray2);
        }
        int[] nArray4 = new int[nArray2[0].length];
        this.paintRSS2DSeparator(nArray2[0], nArray4);
        if (this.format == FORMAT_STACKED) {
            return this.renderRSS(graphics, nArray2, nArray4, true, false, 2, -1);
        }
        return this.renderRSS(graphics, nArray2, nArray4, true, false, 3, -1);
    }

    protected Dimension paintNonStackedBarcode(Graphics graphics, int[] nArray) throws Exception {
        int[][] nArray2 = RSS.createBarMap(96, 1, EMPTY);
        int n = 0;
        if (this.format == FORMAT_TRUNCATED) {
            this.barHeight = this.X * 13;
        }
        n += BarCode.addBarMap(nArray2, n, 0, 1, false);
        n += BarCode.addBarMap(nArray2, n, 0, 1, true);
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            n += BarCode.addBarMap(nArray2, n, 0, nArray[i], !bl);
            bl = !bl;
        }
        n += BarCode.addBarMap(nArray2, n, 0, 1, false);
        n += BarCode.addBarMap(nArray2, n, 0, 1, true);
        int[] nArray3 = new int[nArray2[0].length];
        this.paintRSS2DSeparatorNonStacked(nArray2[0], nArray3);
        return this.renderRSS(graphics, nArray2, nArray3, false, false, 4, -1);
    }

    @Override
    protected Dimension paintBarcode(Graphics graphics) throws Exception {
        super.paintBarcode(graphics);
        if (this.barType != 6) {
            return new Dimension(0, 0);
        }
        if (this.format != FORMAT_REGULAR && this.format != FORMAT_STACKED_OMNIDIRECTIONAL && this.format != FORMAT_TRUNCATED && this.format != FORMAT_STACKED) {
            this.format = FORMAT_REGULAR;
        }
        this.linkFlag = this.secondaryCode.length() > 0;
        this.currentX = 0;
        this.currentY = 0;
        if (this.barHeight < this.X * 33) {
            this.barHeight = this.X * 33;
        }
        int[] nArray = this.createRSS14Pattern(this.code);
        if (this.format == FORMAT_REGULAR || this.format == FORMAT_TRUNCATED) {
            return this.paintNonStackedBarcode(graphics, nArray);
        }
        return this.paintStackedBarcode(graphics, nArray);
    }

    protected int[] createRSS14Pattern(String string) {
        int n;
        int n2;
        int n3;
        BigInteger bigInteger = new BigInteger(string, 10);
        boolean bl = this.linkFlag;
        int[] nArray = new int[42];
        int n4 = 0;
        if (bl) {
            bigInteger = bigInteger.add(new BigInteger("10000000000000", 10));
        }
        if (this.debug) {
            System.out.println("Data is " + bigInteger.toString(10));
        }
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[29] = 1;
        nArray[30] = 1;
        long l = (long)Math.floor(bigInteger.divide(new BigInteger("4537077", 10)).longValue());
        long l2 = bigInteger.mod(new BigInteger("4537077", 10)).longValue();
        long l3 = (long)Math.floor(l / 1597L);
        long l4 = l % 1597L;
        for (n3 = 0; l3 > (long)tableOutside_16_4[n3][5] && n3 < 4; ++n3) {
        }
        int n5 = tableOutside_16_4[n3][0];
        int n6 = tableOutside_16_4[n3][1];
        long l5 = (long)Math.floor((l3 - (long)tableOutside_16_4[n3][6]) / (long)tableOutside_16_4[n3][4]);
        long l6 = (l3 - (long)tableOutside_16_4[n3][6]) % (long)tableOutside_16_4[n3][4];
        if (this.debug) {
            System.out.println("Value 1 is  " + l5);
        }
        int[] nArray2 = this.getRSSwidths((int)l5, n5, 4, n6, 1);
        n4 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n2]);
            }
            nArray[n2 * 2] = nArray2[n2];
            n4 += leftWeights[n2 * 2] * nArray2[n2];
            n4 %= 79;
        }
        n5 = tableOutside_16_4[n3][2];
        n6 = tableOutside_16_4[n3][3];
        if (this.debug) {
            System.out.println("Value 2 is  " + l6);
        }
        nArray2 = this.getRSSwidths((int)l6, n5, 4, n6, 0);
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n2]);
            }
            nArray[1 + n2 * 2] = nArray2[n2];
            n4 += leftWeights[n2 * 2 + 1] * nArray2[n2];
            n4 %= 79;
        }
        for (n3 = 0; l4 > (long)tableInside_15_4[n3][5] && n3 < 3; ++n3) {
        }
        n5 = tableInside_15_4[n3][0];
        n6 = tableInside_15_4[n3][1];
        l5 = (long)Math.floor((l4 - (long)tableInside_15_4[n3][6]) / (long)tableInside_15_4[n3][4]);
        l6 = (l4 - (long)tableInside_15_4[n3][6]) % (long)tableInside_15_4[n3][4];
        if (this.debug) {
            System.out.println("Value 3 is  " + l5);
        }
        nArray2 = this.getRSSwidths((int)l5, n5, 4, n6, 1);
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n2]);
            }
            nArray[19 - n2 * 2] = nArray2[n2];
            n4 += leftWeights[n2 * 2 + 1 + 8] * nArray2[n2];
            n4 %= 79;
        }
        n5 = tableInside_15_4[n3][2];
        n6 = tableInside_15_4[n3][3];
        if (this.debug) {
            System.out.println("Value 4 is  " + l6);
        }
        nArray2 = this.getRSSwidths((int)l6, n5, 4, n6, 0);
        for (n2 = 0; n2 < 4; ++n2) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n2]);
            }
            nArray[20 - n2 * 2] = nArray2[n2];
            n4 += leftWeights[n2 * 2 + 8] * nArray2[n2];
            n4 %= 79;
        }
        l2 = bigInteger.mod(new BigInteger("4537077", 10)).longValue();
        long l7 = (long)Math.floor(l2 / 1597L);
        long l8 = l2 % 1597L;
        for (n3 = 0; l7 > (long)tableOutside_16_4[n3][5] && n3 < 4; ++n3) {
        }
        n5 = tableOutside_16_4[n3][0];
        n6 = tableOutside_16_4[n3][1];
        l5 = (long)Math.floor((l7 - (long)tableOutside_16_4[n3][6]) / (long)tableOutside_16_4[n3][4]);
        l6 = (l7 - (long)tableOutside_16_4[n3][6]) % (long)tableOutside_16_4[n3][4];
        if (this.debug) {
            System.out.println("Value 5 is  " + l5);
        }
        nArray2 = this.getRSSwidths((int)l5, n5, 4, n6, 1);
        for (n = 0; n < 4; ++n) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n]);
            }
            nArray[41 - n * 2] = nArray2[n];
            n4 += rightWeights[n * 2] * nArray2[n];
            n4 %= 79;
        }
        n5 = tableOutside_16_4[n3][2];
        n6 = tableOutside_16_4[n3][3];
        if (this.debug) {
            System.out.println("Value 6 is  " + l6);
        }
        nArray2 = this.getRSSwidths((int)l6, n5, 4, n6, 0);
        for (n = 0; n < 4; ++n) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n]);
            }
            nArray[40 - n * 2] = nArray2[n];
            n4 += rightWeights[n * 2 + 1] * nArray2[n];
            n4 %= 79;
        }
        for (n3 = 0; l8 > (long)tableInside_15_4[n3][5] && n3 < 3; ++n3) {
        }
        n5 = tableInside_15_4[n3][0];
        n6 = tableInside_15_4[n3][1];
        l5 = (long)Math.floor((l8 - (long)tableInside_15_4[n3][6]) / (long)tableInside_15_4[n3][4]);
        l6 = (l8 - (long)tableInside_15_4[n3][6]) % (long)tableInside_15_4[n3][4];
        if (this.debug) {
            System.out.println("Value 7 is  " + l5);
        }
        nArray2 = this.getRSSwidths((int)l5, n5, 4, n6, 1);
        for (n = 0; n < 4; ++n) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n]);
            }
            nArray[22 + n * 2] = nArray2[n];
            n4 += rightWeights[n * 2 + 1 + 8] * nArray2[n];
            n4 %= 79;
        }
        n5 = tableInside_15_4[n3][2];
        n6 = tableInside_15_4[n3][3];
        if (this.debug) {
            System.out.println("Value 8 is  " + l6);
        }
        nArray2 = this.getRSSwidths((int)l6, n5, 4, n6, 0);
        for (n = 0; n < 4; ++n) {
            if (this.debug) {
                System.out.println("width is " + nArray2[n]);
            }
            nArray[21 + n * 2] = nArray2[n];
            n4 += rightWeights[n * 2 + 8] * nArray2[n];
            n4 %= 79;
        }
        if (n4 >= 8) {
            ++n4;
        }
        if (n4 >= 72) {
            ++n4;
        }
        if (this.debug) {
            System.out.println("Checksum is " + n4);
        }
        this.leftChecksum = n4 / 9;
        this.rightChecksum = n4 % 9;
        for (n = 0; n < 3; ++n) {
            nArray[8 + n] = finderPatternWidths[this.leftChecksum * 3 + n];
        }
        for (n = 0; n < 3; ++n) {
            nArray[33 - n] = finderPatternWidths[this.rightChecksum * 3 + n];
        }
        for (n = 0; n < nArray.length; ++n) {
            if (!this.debug) continue;
            System.out.println("Bar " + n + " = " + nArray[n]);
        }
        return nArray;
    }

    protected int[] getRSSwidths(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int[] nArray = new int[14];
        for (int i = 0; i < n3 - 1; ++i) {
            int n7;
            int n8 = 1;
            n6 |= 1 << i;
            while (true) {
                n7 = this.combins(n2 - n8 - 1, n3 - i - 2);
                if (n5 == 0 && n6 == 0 && n2 - n8 - (n3 - i - 1) >= n3 - i - 1) {
                    n7 -= this.combins(n2 - n8 - (n3 - i), n3 - i - 2);
                }
                if (n3 - i - 1 > 1) {
                    int n9 = 0;
                    for (int j = n2 - n8 - (n3 - i - 2); j > n4; --j) {
                        n9 += this.combins(n2 - n8 - j - 1, n3 - i - 3);
                    }
                    n7 -= n9 * (n3 - 1 - i);
                } else if (n2 - n8 > n4) {
                    --n7;
                }
                if ((n -= n7) < 0) break;
                ++n8;
                n6 &= ~(1 << i);
            }
            n += n7;
            n2 -= n8;
            nArray[i] = n8;
        }
        nArray[i] = n2;
        return nArray;
    }

    protected int combins(int n, int n2) {
        int n3;
        int n4;
        if (n - n2 > n2) {
            n4 = n2;
            n3 = n - n2;
        } else {
            n4 = n - n2;
            n3 = n2;
        }
        int n5 = 1;
        int n6 = 1;
        for (int i = n; i > n3; --i) {
            n5 *= i;
            if (n6 > n4) continue;
            n5 /= n6;
            ++n6;
        }
        while (n6 <= n4) {
            n5 /= n6;
            ++n6;
        }
        return n5;
    }

    protected Dimension renderRSS(Graphics graphics, int[][] nArray, int[] nArray2, boolean bl, boolean bl2, int n, int n2) {
        Object object;
        int[][] nArray3 = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.linkFlag) {
            object = new CC_A();
            ((CC)object).setCode(this.secondaryCode);
            ((CC_A)object).PDFColumns = n;
            nArray3 = ((CC_A)object).paintPDF417();
            if (!bl && !bl2) {
                n3 = 0;
            }
            if (bl && !bl2) {
                n3 = 1;
            }
            if (bl && bl2) {
                n3 = 2;
            }
            Dimension dimension = BarCode.renderBarMap(graphics, n3, n4, nArray3, this.barHeight2D, nArray3.length, this.X, this.barColor);
            n5 = Math.max(n5, dimension.width + n3);
            n4 += this.barHeight2D * nArray3.length;
            if (!bl && !bl2) {
                n3 = nArray3[0].length - nArray[0].length + 1;
            }
            if (bl && !bl2) {
                n3 = 0;
            }
            if (bl && bl2) {
                n3 = 0;
            }
            int[][] nArrayArray = new int[][]{nArray2};
            dimension = BarCode.renderBarMap(graphics, n3, n4, nArrayArray, this.X, 1, this.X, this.barColor);
            n5 = Math.max(n5, dimension.width + n3);
            n4 += this.X;
        }
        if (!bl) {
            object = BarCode.renderBarMap(graphics, n3, n4, nArray, this.barHeight, nArray.length, this.X, this.barColor);
            n5 = Math.max(n5, ((Dimension)object).width + n3);
            n4 += this.barHeight;
        }
        if (bl && !bl2) {
            object = new int[nArray.length];
            int n6 = 0;
            int n7 = 2;
            if (this.format == FORMAT_STACKED_OMNIDIRECTIONAL) {
                n7 = 4;
            }
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = i % n7 == 0 ? (Object)this.barHeight : (Object)this.X;
                n6 += object[i];
            }
            Dimension dimension = BarCode.renderBarMap(graphics, n3, n4, nArray, (int[])object, nArray.length, this.X, 0, 0, this.barColor);
            n5 = Math.max(n5, dimension.width + n3);
            n4 += n6;
        }
        if (bl && bl2) {
            object = new int[nArray.length];
            int n8 = 0;
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i] = i % 4 == 0 ? (Object)this.barHeight : (Object)this.X;
                if (i >= n2) continue;
                n8 += object[i];
            }
            Dimension dimension = BarCode.renderBarMap(graphics, n3, n4, nArray, (int[])object, nArray.length, this.X, 0, 0, this.barColor);
            n5 = Math.max(n5, dimension.width + n3);
            n4 += n8;
        }
        object = this.buildCodeText();
        Dimension dimension = this.paintText(graphics, (String)object, n5 / 2, n4);
        this.currentY = n4 += dimension.height;
        this.currentX = n3 + (nArray[0].length + this.X);
        return new Dimension(n5, n4);
    }

    private void paintStackedSeparator(int[][] nArray) {
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        int n3 = nArray[0].length;
        n += RSS.addBarMap(nArray, n, n2, 1, false);
        for (int i = 1; i < n3; ++i) {
            if (nArray[0][n] == nArray[2][n]) {
                if (nArray[0][n] == 1) {
                    n += RSS.addBarMap(nArray, n, n2, 1, false);
                    bl = false;
                    continue;
                }
                n += RSS.addBarMap(nArray, n, n2, 1, true);
                bl = true;
                continue;
            }
            bl = i <= 3 || i >= n3 - 4 ? false : !bl;
            n += RSS.addBarMap(nArray, n, n2, 1, bl);
        }
    }

    private void paintRSS2DSeparator(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 4; i < n - 4; ++i) {
            if (i >= 18 && i <= 30) {
                if (this.leftChecksum == 3 && i == 27) {
                    nArray2[i + 1] = BLACK;
                    continue;
                }
                if (this.leftChecksum == 3 && i == 28) continue;
                if (nArray[i] == BLACK) {
                    nArray2[i] = WHITE;
                    continue;
                }
                nArray2[i] = nArray2[i - 1] == BLACK ? WHITE : BLACK;
                continue;
            }
            nArray2[i] = nArray[i] == WHITE ? BLACK : WHITE;
        }
    }

    private void paintRSS2DSeparatorNonStacked(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 4; i < n - 4; ++i) {
            if (i >= 18 && i <= 30 || i >= 65 && i <= 77) {
                if (this.rightChecksum == 3 && i == 74) {
                    nArray2[i + 1] = BLACK;
                    continue;
                }
                if (this.rightChecksum == 3 && i == 75) continue;
                if (this.leftChecksum == 3 && i == 27) {
                    nArray2[i + 1] = BLACK;
                    continue;
                }
                if (this.leftChecksum == 3 && i == 28) continue;
                if (nArray[i] == BLACK) {
                    nArray2[i] = WHITE;
                    continue;
                }
                nArray2[i] = nArray2[i - 1] == BLACK ? WHITE : BLACK;
                continue;
            }
            nArray2[i] = nArray[i] == WHITE ? BLACK : WHITE;
        }
    }

    private void paintStackedOmniDirectionalSeparator(int[][] nArray) {
        int n;
        boolean bl = false;
        int n2 = 1;
        int n3 = nArray[0].length;
        for (n = 4; n < n3 - 4; ++n) {
            if (n >= 18 && n <= 30) {
                if (nArray[0][n] == 1) {
                    RSS.addBarMap(nArray, n, n2, 1, false);
                    continue;
                }
                RSS.addBarMap(nArray, n, n2, 1, nArray[1][n - 1] == 0);
                continue;
            }
            if (nArray[0][n] == 0) {
                RSS.addBarMap(nArray, n, n2, 1, true);
                continue;
            }
            RSS.addBarMap(nArray, n, n2, 1, false);
        }
        n2 = 2;
        bl = false;
        for (n = 4; n < n3 - 4; ++n) {
            RSS.addBarMap(nArray, n, n2, 1, bl);
            bl = !bl;
        }
        n2 = 3;
        for (n = 4; n < n3 - 4; ++n) {
            if (n >= 19 && n <= 31) {
                if (this.rightChecksum == 3 && n == 28) {
                    RSS.addBarMap(nArray, n + 1, n2, 1, true);
                    continue;
                }
                if (this.rightChecksum == 3 && n == 29) continue;
                if (nArray[4][n] == 1) {
                    RSS.addBarMap(nArray, n, n2, 1, false);
                    continue;
                }
                RSS.addBarMap(nArray, n, n2, 1, nArray[3][n - 1] == 0);
                continue;
            }
            if (nArray[4][n] == 0) {
                RSS.addBarMap(nArray, n, n2, 1, true);
                continue;
            }
            RSS.addBarMap(nArray, n, n2, 1, false);
        }
    }
}

