/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import java.io.DataInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Arrays;

public final class Utils {
    public static final int ALIGN_LEFT = 10;
    public static final int ALIGN_RIGHT = 12;

    private Utils() {
    }

    public static int readLittleEndianInt(DataInput dataInput) throws IOException {
        int n = 0;
        for (int i = 0; i < 32; i += 8) {
            n |= (dataInput.readUnsignedByte() & 0xFF) << i;
        }
        return n;
    }

    public static short readLittleEndianShort(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte() & 0xFF;
        int n2 = dataInput.readUnsignedByte();
        return (short)(n2 << 8 | n);
    }

    public static byte[] trimLeftSpaces(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 32) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString().getBytes();
    }

    public static short littleEndian(short s) {
        short s2 = s;
        int n = 255;
        short s3 = (short)(s2 & n);
        s3 = (short)(s3 << 8);
        n = (short)(n << 8);
        s3 = (short)(s3 | (s2 & n) >> 8);
        return s3;
    }

    public static int littleEndian(int n) {
        int n2 = n;
        int n3 = 255;
        int n4 = 0;
        n4 |= n2 & n3;
        for (int i = 1; i < 4; ++i) {
            n4 <<= 8;
            n4 |= (n2 & (n3 <<= 8)) >> 8 * i;
        }
        return n4;
    }

    public static byte[] textPadding(String string, String string2, int n) throws UnsupportedEncodingException {
        return Utils.textPadding(string, string2, n, 10);
    }

    public static byte[] textPadding(String string, String string2, int n, int n2) throws UnsupportedEncodingException {
        return Utils.textPadding(string, string2, n, n2, (byte)32);
    }

    public static byte[] textPadding(String string, String string2, int n, int n2, byte by) throws UnsupportedEncodingException {
        if (string.length() >= n) {
            return string.substring(0, n).getBytes(string2);
        }
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        switch (n2) {
            case 10: {
                System.arraycopy(string.getBytes(string2), 0, byArray, 0, string.length());
                break;
            }
            case 12: {
                int n3 = n - string.length();
                System.arraycopy(string.getBytes(string2), 0, byArray, n3, string.length());
            }
        }
        return byArray;
    }

    public static byte[] doubleFormating(Double d, String string, int n, int n2) throws UnsupportedEncodingException {
        int n3;
        int n4 = n - (n2 > 0 ? n2 + 1 : 0);
        StringBuffer stringBuffer = new StringBuffer(n);
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.append('#');
        }
        if (n2 > 0) {
            stringBuffer.append('.');
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append('0');
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuffer.toString());
        return Utils.textPadding(decimalFormat.format(d).toString(), string, n, 12);
    }

    public static boolean contains(byte[] byArray, byte by) {
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != by) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

