/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodePostnet
extends Barcode {
    private static final byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String object) {
        int n;
        int n2 = 0;
        for (int i = ((String)object).length() - 1; i >= 0; --i) {
            n = ((String)object).charAt(i) - 48;
            n2 += n;
        }
        object = (String)object + (char)((10 - n2 % 10) % 10 + 48);
        byte[] byArray = new byte[((String)object).length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        for (n = 0; n < ((String)object).length(); ++n) {
            int n3 = ((String)object).charAt(n) - 48;
            System.arraycopy(BARS[n3], 0, byArray, n * 5 + 1, 5);
        }
        return byArray;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float f = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f, this.barHeight);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f = 0.0f;
        for (int i = 0; i < byArray.length; ++i) {
            pdfContentByte.rectangle(f, 0.0f, this.x - this.inkSpreading, byArray[i] == by ? this.barHeight : this.size);
            f += this.n;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color color, Color color2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = color.getRGB();
        int n8 = color2.getRGB();
        Canvas canvas = new Canvas();
        int n9 = (int)this.x;
        if (n9 <= 0) {
            n9 = 1;
        }
        if ((n6 = (int)this.n) <= n9) {
            n6 = n9 + 1;
        }
        if ((n5 = (int)this.size) <= 0) {
            n5 = 1;
        }
        if ((n4 = (int)this.barHeight) <= n5) {
            n4 = n5 + 1;
        }
        int n10 = ((this.code.length() + 1) * 5 + 1) * n6 + n9;
        int[] nArray = new int[n10 * n4];
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        int n11 = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = byArray[n3] == by ? 1 : 0;
            for (n = 0; n < n6; ++n) {
                nArray[n11 + n] = n2 != 0 && n < n9 ? n7 : n8;
            }
            n11 += n6;
        }
        n3 = n10 * (n4 - n5);
        for (n2 = n10; n2 < n3; n2 += n10) {
            System.arraycopy(nArray, 0, nArray, n2, n10);
        }
        n11 = n3;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            for (n = 0; n < n6; ++n) {
                nArray[n11 + n] = n < n9 ? n7 : n8;
            }
            n11 += n6;
        }
        for (n2 = n3 + n10; n2 < nArray.length; n2 += n10) {
            System.arraycopy(nArray, n3, nArray, n2, n10);
        }
        Image image = canvas.createImage(new MemoryImageSource(n10, n4, nArray, 0, n10));
        return image;
    }
}

