/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.TSAClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.X509CRLParser;
import org.bouncycastle.jce.provider.X509CertParser;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.bouncycastle.tsp.TimeStampToken;

public class PdfPKCS7 {
    private byte[] sigAttr;
    private byte[] digestAttr;
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private Collection signCerts;
    private X509Certificate signCert;
    private byte[] digest;
    private MessageDigest messageDigest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private byte[] RSAdata;
    private boolean verified;
    private boolean verifyResult;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String provider;
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    private static final String ID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    private static final String ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    private static final String ID_ADBE_REVOCATION = "1.2.840.113583.1.1.8";
    public static final ASN1ObjectIdentifier AuthorityInfoAccess = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.1");
    private String reason;
    private String location;
    private Calendar signDate;
    private String signName;
    private TimeStampToken timeStampToken;
    private static final HashMap<String, String> digestNames = new HashMap();
    private static final HashMap<String, String> algorithmNames = new HashMap();
    private static final HashMap<String, String> allowedDigests = new HashMap();
    private BasicOCSPResp basicResp;

    public static String getDigest(String string) {
        String string2 = digestNames.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getAlgorithm(String string) {
        String string2 = algorithmNames.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampToken == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = this.timeStampToken.getTimeStampInfo().getGenTime();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    public PdfPKCS7(byte[] byArray, byte[] byArray2, String string) {
        try {
            this.provider = string;
            X509CertParser x509CertParser = new X509CertParser();
            x509CertParser.engineInit((InputStream)new ByteArrayInputStream(byArray2));
            this.signCerts = this.certs = x509CertParser.engineReadAll();
            this.signCert = (X509Certificate)this.certs.iterator().next();
            this.crls = new ArrayList();
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            this.digest = ((DEROctetString)aSN1InputStream.readObject()).getOctets();
            this.sig = string == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", string);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.basicResp;
    }

    private void findOcsp(ASN1Sequence aSN1Sequence) throws IOException {
        ASN1InputStream aSN1InputStream;
        this.basicResp = null;
        boolean bl = false;
        while (!(aSN1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            bl = true;
            for (int i = 0; i < aSN1Sequence.size(); ++i) {
                if (aSN1Sequence.getObjectAt(i) instanceof ASN1Sequence) {
                    aSN1Sequence = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
                    bl = false;
                    break;
                }
                if (!(aSN1Sequence.getObjectAt(i) instanceof ASN1TaggedObject)) continue;
                aSN1InputStream = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i);
                if (aSN1InputStream.getBaseObject() instanceof ASN1Sequence) {
                    aSN1Sequence = (ASN1Sequence)aSN1InputStream.getBaseObject();
                    bl = false;
                    break;
                }
                return;
            }
            if (!bl) continue;
            return;
        }
        DEROctetString dEROctetString = (DEROctetString)aSN1Sequence.getObjectAt(1);
        aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
        BasicOCSPResponse basicOCSPResponse = BasicOCSPResponse.getInstance((Object)aSN1InputStream.readObject());
        this.basicResp = new BasicOCSPResp(basicOCSPResponse);
    }

    public PdfPKCS7(byte[] byArray, String string) {
        try {
            AttributeTable attributeTable;
            ASN1Sequence aSN1Sequence;
            ASN1Set aSN1Set;
            ASN1Sequence aSN1Sequence2;
            X509Certificate x509Certificate;
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1Sequence aSN1Sequence3;
            ASN1Primitive aSN1Primitive;
            this.provider = string;
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            try {
                aSN1Primitive = aSN1InputStream.readObject();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("can't decode PKCS7SignedData object");
            }
            if (!(aSN1Primitive instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not a sequence");
            }
            ASN1Sequence aSN1Sequence4 = (ASN1Sequence)aSN1Primitive;
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)aSN1Sequence4.getObjectAt(0);
            if (!aSN1ObjectIdentifier2.getId().equals(ID_PKCS7_SIGNED_DATA)) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not signed data");
            }
            ASN1Sequence aSN1Sequence5 = (ASN1Sequence)((DERTaggedObject)aSN1Sequence4.getObjectAt(1)).getBaseObject();
            this.version = ((ASN1Integer)aSN1Sequence5.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet();
            Enumeration enumeration = ((ASN1Set)aSN1Sequence5.getObjectAt(1)).getObjects();
            while (enumeration.hasMoreElements()) {
                aSN1Sequence3 = (ASN1Sequence)enumeration.nextElement();
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence3.getObjectAt(0);
                this.digestalgos.add(aSN1ObjectIdentifier.getId());
            }
            aSN1Sequence3 = new X509CertParser();
            aSN1Sequence3.engineInit((InputStream)new ByteArrayInputStream(byArray));
            this.certs = aSN1Sequence3.engineReadAll();
            aSN1ObjectIdentifier = new X509CRLParser();
            aSN1ObjectIdentifier.engineInit((InputStream)new ByteArrayInputStream(byArray));
            this.crls = aSN1ObjectIdentifier.engineReadAll();
            ASN1Sequence aSN1Sequence6 = (ASN1Sequence)aSN1Sequence5.getObjectAt(2);
            if (aSN1Sequence6.size() > 1) {
                DEROctetString dEROctetString = (DEROctetString)((DERTaggedObject)aSN1Sequence6.getObjectAt(1)).getBaseObject();
                this.RSAdata = dEROctetString.getOctets();
            }
            int n = 3;
            while (aSN1Sequence5.getObjectAt(n) instanceof DERTaggedObject) {
                ++n;
            }
            ASN1Set aSN1Set2 = (ASN1Set)aSN1Sequence5.getObjectAt(n);
            if (aSN1Set2.size() != 1) {
                throw new IllegalArgumentException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
            }
            ASN1Sequence aSN1Sequence7 = (ASN1Sequence)aSN1Set2.getObjectAt(0);
            this.signerversion = ((ASN1Integer)aSN1Sequence7.getObjectAt(0)).getValue().intValue();
            ASN1Sequence aSN1Sequence8 = (ASN1Sequence)aSN1Sequence7.getObjectAt(1);
            BigInteger bigInteger = ((ASN1Integer)aSN1Sequence8.getObjectAt(1)).getValue();
            ASN1TaggedObject aSN1TaggedObject = this.certs.iterator();
            while (aSN1TaggedObject.hasNext()) {
                x509Certificate = (X509Certificate)aSN1TaggedObject.next();
                if (!bigInteger.equals(x509Certificate.getSerialNumber())) continue;
                this.signCert = x509Certificate;
                break;
            }
            if (this.signCert == null) {
                throw new IllegalArgumentException("Can't find signing certificate with serial " + bigInteger.toString(16));
            }
            this.signCertificateChain();
            this.digestAlgorithm = ((ASN1ObjectIdentifier)((ASN1Sequence)aSN1Sequence7.getObjectAt(2)).getObjectAt(0)).getId();
            n = 3;
            if (aSN1Sequence7.getObjectAt(n) instanceof ASN1TaggedObject) {
                aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence7.getObjectAt(n);
                x509Certificate = ASN1Set.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                this.sigAttr = x509Certificate.getEncoded();
                for (int i = 0; i < x509Certificate.size(); ++i) {
                    aSN1Sequence2 = (ASN1Sequence)x509Certificate.getObjectAt(i);
                    if (((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId().equals(ID_MESSAGE_DIGEST)) {
                        aSN1Set = (ASN1Set)aSN1Sequence2.getObjectAt(1);
                        this.digestAttr = ((DEROctetString)aSN1Set.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (!((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId().equals(ID_ADBE_REVOCATION)) continue;
                    aSN1Set = (ASN1Set)aSN1Sequence2.getObjectAt(1);
                    aSN1Sequence = (ASN1Sequence)aSN1Set.getObjectAt(0);
                    for (int j = 0; j < aSN1Sequence.size(); ++j) {
                        ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1Sequence.getObjectAt(j);
                        if (aSN1TaggedObject2.getTagNo() != 1) continue;
                        ASN1Sequence aSN1Sequence9 = (ASN1Sequence)aSN1TaggedObject2.getBaseObject();
                        this.findOcsp(aSN1Sequence9);
                    }
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException("Authenticated attribute is missing the digest.");
                }
            }
            int n2 = ++n;
            this.digestEncryptionAlgorithm = ((ASN1ObjectIdentifier)((ASN1Sequence)aSN1Sequence7.getObjectAt(n2)).getObjectAt(0)).getId();
            int n3 = ++n;
            this.digest = ((DEROctetString)aSN1Sequence7.getObjectAt(n3)).getOctets();
            if (++n < aSN1Sequence7.size() && aSN1Sequence7.getObjectAt(n) instanceof DERTaggedObject && (aSN1Sequence2 = (attributeTable = new AttributeTable((ASN1Set)(x509Certificate = ASN1Set.getInstance((ASN1TaggedObject)(aSN1TaggedObject = (DERTaggedObject)aSN1Sequence7.getObjectAt(n)), (boolean)false)))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                aSN1Set = aSN1Sequence2.getAttrValues();
                aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1Set.getObjectAt(0));
                ContentInfo contentInfo = ContentInfo.getInstance((Object)aSN1Sequence);
                this.timeStampToken = new TimeStampToken(contentInfo);
            }
            if (this.RSAdata != null || this.digestAttr != null) {
                this.messageDigest = string == null || string.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), string);
            }
            this.sig = string == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string);
            this.sig.initVerify(this.signCert.getPublicKey());
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public PdfPKCS7(PrivateKey privateKey, Certificate[] certificateArray, CRL[] cRLArray, String string, String string2, boolean bl) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int n;
        this.privKey = privateKey;
        this.provider = string2;
        this.digestAlgorithm = allowedDigests.get(string.toUpperCase());
        if (this.digestAlgorithm == null) {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + string);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certificateArray[0];
        for (n = 0; n < certificateArray.length; ++n) {
            this.certs.add(certificateArray[n]);
        }
        if (cRLArray != null) {
            for (n = 0; n < cRLArray.length; ++n) {
                this.crls.add(cRLArray[n]);
            }
        }
        if (privateKey != null) {
            this.digestEncryptionAlgorithm = privateKey.getAlgorithm();
            if (this.digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
            }
        }
        if (bl) {
            this.RSAdata = new byte[0];
            this.messageDigest = string2 == null || string2.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), string2);
        }
        if (privateKey != null) {
            this.sig = string2 == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), string2);
            this.sig.initSign(privateKey);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.RSAdata != null || this.digestAttr != null) {
            this.messageDigest.update(byArray, n, n2);
        } else {
            this.sig.update(byArray, n, n2);
        }
    }

    public boolean verify() throws SignatureException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.sigAttr != null) {
            this.sig.update(this.sigAttr);
            if (this.RSAdata != null) {
                byte[] byArray = this.messageDigest.digest();
                this.messageDigest.update(byArray);
            }
            this.verifyResult = Arrays.equals(this.messageDigest.digest(), this.digestAttr) && this.sig.verify(this.digest);
        } else {
            if (this.RSAdata != null) {
                this.sig.update(this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.digest);
        }
        this.verified = true;
        return this.verifyResult;
    }

    public boolean verifyTimestampImprint() throws NoSuchAlgorithmException {
        if (this.timeStampToken == null) {
            return false;
        }
        MessageImprint messageImprint = this.timeStampToken.getTimeStampInfo().toTSTInfo().getMessageImprint();
        byte[] byArray = MessageDigest.getInstance("SHA-1").digest(this.digest);
        byte[] byArray2 = messageImprint.getHashedMessage();
        boolean bl = Arrays.equals(byArray, byArray2);
        return bl;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new X509Certificate[this.signCerts.size()]);
    }

    private void signCertificateChain() {
        int n;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(this.signCert);
        ArrayList arrayList2 = new ArrayList(this.certs);
        for (n = 0; n < arrayList2.size(); ++n) {
            if (!this.signCert.getSerialNumber().equals(((X509Certificate)arrayList2.get(n)).getSerialNumber())) continue;
            arrayList2.remove(n);
            --n;
        }
        n = 1;
        block3: while (n != 0) {
            X509Certificate x509Certificate = (X509Certificate)arrayList.get(arrayList.size() - 1);
            n = 0;
            for (int i = 0; i < arrayList2.size(); ++i) {
                try {
                    if (this.provider == null) {
                        x509Certificate.verify(((X509Certificate)arrayList2.get(i)).getPublicKey());
                    } else {
                        x509Certificate.verify(((X509Certificate)arrayList2.get(i)).getPublicKey(), this.provider);
                    }
                    n = 1;
                    arrayList.add((X509Certificate)arrayList2.get(i));
                    arrayList2.remove(i);
                    continue block3;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        this.signCerts = arrayList;
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithm() {
        String string = PdfPKCS7.getAlgorithm(this.digestEncryptionAlgorithm);
        if (string == null) {
            string = this.digestEncryptionAlgorithm;
        }
        return this.getHashAlgorithm() + "with" + string;
    }

    public String getHashAlgorithm() {
        return PdfPKCS7.getDigest(this.digestAlgorithm);
    }

    public static KeyStore loadCacertsKeyStore() {
        return PdfPKCS7.loadCacertsKeyStore(null);
    }

    public static KeyStore loadCacertsKeyStore(String string) {
        File file = new File(System.getProperty("java.home"), "lib");
        file = new File(file, "security");
        file = new File(file, "cacerts");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            KeyStore keyStore = string == null ? KeyStore.getInstance("JKS") : KeyStore.getInstance("JKS", string);
            keyStore.load(fileInputStream, null);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String verifyCertificate(X509Certificate x509Certificate, Collection collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (x509Certificate.hasUnsupportedCriticalExtension()) {
            return "Has unsupported critical extension";
        }
        try {
            x509Certificate.checkValidity(calendar.getTime());
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!((CRL)iterator.next()).isRevoked(x509Certificate)) continue;
                return "Certificate revoked";
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static Object[] verifyCertificates(Certificate[] certificateArray, KeyStore keyStore, Collection collection, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            int n;
            Object object;
            X509Certificate x509Certificate = (X509Certificate)certificateArray[i];
            String string = PdfPKCS7.verifyCertificate(x509Certificate, collection, calendar);
            if (string != null) {
                return new Object[]{x509Certificate, string};
            }
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)object)) continue;
                    X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate((String)object);
                    if (PdfPKCS7.verifyCertificate(x509Certificate2, collection, calendar) != null) continue;
                    {
                        catch (Exception exception) {}
                    }
                    try {
                        x509Certificate.verify(x509Certificate2.getPublicKey());
                        return null;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (n = 0; n < certificateArray.length; ++n) {
                if (n == i) continue;
                object = (X509Certificate)certificateArray[n];
                try {
                    x509Certificate.verify(((Certificate)object).getPublicKey());
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n != certificateArray.length) continue;
            return new Object[]{x509Certificate, "Cannot be verified against the KeyStore or the certificate chain"};
        }
        return new Object[]{null, "Invalid state. Possible circular certificate chain"};
    }

    public static boolean verifyOcspCertificates(BasicOCSPResp basicOCSPResp, KeyStore keyStore, String string) {
        if (string == null) {
            string = "BC";
        }
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                try {
                    X509Certificate x509Certificate;
                    BcRSAContentVerifierProviderBuilder bcRSAContentVerifierProviderBuilder;
                    ContentVerifierProvider contentVerifierProvider;
                    String string2 = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry(string2) || !basicOCSPResp.isSignatureValid(contentVerifierProvider = (bcRSAContentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder())).build((X509CertificateHolder)new JcaX509CertificateHolder(x509Certificate = (X509Certificate)keyStore.getCertificate(string2))))) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean verifyTimestampCertificates(TimeStampToken timeStampToken, KeyStore keyStore, String string) {
        if (string == null) {
            string = "BC";
        }
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                try {
                    String string2 = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry(string2)) continue;
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
                    SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(string).build(x509Certificate);
                    timeStampToken.validate(signerInformationVerifier);
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getOCSPURL(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            ASN1Primitive aSN1Primitive = PdfPKCS7.getExtensionValue(x509Certificate, AuthorityInfoAccess.getId());
            if (aSN1Primitive == null) {
                return null;
            }
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            for (int i = 0; i < aSN1Sequence.size(); ++i) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.getObjectAt(i);
                if (aSN1Sequence2.size() != 2 || !(aSN1Sequence2.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)aSN1Sequence2.getObjectAt(0)).getId().equals("1.3.6.1.5.5.7.48.1")) continue;
                String string = PdfPKCS7.getStringFromGeneralName((ASN1Primitive)aSN1Sequence2.getObjectAt(1));
                if (string == null) {
                    return "";
                }
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            X509Certificate[] x509CertificateArray = (X509Certificate[])this.getSignCertificateChain();
            SingleResp singleResp = this.basicResp.getResponses()[0];
            CertificateID certificateID = singleResp.getCertID();
            X509Certificate x509Certificate = this.getSigningCertificate();
            X509Certificate x509Certificate2 = x509CertificateArray[1];
            BcDigestCalculatorProvider bcDigestCalculatorProvider = new BcDigestCalculatorProvider();
            DigestCalculator digestCalculator = bcDigestCalculatorProvider.get(CertificateID.HASH_SHA1);
            CertificateID certificateID2 = new CertificateID(digestCalculator, (X509CertificateHolder)new JcaX509CertificateHolder(x509Certificate2), x509Certificate.getSerialNumber());
            return certificateID2.equals((Object)certificateID);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static ASN1Primitive getExtensionValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
        return aSN1InputStream.readObject();
    }

    private static String getStringFromGeneralName(ASN1Primitive aSN1Primitive) throws IOException {
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Primitive;
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)dERTaggedObject, (boolean)false).getOctets(), "ISO-8859-1");
    }

    private static ASN1Primitive getIssuer(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (ASN1Primitive)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private static ASN1Primitive getSubject(byte[] byArray) {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return (ASN1Primitive)aSN1Sequence.getObjectAt(aSN1Sequence.getObjectAt(0) instanceof DERTaggedObject ? 5 : 4);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static X509Name getIssuerFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getIssuer(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static X509Name getSubjectFields(X509Certificate x509Certificate) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getSubject(x509Certificate.getTBSCertificate()));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create((OutputStream)byteArrayOutputStream);
            aSN1OutputStream.writeObject((ASN1Primitive)new DEROctetString(this.digest));
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setExternalDigest(byte[] byArray, byte[] byArray2, String string) {
        this.externalDigest = byArray;
        this.externalRSAdata = byArray2;
        if (string != null) {
            if (string.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (string.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new ExceptionConverter(new NoSuchAlgorithmException("Unknown Key Algorithm " + string));
            }
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] byArray, Calendar calendar) {
        return this.getEncodedPKCS7(byArray, calendar, null, null);
    }

    public byte[] getEncodedPKCS7(byte[] byArray, Calendar calendar, TSAClient tSAClient, byte[] byArray2) {
        try {
            Object object;
            Object object2;
            Object object3;
            ASN1EncodableVector aSN1EncodableVector;
            ASN1EncodableVector aSN1EncodableVector2;
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                this.digest = this.sig.sign();
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                this.digest = this.sig.sign();
            }
            ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector4 = this.digestalgos.iterator();
            while (aSN1EncodableVector4.hasNext()) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier((String)aSN1EncodableVector4.next()));
                aSN1EncodableVector2.add((ASN1Encodable)DERNull.INSTANCE);
                aSN1EncodableVector3.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            }
            aSN1EncodableVector4 = new ASN1EncodableVector();
            aSN1EncodableVector4.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_DATA));
            if (this.RSAdata != null) {
                aSN1EncodableVector4.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(this.RSAdata)));
            }
            aSN1EncodableVector2 = new DERSequence(aSN1EncodableVector4);
            aSN1EncodableVector4 = new ASN1EncodableVector();
            DERSet dERSet = this.certs.iterator();
            while (dERSet.hasNext()) {
                aSN1EncodableVector = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)dERSet.next()).getEncoded()));
                aSN1EncodableVector4.add((ASN1Encodable)aSN1EncodableVector.readObject());
            }
            dERSet = new DERSet(aSN1EncodableVector4);
            aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.signerversion));
            aSN1EncodableVector4 = new ASN1EncodableVector();
            aSN1EncodableVector4.add((ASN1Encodable)PdfPKCS7.getIssuer(this.signCert.getTBSCertificate()));
            aSN1EncodableVector4.add((ASN1Encodable)new ASN1Integer(this.signCert.getSerialNumber()));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector4));
            aSN1EncodableVector4 = new ASN1EncodableVector();
            aSN1EncodableVector4.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestAlgorithm));
            aSN1EncodableVector4.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector4));
            if (byArray != null && calendar != null) {
                aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.getAuthenticatedAttributeSet(byArray, calendar, byArray2)));
            }
            aSN1EncodableVector4 = new ASN1EncodableVector();
            aSN1EncodableVector4.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestEncryptionAlgorithm));
            aSN1EncodableVector4.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector4));
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.digest));
            if (tSAClient != null && (object3 = tSAClient.getTimeStampToken(this, (byte[])(object2 = (Object)MessageDigest.getInstance("SHA-1").digest(this.digest)))) != null && (object = this.buildUnauthenticatedAttributes((byte[])object3)) != null) {
                aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERSet((ASN1EncodableVector)object)));
            }
            object2 = new ASN1EncodableVector();
            object2.add((ASN1Encodable)new ASN1Integer((long)this.version));
            object2.add((ASN1Encodable)new DERSet(aSN1EncodableVector3));
            object2.add((ASN1Encodable)aSN1EncodableVector2);
            object2.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)dERSet));
            if (!this.crls.isEmpty()) {
                aSN1EncodableVector4 = new ASN1EncodableVector();
                object3 = this.crls.iterator();
                while (object3.hasNext()) {
                    object = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)object3.next()).getEncoded()));
                    aSN1EncodableVector4.add((ASN1Encodable)object.readObject());
                }
                object3 = new DERSet(aSN1EncodableVector4);
                object2.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)object3));
            }
            object2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(aSN1EncodableVector)));
            object3 = new ASN1EncodableVector();
            object3.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            object3.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DERSequence(object2)));
            object = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create((OutputStream)object);
            aSN1OutputStream.writeObject((ASN1Primitive)new DERSequence((ASN1EncodableVector)object3));
            aSN1OutputStream.close();
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private ASN1EncodableVector buildUnauthenticatedAttributes(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        String string = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(string));
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)aSN1Sequence));
        aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
        return aSN1EncodableVector;
    }

    public byte[] getAuthenticatedAttributeBytes(byte[] byArray, Calendar calendar, byte[] byArray2) {
        try {
            return this.getAuthenticatedAttributeSet(byArray, calendar, byArray2).getEncoded();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private DERSet getAuthenticatedAttributeSet(byte[] byArray, Calendar calendar, byte[] byArray2) {
        try {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_CONTENT_TYPE));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_DATA)));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_SIGNING_TIME));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERUTCTime(calendar.getTime())));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_MESSAGE_DIGEST));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString(byArray)));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            if (byArray2 != null) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_ADBE_REVOCATION));
                DEROctetString dEROctetString = new DEROctetString(byArray2);
                ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
                ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
                aSN1EncodableVector4.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                aSN1EncodableVector4.add((ASN1Encodable)dEROctetString);
                ASN1Enumerated aSN1Enumerated = new ASN1Enumerated(0);
                ASN1EncodableVector aSN1EncodableVector5 = new ASN1EncodableVector();
                aSN1EncodableVector5.add((ASN1Encodable)aSN1Enumerated);
                aSN1EncodableVector5.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(aSN1EncodableVector4)));
                aSN1EncodableVector3.add((ASN1Encodable)new DERSequence(aSN1EncodableVector5));
                aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(aSN1EncodableVector3)))));
                aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            } else if (!this.crls.isEmpty()) {
                aSN1EncodableVector2 = new ASN1EncodableVector();
                aSN1EncodableVector2.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_ADBE_REVOCATION));
                ASN1EncodableVector aSN1EncodableVector6 = new ASN1EncodableVector();
                Iterator iterator = this.crls.iterator();
                while (iterator.hasNext()) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)iterator.next()).getEncoded()));
                    aSN1EncodableVector6.add((ASN1Encodable)aSN1InputStream.readObject());
                }
                aSN1EncodableVector2.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(aSN1EncodableVector6)))));
                aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            }
            return new DERSet(aSN1EncodableVector);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar calendar) {
        this.signDate = calendar;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String string) {
        this.signName = string;
    }

    static {
        digestNames.put("1.2.840.113549.2.5", "MD5");
        digestNames.put("1.2.840.113549.2.2", "MD2");
        digestNames.put("1.3.14.3.2.26", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.2.4", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.2.1", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.2.2", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.2.3", "SHA512");
        digestNames.put("1.3.36.3.2.2", "RIPEMD128");
        digestNames.put("1.3.36.3.2.1", "RIPEMD160");
        digestNames.put("1.3.36.3.2.3", "RIPEMD256");
        digestNames.put("1.2.840.113549.1.1.4", "MD5");
        digestNames.put("1.2.840.113549.1.1.2", "MD2");
        digestNames.put("1.2.840.113549.1.1.5", "SHA1");
        digestNames.put("1.2.840.113549.1.1.14", "SHA224");
        digestNames.put("1.2.840.113549.1.1.11", "SHA256");
        digestNames.put("1.2.840.113549.1.1.12", "SHA384");
        digestNames.put("1.2.840.113549.1.1.13", "SHA512");
        digestNames.put("1.2.840.113549.2.5", "MD5");
        digestNames.put("1.2.840.113549.2.2", "MD2");
        digestNames.put("1.2.840.10040.4.3", "SHA1");
        digestNames.put("2.16.840.1.101.3.4.3.1", "SHA224");
        digestNames.put("2.16.840.1.101.3.4.3.2", "SHA256");
        digestNames.put("2.16.840.1.101.3.4.3.3", "SHA384");
        digestNames.put("2.16.840.1.101.3.4.3.4", "SHA512");
        digestNames.put("1.3.36.3.3.1.3", "RIPEMD128");
        digestNames.put("1.3.36.3.3.1.2", "RIPEMD160");
        digestNames.put("1.3.36.3.3.1.4", "RIPEMD256");
        algorithmNames.put(ID_RSA, "RSA");
        algorithmNames.put(ID_DSA, "DSA");
        algorithmNames.put("1.2.840.113549.1.1.2", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.4", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.5", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.14", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.11", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.12", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.13", "RSA");
        algorithmNames.put("1.2.840.10040.4.3", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.1", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.2", "DSA");
        algorithmNames.put("1.3.36.3.3.1.3", "RSA");
        algorithmNames.put("1.3.36.3.3.1.2", "RSA");
        algorithmNames.put("1.3.36.3.3.1.4", "RSA");
        allowedDigests.put("MD5", "1.2.840.113549.2.5");
        allowedDigests.put("MD2", "1.2.840.113549.2.2");
        allowedDigests.put("SHA1", "1.3.14.3.2.26");
        allowedDigests.put("SHA224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("MD-5", "1.2.840.113549.2.5");
        allowedDigests.put("MD-2", "1.2.840.113549.2.2");
        allowedDigests.put("SHA-1", "1.3.14.3.2.26");
        allowedDigests.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        allowedDigests.put("SHA-256", "2.16.840.1.101.3.4.2.1");
        allowedDigests.put("SHA-384", "2.16.840.1.101.3.4.2.2");
        allowedDigests.put("SHA-512", "2.16.840.1.101.3.4.2.3");
        allowedDigests.put("RIPEMD128", "1.3.36.3.2.2");
        allowedDigests.put("RIPEMD-128", "1.3.36.3.2.2");
        allowedDigests.put("RIPEMD160", "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD-160", "1.3.36.3.2.1");
        allowedDigests.put("RIPEMD256", "1.3.36.3.2.3");
        allowedDigests.put("RIPEMD-256", "1.3.36.3.2.3");
    }

    public static class X509Name {
        public static final ASN1ObjectIdentifier C = new ASN1ObjectIdentifier("2.5.4.6");
        public static final ASN1ObjectIdentifier O = new ASN1ObjectIdentifier("2.5.4.10");
        public static final ASN1ObjectIdentifier OU = new ASN1ObjectIdentifier("2.5.4.11");
        public static final ASN1ObjectIdentifier T = new ASN1ObjectIdentifier("2.5.4.12");
        public static final ASN1ObjectIdentifier CN = new ASN1ObjectIdentifier("2.5.4.3");
        public static final ASN1ObjectIdentifier SN = new ASN1ObjectIdentifier("2.5.4.5");
        public static final ASN1ObjectIdentifier L = new ASN1ObjectIdentifier("2.5.4.7");
        public static final ASN1ObjectIdentifier ST = new ASN1ObjectIdentifier("2.5.4.8");
        public static final ASN1ObjectIdentifier SURNAME = new ASN1ObjectIdentifier("2.5.4.4");
        public static final ASN1ObjectIdentifier GIVENNAME = new ASN1ObjectIdentifier("2.5.4.42");
        public static final ASN1ObjectIdentifier INITIALS = new ASN1ObjectIdentifier("2.5.4.43");
        public static final ASN1ObjectIdentifier GENERATION = new ASN1ObjectIdentifier("2.5.4.44");
        public static final ASN1ObjectIdentifier UNIQUE_IDENTIFIER = new ASN1ObjectIdentifier("2.5.4.45");
        public static final ASN1ObjectIdentifier EmailAddress;
        public static final ASN1ObjectIdentifier E;
        public static final ASN1ObjectIdentifier DC;
        public static final ASN1ObjectIdentifier UID;
        public static HashMap DefaultSymbols;
        public HashMap values = new HashMap();

        public X509Name(ASN1Sequence aSN1Sequence) {
            Enumeration enumeration = aSN1Sequence.getObjects();
            while (enumeration.hasMoreElements()) {
                ASN1Set aSN1Set = (ASN1Set)enumeration.nextElement();
                for (int i = 0; i < aSN1Set.size(); ++i) {
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Set.getObjectAt(i);
                    String string = (String)DefaultSymbols.get(aSN1Sequence2.getObjectAt(0));
                    if (string == null) continue;
                    ArrayList<String> arrayList = (ArrayList<String>)this.values.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        this.values.put(string, arrayList);
                    }
                    arrayList.add(((ASN1String)aSN1Sequence2.getObjectAt(1)).getString());
                }
            }
        }

        public X509Name(String string) {
            X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
            while (x509NameTokenizer.hasMoreTokens()) {
                String string2 = x509NameTokenizer.nextToken();
                int n = string2.indexOf(61);
                if (n == -1) {
                    throw new IllegalArgumentException("badly formated directory string");
                }
                String string3 = string2.substring(0, n).toUpperCase();
                String string4 = string2.substring(n + 1);
                ArrayList<String> arrayList = (ArrayList<String>)this.values.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    this.values.put(string3, arrayList);
                }
                arrayList.add(string4);
            }
        }

        public String getField(String string) {
            ArrayList arrayList = (ArrayList)this.values.get(string);
            return arrayList == null ? null : (String)arrayList.get(0);
        }

        public ArrayList getFieldArray(String string) {
            ArrayList arrayList = (ArrayList)this.values.get(string);
            return arrayList == null ? null : arrayList;
        }

        public HashMap getFields() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }

        static {
            E = EmailAddress = new ASN1ObjectIdentifier("1.2.840.113549.1.9.1");
            DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
            DefaultSymbols = new HashMap();
            DefaultSymbols.put(C, "C");
            DefaultSymbols.put(O, "O");
            DefaultSymbols.put(T, "T");
            DefaultSymbols.put(OU, "OU");
            DefaultSymbols.put(CN, "CN");
            DefaultSymbols.put(L, "L");
            DefaultSymbols.put(ST, "ST");
            DefaultSymbols.put(SN, "SN");
            DefaultSymbols.put(EmailAddress, "E");
            DefaultSymbols.put(DC, "DC");
            DefaultSymbols.put(UID, "UID");
            DefaultSymbols.put(SURNAME, "SURNAME");
            DefaultSymbols.put(GIVENNAME, "GIVENNAME");
            DefaultSymbols.put(INITIALS, "INITIALS");
            DefaultSymbols.put(GENERATION, "GENERATION");
        }
    }

    public static class X509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public X509NameTokenizer(String string) {
            this.oid = string;
            this.index = -1;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            int n;
            if (this.index == this.oid.length()) {
                return null;
            }
            boolean bl = false;
            boolean bl2 = false;
            this.buf.setLength(0);
            for (n = this.index + 1; n != this.oid.length(); ++n) {
                char c = this.oid.charAt(n);
                if (c == '\"') {
                    if (!bl2) {
                        bl = !bl;
                    } else {
                        this.buf.append(c);
                    }
                    bl2 = false;
                    continue;
                }
                if (bl2 || bl) {
                    this.buf.append(c);
                    bl2 = false;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (c == ',') break;
                this.buf.append(c);
            }
            this.index = n;
            return this.buf.toString().trim();
        }
    }
}

