/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.ImgJBIG2;
import com.lowagie.text.ImgWMF;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColorDetails;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.OutputStreamCounter;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDeveloperExtension;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLayer;
import com.lowagie.text.pdf.PdfLayerMembership;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfOCG;
import com.lowagie.text.pdf.PdfOCProperties;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageLabels;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfShading;
import com.lowagie.text.pdf.PdfShadingPattern;
import com.lowagie.text.pdf.PdfSpotColor;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfXConformanceException;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.text.pdf.SpotColor;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.events.PdfPageEventForwarder;
import com.lowagie.text.pdf.interfaces.PdfAnnotations;
import com.lowagie.text.pdf.interfaces.PdfDocumentActions;
import com.lowagie.text.pdf.interfaces.PdfEncryptionSettings;
import com.lowagie.text.pdf.interfaces.PdfPageActions;
import com.lowagie.text.pdf.interfaces.PdfRunDirection;
import com.lowagie.text.pdf.interfaces.PdfVersion;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import com.lowagie.text.pdf.interfaces.PdfXConformance;
import com.lowagie.text.pdf.internal.PdfVersionImp;
import com.lowagie.text.pdf.internal.PdfXConformanceImp;
import com.lowagie.text.xml.xmp.XmpWriter;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class PdfWriter
extends DocWriter
implements PdfViewerPreferences,
PdfEncryptionSettings,
PdfVersion,
PdfDocumentActions,
PdfPageActions,
PdfXConformance,
PdfRunDirection,
PdfAnnotations {
    public static final int GENERATION_MAX = 65535;
    protected PdfDocument pdf;
    protected PdfContentByte directContent;
    protected PdfContentByte directContentUnder;
    protected PdfBody body;
    protected PdfDictionary extraCatalog;
    protected PdfPages root = new PdfPages(this);
    protected ArrayList pageReferences = new ArrayList();
    protected int currentPageNumber = 1;
    protected PdfName tabs = null;
    private PdfPageEvent pageEvent;
    protected int prevxref = 0;
    protected List newBookmarks;
    public static final char VERSION_1_2 = '2';
    public static final char VERSION_1_3 = '3';
    public static final char VERSION_1_4 = '4';
    public static final char VERSION_1_5 = '5';
    public static final char VERSION_1_6 = '6';
    public static final char VERSION_1_7 = '7';
    public static final PdfName PDF_VERSION_1_2 = new PdfName("1.2");
    public static final PdfName PDF_VERSION_1_3 = new PdfName("1.3");
    public static final PdfName PDF_VERSION_1_4 = new PdfName("1.4");
    public static final PdfName PDF_VERSION_1_5 = new PdfName("1.5");
    public static final PdfName PDF_VERSION_1_6 = new PdfName("1.6");
    public static final PdfName PDF_VERSION_1_7 = new PdfName("1.7");
    protected PdfVersionImp pdf_version = new PdfVersionImp();
    public static final int PageLayoutSinglePage = 1;
    public static final int PageLayoutOneColumn = 2;
    public static final int PageLayoutTwoColumnLeft = 4;
    public static final int PageLayoutTwoColumnRight = 8;
    public static final int PageLayoutTwoPageLeft = 16;
    public static final int PageLayoutTwoPageRight = 32;
    public static final int PageModeUseNone = 64;
    public static final int PageModeUseOutlines = 128;
    public static final int PageModeUseThumbs = 256;
    public static final int PageModeFullScreen = 512;
    public static final int PageModeUseOC = 1024;
    public static final int PageModeUseAttachments = 2048;
    public static final int HideToolbar = 4096;
    public static final int HideMenubar = 8192;
    public static final int HideWindowUI = 16384;
    public static final int FitWindow = 32768;
    public static final int CenterWindow = 65536;
    public static final int DisplayDocTitle = 131072;
    public static final int NonFullScreenPageModeUseNone = 262144;
    public static final int NonFullScreenPageModeUseOutlines = 524288;
    public static final int NonFullScreenPageModeUseThumbs = 0x100000;
    public static final int NonFullScreenPageModeUseOC = 0x200000;
    public static final int DirectionL2R = 0x400000;
    public static final int DirectionR2L = 0x800000;
    public static final int PrintScalingNone = 0x1000000;
    public static final PdfName DOCUMENT_CLOSE = PdfName.WC;
    public static final PdfName WILL_SAVE = PdfName.WS;
    public static final PdfName DID_SAVE = PdfName.DS;
    public static final PdfName WILL_PRINT = PdfName.WP;
    public static final PdfName DID_PRINT = PdfName.DP;
    public static final int SIGNATURE_EXISTS = 1;
    public static final int SIGNATURE_APPEND_ONLY = 2;
    protected byte[] xmpMetadata = null;
    public static final int PDFXNONE = 0;
    public static final int PDFX1A2001 = 1;
    public static final int PDFX32002 = 2;
    public static final int PDFA1A = 3;
    public static final int PDFA1B = 4;
    private PdfXConformanceImp pdfxConformance = new PdfXConformanceImp();
    public static final int STANDARD_ENCRYPTION_40 = 0;
    public static final int STANDARD_ENCRYPTION_128 = 1;
    public static final int ENCRYPTION_AES_128 = 2;
    static final int ENCRYPTION_MASK = 7;
    public static final int DO_NOT_ENCRYPT_METADATA = 8;
    public static final int EMBEDDED_FILES_ONLY = 24;
    public static final int ALLOW_PRINTING = 2052;
    public static final int ALLOW_MODIFY_CONTENTS = 8;
    public static final int ALLOW_COPY = 16;
    public static final int ALLOW_MODIFY_ANNOTATIONS = 32;
    public static final int ALLOW_FILL_IN = 256;
    public static final int ALLOW_SCREENREADERS = 512;
    public static final int ALLOW_ASSEMBLY = 1024;
    public static final int ALLOW_DEGRADED_PRINTING = 4;
    @Deprecated
    public static final int AllowPrinting = 2052;
    @Deprecated
    public static final int AllowModifyContents = 8;
    @Deprecated
    public static final int AllowCopy = 16;
    @Deprecated
    public static final int AllowModifyAnnotations = 32;
    @Deprecated
    public static final int AllowFillIn = 256;
    @Deprecated
    public static final int AllowScreenReaders = 512;
    @Deprecated
    public static final int AllowAssembly = 1024;
    @Deprecated
    public static final int AllowDegradedPrinting = 4;
    @Deprecated
    public static final boolean STRENGTH40BITS = false;
    @Deprecated
    public static final boolean STRENGTH128BITS = true;
    protected PdfEncryption crypto;
    protected boolean fullCompression = false;
    protected int compressionLevel = -1;
    protected LinkedHashMap documentFonts = new LinkedHashMap();
    protected int fontNumber = 1;
    protected HashMap formXObjects = new HashMap();
    protected int formXObjectsCounter = 1;
    protected HashMap importedPages = new HashMap();
    protected PdfReaderInstance currentPdfReaderInstance;
    protected HashMap documentColors = new HashMap();
    protected int colorNumber = 1;
    protected HashMap documentPatterns = new HashMap();
    protected int patternNumber = 1;
    protected HashMap documentShadingPatterns = new HashMap();
    protected HashMap documentShadings = new HashMap();
    protected HashMap documentExtGState = new HashMap();
    protected HashMap documentProperties = new HashMap();
    protected boolean tagged = false;
    protected PdfStructureTreeRoot structureTreeRoot;
    protected HashSet documentOCG = new HashSet();
    protected ArrayList documentOCGorder = new ArrayList();
    protected PdfOCProperties OCProperties;
    protected PdfArray OCGRadioGroup = new PdfArray();
    protected PdfArray OCGLocked = new PdfArray();
    public static final PdfName PAGE_OPEN = PdfName.O;
    public static final PdfName PAGE_CLOSE = PdfName.C;
    protected PdfDictionary group;
    public static final float SPACE_CHAR_RATIO_DEFAULT = 2.5f;
    public static final float NO_SPACE_CHAR_RATIO = 1.0E7f;
    private float spaceCharRatio = 2.5f;
    public static final int RUN_DIRECTION_DEFAULT = 0;
    public static final int RUN_DIRECTION_NO_BIDI = 1;
    public static final int RUN_DIRECTION_LTR = 2;
    public static final int RUN_DIRECTION_RTL = 3;
    protected int runDirection = 1;
    protected float userunit = 0.0f;
    protected PdfDictionary defaultColorspace = new PdfDictionary();
    protected HashMap documentSpotPatterns = new HashMap();
    protected ColorDetails patternColorspaceRGB;
    protected ColorDetails patternColorspaceGRAY;
    protected ColorDetails patternColorspaceCMYK;
    protected PdfDictionary imageDictionary = new PdfDictionary();
    private HashMap images = new HashMap();
    protected HashMap JBIG2Globals = new HashMap();
    private boolean userProperties;
    private boolean rgbTransparencyBlending;

    protected PdfWriter() {
    }

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
        this.directContentUnder = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    PdfDocument getPdfDocument() {
        return this.pdf;
    }

    public PdfDictionary getInfo() {
        return this.pdf.getInfo();
    }

    public float getVerticalPosition(boolean bl) {
        return this.pdf.getVerticalPosition(bl);
    }

    public void setInitialLeading(float f) throws DocumentException {
        if (this.open) {
            throw new DocumentException("You can't set the initial leading if the document is already open.");
        }
        this.pdf.setLeading(f);
    }

    public PdfContentByte getDirectContent() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContent;
    }

    public PdfContentByte getDirectContentUnder() {
        if (!this.open) {
            throw new RuntimeException("The document is not open.");
        }
        return this.directContentUnder;
    }

    void resetContent() {
        this.directContent.reset();
        this.directContentUnder.reset();
    }

    void addLocalDestinations(TreeMap treeMap) throws IOException {
        for (Map.Entry entry : treeMap.entrySet()) {
            String string = (String)entry.getKey();
            Object[] objectArray = (Object[])entry.getValue();
            PdfDestination pdfDestination = (PdfDestination)objectArray[2];
            if (objectArray[1] == null) {
                objectArray[1] = this.getPdfIndirectReference();
            }
            if (pdfDestination == null) {
                this.addToBody((PdfObject)new PdfString("invalid_" + string), (PdfIndirectReference)objectArray[1]);
                continue;
            }
            this.addToBody((PdfObject)pdfDestination, (PdfIndirectReference)objectArray[1]);
        }
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, bl);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, pdfIndirectReference, bl);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n);
        return pdfIndirectObject;
    }

    public PdfIndirectObject addToBody(PdfObject pdfObject, int n, boolean bl) throws IOException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject, n, bl);
        return pdfIndirectObject;
    }

    public PdfIndirectReference getPdfIndirectReference() {
        return this.body.getPdfIndirectReference();
    }

    int getIndirectReferenceNumber() {
        return this.body.getIndirectReferenceNumber();
    }

    OutputStreamCounter getOs() {
        return this.os;
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        PdfDocument.PdfCatalog pdfCatalog = this.pdf.getCatalog(pdfIndirectReference);
        if (this.tagged) {
            try {
                this.getStructureTreeRoot().buildTree();
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
            pdfCatalog.put(PdfName.STRUCTTREEROOT, this.structureTreeRoot.getReference());
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.MARKED, PdfBoolean.PDFTRUE);
            if (this.userProperties) {
                pdfDictionary.put(PdfName.USERPROPERTIES, PdfBoolean.PDFTRUE);
            }
            pdfCatalog.put(PdfName.MARKINFO, pdfDictionary);
        }
        if (!this.documentOCG.isEmpty()) {
            this.fillOCProperties(false);
            pdfCatalog.put(PdfName.OCPROPERTIES, this.OCProperties);
        }
        return pdfCatalog;
    }

    public PdfDictionary getExtraCatalog() {
        if (this.extraCatalog == null) {
            this.extraCatalog = new PdfDictionary();
        }
        return this.extraCatalog;
    }

    public void setLinearPageMode() {
        this.root.setLinearMode(null);
    }

    public int reorderPages(int[] nArray) throws DocumentException {
        return this.root.reorderPages(nArray);
    }

    public PdfIndirectReference getPageReference(int n) {
        PdfIndirectReference pdfIndirectReference;
        if (--n < 0) {
            throw new IndexOutOfBoundsException("The page numbers start at 1.");
        }
        if (n < this.pageReferences.size()) {
            pdfIndirectReference = (PdfIndirectReference)this.pageReferences.get(n);
            if (pdfIndirectReference == null) {
                pdfIndirectReference = this.body.getPdfIndirectReference();
                this.pageReferences.set(n, pdfIndirectReference);
            }
        } else {
            int n2 = n - this.pageReferences.size();
            for (int i = 0; i < n2; ++i) {
                this.pageReferences.add(null);
            }
            pdfIndirectReference = this.body.getPdfIndirectReference();
            this.pageReferences.add(pdfIndirectReference);
        }
        return pdfIndirectReference;
    }

    public int getPageNumber() {
        return this.pdf.getPageNumber();
    }

    PdfIndirectReference getCurrentPage() {
        return this.getPageReference(this.currentPageNumber);
    }

    public int getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setTabs(PdfName pdfName) {
        this.tabs = pdfName;
    }

    public PdfName getTabs() {
        return this.tabs;
    }

    PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        PdfIndirectObject pdfIndirectObject;
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        try {
            pdfIndirectObject = this.addToBody(pdfContents);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        if (this.group != null) {
            pdfPage.put(PdfName.GROUP, this.group);
            this.group = null;
        } else if (this.rgbTransparencyBlending) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.TYPE, PdfName.GROUP);
            pdfDictionary.put(PdfName.S, PdfName.TRANSPARENCY);
            pdfDictionary.put(PdfName.CS, PdfName.DEVICERGB);
            pdfPage.put(PdfName.GROUP, pdfDictionary);
        }
        this.root.addPage(pdfPage);
        ++this.currentPageNumber;
        return null;
    }

    public void setPageEvent(PdfPageEvent pdfPageEvent) {
        if (pdfPageEvent == null) {
            this.pageEvent = null;
        } else if (this.pageEvent == null) {
            this.pageEvent = pdfPageEvent;
        } else if (this.pageEvent instanceof PdfPageEventForwarder) {
            ((PdfPageEventForwarder)this.pageEvent).addPageEvent(pdfPageEvent);
        } else {
            PdfPageEventForwarder pdfPageEventForwarder = new PdfPageEventForwarder();
            pdfPageEventForwarder.addPageEvent(this.pageEvent);
            pdfPageEventForwarder.addPageEvent(pdfPageEvent);
            this.pageEvent = pdfPageEventForwarder;
        }
    }

    public PdfPageEvent getPageEvent() {
        return this.pageEvent;
    }

    @Override
    public void open() {
        super.open();
        try {
            this.pdf_version.writeHeader(this.os);
            this.body = new PdfBody(this);
            if (this.pdfxConformance.isPdfX32002()) {
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.GAMMA, new PdfArray(new float[]{2.2f, 2.2f, 2.2f}));
                pdfDictionary.put(PdfName.MATRIX, new PdfArray(new float[]{0.4124f, 0.2126f, 0.0193f, 0.3576f, 0.7152f, 0.1192f, 0.1805f, 0.0722f, 0.9505f}));
                pdfDictionary.put(PdfName.WHITEPOINT, new PdfArray(new float[]{0.9505f, 1.0f, 1.089f}));
                PdfArray pdfArray = new PdfArray(PdfName.CALRGB);
                pdfArray.add(pdfDictionary);
                this.setDefaultColorspace(PdfName.DEFAULTRGB, this.addToBody(pdfArray).getIndirectReference());
            }
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    @Override
    public void close() {
        if (this.open) {
            if (this.currentPageNumber - 1 != this.pageReferences.size()) {
                throw new RuntimeException("The page " + this.pageReferences.size() + " was requested but the document has only " + (this.currentPageNumber - 1) + " pages.");
            }
            this.pdf.close();
            try {
                Object object;
                Object object2;
                Object object3;
                this.addSharedObjectsToBody();
                PdfIndirectReference pdfIndirectReference = this.root.writePageTree();
                PdfDictionary pdfDictionary = this.getCatalog(pdfIndirectReference);
                if (this.xmpMetadata != null) {
                    object3 = new PdfStream(this.xmpMetadata);
                    ((PdfDictionary)object3).put(PdfName.TYPE, PdfName.METADATA);
                    ((PdfDictionary)object3).put(PdfName.SUBTYPE, PdfName.XML);
                    if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                        object2 = new PdfArray();
                        ((PdfArray)object2).add(PdfName.CRYPT);
                        ((PdfDictionary)object3).put(PdfName.FILTER, (PdfObject)object2);
                    }
                    pdfDictionary.put(PdfName.METADATA, this.body.add((PdfObject)object3).getIndirectReference());
                }
                if (this.isPdfX()) {
                    this.pdfxConformance.completeInfoDictionary(this.getInfo());
                    this.pdfxConformance.completeExtraCatalog(this.getExtraCatalog());
                }
                if (this.extraCatalog != null) {
                    pdfDictionary.mergeDifferent(this.extraCatalog);
                }
                this.writeOutlines(pdfDictionary, false);
                object3 = this.addToBody((PdfObject)pdfDictionary, false);
                object2 = this.addToBody((PdfObject)this.getInfo(), false);
                PdfIndirectReference pdfIndirectReference2 = null;
                PdfObject pdfObject = null;
                this.body.flushObjStm();
                if (this.crypto != null) {
                    object = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                    pdfIndirectReference2 = ((PdfIndirectObject)object).getIndirectReference();
                    pdfObject = this.crypto.getFileID();
                } else {
                    pdfObject = PdfEncryption.createInfoId(PdfEncryption.createDocumentId());
                }
                this.body.writeCrossReferenceTable(this.os, ((PdfIndirectObject)object3).getIndirectReference(), ((PdfIndirectObject)object2).getIndirectReference(), pdfIndirectReference2, pdfObject, this.prevxref);
                if (this.fullCompression) {
                    this.os.write(PdfWriter.getISOBytes("startxref\n"));
                    this.os.write(PdfWriter.getISOBytes(String.valueOf(this.body.offset())));
                    this.os.write(PdfWriter.getISOBytes("\n%%EOF\n"));
                } else {
                    object = new PdfTrailer(this.body.size(), this.body.offset(), ((PdfIndirectObject)object3).getIndirectReference(), ((PdfIndirectObject)object2).getIndirectReference(), pdfIndirectReference2, pdfObject, this.prevxref);
                    ((PdfTrailer)object).toPdf(this, this.os);
                }
                super.close();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    protected void addSharedObjectsToBody() throws IOException {
        PdfObject[] pdfObjectArray;
        Object object;
        for (FontDetails object2 : this.documentFonts.values()) {
            object2.writeFont(this);
        }
        for (Object[] objectArray : this.formXObjects.values()) {
            object = (PdfTemplate)objectArray[1];
            if (object != null && ((PdfTemplate)object).getIndirectReference() instanceof PRIndirectReference || object == null || ((PdfTemplate)object).getType() != 1) continue;
            this.addToBody((PdfObject)((PdfTemplate)object).getFormXObject(this.compressionLevel), ((PdfTemplate)object).getIndirectReference());
        }
        for (PdfReaderInstance this.currentPdfReaderInstance : this.importedPages.values()) {
            this.currentPdfReaderInstance.writeAllPages();
        }
        this.currentPdfReaderInstance = null;
        for (ColorDetails colorDetails : this.documentColors.values()) {
            this.addToBody(colorDetails.getSpotColor(this), colorDetails.getIndirectReference());
        }
        for (PdfPatternPainter pdfPatternPainter : this.documentPatterns.keySet()) {
            this.addToBody((PdfObject)pdfPatternPainter.getPattern(this.compressionLevel), pdfPatternPainter.getIndirectReference());
        }
        for (PdfShadingPattern pdfShadingPattern : this.documentShadingPatterns.keySet()) {
            pdfShadingPattern.addToBody();
        }
        for (PdfShading pdfShading : this.documentShadings.keySet()) {
            pdfShading.addToBody();
        }
        for (Map.Entry entry : this.documentExtGState.entrySet()) {
            object = (PdfDictionary)entry.getKey();
            pdfObjectArray = (PdfObject[])entry.getValue();
            this.addToBody((PdfObject)object, (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (Map.Entry entry : this.documentProperties.entrySet()) {
            object = entry.getKey();
            pdfObjectArray = (PdfObject[])entry.getValue();
            if (object instanceof PdfLayerMembership) {
                PdfLayerMembership pdfLayerMembership = (PdfLayerMembership)object;
                this.addToBody(pdfLayerMembership.getPdfObject(), pdfLayerMembership.getRef());
                continue;
            }
            if (!(object instanceof PdfDictionary) || object instanceof PdfLayer) continue;
            this.addToBody((PdfObject)((PdfDictionary)object), (PdfIndirectReference)pdfObjectArray[1]);
        }
        for (PdfOCG pdfOCG : this.documentOCG) {
            this.addToBody(pdfOCG.getPdfObject(), pdfOCG.getRef());
        }
    }

    public PdfOutline getRootOutline() {
        return this.directContent.getRootOutline();
    }

    public void setOutlines(List list) {
        this.newBookmarks = list;
    }

    protected void writeOutlines(PdfDictionary pdfDictionary, boolean bl) throws IOException {
        if (this.newBookmarks == null || this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfIndirectReference pdfIndirectReference = this.getPdfIndirectReference();
        Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference, this.newBookmarks, bl);
        pdfDictionary2.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
        pdfDictionary2.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
        pdfDictionary2.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
        this.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
        pdfDictionary.put(PdfName.OUTLINES, pdfIndirectReference);
    }

    @Override
    public void setPdfVersion(char c) {
        this.pdf_version.setPdfVersion(c);
    }

    @Override
    public void setAtLeastPdfVersion(char c) {
        this.pdf_version.setAtLeastPdfVersion(c);
    }

    @Override
    public void setPdfVersion(PdfName pdfName) {
        this.pdf_version.setPdfVersion(pdfName);
    }

    @Override
    public void addDeveloperExtension(PdfDeveloperExtension pdfDeveloperExtension) {
        this.pdf_version.addDeveloperExtension(pdfDeveloperExtension);
    }

    PdfVersionImp getPdfVersion() {
        return this.pdf_version;
    }

    @Override
    public void setViewerPreferences(int n) {
        this.pdf.setViewerPreferences(n);
    }

    @Override
    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.pdf.addViewerPreference(pdfName, pdfObject);
    }

    public void setPageLabels(PdfPageLabels pdfPageLabels) {
        this.pdf.setPageLabels(pdfPageLabels);
    }

    public void addJavaScript(PdfAction pdfAction) {
        this.pdf.addJavaScript(pdfAction);
    }

    public void addJavaScript(String string, boolean bl) {
        this.addJavaScript(PdfAction.javaScript(string, this, bl));
    }

    public void addJavaScript(String string) {
        this.addJavaScript(string, false);
    }

    public void addJavaScript(String string, PdfAction pdfAction) {
        this.pdf.addJavaScript(string, pdfAction);
    }

    public void addJavaScript(String string, String string2, boolean bl) {
        this.addJavaScript(string, PdfAction.javaScript(string2, this, bl));
    }

    public void addJavaScript(String string, String string2) {
        this.addJavaScript(string, string2, false);
    }

    public void addFileAttachment(String string, byte[] byArray, String string2, String string3) throws IOException {
        this.addFileAttachment(string, PdfFileSpecification.fileEmbedded(this, string2, string3, byArray));
    }

    public void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        this.pdf.addFileAttachment(string, pdfFileSpecification);
    }

    public void addFileAttachment(PdfFileSpecification pdfFileSpecification) throws IOException {
        this.addFileAttachment(null, pdfFileSpecification);
    }

    @Override
    public void setOpenAction(String string) {
        this.pdf.setOpenAction(string);
    }

    @Override
    public void setOpenAction(PdfAction pdfAction) {
        this.pdf.setOpenAction(pdfAction);
    }

    @Override
    public void setAdditionalAction(PdfName pdfName, PdfAction pdfAction) throws DocumentException {
        if (!(pdfName.equals(DOCUMENT_CLOSE) || pdfName.equals(WILL_SAVE) || pdfName.equals(DID_SAVE) || pdfName.equals(WILL_PRINT) || pdfName.equals(DID_PRINT))) {
            throw new DocumentException("Invalid additional action type: " + pdfName.toString());
        }
        this.pdf.addAdditionalAction(pdfName, pdfAction);
    }

    public void setCollection(PdfCollection pdfCollection) {
        this.setAtLeastPdfVersion('7');
        this.pdf.setCollection(pdfCollection);
    }

    @Override
    public PdfAcroForm getAcroForm() {
        return this.pdf.getAcroForm();
    }

    @Override
    public void addAnnotation(PdfAnnotation pdfAnnotation) {
        this.pdf.addAnnotation(pdfAnnotation);
    }

    void addAnnotation(PdfAnnotation pdfAnnotation, int n) {
        this.addAnnotation(pdfAnnotation);
    }

    @Override
    public void addCalculationOrder(PdfFormField pdfFormField) {
        this.pdf.addCalculationOrder(pdfFormField);
    }

    @Override
    public void setSigFlags(int n) {
        this.pdf.setSigFlags(n);
    }

    public void setXmpMetadata(byte[] byArray) {
        this.xmpMetadata = byArray;
    }

    public void setPageXmpMetadata(byte[] byArray) {
        this.pdf.setXmpMetadata(byArray);
    }

    public void createXmpMetadata() {
        this.setXmpMetadata(this.createXmpMetadataBytes());
    }

    private byte[] createXmpMetadataBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XmpWriter xmpWriter = new XmpWriter((OutputStream)byteArrayOutputStream, this.pdf.getInfo(), this.pdfxConformance.getPDFXConformance());
            xmpWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void setPDFXConformance(int n) {
        if (this.pdfxConformance.getPDFXConformance() == n) {
            return;
        }
        if (this.pdf.isOpen()) {
            throw new PdfXConformanceException("PDFX conformance can only be set before opening the document.");
        }
        if (this.crypto != null) {
            throw new PdfXConformanceException("A PDFX conforming document cannot be encrypted.");
        }
        if (n == 3 || n == 4) {
            this.setPdfVersion('4');
        } else if (n != 0) {
            this.setPdfVersion('3');
        }
        this.pdfxConformance.setPDFXConformance(n);
    }

    @Override
    public int getPDFXConformance() {
        return this.pdfxConformance.getPDFXConformance();
    }

    @Override
    public boolean isPdfX() {
        return this.pdfxConformance.isPdfX();
    }

    public void setOutputIntents(String string, String string2, String string3, String string4, ICC_Profile iCC_Profile) throws IOException {
        PdfObject pdfObject;
        this.getExtraCatalog();
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
        if (string2 != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITION, new PdfString(string2, "UnicodeBig"));
        }
        if (string != null) {
            pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString(string, "UnicodeBig"));
        }
        if (string3 != null) {
            pdfDictionary.put(PdfName.REGISTRYNAME, new PdfString(string3, "UnicodeBig"));
        }
        if (string4 != null) {
            pdfDictionary.put(PdfName.INFO, new PdfString(string4, "UnicodeBig"));
        }
        if (iCC_Profile != null) {
            pdfObject = new PdfICCBased(iCC_Profile, this.compressionLevel);
            pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, this.addToBody(pdfObject).getIndirectReference());
        }
        pdfObject = this.pdfxConformance.isPdfA1() || "PDFA/1".equals(string2) ? PdfName.GTS_PDFA1 : PdfName.GTS_PDFX;
        pdfDictionary.put(PdfName.S, pdfObject);
        this.extraCatalog.put(PdfName.OUTPUTINTENTS, new PdfArray(pdfDictionary));
    }

    public void setOutputIntents(String string, String string2, String string3, String string4, byte[] byArray) throws IOException {
        ICC_Profile iCC_Profile = byArray == null ? null : ICC_Profile.getInstance(byArray);
        this.setOutputIntents(string, string2, string3, string4, iCC_Profile);
    }

    public boolean setOutputIntents(PdfReader pdfReader, boolean bl) throws IOException {
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.OUTPUTINTENTS);
        if (pdfArray == null) {
            return false;
        }
        if (pdfArray.isEmpty()) {
            return false;
        }
        PdfDictionary pdfDictionary2 = pdfArray.getAsDict(0);
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary2.get(PdfName.S));
        if (pdfObject == null || !PdfName.GTS_PDFX.equals(pdfObject)) {
            return false;
        }
        if (bl) {
            return true;
        }
        PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary2.get(PdfName.DESTOUTPUTPROFILE));
        byte[] byArray = null;
        if (pRStream != null) {
            byArray = PdfReader.getStreamBytes(pRStream);
        }
        this.setOutputIntents(PdfWriter.getNameString(pdfDictionary2, PdfName.OUTPUTCONDITIONIDENTIFIER), PdfWriter.getNameString(pdfDictionary2, PdfName.OUTPUTCONDITION), PdfWriter.getNameString(pdfDictionary2, PdfName.REGISTRYNAME), PdfWriter.getNameString(pdfDictionary2, PdfName.INFO), byArray);
        return true;
    }

    private static String getNameString(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(pdfName));
        if (pdfObject == null || !pdfObject.isString()) {
            return null;
        }
        return ((PdfString)pdfObject).toUnicodeString();
    }

    PdfEncryption getEncryption() {
        return this.crypto;
    }

    @Override
    public void setEncryption(byte[] byArray, byte[] byArray2, int n, int n2) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        this.crypto.setCryptoMode(n2, 0);
        this.crypto.setupAllKeys(byArray, byArray2, n);
    }

    @Override
    public void setEncryption(Certificate[] certificateArray, int[] nArray, int n) throws DocumentException {
        if (this.pdf.isOpen()) {
            throw new DocumentException("Encryption can only be added before opening the document.");
        }
        this.crypto = new PdfEncryption();
        if (certificateArray != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                this.crypto.addRecipient(certificateArray[i], nArray[i]);
            }
        }
        this.crypto.setCryptoMode(n, 0);
        this.crypto.getEncryptionDictionary();
    }

    @Deprecated
    public void setEncryption(byte[] byArray, byte[] byArray2, int n, boolean bl) throws DocumentException {
        this.setEncryption(byArray, byArray2, n, bl ? 1 : 0);
    }

    @Deprecated
    public void setEncryption(boolean bl, String string, String string2, int n) throws DocumentException {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n, bl ? 1 : 0);
    }

    @Deprecated
    public void setEncryption(int n, String string, String string2, int n2) throws DocumentException {
        this.setEncryption(PdfWriter.getISOBytes(string), PdfWriter.getISOBytes(string2), n2, n);
    }

    public boolean isFullCompression() {
        return this.fullCompression;
    }

    public void setFullCompression() {
        this.fullCompression = true;
        this.setAtLeastPdfVersion('5');
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n < 0 || n > 9 ? -1 : n;
    }

    FontDetails addSimple(BaseFont baseFont) {
        if (baseFont.getFontType() == 4) {
            return new FontDetails(new PdfName("F" + this.fontNumber++), ((DocumentFont)baseFont).getIndirectReference(), baseFont);
        }
        FontDetails fontDetails = (FontDetails)this.documentFonts.get(baseFont);
        if (fontDetails == null) {
            PdfXConformanceImp.checkPDFXConformance(this, 4, baseFont);
            fontDetails = new FontDetails(new PdfName("F" + this.fontNumber++), this.body.getPdfIndirectReference(), baseFont);
            this.documentFonts.put(baseFont, fontDetails);
        }
        return fontDetails;
    }

    void eliminateFontSubset(PdfDictionary pdfDictionary) {
        for (FontDetails fontDetails : this.documentFonts.values()) {
            if (pdfDictionary.get(fontDetails.getFontName()) == null) continue;
            fontDetails.setSubset(false);
        }
    }

    PdfName addDirectTemplateSimple(PdfTemplate pdfTemplate, PdfName pdfName) {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        PdfName pdfName2 = null;
        try {
            if (objectArray == null) {
                if (pdfName == null) {
                    pdfName2 = new PdfName("Xf" + this.formXObjectsCounter);
                    ++this.formXObjectsCounter;
                } else {
                    pdfName2 = pdfName;
                }
                if (pdfTemplate.getType() == 2) {
                    PdfImportedPage pdfImportedPage = (PdfImportedPage)pdfTemplate;
                    PdfReader pdfReader = pdfImportedPage.getPdfReaderInstance().getReader();
                    if (!this.importedPages.containsKey(pdfReader)) {
                        this.importedPages.put(pdfReader, pdfImportedPage.getPdfReaderInstance());
                    }
                    pdfTemplate = null;
                }
                this.formXObjects.put(pdfIndirectReference, new Object[]{pdfName2, pdfTemplate});
            } else {
                pdfName2 = (PdfName)objectArray[0];
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName2;
    }

    public void releaseTemplate(PdfTemplate pdfTemplate) throws IOException {
        PdfIndirectReference pdfIndirectReference = pdfTemplate.getIndirectReference();
        Object[] objectArray = (Object[])this.formXObjects.get(pdfIndirectReference);
        if (objectArray == null || objectArray[1] == null) {
            return;
        }
        PdfTemplate pdfTemplate2 = (PdfTemplate)objectArray[1];
        if (pdfTemplate2.getIndirectReference() instanceof PRIndirectReference) {
            return;
        }
        if (pdfTemplate2.getType() == 1) {
            this.addToBody((PdfObject)pdfTemplate2.getFormXObject(this.compressionLevel), pdfTemplate2.getIndirectReference());
            objectArray[1] = null;
        }
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        PdfReaderInstance pdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (pdfReaderInstance == null) {
            pdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            this.importedPages.put(pdfReader, pdfReaderInstance);
        }
        return pdfReaderInstance.getImportedPage(n);
    }

    public void freeReader(PdfReader pdfReader) throws IOException {
        this.currentPdfReaderInstance = (PdfReaderInstance)this.importedPages.get(pdfReader);
        if (this.currentPdfReaderInstance == null) {
            return;
        }
        this.currentPdfReaderInstance.writeAllPages();
        this.currentPdfReaderInstance = null;
        this.importedPages.remove(pdfReader);
    }

    public int getCurrentDocumentSize() {
        return this.body.offset() + this.body.size() * 20 + 72;
    }

    protected int getNewObjectNumber(PdfReader pdfReader, int n, int n2) {
        return this.currentPdfReaderInstance.getNewObjectNumber(n, n2);
    }

    RandomAccessFileOrArray getReaderFile(PdfReader pdfReader) {
        return this.currentPdfReaderInstance.getReaderFile();
    }

    PdfName getColorspaceName() {
        return new PdfName("CS" + this.colorNumber++);
    }

    ColorDetails addSimple(PdfSpotColor pdfSpotColor) {
        ColorDetails colorDetails = (ColorDetails)this.documentColors.get(pdfSpotColor);
        if (colorDetails == null) {
            colorDetails = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), pdfSpotColor);
            this.documentColors.put(pdfSpotColor, colorDetails);
        }
        return colorDetails;
    }

    PdfName addSimplePattern(PdfPatternPainter pdfPatternPainter) {
        PdfName pdfName = (PdfName)this.documentPatterns.get(pdfPatternPainter);
        try {
            if (pdfName == null) {
                pdfName = new PdfName("P" + this.patternNumber);
                ++this.patternNumber;
                this.documentPatterns.put(pdfPatternPainter, pdfName);
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return pdfName;
    }

    void addSimpleShadingPattern(PdfShadingPattern pdfShadingPattern) {
        if (!this.documentShadingPatterns.containsKey(pdfShadingPattern)) {
            pdfShadingPattern.setName(this.patternNumber);
            ++this.patternNumber;
            this.documentShadingPatterns.put(pdfShadingPattern, null);
            this.addSimpleShading(pdfShadingPattern.getShading());
        }
    }

    void addSimpleShading(PdfShading pdfShading) {
        if (!this.documentShadings.containsKey(pdfShading)) {
            this.documentShadings.put(pdfShading, null);
            pdfShading.setName(this.documentShadings.size());
        }
    }

    PdfObject[] addSimpleExtGState(PdfDictionary pdfDictionary) {
        if (!this.documentExtGState.containsKey(pdfDictionary)) {
            PdfXConformanceImp.checkPDFXConformance(this, 6, pdfDictionary);
            this.documentExtGState.put(pdfDictionary, new PdfObject[]{new PdfName("GS" + (this.documentExtGState.size() + 1)), this.getPdfIndirectReference()});
        }
        return (PdfObject[])this.documentExtGState.get(pdfDictionary);
    }

    PdfObject[] addSimpleProperty(Object object, PdfIndirectReference pdfIndirectReference) {
        if (!this.documentProperties.containsKey(object)) {
            if (object instanceof PdfOCG) {
                PdfXConformanceImp.checkPDFXConformance(this, 7, null);
            }
            this.documentProperties.put(object, new PdfObject[]{new PdfName("Pr" + (this.documentProperties.size() + 1)), pdfIndirectReference});
        }
        return (PdfObject[])this.documentProperties.get(object);
    }

    boolean propertyExists(Object object) {
        return this.documentProperties.containsKey(object);
    }

    public void setTagged() {
        if (this.open) {
            throw new IllegalArgumentException("Tagging must be set before opening the document.");
        }
        this.tagged = true;
    }

    public boolean isTagged() {
        return this.tagged;
    }

    public PdfStructureTreeRoot getStructureTreeRoot() {
        if (this.tagged && this.structureTreeRoot == null) {
            this.structureTreeRoot = new PdfStructureTreeRoot(this);
        }
        return this.structureTreeRoot;
    }

    public PdfOCProperties getOCProperties() {
        this.fillOCProperties(true);
        return this.OCProperties;
    }

    public void addOCGRadioGroup(ArrayList arrayList) {
        PdfArray pdfArray = new PdfArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfLayer pdfLayer = (PdfLayer)arrayList.get(i);
            if (pdfLayer.getTitle() != null) continue;
            pdfArray.add(pdfLayer.getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        this.OCGRadioGroup.add(pdfArray);
    }

    public void lockLayer(PdfLayer pdfLayer) {
        this.OCGLocked.add(pdfLayer.getRef());
    }

    private static void getOCGOrder(PdfArray pdfArray, PdfLayer pdfLayer) {
        ArrayList arrayList;
        if (!pdfLayer.isOnPanel()) {
            return;
        }
        if (pdfLayer.getTitle() == null) {
            pdfArray.add(pdfLayer.getRef());
        }
        if ((arrayList = pdfLayer.getChildren()) == null) {
            return;
        }
        PdfArray pdfArray2 = new PdfArray();
        if (pdfLayer.getTitle() != null) {
            pdfArray2.add(new PdfString(pdfLayer.getTitle(), "UnicodeBig"));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PdfWriter.getOCGOrder(pdfArray2, (PdfLayer)arrayList.get(i));
        }
        if (pdfArray2.size() > 0) {
            pdfArray.add(pdfArray2);
        }
    }

    private void addASEvent(PdfName pdfName, PdfName pdfName2) {
        PdfDictionary pdfDictionary;
        PdfObject pdfObject2;
        PdfArray pdfArray = new PdfArray();
        for (PdfObject pdfObject2 : this.documentOCG) {
            pdfDictionary = (PdfDictionary)((PdfDictionary)pdfObject2).get(PdfName.USAGE);
            if (pdfDictionary == null || pdfDictionary.get(pdfName2) == null) continue;
            pdfArray.add(((PdfLayer)pdfObject2).getRef());
        }
        if (pdfArray.size() == 0) {
            return;
        }
        PdfDictionary pdfDictionary2 = (PdfDictionary)this.OCProperties.get(PdfName.D);
        pdfObject2 = (PdfArray)pdfDictionary2.get(PdfName.AS);
        if (pdfObject2 == null) {
            pdfObject2 = new PdfArray();
            pdfDictionary2.put(PdfName.AS, pdfObject2);
        }
        pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.EVENT, pdfName);
        pdfDictionary.put(PdfName.CATEGORY, new PdfArray(pdfName2));
        pdfDictionary.put(PdfName.OCGS, pdfArray);
        ((PdfArray)pdfObject2).add(pdfDictionary);
    }

    protected void fillOCProperties(boolean bl) {
        PdfObject pdfObject;
        Object object3;
        Object object2;
        if (this.OCProperties == null) {
            this.OCProperties = new PdfOCProperties();
        }
        if (bl) {
            this.OCProperties.remove(PdfName.OCGS);
            this.OCProperties.remove(PdfName.D);
        }
        if (this.OCProperties.get(PdfName.OCGS) == null) {
            object2 = new PdfArray();
            for (Object object3 : this.documentOCG) {
                ((PdfArray)object2).add(((PdfLayer)object3).getRef());
            }
            this.OCProperties.put(PdfName.OCGS, (PdfObject)object2);
        }
        if (this.OCProperties.get(PdfName.D) != null) {
            return;
        }
        object2 = new ArrayList(this.documentOCGorder);
        Object object4 = ((ArrayList)object2).iterator();
        while (object4.hasNext()) {
            object3 = (PdfLayer)object4.next();
            if (((PdfLayer)object3).getParent() == null) continue;
            object4.remove();
        }
        object4 = new PdfArray();
        object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            pdfObject = (PdfLayer)object3.next();
            PdfWriter.getOCGOrder((PdfArray)object4, (PdfLayer)pdfObject);
        }
        object3 = new PdfDictionary();
        this.OCProperties.put(PdfName.D, (PdfObject)object3);
        ((PdfDictionary)object3).put(PdfName.ORDER, (PdfObject)object4);
        pdfObject = new PdfArray();
        for (PdfLayer pdfLayer : this.documentOCG) {
            if (pdfLayer.isOn()) continue;
            ((PdfArray)pdfObject).add(pdfLayer.getRef());
        }
        if (((PdfArray)pdfObject).size() > 0) {
            ((PdfDictionary)object3).put(PdfName.OFF, pdfObject);
        }
        if (this.OCGRadioGroup.size() > 0) {
            ((PdfDictionary)object3).put(PdfName.RBGROUPS, this.OCGRadioGroup);
        }
        if (this.OCGLocked.size() > 0) {
            ((PdfDictionary)object3).put(PdfName.LOCKED, this.OCGLocked);
        }
        this.addASEvent(PdfName.VIEW, PdfName.ZOOM);
        this.addASEvent(PdfName.VIEW, PdfName.VIEW);
        this.addASEvent(PdfName.PRINT, PdfName.PRINT);
        this.addASEvent(PdfName.EXPORT, PdfName.EXPORT);
        ((PdfDictionary)object3).put(PdfName.LISTMODE, PdfName.VISIBLEPAGES);
    }

    void registerLayer(PdfOCG pdfOCG) {
        PdfXConformanceImp.checkPDFXConformance(this, 7, null);
        if (pdfOCG instanceof PdfLayer) {
            PdfLayer pdfLayer = (PdfLayer)pdfOCG;
            if (pdfLayer.getTitle() == null) {
                if (!this.documentOCG.contains(pdfOCG)) {
                    this.documentOCG.add(pdfOCG);
                    this.documentOCGorder.add(pdfOCG);
                }
            } else {
                this.documentOCGorder.add(pdfOCG);
            }
        } else {
            throw new IllegalArgumentException("Only PdfLayer is accepted.");
        }
    }

    public Rectangle getPageSize() {
        return this.pdf.getPageSize();
    }

    public void setCropBoxSize(Rectangle rectangle) {
        this.pdf.setCropBoxSize(rectangle);
    }

    public void setBoxSize(String string, Rectangle rectangle) {
        this.pdf.setBoxSize(string, rectangle);
    }

    public Rectangle getBoxSize(String string) {
        return this.pdf.getBoxSize(string);
    }

    public void setPageEmpty(boolean bl) {
        this.pdf.setPageEmpty(bl);
    }

    @Override
    public void setPageAction(PdfName pdfName, PdfAction pdfAction) throws DocumentException {
        if (!pdfName.equals(PAGE_OPEN) && !pdfName.equals(PAGE_CLOSE)) {
            throw new DocumentException("Invalid page additional action type: " + pdfName.toString());
        }
        this.pdf.setPageAction(pdfName, pdfAction);
    }

    @Override
    public void setDuration(int n) {
        this.pdf.setDuration(n);
    }

    @Override
    public void setTransition(PdfTransition pdfTransition) {
        this.pdf.setTransition(pdfTransition);
    }

    public void setThumbnail(Image image) throws PdfException, DocumentException {
        this.pdf.setThumbnail(image);
    }

    public PdfDictionary getGroup() {
        return this.group;
    }

    public void setGroup(PdfDictionary pdfDictionary) {
        this.group = pdfDictionary;
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float f) {
        this.spaceCharRatio = f < 0.001f ? 0.001f : f;
    }

    @Override
    public void setRunDirection(int n) {
        if (n < 1 || n > 3) {
            throw new RuntimeException("Invalid run direction: " + n);
        }
        this.runDirection = n;
    }

    @Override
    public int getRunDirection() {
        return this.runDirection;
    }

    public float getUserunit() {
        return this.userunit;
    }

    public void setUserunit(float f) throws DocumentException {
        if (f < 1.0f || f > 75000.0f) {
            throw new DocumentException("UserUnit should be a value between 1 and 75000.");
        }
        this.userunit = f;
        this.setAtLeastPdfVersion('6');
    }

    public PdfDictionary getDefaultColorspace() {
        return this.defaultColorspace;
    }

    public void setDefaultColorspace(PdfName pdfName, PdfObject pdfObject) {
        if (pdfObject == null || pdfObject.isNull()) {
            this.defaultColorspace.remove(pdfName);
        }
        this.defaultColorspace.put(pdfName, pdfObject);
    }

    ColorDetails addSimplePatternColorspace(Color color) {
        int n = ExtendedColor.getType(color);
        if (n == 4 || n == 5) {
            throw new RuntimeException("An uncolored tile pattern can not have another pattern or shading as color.");
        }
        try {
            switch (n) {
                case 0: {
                    if (this.patternColorspaceRGB == null) {
                        this.patternColorspaceRGB = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICERGB);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceRGB.getIndirectReference());
                    }
                    return this.patternColorspaceRGB;
                }
                case 2: {
                    if (this.patternColorspaceCMYK == null) {
                        this.patternColorspaceCMYK = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICECMYK);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceCMYK.getIndirectReference());
                    }
                    return this.patternColorspaceCMYK;
                }
                case 1: {
                    if (this.patternColorspaceGRAY == null) {
                        this.patternColorspaceGRAY = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(PdfName.DEVICEGRAY);
                        this.addToBody((PdfObject)pdfArray, this.patternColorspaceGRAY.getIndirectReference());
                    }
                    return this.patternColorspaceGRAY;
                }
                case 3: {
                    ColorDetails colorDetails = this.addSimple(((SpotColor)color).getPdfSpotColor());
                    ColorDetails colorDetails2 = (ColorDetails)this.documentSpotPatterns.get(colorDetails);
                    if (colorDetails2 == null) {
                        colorDetails2 = new ColorDetails(this.getColorspaceName(), this.body.getPdfIndirectReference(), null);
                        PdfArray pdfArray = new PdfArray(PdfName.PATTERN);
                        pdfArray.add(colorDetails.getIndirectReference());
                        this.addToBody((PdfObject)pdfArray, colorDetails2.getIndirectReference());
                        this.documentSpotPatterns.put(colorDetails, colorDetails2);
                    }
                    return colorDetails2;
                }
            }
            throw new RuntimeException("Invalid color type in PdfWriter.addSimplePatternColorspace().");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public boolean isStrictImageSequence() {
        return this.pdf.isStrictImageSequence();
    }

    public void setStrictImageSequence(boolean bl) {
        this.pdf.setStrictImageSequence(bl);
    }

    public void clearTextWrap() throws DocumentException {
        this.pdf.clearTextWrap();
    }

    public PdfName addDirectImageSimple(Image image) throws PdfException, DocumentException {
        return this.addDirectImageSimple(image, null);
    }

    public PdfName addDirectImageSimple(Image image, PdfIndirectReference pdfIndirectReference) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image.getMySerialId())) {
            pdfName = (PdfName)this.images.get(image.getMySerialId());
        } else {
            if (image.isImgTemplate()) {
                pdfName = new PdfName("img" + this.images.size());
                if (image instanceof ImgWMF) {
                    try {
                        ImgWMF imgWMF = (ImgWMF)image;
                        imgWMF.readWMF(PdfTemplate.createTemplate(this, 0.0f, 0.0f));
                    }
                    catch (Exception exception) {
                        throw new DocumentException(exception);
                    }
                }
            } else {
                PdfObject pdfObject;
                Object object;
                PdfObject pdfObject2;
                PdfIndirectReference pdfIndirectReference2 = image.getDirectReference();
                if (pdfIndirectReference2 != null) {
                    PdfName pdfName2 = new PdfName("img" + this.images.size());
                    this.images.put(image.getMySerialId(), pdfName2);
                    this.imageDictionary.put(pdfName2, pdfIndirectReference2);
                    return pdfName2;
                }
                Image image2 = image.getImageMask();
                PdfIndirectReference pdfIndirectReference3 = null;
                if (image2 != null) {
                    pdfObject2 = (PdfName)this.images.get(image2.getMySerialId());
                    pdfIndirectReference3 = this.getImageReference((PdfName)pdfObject2);
                }
                pdfObject2 = new PdfImage(image, "img" + this.images.size(), pdfIndirectReference3);
                if (image instanceof ImgJBIG2 && (object = ((ImgJBIG2)image).getGlobalBytes()) != null) {
                    pdfObject = new PdfDictionary();
                    pdfObject.put(PdfName.JBIG2GLOBALS, this.getReferenceJBIG2Globals((byte[])object));
                    ((PdfDictionary)pdfObject2).put(PdfName.DECODEPARMS, pdfObject);
                }
                if (image.hasICCProfile()) {
                    object = new PdfICCBased(image.getICCProfile(), image.getCompressionLevel());
                    pdfObject = this.add((PdfICCBased)object);
                    PdfArray pdfArray = new PdfArray();
                    pdfArray.add(PdfName.ICCBASED);
                    pdfArray.add(pdfObject);
                    PdfArray pdfArray2 = ((PdfDictionary)pdfObject2).getAsArray(PdfName.COLORSPACE);
                    if (pdfArray2 != null) {
                        if (pdfArray2.size() > 1 && PdfName.INDEXED.equals(pdfArray2.getPdfObject(0))) {
                            pdfArray2.set(1, pdfArray);
                        } else {
                            ((PdfDictionary)pdfObject2).put(PdfName.COLORSPACE, pdfArray);
                        }
                    } else {
                        ((PdfDictionary)pdfObject2).put(PdfName.COLORSPACE, pdfArray);
                    }
                }
                this.add((PdfImage)pdfObject2, pdfIndirectReference);
                pdfName = ((PdfImage)pdfObject2).name();
            }
            this.images.put(image.getMySerialId(), pdfName);
        }
        return pdfName;
    }

    PdfIndirectReference add(PdfImage pdfImage, PdfIndirectReference pdfIndirectReference) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage.name())) {
            PdfXConformanceImp.checkPDFXConformance(this, 5, pdfImage);
            if (pdfIndirectReference instanceof PRIndirectReference) {
                PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfIndirectReference;
                pdfIndirectReference = new PdfIndirectReference(0, this.getNewObjectNumber(pRIndirectReference.getReader(), pRIndirectReference.getNumber(), pRIndirectReference.getGeneration()));
            }
            try {
                if (pdfIndirectReference == null) {
                    pdfIndirectReference = this.addToBody(pdfImage).getIndirectReference();
                } else {
                    this.addToBody((PdfObject)pdfImage, pdfIndirectReference);
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectReference);
            return pdfIndirectReference;
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    protected PdfIndirectReference add(PdfICCBased pdfICCBased) {
        PdfIndirectObject pdfIndirectObject;
        try {
            pdfIndirectObject = this.addToBody(pdfICCBased);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        return pdfIndirectObject.getIndirectReference();
    }

    protected PdfIndirectReference getReferenceJBIG2Globals(byte[] byArray) {
        PdfIndirectObject pdfIndirectObject;
        PdfStream pdfStream2;
        if (byArray == null) {
            return null;
        }
        for (PdfStream pdfStream2 : this.JBIG2Globals.keySet()) {
            if (!Arrays.equals(byArray, pdfStream2.getBytes())) continue;
            return (PdfIndirectReference)this.JBIG2Globals.get(pdfStream2);
        }
        pdfStream2 = new PdfStream(byArray);
        try {
            pdfIndirectObject = this.addToBody(pdfStream2);
        }
        catch (IOException iOException) {
            return null;
        }
        this.JBIG2Globals.put(pdfStream2, pdfIndirectObject.getIndirectReference());
        return pdfIndirectObject.getIndirectReference();
    }

    public boolean fitsPage(Table table, float f) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + f;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0.0f);
    }

    public boolean isUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(boolean bl) {
        this.userProperties = bl;
    }

    public boolean isRgbTransparencyBlending() {
        return this.rgbTransparencyBlending;
    }

    public void setRgbTransparencyBlending(boolean bl) {
        this.rgbTransparencyBlending = bl;
    }

    public static class PdfBody {
        private static final int OBJSINSTREAM = 200;
        private TreeSet xrefs = new TreeSet();
        private int refnum;
        private int position;
        private PdfWriter writer;
        private ByteBuffer index;
        private ByteBuffer streamObjects;
        private int currentObjNum;
        private int numObj = 0;

        PdfBody(PdfWriter pdfWriter) {
            this.xrefs.add(new PdfCrossReference(0, 0, 65535));
            this.position = pdfWriter.getOs().getCounter();
            this.refnum = 1;
            this.writer = pdfWriter;
        }

        void setRefnum(int n) {
            this.refnum = n;
        }

        private PdfCrossReference addToObjStm(PdfObject pdfObject, int n) throws IOException {
            if (this.numObj >= 200) {
                this.flushObjStm();
            }
            if (this.index == null) {
                this.index = new ByteBuffer();
                this.streamObjects = new ByteBuffer();
                this.currentObjNum = this.getIndirectReferenceNumber();
                this.numObj = 0;
            }
            int n2 = this.streamObjects.size();
            int n3 = this.numObj++;
            PdfEncryption pdfEncryption = this.writer.crypto;
            this.writer.crypto = null;
            pdfObject.toPdf(this.writer, this.streamObjects);
            this.writer.crypto = pdfEncryption;
            this.streamObjects.append(' ');
            this.index.append(n).append(' ').append(n2).append(' ');
            return new PdfCrossReference(2, n, this.currentObjNum, n3);
        }

        private void flushObjStm() throws IOException {
            if (this.numObj == 0) {
                return;
            }
            int n = this.index.size();
            this.index.append(this.streamObjects);
            PdfStream pdfStream = new PdfStream(this.index.toByteArray());
            pdfStream.flateCompress(this.writer.getCompressionLevel());
            pdfStream.put(PdfName.TYPE, PdfName.OBJSTM);
            pdfStream.put(PdfName.N, new PdfNumber(this.numObj));
            pdfStream.put(PdfName.FIRST, new PdfNumber(n));
            this.add((PdfObject)pdfStream, this.currentObjNum);
            this.index = null;
            this.streamObjects = null;
            this.numObj = 0;
        }

        PdfIndirectObject add(PdfObject pdfObject) throws IOException {
            return this.add(pdfObject, this.getIndirectReferenceNumber());
        }

        PdfIndirectObject add(PdfObject pdfObject, boolean bl) throws IOException {
            return this.add(pdfObject, this.getIndirectReferenceNumber(), bl);
        }

        PdfIndirectReference getPdfIndirectReference() {
            return new PdfIndirectReference(0, this.getIndirectReferenceNumber());
        }

        int getIndirectReferenceNumber() {
            int n = this.refnum++;
            this.xrefs.add(new PdfCrossReference(n, 0, 65535));
            return n;
        }

        PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference) throws IOException {
            return this.add(pdfObject, pdfIndirectReference.getNumber());
        }

        PdfIndirectObject add(PdfObject pdfObject, PdfIndirectReference pdfIndirectReference, boolean bl) throws IOException {
            return this.add(pdfObject, pdfIndirectReference.getNumber(), bl);
        }

        PdfIndirectObject add(PdfObject pdfObject, int n) throws IOException {
            return this.add(pdfObject, n, true);
        }

        PdfIndirectObject add(PdfObject pdfObject, int n, boolean bl) throws IOException {
            if (bl && pdfObject.canBeInObjStm() && this.writer.isFullCompression()) {
                PdfCrossReference pdfCrossReference = this.addToObjStm(pdfObject, n);
                PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
                if (!this.xrefs.add(pdfCrossReference)) {
                    this.xrefs.remove(pdfCrossReference);
                    this.xrefs.add(pdfCrossReference);
                }
                return pdfIndirectObject;
            }
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n, pdfObject, this.writer);
            PdfCrossReference pdfCrossReference = new PdfCrossReference(n, this.position);
            if (!this.xrefs.add(pdfCrossReference)) {
                this.xrefs.remove(pdfCrossReference);
                this.xrefs.add(pdfCrossReference);
            }
            pdfIndirectObject.writeTo(this.writer.getOs());
            this.position = this.writer.getOs().getCounter();
            return pdfIndirectObject;
        }

        int offset() {
            return this.position;
        }

        int size() {
            return Math.max(((PdfCrossReference)this.xrefs.last()).getRefnum() + 1, this.refnum);
        }

        void writeCrossReferenceTable(OutputStream outputStream, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject, int n) throws IOException {
            int n2 = 0;
            if (this.writer.isFullCompression()) {
                this.flushObjStm();
                n2 = this.getIndirectReferenceNumber();
                this.xrefs.add(new PdfCrossReference(n2, this.position));
            }
            PdfCrossReference pdfCrossReference2 = (PdfCrossReference)this.xrefs.first();
            int n3 = pdfCrossReference2.getRefnum();
            int n4 = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PdfCrossReference pdfCrossReference2 : this.xrefs) {
                if (n3 + n4 == pdfCrossReference2.getRefnum()) {
                    ++n4;
                    continue;
                }
                arrayList.add(new Integer(n3));
                arrayList.add(new Integer(n4));
                n3 = pdfCrossReference2.getRefnum();
                n4 = 1;
            }
            arrayList.add(new Integer(n3));
            arrayList.add(new Integer(n4));
            if (this.writer.isFullCompression()) {
                int n5;
                int n6 = -16777216;
                for (n5 = 4; n5 > 1 && (n6 & this.position) == 0; --n5) {
                    n6 >>>= 8;
                }
                ByteBuffer byteBuffer = new ByteBuffer();
                for (PdfCrossReference pdfCrossReference2 : this.xrefs) {
                    pdfCrossReference2.toPdf(n5, byteBuffer);
                }
                PdfStream pdfStream = new PdfStream(byteBuffer.toByteArray());
                byteBuffer = null;
                pdfStream.flateCompress(this.writer.getCompressionLevel());
                pdfStream.put(PdfName.SIZE, new PdfNumber(this.size()));
                pdfStream.put(PdfName.ROOT, pdfIndirectReference);
                if (pdfIndirectReference2 != null) {
                    pdfStream.put(PdfName.INFO, pdfIndirectReference2);
                }
                if (pdfIndirectReference3 != null) {
                    pdfStream.put(PdfName.ENCRYPT, pdfIndirectReference3);
                }
                if (pdfObject != null) {
                    pdfStream.put(PdfName.ID, pdfObject);
                }
                pdfStream.put(PdfName.W, new PdfArray(new int[]{1, n5, 2}));
                pdfStream.put(PdfName.TYPE, PdfName.XREF);
                PdfArray pdfArray = new PdfArray();
                for (int i = 0; i < arrayList.size(); ++i) {
                    pdfArray.add(new PdfNumber((Integer)arrayList.get(i)));
                }
                pdfStream.put(PdfName.INDEX, pdfArray);
                if (n > 0) {
                    pdfStream.put(PdfName.PREV, new PdfNumber(n));
                }
                PdfEncryption pdfEncryption = this.writer.crypto;
                this.writer.crypto = null;
                PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(n2, (PdfObject)pdfStream, this.writer);
                pdfIndirectObject.writeTo(this.writer.getOs());
                this.writer.crypto = pdfEncryption;
            } else {
                outputStream.write(DocWriter.getISOBytes("xref\n"));
                Iterator iterator = this.xrefs.iterator();
                for (int i = 0; i < arrayList.size(); i += 2) {
                    n3 = (Integer)arrayList.get(i);
                    n4 = (Integer)arrayList.get(i + 1);
                    outputStream.write(DocWriter.getISOBytes(String.valueOf(n3)));
                    outputStream.write(DocWriter.getISOBytes(" "));
                    outputStream.write(DocWriter.getISOBytes(String.valueOf(n4)));
                    outputStream.write(10);
                    while (n4-- > 0) {
                        pdfCrossReference2 = (PdfCrossReference)iterator.next();
                        pdfCrossReference2.toPdf(outputStream);
                    }
                }
            }
        }

        static class PdfCrossReference
        implements Comparable<Object> {
            private int type;
            private int offset;
            private int refnum;
            private int generation;

            PdfCrossReference(int n, int n2, int n3) {
                this.type = 0;
                this.offset = n2;
                this.refnum = n;
                this.generation = n3;
            }

            PdfCrossReference(int n, int n2) {
                this.type = 1;
                this.offset = n2;
                this.refnum = n;
                this.generation = 0;
            }

            PdfCrossReference(int n, int n2, int n3, int n4) {
                this.type = n;
                this.offset = n3;
                this.refnum = n2;
                this.generation = n4;
            }

            int getRefnum() {
                return this.refnum;
            }

            public void toPdf(OutputStream outputStream) throws IOException {
                StringBuffer stringBuffer = new StringBuffer("0000000000").append(this.offset);
                stringBuffer.delete(0, stringBuffer.length() - 10);
                StringBuffer stringBuffer2 = new StringBuffer("00000").append(this.generation);
                stringBuffer2.delete(0, stringBuffer2.length() - 5);
                stringBuffer.append(' ').append(stringBuffer2).append(this.generation == 65535 ? " f \n" : " n \n");
                outputStream.write(DocWriter.getISOBytes(stringBuffer.toString()));
            }

            public void toPdf(int n, OutputStream outputStream) throws IOException {
                outputStream.write((byte)this.type);
                while (--n >= 0) {
                    outputStream.write((byte)(this.offset >>> 8 * n & 0xFF));
                }
                outputStream.write((byte)(this.generation >>> 8 & 0xFF));
                outputStream.write((byte)(this.generation & 0xFF));
            }

            @Override
            public int compareTo(Object object) {
                PdfCrossReference pdfCrossReference = (PdfCrossReference)object;
                return this.refnum < pdfCrossReference.refnum ? -1 : (this.refnum == pdfCrossReference.refnum ? 0 : 1);
            }

            public boolean equals(Object object) {
                if (object instanceof PdfCrossReference) {
                    PdfCrossReference pdfCrossReference = (PdfCrossReference)object;
                    return this.refnum == pdfCrossReference.refnum;
                }
                return false;
            }

            public int hashCode() {
                return this.refnum;
            }
        }
    }

    static class PdfTrailer
    extends PdfDictionary {
        int offset;

        PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2, PdfIndirectReference pdfIndirectReference3, PdfObject pdfObject, int n3) {
            this.offset = n2;
            this.put(PdfName.SIZE, new PdfNumber(n));
            this.put(PdfName.ROOT, pdfIndirectReference);
            if (pdfIndirectReference2 != null) {
                this.put(PdfName.INFO, pdfIndirectReference2);
            }
            if (pdfIndirectReference3 != null) {
                this.put(PdfName.ENCRYPT, pdfIndirectReference3);
            }
            if (pdfObject != null) {
                this.put(PdfName.ID, pdfObject);
            }
            if (n3 > 0) {
                this.put(PdfName.PREV, new PdfNumber(n3));
            }
        }

        @Override
        public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
            outputStream.write(DocWriter.getISOBytes("trailer\n"));
            super.toPdf(null, outputStream);
            outputStream.write(DocWriter.getISOBytes("\nstartxref\n"));
            outputStream.write(DocWriter.getISOBytes(String.valueOf(this.offset)));
            outputStream.write(DocWriter.getISOBytes("\n%%EOF\n"));
        }
    }
}

