/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import com.lowagie.text.xml.simpleparser.SimpleXMLParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private Stack fieldNames = new Stack();
    private Stack fieldValues = new Stack();
    HashMap fields;
    protected HashMap listFields;
    String fileSpec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XfdfReader(String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, fileInputStream);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public XfdfReader(byte[] byArray) throws IOException {
        SimpleXMLParser.parse((SimpleXMLDocHandler)this, new ByteArrayInputStream(byArray));
    }

    public HashMap getFields() {
        return this.fields;
    }

    public String getField(String string) {
        return (String)this.fields.get(string);
    }

    public String getFieldValue(String string) {
        String string2 = (String)this.fields.get(string);
        if (string2 == null) {
            return null;
        }
        return string2;
    }

    public List getListValues(String string) {
        return (List)this.listFields.get(string);
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    @Override
    public void startElement(String string, HashMap hashMap) {
        if (!this.foundRoot) {
            if (!string.equals("xfdf")) {
                throw new RuntimeException("Root element is not Bookmark.");
            }
            this.foundRoot = true;
        }
        if (!string.equals("xfdf")) {
            if (string.equals("f")) {
                this.fileSpec = (String)hashMap.get("href");
            } else if (string.equals("fields")) {
                this.fields = new HashMap();
                this.listFields = new HashMap();
            } else if (string.equals("field")) {
                String string2 = (String)hashMap.get("name");
                this.fieldNames.push(string2);
            } else if (string.equals("value")) {
                this.fieldValues.push("");
            }
        }
    }

    @Override
    public void endElement(String string) {
        if (string.equals("value")) {
            String string2;
            String string3;
            Object object = "";
            for (int i = 0; i < this.fieldNames.size(); ++i) {
                object = (String)object + "." + (String)this.fieldNames.elementAt(i);
            }
            if (((String)object).startsWith(".")) {
                object = ((String)object).substring(1);
            }
            if ((string3 = this.fields.put(object, string2 = (String)this.fieldValues.pop())) != null) {
                ArrayList<String> arrayList = (ArrayList<String>)this.listFields.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string3);
                }
                arrayList.add(string2);
                this.listFields.put(object, arrayList);
            }
        } else if (string.equals("field") && !this.fieldNames.isEmpty()) {
            this.fieldNames.pop();
        }
    }

    @Override
    public void startDocument() {
        this.fileSpec = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(String string) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        Object object = (String)this.fieldValues.pop();
        object = (String)object + string;
        this.fieldValues.push(object);
    }
}

