/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.factories.ElementFactory;
import com.lowagie.text.html.HtmlTagMap;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.draw.LineSeparator;
import com.lowagie.text.xml.simpleparser.EntitiesToSymbol;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXiTextHandler
extends DefaultHandler {
    protected DocListener document;
    protected Stack stack;
    protected int chapters = 0;
    protected Chunk currentChunk = null;
    protected boolean ignore = false;
    protected boolean controlOpenClose = true;
    float topMargin = 36.0f;
    float rightMargin = 36.0f;
    float leftMargin = 36.0f;
    float bottomMargin = 36.0f;
    protected HashMap myTags;
    private BaseFont bf = null;

    public SAXiTextHandler(DocListener docListener) {
        this.document = docListener;
        this.stack = new Stack();
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap) {
        this(docListener);
        this.myTags = htmlTagMap;
    }

    public SAXiTextHandler(DocListener docListener, HtmlTagMap htmlTagMap, BaseFont baseFont) {
        this(docListener, htmlTagMap);
        this.bf = baseFont;
    }

    public SAXiTextHandler(DocListener docListener, HashMap hashMap) {
        this(docListener);
        this.myTags = hashMap;
    }

    public void setControlOpenClose(boolean bl) {
        this.controlOpenClose = bl;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Properties properties = new Properties();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                properties.setProperty(string4, attributes.getValue(i));
            }
        }
        this.handleStartingTags(string3, properties);
    }

    public void handleStartingTags(String string, Properties properties) {
        Object object2;
        if (this.ignore || "ignore".equals(string)) {
            this.ignore = true;
            return;
        }
        if (this.currentChunk != null) {
            try {
                object2 = (TextElementArray)this.stack.pop();
            }
            catch (EmptyStackException emptyStackException) {
                object2 = this.bf == null ? new Paragraph("", new Font()) : new Paragraph("", new Font(this.bf));
            }
            object2.add(this.currentChunk);
            this.stack.push(object2);
            this.currentChunk = null;
        }
        if ("chunk".equals(string)) {
            this.currentChunk = ElementFactory.getChunk(properties);
            if (this.bf != null) {
                this.currentChunk.setFont(new Font(this.bf));
            }
            return;
        }
        if ("entity".equals(string)) {
            object2 = new Font();
            if (this.currentChunk != null) {
                this.handleEndingTags("chunk");
                object2 = this.currentChunk.getFont();
            }
            this.currentChunk = EntitiesToSymbol.get(properties.getProperty("id"), (Font)object2);
            return;
        }
        if ("phrase".equals(string)) {
            this.stack.push(ElementFactory.getPhrase(properties));
            return;
        }
        if ("anchor".equals(string)) {
            this.stack.push(ElementFactory.getAnchor(properties));
            return;
        }
        if ("paragraph".equals(string) || "title".equals(string)) {
            this.stack.push(ElementFactory.getParagraph(properties));
            return;
        }
        if ("list".equals(string)) {
            this.stack.push(ElementFactory.getList(properties));
            return;
        }
        if ("listitem".equals(string)) {
            this.stack.push(ElementFactory.getListItem(properties));
            return;
        }
        if ("cell".equals(string)) {
            this.stack.push(ElementFactory.getCell(properties));
            return;
        }
        if ("table".equals(string)) {
            object2 = ElementFactory.getTable(properties);
            float[] fArray = ((Table)object2).getProportionalWidths();
            for (int i = 0; i < fArray.length; ++i) {
                if (fArray[i] != 0.0f) continue;
                fArray[i] = 100.0f / (float)fArray.length;
            }
            try {
                ((Table)object2).setWidths(fArray);
            }
            catch (BadElementException badElementException) {
                throw new ExceptionConverter(badElementException);
            }
            this.stack.push(object2);
            return;
        }
        if ("section".equals(string)) {
            Section section;
            object2 = (Element)this.stack.pop();
            try {
                section = ElementFactory.getSection((Section)object2, properties);
            }
            catch (ClassCastException classCastException) {
                throw new ExceptionConverter(classCastException);
            }
            this.stack.push(object2);
            this.stack.push(section);
            return;
        }
        if ("chapter".equals(string)) {
            this.stack.push(ElementFactory.getChapter(properties));
            return;
        }
        if ("image".equals(string)) {
            try {
                object2 = ElementFactory.getImage(properties);
                try {
                    this.addImage((Image)object2);
                    return;
                }
                catch (EmptyStackException emptyStackException) {
                    try {
                        this.document.add((Element)object2);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        if ("annotation".equals(string)) {
            object2 = ElementFactory.getAnnotation(properties);
            try {
                try {
                    TextElementArray textElementArray = (TextElementArray)this.stack.pop();
                    try {
                        textElementArray.add(object2);
                    }
                    catch (Exception exception) {
                        this.document.add((Element)object2);
                    }
                    this.stack.push(textElementArray);
                }
                catch (EmptyStackException emptyStackException) {
                    this.document.add((Element)object2);
                }
                return;
            }
            catch (DocumentException documentException) {
                throw new ExceptionConverter(documentException);
            }
        }
        if (this.isNewline(string)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add(Chunk.NEWLINE);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                if (this.currentChunk == null) {
                    try {
                        this.document.add(Chunk.NEWLINE);
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                }
                this.currentChunk.append("\n");
            }
            return;
        }
        if (this.isNewpage(string)) {
            try {
                object2 = (TextElementArray)this.stack.pop();
                Chunk chunk = new Chunk("");
                chunk.setNewPage();
                if (this.bf != null) {
                    chunk.setFont(new Font(this.bf));
                }
                object2.add(chunk);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                this.document.newPage();
            }
            return;
        }
        if ("horizontalrule".equals(string)) {
            LineSeparator lineSeparator = new LineSeparator(1.0f, 100.0f, null, 1, 0.0f);
            try {
                object2 = (TextElementArray)this.stack.pop();
                object2.add(lineSeparator);
                this.stack.push(object2);
            }
            catch (EmptyStackException emptyStackException) {
                try {
                    this.document.add(lineSeparator);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            return;
        }
        if (this.isDocumentRoot(string)) {
            Rectangle rectangle = null;
            String string2 = null;
            for (Object object2 : properties.keySet()) {
                String string3 = properties.getProperty((String)object2);
                try {
                    if ("left".equalsIgnoreCase((String)object2)) {
                        this.leftMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("right".equalsIgnoreCase((String)object2)) {
                        this.rightMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("top".equalsIgnoreCase((String)object2)) {
                        this.topMargin = Float.parseFloat(string3 + "f");
                    }
                    if ("bottom".equalsIgnoreCase((String)object2)) {
                        this.bottomMargin = Float.parseFloat(string3 + "f");
                    }
                }
                catch (Exception exception) {
                    throw new ExceptionConverter(exception);
                }
                if ("pagesize".equals(object2)) {
                    try {
                        String string4 = string3;
                        Field field = PageSize.class.getField(string4);
                        rectangle = (Rectangle)field.get(null);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                if ("orientation".equals(object2)) {
                    try {
                        if (!"landscape".equals(string3)) continue;
                        string2 = "landscape";
                        continue;
                    }
                    catch (Exception exception) {
                        throw new ExceptionConverter(exception);
                    }
                }
                try {
                    this.document.add(new Meta((String)object2, string3));
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (rectangle != null) {
                if ("landscape".equals(string2)) {
                    rectangle = rectangle.rotate();
                }
                this.document.setPageSize(rectangle);
            }
            this.document.setMargins(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin);
            if (this.controlOpenClose) {
                this.document.open();
            }
        }
    }

    protected void addImage(Image image) throws EmptyStackException {
        Object e = this.stack.pop();
        if (e instanceof Chapter || e instanceof Section || e instanceof Cell) {
            ((TextElementArray)e).add(image);
            this.stack.push(e);
            return;
        }
        Stack stack = new Stack();
        while (!(e instanceof Chapter || e instanceof Section || e instanceof Cell)) {
            stack.push(e);
            if (e instanceof Anchor) {
                image.setAnnotation(new Annotation(0.0f, 0.0f, 0.0f, 0.0f, ((Anchor)e).getReference()));
            }
            e = this.stack.pop();
        }
        ((TextElementArray)e).add(image);
        this.stack.push(e);
        while (!stack.empty()) {
            this.stack.push(stack.pop());
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.ignore) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (string.trim().length() == 0 && string.indexOf(32) < 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        block6: for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (bl) continue block6;
                    stringBuffer.append(c);
                    continue block6;
                }
                case '\n': {
                    if (i <= 0) continue block6;
                    bl = true;
                    stringBuffer.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    bl = false;
                    stringBuffer.append(c);
                }
            }
        }
        if (this.currentChunk == null) {
            this.currentChunk = this.bf == null ? new Chunk(stringBuffer.toString()) : new Chunk(stringBuffer.toString(), new Font(this.bf));
        } else {
            this.currentChunk.append(stringBuffer.toString());
        }
    }

    public void setBaseFont(BaseFont baseFont) {
        this.bf = baseFont;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.handleEndingTags(string3);
    }

    /*
     * Unable to fully structure code
     */
    public void handleEndingTags(String var1_1) {
        block47: {
            if ("ignore".equals(var1_1)) {
                this.ignore = false;
                return;
            }
            if (this.ignore) {
                return;
            }
            if (this.isNewpage(var1_1) || "annotation".equals(var1_1) || "image".equals(var1_1) || this.isNewline(var1_1)) {
                return;
            }
            try {
                if ("title".equals(var1_1)) {
                    var2_2 = (Paragraph)this.stack.pop();
                    if (this.currentChunk != null) {
                        var2_2.add(this.currentChunk);
                        this.currentChunk = null;
                    }
                    var3_6 = (Section)this.stack.pop();
                    var3_6.setTitle(var2_2);
                    this.stack.push(var3_6);
                    return;
                }
                if (this.currentChunk != null) {
                    try {
                        var2_3 = (TextElementArray)this.stack.pop();
                    }
                    catch (EmptyStackException var3_7) {
                        var2_3 = new Paragraph();
                    }
                    var2_3.add(this.currentChunk);
                    this.stack.push(var2_3);
                    this.currentChunk = null;
                }
                if ("chunk".equals(var1_1)) {
                    return;
                }
                if ("phrase".equals(var1_1) || "anchor".equals(var1_1) || "list".equals(var1_1) || "paragraph".equals(var1_1)) {
                    var2_3 = (Element)this.stack.pop();
                    try {
                        var3_8 = (TextElementArray)this.stack.pop();
                        var3_8.add(var2_3);
                        this.stack.push(var3_8);
                    }
                    catch (EmptyStackException var3_9) {
                        this.document.add((Element)var2_3);
                    }
                    return;
                }
                if ("listitem".equals(var1_1)) {
                    var2_3 = (ListItem)this.stack.pop();
                    var3_10 = (List)this.stack.pop();
                    var3_10.add(var2_3);
                    this.stack.push(var3_10);
                }
                if ("table".equals(var1_1)) {
                    var2_3 = (Table)this.stack.pop();
                    try {
                        var3_10 = (TextElementArray)this.stack.pop();
                        var3_10.add(var2_3);
                        this.stack.push(var3_10);
                    }
                    catch (EmptyStackException var3_11) {
                        this.document.add((Element)var2_3);
                    }
                    return;
                }
                if ("row".equals(var1_1)) {
                    var2_3 = new ArrayList<E>();
                    var3_12 = 0;
                    while ((var6_16 = (Element)this.stack.pop()).type() == 20) {
                        var5_15 = (Cell)var6_16;
                        var3_12 += var5_15.getColspan();
                        var2_3.add(var5_15);
                    }
                    var4_17 = (Table)var6_16;
                    if (var4_17.getColumns() < var3_12) {
                        var4_17.addColumns(var3_12 - var4_17.getColumns());
                    }
                    Collections.reverse(var2_3);
                    var7_18 = new float[var3_12];
                    var8_19 = new boolean[var3_12];
                    for (var9_20 = 0; var9_20 < var3_12; ++var9_20) {
                        var7_18[var9_20] = 0.0f;
                        var8_19[var9_20] = true;
                    }
                    var9_21 = 0.0f;
                    var10_22 = 0;
                    var11_23 = var2_3.iterator();
                    while (var11_23.hasNext()) {
                        var5_15 = (Cell)var11_23.next();
                        var6_16 = var5_15.getWidthAsString();
                        if (var5_15.getWidth() == 0.0f) {
                            if (var5_15.getColspan() == 1 && var7_18[var10_22] == 0.0f) {
                                try {
                                    var7_18[var10_22] = 100.0f / (float)var3_12;
                                    var9_21 += var7_18[var10_22];
                                }
                                catch (Exception var12_25) {}
                            } else if (var5_15.getColspan() == 1) {
                                var8_19[var10_22] = false;
                            }
                        } else if (var5_15.getColspan() == 1 && var6_16.endsWith("%")) {
                            try {
                                var7_18[var10_22] = Float.parseFloat(var6_16.substring(0, var6_16.length() - 1) + "f");
                                var9_21 += var7_18[var10_22];
                            }
                            catch (Exception var12_26) {
                                // empty catch block
                            }
                        }
                        var10_22 += var5_15.getColspan();
                        var4_17.addCell(var5_15);
                    }
                    var11_23 = var4_17.getProportionalWidths();
                    if (((Object)var11_23).length == var3_12) {
                        var12_27 = 0.0f;
                        for (var13_28 = 0; var13_28 < var3_12; ++var13_28) {
                            if (!var8_19[var13_28] || var11_23[var13_28] == 0.0f) continue;
                            var12_27 += var11_23[var13_28];
                            var7_18[var13_28] = (float)var11_23[var13_28];
                        }
                        if (100.0 >= (double)var9_21) {
                            for (var13_28 = 0; var13_28 < ((Object)var11_23).length; ++var13_28) {
                                if (var7_18[var13_28] != 0.0f || var11_23[var13_28] == 0.0f) continue;
                                var7_18[var13_28] = (float)(var11_23[var13_28] / var12_27 * (100.0f - var9_21));
                            }
                        }
                        var4_17.setWidths(var7_18);
                    }
                    this.stack.push(var4_17);
                }
                if ("cell".equals(var1_1)) {
                    return;
                }
                if ("section".equals(var1_1)) {
                    this.stack.pop();
                    return;
                }
                if ("chapter".equals(var1_1)) {
                    this.document.add((Element)this.stack.pop());
                    return;
                }
                if (!this.isDocumentRoot(var1_1)) break block47;
                block21: while (true) lbl-1000:
                // 2 sources

                {
                    try {
                        while (true) {
                            var2_3 = (Element)this.stack.pop();
                            try {
                                var3_13 = (TextElementArray)this.stack.pop();
                                var3_13.add(var2_3);
                                this.stack.push(var3_13);
                                continue block21;
                            }
                            catch (EmptyStackException var3_14) {
                                this.document.add((Element)var2_3);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (EmptyStackException var2_4) {
                        if (this.controlOpenClose) {
                            this.document.close();
                        }
                        return;
                    }
                    break;
                }
            }
            catch (DocumentException var2_5) {
                throw new ExceptionConverter(var2_5);
            }
            {
                ** while (true)
            }
        }
    }

    private boolean isNewpage(String string) {
        return "newpage".equals(string);
    }

    private boolean isNewline(String string) {
        return "newline".equals(string);
    }

    protected boolean isDocumentRoot(String string) {
        return "itext".equals(string);
    }
}

