/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.xml.XmlPeer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TagMap
extends HashMap<Object, Object> {
    private static final long serialVersionUID = -6809383366554350820L;

    public TagMap(String string) {
        try {
            this.init(TagMap.class.getClassLoader().getResourceAsStream(string));
        }
        catch (Exception exception) {
            try {
                this.init(new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ExceptionConverter(fileNotFoundException);
            }
        }
    }

    public TagMap(InputStream inputStream) {
        this.init(inputStream);
    }

    protected void init(InputStream inputStream) {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)new AttributeHandler(this));
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    class AttributeHandler
    extends DefaultHandler {
        public static final String TAG = "tag";
        public static final String ATTRIBUTE = "attribute";
        public static final String NAME = "name";
        public static final String ALIAS = "alias";
        public static final String VALUE = "value";
        public static final String CONTENT = "content";
        private HashMap tagMap;
        private XmlPeer currentPeer;

        public AttributeHandler(HashMap hashMap) {
            this.tagMap = hashMap;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = attributes.getValue(NAME);
            String string5 = attributes.getValue(ALIAS);
            String string6 = attributes.getValue(VALUE);
            if (string4 != null) {
                if (TAG.equals(string3)) {
                    this.currentPeer = new XmlPeer(string4, string5);
                } else if (ATTRIBUTE.equals(string3)) {
                    if (string5 != null) {
                        this.currentPeer.addAlias(string4, string5);
                    }
                    if (string6 != null) {
                        this.currentPeer.addValue(string4, string6);
                    }
                }
            }
            if ((string6 = attributes.getValue(CONTENT)) != null) {
                this.currentPeer.setContent(string6);
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (TAG.equals(string3)) {
                this.tagMap.put(this.currentPeer.getAlias(), this.currentPeer);
            }
        }
    }
}

