/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j;

import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.InvalidValueException;
import org.osgeo.proj4j.Registry;
import org.osgeo.proj4j.UnknownAuthorityCodeException;
import org.osgeo.proj4j.UnsupportedParameterException;
import org.osgeo.proj4j.io.Proj4FileReader;
import org.osgeo.proj4j.parser.Proj4Parser;

public class CRSFactory {
    private static Proj4FileReader csReader = new Proj4FileReader();
    private static Registry registry = new Registry();

    public Registry getRegistry() {
        return registry;
    }

    public CoordinateReferenceSystem createFromName(String string) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        String[] stringArray = csReader.getParameters(string);
        if (stringArray == null) {
            throw new UnknownAuthorityCodeException(string);
        }
        return this.createFromParameters(string, stringArray);
    }

    public CoordinateReferenceSystem createFromParameters(String string, String string2) throws UnsupportedParameterException, InvalidValueException {
        return this.createFromParameters(string, CRSFactory.splitParameters(string2));
    }

    public CoordinateReferenceSystem createFromParameters(String string, String[] stringArray) throws UnsupportedParameterException, InvalidValueException {
        if (stringArray == null) {
            return null;
        }
        Proj4Parser proj4Parser = new Proj4Parser(registry);
        return proj4Parser.parse(string, stringArray);
    }

    private static String[] splitParameters(String string) {
        String[] stringArray = string.split("\\s+");
        return stringArray;
    }
}

