/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.datum;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.datum.Ellipsoid;

public class GeocentricConverter {
    double a;
    double b;
    double a2;
    double b2;
    double e2;
    double ep2;
    private static final double ITERATION_THRESHOLD = 4.84813681109536E-8;

    public GeocentricConverter(Ellipsoid ellipsoid) {
        this(ellipsoid.getA(), ellipsoid.getB());
    }

    public GeocentricConverter(double d, double d2) {
        this.a = d;
        this.b = d2;
        this.a2 = d * d;
        this.b2 = d2 * d2;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
    }

    public void convertGeodeticToGeocentric(ProjCoordinate projCoordinate) {
        double d;
        double d2 = projCoordinate.x;
        double d3 = projCoordinate.y;
        double d4 = d = projCoordinate.hasValidZOrdinate() ? projCoordinate.z : 0.0;
        if (d3 < -1.5707963267948966 && d3 > -1.5723671231216914) {
            d3 = -1.5707963267948966;
        } else if (d3 > 1.5707963267948966 && d3 < 1.5723671231216914) {
            d3 = 1.5707963267948966;
        } else if (d3 < -1.5707963267948966 || d3 > 1.5707963267948966) {
            throw new IllegalStateException("Latitude is out of range: " + d3);
        }
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = d5 * d5;
        double d8 = this.a / Math.sqrt(1.0 - this.e2 * d7);
        double d9 = (d8 + d) * d6 * Math.cos(d2);
        double d10 = (d8 + d) * d6 * Math.sin(d2);
        double d11 = (d8 * (1.0 - this.e2) + d) * d5;
        projCoordinate.x = d9;
        projCoordinate.y = d10;
        projCoordinate.z = d11;
    }

    public void convertGeocentricToGeodetic(ProjCoordinate projCoordinate) {
        this.convertGeocentricToGeodeticIter(projCoordinate);
    }

    public void convertGeocentricToGeodeticIter(ProjCoordinate projCoordinate) {
        double d;
        double d2;
        double d3 = projCoordinate.x;
        double d4 = projCoordinate.y;
        double d5 = projCoordinate.z;
        double d6 = 1.0 - this.e2;
        double d7 = Math.atan2(d4, d3);
        double d8 = Math.sqrt(d3 * d3 + d4 * d4);
        double d9 = Math.atan(d5 / d8);
        double d10 = this.primeVerticalRadiusOfCurvature(d9);
        double d11 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) - d10;
        int n = 0;
        do {
            double d12 = Math.cos(d9);
            double d13 = Math.sin(d9);
            d10 = this.primeVerticalRadiusOfCurvature(d9);
            d2 = d8 - (d10 + d11) * d12;
            d = d5 - (d10 * d6 + d11) * d13;
            double d14 = this.meridianRadiusOfCurvature(d9);
            double d15 = (-d2 * d13 + d * d12) / (d14 + d11);
            double d16 = d2 * d12 + d * d13;
            d9 += d15;
            d11 += d16;
            n = (short)(n + 1);
        } while ((Math.abs(d2) > 4.84813681109536E-8 || Math.abs(d) > 4.84813681109536E-8) && n < 100);
        projCoordinate.x = d7;
        projCoordinate.y = d9;
        projCoordinate.z = d11;
    }

    private double primeVerticalRadiusOfCurvature(double d) {
        double d2 = Math.sqrt(this.e2) * Math.sin(d);
        double d3 = this.a / Math.sqrt(1.0 - d2 * d2);
        return d3;
    }

    private double meridianRadiusOfCurvature(double d) {
        double d2 = Math.sin(d);
        double d3 = 1.0 - this.e2 * d2 * d2;
        double d4 = this.a * (1.0 - this.e2) / Math.sqrt(d3 * d3 * d3);
        return d4;
    }
}

