/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.parser;

import org.osgeo.proj4j.datum.Datum;
import org.osgeo.proj4j.datum.Ellipsoid;

public class DatumParameters {
    private static final double SIXTH = 0.16666666666666666;
    private static final double RA4 = 0.04722222222222222;
    private static final double RA6 = 0.022156084656084655;
    private static final double RV4 = 0.06944444444444445;
    private static final double RV6 = 0.04243827160493827;
    private Datum datum = null;
    private double[] datumTransform = null;
    private Ellipsoid ellipsoid;
    private double a = Double.NaN;
    private double es = Double.NaN;

    public Datum getDatum() {
        if (this.datum != null) {
            return this.datum;
        }
        if (this.ellipsoid == null && !this.isDefinedExplicitly()) {
            return Datum.WGS84;
        }
        if (this.ellipsoid == Ellipsoid.WGS84) {
            return Datum.WGS84;
        }
        return new Datum("User", this.datumTransform, this.getEllipsoid(), "User-defined");
    }

    private boolean isDefinedExplicitly() {
        return !Double.isNaN(this.a) && !Double.isNaN(this.es);
    }

    public Ellipsoid getEllipsoid() {
        if (this.ellipsoid != null) {
            return this.ellipsoid;
        }
        return new Ellipsoid("user", this.a, this.es, "User-defined");
    }

    public void setDatumTransform(double[] dArray) {
        this.datumTransform = dArray;
        this.datum = null;
    }

    public void setDatum(Datum datum) {
        this.datum = datum;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.es = ellipsoid.eccentricity2;
        this.a = ellipsoid.equatorRadius;
    }

    public void setA(double d) {
        this.ellipsoid = null;
        this.a = d;
    }

    public void setB(double d) {
        this.ellipsoid = null;
        this.es = 1.0 - d * d / (this.a * this.a);
    }

    public void setES(double d) {
        this.ellipsoid = null;
        this.es = d;
    }

    public void setRF(double d) {
        this.ellipsoid = null;
        this.es = d * (2.0 - d);
    }

    public void setR_A() {
        this.ellipsoid = null;
        this.a *= 1.0 - this.es * (0.16666666666666666 + this.es * (0.04722222222222222 + this.es * 0.022156084656084655));
    }

    public void setF(double d) {
        this.ellipsoid = null;
        double d2 = 1.0 / d;
        this.es = d2 * (2.0 - d2);
    }

    public double getA() {
        return this.a;
    }

    public double getES() {
        return this.es;
    }
}

