/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class GaussProjection
extends Projection {
    private static final int MAX_ITER = 20;
    private static final double DEL_TOL = 1.0E-14;
    private double C;
    private double K;
    protected double rc;
    protected double phic0;
    private double ratexp;

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        projCoordinate.y = 2.0 * Math.atan(this.K * Math.pow(Math.tan(0.5 * d2 + 0.7853981633974483), this.C) * GaussProjection.srat(this.e * Math.sin(d2), this.ratexp)) - 1.5707963267948966;
        projCoordinate.x = this.C * d;
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = d / this.C;
        double d4 = d2;
        double d5 = Math.pow(Math.tan(0.5 * d4 + 0.7853981633974483) / this.K, 1.0 / this.C);
        for (n = 20; n > 0 && !(Math.abs((d4 = 2.0 * Math.atan(d5 * GaussProjection.srat(this.e * Math.sin(d2), -0.5 * this.e)) - 1.5707963267948966) - d2) < 1.0E-14); --n) {
            d2 = d4;
        }
        if (n <= 0) {
            throw new ProjectionException(this, ProjectionException.ERR_17);
        }
        projCoordinate.x = d3;
        projCoordinate.y = d4;
        return projCoordinate;
    }

    @Override
    public void initialize() {
        super.initialize();
        double d = Math.sin(this.projectionLatitude);
        double d2 = Math.cos(this.projectionLatitude);
        d2 *= d2;
        this.rc = Math.sqrt(1.0 - this.es) / (1.0 - this.es * d * d);
        this.C = Math.sqrt(1.0 + this.es * d2 * d2 / (1.0 - this.es));
        this.phic0 = Math.asin(d / this.C);
        this.ratexp = 0.5 * this.C * this.e;
        this.K = Math.tan(0.5 * this.phic0 + 0.7853981633974483) / (Math.pow(Math.tan(0.5 * this.projectionLatitude + 0.7853981633974483), this.C) * GaussProjection.srat(this.e * d, this.ratexp));
    }

    private static double srat(double d, double d2) {
        return Math.pow((1.0 - d) / (1.0 + d), d2);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Gauss";
    }
}

