/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.GaussProjection;

public class ObliqueStereographicAlternativeProjection
extends GaussProjection {
    private double sinc0;
    private double cosc0;
    private double R2;

    public ProjCoordinate OLDproject(double d, double d2, ProjCoordinate projCoordinate) {
        super.project(d, d2, projCoordinate);
        double d3 = projCoordinate.x;
        double d4 = projCoordinate.y;
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.cos(d3);
        double d8 = this.scaleFactor * this.R2 / (1.0 + this.sinc0 * d5 + this.cosc0 * d6 * d7);
        projCoordinate.x = d8 * d6 * Math.sin(d3);
        projCoordinate.y = d8 * (this.cosc0 * d5 - this.sinc0 * d6 * d7);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        super.project(d, d2, projCoordinate);
        double d3 = projCoordinate.x;
        double d4 = projCoordinate.y;
        double d5 = Math.sin(d4);
        double d6 = Math.cos(d4);
        double d7 = Math.cos(d3);
        double d8 = this.scaleFactor * this.R2 / (1.0 + this.sinc0 * d5 + this.cosc0 * d6 * d7);
        projCoordinate.x = d8 * d6 * Math.sin(d3);
        projCoordinate.y = d8 * (this.cosc0 * d5 - this.sinc0 * d6 * d7);
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        double d3;
        double d4;
        double d5 = d / this.scaleFactor;
        double d6 = d2 / this.scaleFactor;
        double d7 = Math.sqrt(d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            double d8 = 2.0 * Math.atan2(d7, this.R2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            d4 = Math.asin(d10 * this.sinc0 + d6 * d9 * this.cosc0 / d7);
            d3 = Math.atan2(d5 * d9, d7 * this.cosc0 * d10 - d6 * this.sinc0 * d9);
        } else {
            d4 = this.phic0;
            d3 = 0.0;
        }
        return super.projectInverse(d3, d4, projCoordinate);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sinc0 = Math.sin(this.phic0);
        this.cosc0 = Math.cos(this.phic0);
        this.R2 = 2.0 * this.rc;
    }

    @Override
    public String toString() {
        return "Oblique Stereographic Alternative";
    }
}

