/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;

public class SwissObliqueMercatorProjection
extends Projection {
    private static final int NITER = 6;
    private double K;
    private double c;
    private double hlf_e;
    private double kR;
    private double cosp0;
    private double sinp0;
    private double phi0;

    @Override
    public void initialize() {
        super.initialize();
        this.phi0 = this.projectionLatitude;
        this.hlf_e = 0.5 * this.e;
        double d = Math.cos(this.phi0);
        d *= d;
        this.c = Math.sqrt(1.0 + this.es * d * d * this.rone_es);
        double d2 = Math.sin(this.phi0);
        this.sinp0 = d2 / this.c;
        double d3 = Math.asin(this.sinp0);
        this.cosp0 = Math.cos(d3);
        this.K = Math.log(Math.tan(0.7853981633974483 + 0.5 * d3)) - this.c * (Math.log(Math.tan(0.7853981633974483 + 0.5 * this.phi0)) - this.hlf_e * Math.log((1.0 + (d2 *= this.e)) / (1.0 - d2)));
        this.kR = this.scaleFactor * Math.sqrt(this.one_es) / (1.0 - d2 * d2);
    }

    @Override
    public ProjCoordinate project(double d, double d2, ProjCoordinate projCoordinate) {
        double d3 = this.e * Math.sin(d2);
        double d4 = 2.0 * Math.atan(Math.exp(this.c * (Math.log(Math.tan(0.7853981633974483 + 0.5 * d2)) - this.hlf_e * Math.log((1.0 + d3) / (1.0 - d3))) + this.K)) - 1.5707963267948966;
        double d5 = this.c * d;
        double d6 = Math.cos(d4);
        double d7 = Math.asin(this.cosp0 * Math.sin(d4) - this.sinp0 * d6 * Math.cos(d5));
        double d8 = Math.asin(d6 * Math.sin(d5) / Math.cos(d7));
        projCoordinate.x = this.kR * d8;
        projCoordinate.y = this.kR * Math.log(Math.tan(0.7853981633974483 + 0.5 * d7));
        return projCoordinate;
    }

    @Override
    public ProjCoordinate projectInverse(double d, double d2, ProjCoordinate projCoordinate) {
        int n;
        double d3 = 2.0 * (Math.atan(Math.exp(d2 / this.kR)) - 0.7853981633974483);
        double d4 = d / this.kR;
        double d5 = Math.cos(d3);
        double d6 = Math.asin(this.cosp0 * Math.sin(d3) + this.sinp0 * d5 * Math.cos(d4));
        double d7 = Math.asin(d5 * Math.sin(d4) / Math.cos(d6));
        double d8 = (this.K - Math.log(Math.tan(0.7853981633974483 + 0.5 * d6))) / this.c;
        for (n = 6; n != 0; --n) {
            double d9 = this.e * Math.sin(d6);
            double d10 = (d8 + Math.log(Math.tan(0.7853981633974483 + 0.5 * d6)) - this.hlf_e * Math.log((1.0 + d9) / (1.0 - d9))) * (1.0 - d9 * d9) * Math.cos(d6) * this.rone_es;
            d6 -= d10;
            if (Math.abs(d10) < 1.0E-10) break;
        }
        if (n == 0) {
            throw new ProjectionException("I_ERROR");
        }
        double d11 = d6;
        double d12 = d7 / this.c;
        projCoordinate.x = d12;
        projCoordinate.y = d11;
        return projCoordinate;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Swiss Oblique Mercator";
    }
}

