/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jms;

import ambience.etl.Builder;
import ambience.etl.jms.JMSCategory;
import ambience.etl.jms.JMSCategory$;
import ambience.etl.jms.JMSReaderObservable$Connection$;
import ambience.etl.jms.JMSTopicReader;
import ambience.etl.jms.JMSTopicReader$;
import com.elixirtech.arch.LogMessage;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public class JMSReaderObservable
extends Observable<Document> {
    private final Builder.Context cxt;
    private final JMSTopicReader.Info info;
    private final Document doc;
    private final JMSCategory.Logger logger;
    private Subscriber subscriber;

    public JMSReaderObservable(Builder.Context cxt, JMSTopicReader.Info info, Document doc) {
        this.cxt = cxt;
        this.info = info;
        this.doc = doc;
        this.logger = new JMSCategory.Logger(cxt);
    }

    public JMSCategory.Logger logger() {
        return this.logger;
    }

    public Subscriber<Document> subscriber() {
        return this.subscriber;
    }

    public void subscriber_$eq(Subscriber<Document> x$1) {
        this.subscriber = x$1;
    }

    public Cancelable unsafeSubscribeFn(Subscriber<Document> subscriber) {
        this.subscriber_$eq(subscriber);
        Option<TopicConnection> option = JMSCategory$.MODULE$.getTopicConnection(this.info.server());
        if (option instanceof Some) {
            TopicConnection connection = (TopicConnection)((Some)option).value();
            this.logger().log((LogMessage)LogMessage.Debug$.MODULE$.apply("Connection obtained"));
            TopicSession session = connection.createTopicSession(false, 2);
            this.logger().log((LogMessage)LogMessage.Debug$.MODULE$.apply("Session created"));
            Topic topic = session.createTopic(this.info.topic());
            this.logger().log((LogMessage)LogMessage.Debug$.MODULE$.apply("Topic created: " + this.info.topic()));
            MessageConsumer consumer = session.createConsumer((Destination)topic);
            Connection conn = JMSReaderObservable$Connection$.MODULE$.apply(connection, session, topic, consumer);
            this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Connected to JMS server " + this.info.server()));
            consumer.setMessageListener((MessageListener)new Callback(this.cxt, this.logger(), this.info, conn, this.doc, subscriber));
            connection.start();
        } else if (None$.MODULE$.equals(option)) {
            this.logger().log((LogMessage)LogMessage.Error$.MODULE$.apply("No JMS server " + this.info.server() + " defined"));
            subscriber.onComplete();
        } else {
            throw new MatchError(option);
        }
        return Cancelable$.MODULE$.empty();
    }

    public static class Callback
    implements MessageListener {
        private final JMSCategory.Logger logger;
        private final JMSTopicReader.Info info;
        private final Connection conn;
        private final Document doc;
        private final Subscriber<Document> subscriber;
        private final Scheduler scheduler;

        public Callback(Builder.Context cxt, JMSCategory.Logger logger, JMSTopicReader.Info info, Connection conn, Document doc, Subscriber<Document> subscriber) {
            this.logger = logger;
            this.info = info;
            this.conn = conn;
            this.doc = doc;
            this.subscriber = subscriber;
            this.scheduler = Scheduler$.MODULE$.global();
        }

        public Scheduler scheduler() {
            return this.scheduler;
        }

        public void onMessage(Message message) {
            Object object;
            Message message2 = message;
            if (message2 instanceof BytesMessage) {
                BytesMessage msg = (BytesMessage)message2;
                int len = (int)msg.getBodyLength();
                byte[] buffer = new byte[len];
                msg.readBytes(buffer);
                this.logger.log((LogMessage)LogMessage.Debug$.MODULE$.apply("Received " + len + " bytes"));
                String string = this.info.mode();
                String string2 = JMSTopicReader$.MODULE$.BytesMode();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonBinary$.MODULE$.apply(buffer)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    object = Some$.MODULE$.apply(this.doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                } else {
                    String string5 = JMSTopicReader$.MODULE$.StringMode();
                    String string6 = string;
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"string");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonString$.MODULE$.apply(new String(buffer, "UTF-8"))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        object = Some$.MODULE$.apply(this.doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    } else {
                        String string8 = JMSTopicReader$.MODULE$.JsonMode();
                        String string9 = string;
                        object = !(string8 != null ? !string8.equals(string9) : string9 != null) ? Some$.MODULE$.apply((Object)this.doc.$plus$plus((IterableOnce)Document$.MODULE$.apply(new String(buffer, "UTF-8")))) : None$.MODULE$;
                    }
                }
            } else if (message2 instanceof TextMessage) {
                TextMessage msg = (TextMessage)message2;
                String txt = msg.getText();
                this.logger.log((LogMessage)LogMessage.Debug$.MODULE$.apply("Received " + txt));
                String string = this.info.mode();
                String string10 = JMSTopicReader$.MODULE$.BytesMode();
                String string11 = string;
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string12 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string12, (Object)BsonBinary$.MODULE$.apply(txt.getBytes("UTF-8"))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    object = Some$.MODULE$.apply(this.doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                } else {
                    String string13 = JMSTopicReader$.MODULE$.StringMode();
                    String string14 = string;
                    if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string15 = (String)Predef$.MODULE$.ArrowAssoc((Object)"string");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string15, (Object)BsonString$.MODULE$.apply(txt)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        object = Some$.MODULE$.apply(this.doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    } else {
                        String string16 = JMSTopicReader$.MODULE$.JsonMode();
                        String string17 = string;
                        object = !(string16 != null ? !string16.equals(string17) : string17 != null) ? Some$.MODULE$.apply((Object)this.doc.$plus$plus((IterableOnce)Document$.MODULE$.apply(txt))) : None$.MODULE$;
                    }
                }
            } else {
                Message x = message2;
                this.logger.log((LogMessage)LogMessage.Warn$.MODULE$.apply("Unknown message type: " + x));
                message.acknowledge();
                object = None$.MODULE$;
            }
            None$ optDoc = object;
            optDoc.foreach((Function1 & Serializable)doc -> this.subscriber.onNext(doc).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Ack ack = x$1;
                if (Ack.Continue$.MODULE$.equals(ack)) {
                    this.logger.log((LogMessage)LogMessage.Debug$.MODULE$.apply("Ack.Continue received"));
                    message.acknowledge();
                    return;
                }
                if (Ack.Stop$.MODULE$.equals(ack)) {
                    this.logger.log((LogMessage)LogMessage.Debug$.MODULE$.apply("Ack.Stop received"));
                    message.acknowledge();
                    this.logger.log((LogMessage)LogMessage.Info$.MODULE$.apply("Closing connection to JMS server " + this.info.server()));
                    this.conn.close();
                    return;
                }
                throw new MatchError((Object)ack);
            }, (ExecutionContext)this.scheduler()));
        }
    }

    public static final class Connection
    implements Product,
    Serializable {
        private final TopicConnection connection;
        private final TopicSession session;
        private final Topic topic;
        private final MessageConsumer subscriber;

        public static Connection apply(TopicConnection topicConnection, TopicSession topicSession, Topic topic, MessageConsumer messageConsumer) {
            return JMSReaderObservable$Connection$.MODULE$.apply(topicConnection, topicSession, topic, messageConsumer);
        }

        public static Connection fromProduct(Product product) {
            return JMSReaderObservable$Connection$.MODULE$.fromProduct(product);
        }

        public static Connection unapply(Connection connection) {
            return JMSReaderObservable$Connection$.MODULE$.unapply(connection);
        }

        public Connection(TopicConnection connection, TopicSession session, Topic topic, MessageConsumer subscriber) {
            this.connection = connection;
            this.session = session;
            this.topic = topic;
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Connection)) return false;
            Connection connection = (Connection)object;
            TopicConnection topicConnection = this.connection();
            TopicConnection topicConnection2 = connection.connection();
            if (topicConnection == null) {
                if (topicConnection2 != null) {
                    return false;
                }
            } else if (!topicConnection.equals(topicConnection2)) return false;
            TopicSession topicSession = this.session();
            TopicSession topicSession2 = connection.session();
            if (topicSession == null) {
                if (topicSession2 != null) {
                    return false;
                }
            } else if (!topicSession.equals(topicSession2)) return false;
            Topic topic = this.topic();
            Topic topic2 = connection.topic();
            if (topic == null) {
                if (topic2 != null) {
                    return false;
                }
            } else if (!topic.equals(topic2)) return false;
            MessageConsumer messageConsumer = this.subscriber();
            MessageConsumer messageConsumer2 = connection.subscriber();
            if (messageConsumer == null) {
                if (messageConsumer2 == null) return true;
                return false;
            } else {
                if (!messageConsumer.equals(messageConsumer2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Connection;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Connection";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "connection";
                }
                case 1: {
                    return "session";
                }
                case 2: {
                    return "topic";
                }
                case 3: {
                    return "subscriber";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TopicConnection connection() {
            return this.connection;
        }

        public TopicSession session() {
            return this.session;
        }

        public Topic topic() {
            return this.topic;
        }

        public MessageConsumer subscriber() {
            return this.subscriber;
        }

        public void close() {
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.close$$anonfun$1();
                return BoxedUnit.UNIT;
            });
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.close$$anonfun$2();
                return BoxedUnit.UNIT;
            });
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.close$$anonfun$3();
                return BoxedUnit.UNIT;
            });
        }

        public Connection copy(TopicConnection connection, TopicSession session, Topic topic, MessageConsumer subscriber) {
            return new Connection(connection, session, topic, subscriber);
        }

        public TopicConnection copy$default$1() {
            return this.connection();
        }

        public TopicSession copy$default$2() {
            return this.session();
        }

        public Topic copy$default$3() {
            return this.topic();
        }

        public MessageConsumer copy$default$4() {
            return this.subscriber();
        }

        public TopicConnection _1() {
            return this.connection();
        }

        public TopicSession _2() {
            return this.session();
        }

        public Topic _3() {
            return this.topic();
        }

        public MessageConsumer _4() {
            return this.subscriber();
        }

        private final void close$$anonfun$1() {
            this.subscriber().close();
        }

        private final void close$$anonfun$2() {
            this.session().close();
        }

        private final void close$$anonfun$3() {
            this.connection().close();
        }
    }
}

