/*
 * Decompiled with CFR 0.152.
 */
package ambience.redirect.etl;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.redirect.Shared$;
import ambience.redirect.etl.AddRedirect;
import ambience.redirect.etl.AddRedirect$DMY$;
import ambience.redirect.etl.AddRedirect$Info$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonDateTime;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple6$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class AddRedirect$
implements Builder,
PanelBuilder,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AddRedirect$.class.getDeclaredField("cltnT$lzy1"));
    private static final int hourMillis;
    private static final int dayMillis;
    private static final String stepType;
    private volatile Object cltnT$lzy1;
    private static final Regex OffsetRegEx;
    public static final AddRedirect$Info$ Info;
    public static final AddRedirect$DMY$ DMY;
    public static final AddRedirect$ MODULE$;

    private AddRedirect$() {
    }

    static {
        MODULE$ = new AddRedirect$();
        hourMillis = 3600000;
        dayMillis = 24 * MODULE$.hourMillis();
        stepType = ETLStepType$.MODULE$.apply("redirect.AddRedirect");
        OffsetRegEx = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[+]([0-9]+)([dh])"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AddRedirect$.class);
    }

    public int hourMillis() {
        return hourMillis;
    }

    public int dayMillis() {
        return dayMillis;
    }

    public String stepType() {
        return stepType;
    }

    public Task<CodexCollection> cltnT() {
        Object object = this.cltnT$lzy1;
        if (object instanceof Task) {
            return (Task)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Task)this.cltnT$lzyINIT1();
    }

    private Object cltnT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.cltnT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Task task = null;
                    try {
                        task = ((CodexDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(CodexDB.class))).getCodexCollection("Redirects");
                        object2 = task == null ? LazyVals.NullValue$.MODULE$ : task;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.cltnT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return task;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Regex OffsetRegEx() {
        return OffsetRegEx;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "urlField";
        String string2 = "defaultField";
        String string3 = "chainsetField";
        String string4 = "chainField";
        String string5 = "codeField";
        String string6 = "expiryField";
        int size = 6;
        AddRedirect.Info info = (AddRedirect.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", AddRedirect$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), AddRedirect$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(AddRedirect$::$anonfun$3))))).toOption().getOrElse(AddRedirect$::$anonfun$4);
        Panel.Item url = PanelItem$.MODULE$.text("urlField", "URL Field", info.urlField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item item = PanelItem$.MODULE$.text("defaultField", "Default Location Field", info.defaultField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item chainset = PanelItem$.MODULE$.text("chainsetField", "Chainset Field", info.chainsetField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item chain = PanelItem$.MODULE$.text("chainField", "Chain Field", info.chainField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item code = PanelItem$.MODULE$.text("codeField", "HTTP Code Field", info.codeField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item expiry = PanelItem$.MODULE$.text("expiryField", "Expiry Field", info.expiryField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> AddRedirect$.buildPanel$$anonfun$1(url, item, chainset, chain, code, expiry));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> AddRedirect$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "urlField";
        String string2 = "defaultField";
        String string3 = "chainsetField";
        String string4 = "chainField";
        String string5 = "codeField";
        String string6 = "expiryField";
        int size = 6;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", AddRedirect$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), AddRedirect$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(AddRedirect$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (AddRedirect.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, AddRedirect.Info info, Observable<Document> from) {
        if (cxt.user().privileges().contains((Object)"mod-redirect-edit")) {
            return from.mapEval((Function1 & Serializable)doc -> MODULE$.doAdd(cxt, info, (Document)doc).map((Function1 & Serializable)_$1 -> doc));
        }
        return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("User does not have mod-redirect-edit privileges"));
    }

    public String codeMatch(int code) {
        int n = code;
        switch (n) {
            case 303: {
                return Shared$.MODULE$.Http303();
            }
            case 307: {
                return Shared$.MODULE$.Http307();
            }
            case 308: {
                return Shared$.MODULE$.Http308();
            }
        }
        return Shared$.MODULE$.Http307();
    }

    public Either<String, Document> buildETLRecord(Builder.Context cxt, AddRedirect.Info info, Document doc) {
        Option optAdd = doc.get(info.urlField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).flatMap((Function1 & Serializable)url -> Some$.MODULE$.apply(doc.get(info.defaultField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(AddRedirect$::$anonfun$7$$anonfun$2)).flatMap((Function1 & Serializable)string -> Some$.MODULE$.apply(doc.get(info.chainsetField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).getOrElse(AddRedirect$::$anonfun$7$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)chainset -> Some$.MODULE$.apply(doc.get(info.chainField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).getOrElse(AddRedirect$::$anonfun$7$$anonfun$3$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)chain -> Some$.MODULE$.apply(doc.get(info.codeField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()).getOrElse(AddRedirect$::$anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2)).flatMap((Function1 & Serializable)code -> AddRedirect$.$anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3(doc, info, url, string, chainset, chain, cxt, BoxesRunTime.unboxToInt((Object)code)))))));
        return optAdd.toRight(() -> AddRedirect$.buildETLRecord$$anonfun$1(info));
    }

    public String addSlash(String url) {
        if (url.startsWith("/")) {
            return url;
        }
        return "/" + url;
    }

    public Either<String, Document> fixExpireFormat(Document doc) {
        Option option = doc.get("expireAt", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonInt64) {
                BsonInt64 bsonInt64 = (BsonInt64)bsonValue;
                return this.handleExpireAtLong(doc, bsonInt64.getValue());
            }
            if (bsonValue instanceof BsonString) {
                BsonString string = (BsonString)bsonValue;
                return this.handleExpireAtString(doc, string.getValue());
            }
            if (bsonValue instanceof BsonDateTime) {
                BsonDateTime date = (BsonDateTime)bsonValue;
                return this.handleExpireAtDate(doc, date.getValue());
            }
        }
        Option x = option;
        return scala.package$.MODULE$.Left().apply((Object)("Unable to read expireAt: " + x));
    }

    public Either<String, Document> handleExpireAtLong(Document doc, long expireTime) {
        if (expireTime == 0L) {
            return scala.package$.MODULE$.Right().apply((Object)doc);
        }
        if (expireTime < System.currentTimeMillis()) {
            return scala.package$.MODULE$.Left().apply((Object)"Expiry is in the past");
        }
        return scala.package$.MODULE$.Right().apply((Object)this.updated(doc, expireTime));
    }

    public Either<String, Document> handleExpireAtString(Document doc, String expireAt) {
        if (expireAt.startsWith("+")) {
            return this.handleExpireAtRelative(doc, expireAt);
        }
        return this.handleExpireAtDMY(doc, expireAt);
    }

    public Either<String, Document> handleExpireAtDMY(Document doc, String expireAt) {
        return Try$.MODULE$.apply(() -> AddRedirect$.handleExpireAtDMY$$anonfun$1(expireAt)).map((Function1 & Serializable)_$7 -> _$7.atStartOfDay(ZoneId.systemDefault())).toEither().map((Function1 & Serializable)ts -> MODULE$.updated(doc, ts.toEpochSecond() * 1000L)).left().map((Function1 & Serializable)_$8 -> _$8.toString());
    }

    public Either<String, Document> handleExpireAtRelative(Document doc, String expireAt) {
        List list;
        Option option;
        long now = System.currentTimeMillis();
        String string = expireAt;
        if (string != null && !(option = this.OffsetRegEx().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String value = string2;
            String units = string3;
            return scala.package$.MODULE$.Right().apply((Object)this.updated(doc, now + (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value)) * this.multiplier(units)));
        }
        return scala.package$.MODULE$.Left().apply((Object)("Invalid offset: " + expireAt));
    }

    public Document updated(Document doc, long expireAt) {
        return (Document)doc.updated("expireAt", (Object)BsonDateTime$.MODULE$.apply(expireAt), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
    }

    public long multiplier(String units) {
        String string = units;
        if ("d".equals(string)) {
            return Int$.MODULE$.int2long(this.dayMillis());
        }
        if ("h".equals(string)) {
            return Int$.MODULE$.int2long(this.hourMillis());
        }
        return 0L;
    }

    public Either<String, Document> handleExpireAtDate(Document doc, long expireAt) {
        if (expireAt < System.currentTimeMillis()) {
            return scala.package$.MODULE$.Left().apply((Object)"Expiry is in the past");
        }
        return scala.package$.MODULE$.Right().apply((Object)doc);
    }

    public Either<String, Document> validateURL(Document doc) {
        Option option = doc.get("url", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
        if (option instanceof Some) {
            BsonString url = (BsonString)((Some)option).value();
            String str = url.getValue();
            if (str.endsWith("/")) {
                return scala.package$.MODULE$.Left().apply((Object)"Disallowed URL");
            }
            if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(url.getValue()), (Function1 & Serializable)_$9 -> StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(Shared$.MODULE$.Disallowed()), BoxesRunTime.unboxToChar((Object)_$9)))) {
                return scala.package$.MODULE$.Left().apply((Object)"URL contains disallowed character");
            }
            return scala.package$.MODULE$.Right().apply((Object)doc);
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)"Unable to read URL");
        }
        throw new MatchError((Object)option);
    }

    public Task<BoxedUnit> doAdd(Builder.Context cxt, AddRedirect.Info info, Document doc) {
        Either finalRec = this.buildETLRecord(cxt, info, doc).flatMap((Function1 & Serializable)doc2 -> MODULE$.validateURL((Document)doc2).flatMap((Function1 & Serializable)doc3 -> MODULE$.fixExpireFormat((Document)doc3).map((Function1 & Serializable)doc4 -> doc4)));
        Either either = finalRec;
        if (either instanceof Right) {
            Document rec = (Document)((Right)either).value();
            return this.upsert(cxt, rec);
        }
        if (either instanceof Left) {
            String err = (String)((Left)either).value();
            return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply(err));
        }
        throw new MatchError((Object)either);
    }

    public Task<BoxedUnit> upsert(Builder.Context cxt, Document rec) {
        Task toptdoc = this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("url", rec.apply("url", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)))).firstOptionL().map((Function1 & Serializable)optdoc -> optdoc));
        return toptdoc.flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                BsonValue id = doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
                return cxt.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Replacing redirect " + id)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.replaceOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", id), rec).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        CodexDB.UpdateResult updateResult = x$1;
                    }));
                });
            }
            if (None$.MODULE$.equals(option)) {
                String uuid = UUID.randomUUID().toString();
                return cxt.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Inserting new redirect")).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.cltnT().flatMap((Function1 & Serializable)cltn -> {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)uuid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                        return cltn.insertOneT((Document)rec.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            CodexDB.InsertOneResult insertOneResult = x$1;
                        });
                    });
                });
            }
            throw new MatchError((Object)option);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        AddRedirect$Info$ addRedirect$Info$ = AddRedirect$Info$.MODULE$;
        return (Function1 & Serializable)p -> (AddRedirect.Info)addRedirect$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    private static final AddRedirect.Info $anonfun$4() {
        return AddRedirect$Info$.MODULE$.apply(AddRedirect$Info$.MODULE$.$lessinit$greater$default$1(), AddRedirect$Info$.MODULE$.$lessinit$greater$default$2(), AddRedirect$Info$.MODULE$.$lessinit$greater$default$3(), AddRedirect$Info$.MODULE$.$lessinit$greater$default$4(), AddRedirect$Info$.MODULE$.$lessinit$greater$default$5(), AddRedirect$Info$.MODULE$.$lessinit$greater$default$6());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item url$1, Panel.Item default$1, Panel.Item chainset$1, Panel.Item chain$1, Panel.Item code$1, Panel.Item expiry$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)url$1, (List)new .colon.colon((Object)default$1, (List)new .colon.colon((Object)chainset$1, (List)new .colon.colon((Object)chain$1, (List)new .colon.colon((Object)code$1, (List)new .colon.colon((Object)expiry$1, (List)Nil$.MODULE$)))))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        AddRedirect$Info$ addRedirect$Info$ = AddRedirect$Info$.MODULE$;
        return (Function1 & Serializable)p -> (AddRedirect.Info)addRedirect$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "urlField";
        String string2 = "defaultField";
        String string3 = "chainsetField";
        String string4 = "chainField";
        String string5 = "codeField";
        String string6 = "expiryField";
        int size = 6;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", AddRedirect$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), AddRedirect$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(AddRedirect$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            AddRedirect.Info info2 = (AddRedirect.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "urlField";
            String string2 = "defaultField";
            String string3 = "chainsetField";
            String string4 = "chainField";
            String string5 = "codeField";
            String string6 = "expiryField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(AddRedirect$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string7 = step$1.copy$default$1();
            String string8 = step$1.copy$default$2();
            String string9 = step$1.copy$default$3();
            String string10 = step$1.copy$default$4();
            String string11 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string7, string8, string9, string10, string11, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        AddRedirect$Info$ addRedirect$Info$ = AddRedirect$Info$.MODULE$;
        return (Function1 & Serializable)p -> (AddRedirect.Info)addRedirect$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)AddRedirect$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    private static final String $anonfun$7$$anonfun$2() {
        return "";
    }

    private static final String $anonfun$7$$anonfun$3$$anonfun$2() {
        return "";
    }

    private static final String $anonfun$7$$anonfun$3$$anonfun$3$$anonfun$2() {
        return "";
    }

    private static final int $anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2() {
        return 307;
    }

    private static final BsonValue $anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1() {
        return BsonInt64$.MODULE$.apply(0L);
    }

    private static final /* synthetic */ Option $anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3(Document doc$6, AddRedirect.Info info$7, String url$5, String default$4, String chainset$3, String chain$2, Builder.Context cxt$8, int code) {
        return Some$.MODULE$.apply(doc$6.get(info$7.expiryField(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).getOrElse(AddRedirect$::$anonfun$7$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$1)).flatMap((Function1 & Serializable)expiry -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[9];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"url");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MODULE$.addSlash(url$5)), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"location");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)default$4), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"chainset");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)chainset$3), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"chain");
            objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)chain$2), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"statusCode");
            objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BoxesRunTime.boxToInteger((int)code)), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt());
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"enabled");
            objectArray[5] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BoxesRunTime.boxToBoolean((boolean)true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expireAt");
            objectArray[6] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, expiry), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
            objectArray[7] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
            objectArray[8] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)cxt$8.user().id()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            return Some$.MODULE$.apply((Object)package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).map((Function1 & Serializable)add -> add);
        });
    }

    private static final String buildETLRecord$$anonfun$1(AddRedirect.Info info$8) {
        return "No URL available in " + info$8.urlField();
    }

    private static final LocalDate handleExpireAtDMY$$anonfun$1(String expireAt$1) {
        return LocalDate.parse(expireAt$1);
    }
}

