/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export;

import ambience.adhocreport.Model;
import ambience.adhocreport.export.ExportRoute$;
import ambience.adhocreport.export.ExportXlsx;
import ambience.adhocreport.export.ExportXlsx$Context$;
import ambience.adhocreport.export.Util$;
import ambience.adhocreport.export.xlsx.XlsxBuilder;
import ambience.adhocreport.export.xlsx.XlsxBuilder$XlsxContext$;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder;
import ambience.adhocreport.export.xlsx.builder.alignleft.AlignLeftBuilder;
import ambience.adhocreport.export.xlsx.builder.block.BlockBuilder;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownBuilder$;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownLink;
import ambience.adhocreport.export.xlsx.builder.summary.SummaryBuilder;
import ambience.adhocreport.report.db.AdhocReportDB$;
import ambience.adhocreport.report.render.ReportRenderer$;
import ambience.adhocreport.report.render.html.ReportBuilder;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.coredata.Data;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.vdom.VNode;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ExportXlsx$
implements Serializable {
    public static final ExportXlsx$Context$ Context;
    public static final ExportXlsx$ MODULE$;

    private ExportXlsx$() {
    }

    static {
        MODULE$ = new ExportXlsx$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExportXlsx$.class);
    }

    public Task<GravityResponse> apply(UserDB.User user, Model.ExportRequest expRequest) {
        Model.LayoutType layoutType = expRequest.reportRequest().layoutType();
        if (Model.DrillDown$.MODULE$.equals(layoutType)) {
            return this.buildDrillDownXlsxReport(user, expRequest);
        }
        return this.buildSingleSheetXlsxReport(user, expRequest);
    }

    public Task<GravityResponse> buildDrillDownXlsxReport(UserDB.User user, Model.ExportRequest expRequest) {
        boolean isNoGroup = expRequest.reportRequest().groups().isEmpty();
        DrillDownLink dLink = new DrillDownLink();
        Task<Either<LogMessage, byte[]>> buildResultT = isNoGroup ? DrillDownBuilder$.MODULE$.renderNoGroupReport(user, expRequest) : DrillDownBuilder$.MODULE$.renderMultipleReports(user, expRequest, dLink);
        return buildResultT.map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage err = (LogMessage)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(err.msg());
            }
            if (either instanceof Right) {
                byte[] dataBytes = (byte[])((Right)either).value();
                Gravity.Headers headers = Util$.MODULE$.headers(Util$.MODULE$.getFileName(expRequest) + ".xlsx", MimeTypes$.MODULE$.XLSX());
                DataBytes dataBytes2 = DataBytes$.MODULE$.apply(dataBytes);
                int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                return GravityResponse$.MODULE$.apply(n, headers, dataBytes2);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<GravityResponse> buildSingleSheetXlsxReport(UserDB.User user, Model.ExportRequest expRequest) {
        EitherT result = EitherT$.MODULE$.apply(Util$.MODULE$.getSchema(user, expRequest)).flatMap((Function1 & Serializable)schema -> EitherT$.MODULE$.apply(MODULE$.renderSingleSheetReport(user, (Data.Schema)schema, expRequest)).flatMap((Function1 & Serializable)reportVNode -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> ExportXlsx$.$anonfun$1$$anonfun$1$$anonfun$1(reportVNode, expRequest, schema))).map((Function1 & Serializable)xlsx -> xlsx, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)result.value()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage err = (LogMessage)((Left)either).value();
                return Gravity$.MODULE$.BadRequestResponse(err.msg());
            }
            if (either instanceof Right) {
                DataBytes dataBytes = (DataBytes)((Right)either).value();
                Gravity.Headers headers = Util$.MODULE$.headers(Util$.MODULE$.getFileName(expRequest) + ".xlsx", MimeTypes$.MODULE$.XLSX());
                return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), headers, dataBytes);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, VNode>> renderSingleSheetReport(UserDB.User user, Data.Schema schema, Model.ExportRequest request) {
        Option<ReportBuilder> option = ReportRenderer$.MODULE$.getReportBuilder(request.reportRequest().layoutType());
        if (None$.MODULE$.equals(option)) {
            return ExportRoute$.MODULE$.LeftErrT("Unable to get report builder");
        }
        if (option instanceof Some) {
            ReportBuilder builder = (ReportBuilder)((Some)option).value();
            List<Bson> agg = builder.buildAggExport(request.reportRequest(), request.reportRequest().exportType());
            Task docsT = AdhocReportDB$.MODULE$.fetchReportData(request.cltnName(), agg, user).toListL();
            return docsT.map((Function1 & Serializable)docs -> package$.MODULE$.Right().apply((Object)builder.buildReport((List<Document>)docs, Util$.MODULE$.buildRenderContext(schema, request))));
        }
        throw new MatchError(option);
    }

    public DataBytes buildXlsxBytes(VNode reportVNode, Model.ExportRequest expRequest, Data.Schema schema) {
        XlsxBuilder.XlsxContext xlsxCxt = this.buildXlsxContext(expRequest, schema, reportVNode, (Option<DrillDownLink>)None$.MODULE$);
        Model.LayoutType layoutType = expRequest.reportRequest().layoutType();
        Object result = Model.AlignLeft$.MODULE$.equals(layoutType) ? Some$.MODULE$.apply((Object)new AlignLeftBuilder(xlsxCxt)) : (Model.Block$.MODULE$.equals(layoutType) ? Some$.MODULE$.apply((Object)new BlockBuilder(xlsxCxt)) : (Model.Summary$.MODULE$.equals(layoutType) ? Some$.MODULE$.apply((Object)new SummaryBuilder(xlsxCxt)) : None$.MODULE$));
        Some some = result;
        if (some instanceof Some) {
            BaseBuilder reportBuilder = (BaseBuilder)some.value();
            return DataBytes$.MODULE$.apply(reportBuilder.getReportBytes());
        }
        if (None$.MODULE$.equals(some)) {
            return DataBytes$.MODULE$.apply(new byte[0]);
        }
        throw new MatchError((Object)some);
    }

    public XlsxBuilder.XlsxContext buildXlsxContext(Model.ExportRequest expRequest, Data.Schema schema, VNode reportVNode, Option<DrillDownLink> dLinkOpt) {
        Model.LayoutType layoutType = expRequest.reportRequest().layoutType();
        List groups = expRequest.reportRequest().groups();
        List fields = expRequest.reportRequest().fields();
        List adhocFields = expRequest.reportRequest().adhocFields();
        Model.TableProperties tableProperties = expRequest.reportRequest().tableProperties();
        ExportXlsx.Context context = ExportXlsx$Context$.MODULE$.apply(layoutType, expRequest.styleInfo(), expRequest.zoneId(), (List<Model.DimGroup>)groups, (List<Model.DimField>)fields, (List<Model.AdhocField>)adhocFields, tableProperties, schema);
        return XlsxBuilder$XlsxContext$.MODULE$.apply(reportVNode, context, dLinkOpt);
    }

    private static final Right $anonfun$1$$anonfun$1$$anonfun$1(VNode reportVNode$1, Model.ExportRequest expRequest$3, Data.Schema schema$1) {
        return package$.MODULE$.Right().apply((Object)MODULE$.buildXlsxBytes(reportVNode$1, expRequest$3, schema$1));
    }
}

