/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.pdf;

import ambience.adhocreport.Model;
import ambience.adhocreport.export.PDFPageFormat$;
import ambience.adhocreport.export.UnitDim;
import ambience.adhocreport.export.pdf.Pdf;
import ambience.adhocreport.export.pdf.Pdf$;
import ambience.adhocreport.export.pdf.Pdf$Center$;
import ambience.adhocreport.export.pdf.Pdf$Left$;
import ambience.adhocreport.export.pdf.Pdf$Right$;
import ambience.adhocreport.export.pdf.PdfBuilder$;
import ambience.adhocreport.export.pdf.PdfBuilder$BorderStyle$;
import ambience.adhocreport.export.pdf.PdfBuilder$RectData$;
import ambience.adhocreport.export.pdf.PdfBuilder$RelativePosition$;
import ambience.adhocreport.export.pdf.PdfBuilder$TextProperty$;
import ambience.adhocreport.export.pdf.TableStructure;
import ambience.adhocreport.export.pdf.TableStructure$;
import ambience.adhocreport.export.pdf.table.HFTextBuilder;
import ambience.adhocreport.export.pdf.table.HFTextBuilder$;
import ambience.adhocreport.export.pdf.table.TableBuilder$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.vdom.VElement;
import com.elixirtech.vdom.VNode;
import com.elixirtech.vdom.VText;
import io.circe.Json;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class PdfBuilder
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PdfBuilder.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Model.ExportRequest expRequest;
    private final Model.PageFormat pageFormat;
    private final UnitDim.Dim bodyHeight;
    private final UnitDim.Dim bodyWidth;
    private final PDDocument doc;
    private PDPageContentStream contents;
    private final UnitDim.Dim MarginLeft;
    private final UnitDim.Dim MarginRight;
    private final UnitDim.Dim MarginTop;
    private final UnitDim.Dim MarginBottom;
    private final HFTextBuilder.PageHFRow HeaderRow;
    private final HFTextBuilder.PageHFRow FooterRow;
    private final PDType0Font font;
    private final UnitDim.Dim fontSize;
    private final UnitDim.Dim BottomLimit;
    private final UnitDim.Dim yStartDim;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PdfBuilder$.class.getDeclaredField("TextWidthLimit$lzy1"));

    public static UnitDim.Dim TextWidthLimit() {
        return PdfBuilder$.MODULE$.TextWidthLimit();
    }

    public static byte[] apply(VNode vNode, Model.ExportRequest exportRequest) {
        return PdfBuilder$.MODULE$.apply(vNode, exportRequest);
    }

    public static boolean containsUnicode(String string) {
        return PdfBuilder$.MODULE$.containsUnicode(string);
    }

    public static PDType0Font getFont(PDDocument pDDocument) {
        return PdfBuilder$.MODULE$.getFont(pDDocument);
    }

    public static UnitDim.Dim getLineHeight(TextProperty textProperty) {
        return PdfBuilder$.MODULE$.getLineHeight(textProperty);
    }

    public static UnitDim.Dim getTextWidth(String string, TextProperty textProperty) {
        return PdfBuilder$.MODULE$.getTextWidth(string, textProperty);
    }

    public PdfBuilder(Model.ExportRequest expRequest) {
        this.expRequest = expRequest;
        this.pageFormat = (Model.PageFormat)expRequest.reportRequest().pageFormat().getOrElse(PdfBuilder::$init$$$anonfun$1);
        this.bodyHeight = UnitDim.Dim$.MODULE$.apply(this.pageFormat().height());
        this.bodyWidth = UnitDim.Dim$.MODULE$.apply(this.pageFormat().width());
        this.doc = new PDDocument();
        this.contents = this.newPage();
        this.MarginLeft = UnitDim.Dim$.MODULE$.apply(this.pageFormat().marginLeft());
        this.MarginRight = UnitDim.Dim$.MODULE$.apply(this.pageFormat().marginRight());
        this.MarginTop = UnitDim.Dim$.MODULE$.apply(this.pageFormat().marginTop());
        this.MarginBottom = UnitDim.Dim$.MODULE$.apply(this.pageFormat().marginBottom());
        this.HeaderRow = this.getHFRow((Function1<Model.PageFormat, Json>)(Function1 & Serializable)_$1 -> _$1.headerOption());
        this.FooterRow = this.getHFRow((Function1<Model.PageFormat, Json>)(Function1 & Serializable)_$2 -> _$2.footerOption());
        this.font = PdfBuilder$.MODULE$.getFont(this.doc());
        this.fontSize = UnitDim.Dim$.MODULE$.pts(12.0f);
        this.BottomLimit = this.MarginBottom().$plus(HFTextBuilder$.MODULE$.TopOrBottomMargin()).$plus(this.fontSize());
        HFTextBuilder.PageHFRow pageHFRow = this.HeaderRow();
        HFTextBuilder.PageHFRow pageHFRow2 = HFTextBuilder$.MODULE$.EmptyPageHFRow();
        this.yStartDim = !(pageHFRow != null ? !((Object)pageHFRow).equals(pageHFRow2) : pageHFRow2 != null) ? this.bodyHeight().$minus(this.MarginTop()) : this.bodyHeight().$minus(this.MarginTop()).$minus(this.fontSize());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Model.ExportRequest expRequest() {
        return this.expRequest;
    }

    public Model.PageFormat pageFormat() {
        return this.pageFormat;
    }

    public UnitDim.Dim bodyHeight() {
        return this.bodyHeight;
    }

    public UnitDim.Dim bodyWidth() {
        return this.bodyWidth;
    }

    public PDDocument doc() {
        return this.doc;
    }

    public UnitDim.Dim MarginLeft() {
        return this.MarginLeft;
    }

    public UnitDim.Dim MarginRight() {
        return this.MarginRight;
    }

    public UnitDim.Dim MarginTop() {
        return this.MarginTop;
    }

    public UnitDim.Dim MarginBottom() {
        return this.MarginBottom;
    }

    public HFTextBuilder.PageHFRow HeaderRow() {
        return this.HeaderRow;
    }

    public HFTextBuilder.PageHFRow FooterRow() {
        return this.FooterRow;
    }

    public PDType0Font font() {
        return this.font;
    }

    public UnitDim.Dim fontSize() {
        return this.fontSize;
    }

    public UnitDim.Dim BottomLimit() {
        return this.BottomLimit;
    }

    public UnitDim.Dim yStartDim() {
        return this.yStartDim;
    }

    public byte[] run(VNode v) {
        VNode vNode = v;
        if (vNode instanceof VElement) {
            VElement table = (VElement)vNode;
            TableStructure.Table tStructure = TableStructure$.MODULE$.build(table);
            TableBuilder$.MODULE$.apply(tStructure, this);
        } else if (vNode instanceof VText) {
            VText text = (VText)vNode;
            Predef$.MODULE$.println((Object)("VTEXT " + text));
        } else {
            VNode other = vNode;
            Predef$.MODULE$.println((Object)("OTHER " + other));
        }
        return this.getBytes();
    }

    public void set(UnitDim.Dim x, UnitDim.Dim y, String text, TextProperty textProperty) {
        UnitDim.Dim textHeight = PdfBuilder$.MODULE$.getLineHeight(textProperty);
        this.setTransparent(textProperty.color());
        this.contents.beginText();
        this.handleFont(text, textProperty);
        this.setLineOffset(x, y);
        this.contents.setNonStrokingColor(textProperty.color());
        this.contents.showText(text);
        this.contents.endText();
    }

    public void startClip() {
        float x = this.MarginLeft().pts();
        float y = this.MarginBottom().pts();
        UnitDim.Dim width = this.bodyWidth().$minus(this.MarginLeft().$plus(this.MarginRight()));
        float height = UnitDim.Dim$.MODULE$.apply(this.pageFormat().height()).pts();
        this.contents.addRect(x, y, width.pts(), height);
        this.contents.clip();
    }

    public void startClip(PDPageContentStream contents) {
        float x = this.MarginLeft().pts();
        float y = this.MarginBottom().pts();
        UnitDim.Dim width = this.bodyWidth().$minus(this.MarginLeft().$plus(this.MarginRight()));
        float height = UnitDim.Dim$.MODULE$.apply(this.pageFormat().height()).pts();
        contents.addRect(x, y, width.pts(), height);
        contents.clip();
    }

    public void fillBox(RectData rowRec, Color color) {
        this.fillBox(rowRec.x(), rowRec.y(), rowRec.width(), rowRec.height(), color);
    }

    public void fillBox(UnitDim.Dim x, UnitDim.Dim y, UnitDim.Dim width, UnitDim.Dim height, Color color) {
        this.setTransparent(color);
        this.contents.setNonStrokingColor(color);
        this.contents.addRect(this.MarginLeft().$plus(x).pts(), this.yStartDim().$minus(y).pts(), width.pts(), height.pts());
        this.contents.fill();
    }

    public void setTransparent(Color color) {
        PDExtendedGraphicsState gs = new PDExtendedGraphicsState();
        gs.setNonStrokingAlphaConstant(Predef$.MODULE$.float2Float((float)color.getAlpha() / 255.0f));
        gs.setAlphaSourceFlag(true);
        this.contents.setGraphicsStateParameters(gs);
    }

    public void setStroke(RectData rowRec, BorderStyle borderStyle) {
        this.setStroke(rowRec.x(), rowRec.y(), rowRec.width(), rowRec.height(), borderStyle);
    }

    public void setStroke(UnitDim.Dim x, UnitDim.Dim y, UnitDim.Dim width, UnitDim.Dim height, BorderStyle borderStyle) {
        this.contents.setStrokingColor(borderStyle.color());
        this.contents.setLineWidth(borderStyle.lineWidth().pts());
        float yPos = this.yStartDim().$minus(y).pts() + height.pts();
        this.contents.moveTo(this.MarginLeft().$plus(x).pts(), yPos);
        this.contents.lineTo(this.MarginLeft().$plus(x).pts() + width.pts(), yPos);
        this.contents.stroke();
    }

    public void setHeader(String footerInfo, Pdf.Alignment align) {
        UnitDim.Dim yPos = Pdf$.MODULE$.ZeroDim();
        this.setInfoOption(footerInfo, align, yPos);
    }

    public void setFooter(String headerInfo, Pdf.Alignment align) {
        UnitDim.Dim yPos = this.bodyHeight().$minus(this.MarginTop().$plus(this.BottomLimit()));
        this.setInfoOption(headerInfo, align, yPos);
    }

    public boolean isNewPage(UnitDim.Dim y) {
        UnitDim.Dim yPos = this.yStartDim().$minus(y);
        return yPos.$less(this.BottomLimit());
    }

    public void buildNewPage() {
        this.contents.close();
        this.contents = this.newPage();
    }

    private void setInfoOption(String text, Pdf.Alignment align, UnitDim.Dim yPos) {
        UnitDim.Dim dim;
        RelativePosition padding = PdfBuilder$RelativePosition$.MODULE$.apply(Pdf$.MODULE$.ZeroDim(), Pdf$.MODULE$.ZeroDim(), Pdf$.MODULE$.ZeroDim(), Pdf$.MODULE$.ZeroDim());
        TextProperty textProperty = PdfBuilder$TextProperty$.MODULE$.apply(Standard14Fonts.FontName.HELVETICA_OBLIQUE, this.fontSize(), 0, align.id(), Color.BLACK, padding);
        Pdf.Alignment alignment = align;
        if (Pdf$Left$.MODULE$.equals(alignment)) {
            dim = Pdf$.MODULE$.ZeroDim();
        } else if (Pdf$Right$.MODULE$.equals(alignment)) {
            dim = this.bodyWidth().$minus(this.MarginLeft()).$minus(this.MarginRight()).$minus(PdfBuilder.textWidth$1(textProperty, text));
        } else if (Pdf$Center$.MODULE$.equals(alignment)) {
            dim = UnitDim.Dim$.MODULE$.apply(this.bodyWidth().$minus(PdfBuilder.textWidth$1(textProperty, text)).twips() / (float)2).$minus(this.MarginLeft());
        } else {
            throw new MatchError((Object)alignment);
        }
        UnitDim.Dim xPos = dim;
        this.set(xPos, yPos, text, textProperty);
    }

    private PDPageContentStream newPage() {
        PDPage page = new PDPage(new PDRectangle(this.bodyWidth().pts(), this.bodyHeight().pts()));
        this.doc().addPage(page);
        return new PDPageContentStream(this.doc(), page);
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.contents.close();
        this.doc().save((OutputStream)baos);
        return baos.toByteArray();
    }

    public HFTextBuilder.PageHFRow getHFRow(Function1<Model.PageFormat, Json> fn) {
        return (HFTextBuilder.PageHFRow)this.expRequest().reportRequest().pageFormat().flatMap((Function1 & Serializable)format -> HFTextBuilder$.MODULE$.getPageHFRow((Json)fn.apply(format))).getOrElse(PdfBuilder::getHFRow$$anonfun$2);
    }

    private void handleFont(String text, TextProperty textProperty) {
        if (PdfBuilder$.MODULE$.containsUnicode(text)) {
            this.contents.setFont((PDFont)this.font(), textProperty.size().pts());
            return;
        }
        this.contents.setFont((PDFont)new PDType1Font(textProperty.font()), textProperty.size().pts());
    }

    private void setLineOffset(UnitDim.Dim x, UnitDim.Dim y) {
        float yPos = this.yStartDim().$minus(y).pts();
        float xPos = this.MarginLeft().$plus(x).pts();
        this.contents.newLineAtOffset(xPos, yPos);
    }

    private static final Model.PageFormat $init$$$anonfun$1() {
        return PDFPageFormat$.MODULE$.A4Format();
    }

    private static final UnitDim.Dim textWidth$1(TextProperty textProperty$1, String text$1) {
        return Pdf$.MODULE$.stringWidth((PDFont)new PDType1Font(textProperty$1.font()), textProperty$1.size(), text$1);
    }

    private static final HFTextBuilder.PageHFRow getHFRow$$anonfun$2() {
        return HFTextBuilder$.MODULE$.EmptyPageHFRow();
    }

    public static final class BorderStyle
    implements Product,
    Serializable {
        private final UnitDim.Dim lineWidth;
        private final String borderType;
        private final Color color;

        public static BorderStyle apply(UnitDim.Dim dim, String string, Color color) {
            return PdfBuilder$BorderStyle$.MODULE$.apply(dim, string, color);
        }

        public static BorderStyle fromProduct(Product product) {
            return PdfBuilder$BorderStyle$.MODULE$.fromProduct(product);
        }

        public static BorderStyle unapply(BorderStyle borderStyle) {
            return PdfBuilder$BorderStyle$.MODULE$.unapply(borderStyle);
        }

        public BorderStyle(UnitDim.Dim lineWidth, String borderType, Color color) {
            this.lineWidth = lineWidth;
            this.borderType = borderType;
            this.color = color;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BorderStyle)) return false;
            BorderStyle borderStyle = (BorderStyle)object;
            UnitDim.Dim dim = this.lineWidth();
            UnitDim.Dim dim2 = borderStyle.lineWidth();
            if (dim == null) {
                if (dim2 != null) {
                    return false;
                }
            } else if (!dim.equals(dim2)) return false;
            String string = this.borderType();
            String string2 = borderStyle.borderType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Color color = this.color();
            Color color2 = borderStyle.color();
            if (color == null) {
                if (color2 == null) return true;
                return false;
            } else {
                if (!((Object)color).equals(color2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BorderStyle;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "BorderStyle";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineWidth";
                }
                case 1: {
                    return "borderType";
                }
                case 2: {
                    return "color";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UnitDim.Dim lineWidth() {
            return this.lineWidth;
        }

        public String borderType() {
            return this.borderType;
        }

        public Color color() {
            return this.color;
        }

        public BorderStyle copy(UnitDim.Dim lineWidth, String borderType, Color color) {
            return new BorderStyle(lineWidth, borderType, color);
        }

        public UnitDim.Dim copy$default$1() {
            return this.lineWidth();
        }

        public String copy$default$2() {
            return this.borderType();
        }

        public Color copy$default$3() {
            return this.color();
        }

        public UnitDim.Dim _1() {
            return this.lineWidth();
        }

        public String _2() {
            return this.borderType();
        }

        public Color _3() {
            return this.color();
        }
    }

    public static final class RectData
    implements Product,
    Serializable {
        private final UnitDim.Dim x;
        private final UnitDim.Dim y;
        private final UnitDim.Dim width;
        private final UnitDim.Dim height;

        public static RectData apply(UnitDim.Dim dim, UnitDim.Dim dim2, UnitDim.Dim dim3, UnitDim.Dim dim4) {
            return PdfBuilder$RectData$.MODULE$.apply(dim, dim2, dim3, dim4);
        }

        public static RectData fromProduct(Product product) {
            return PdfBuilder$RectData$.MODULE$.fromProduct(product);
        }

        public static RectData unapply(RectData rectData) {
            return PdfBuilder$RectData$.MODULE$.unapply(rectData);
        }

        public RectData(UnitDim.Dim x, UnitDim.Dim y, UnitDim.Dim width, UnitDim.Dim height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RectData)) return false;
            RectData rectData = (RectData)object;
            UnitDim.Dim dim = this.x();
            UnitDim.Dim dim2 = rectData.x();
            if (dim == null) {
                if (dim2 != null) {
                    return false;
                }
            } else if (!dim.equals(dim2)) return false;
            UnitDim.Dim dim3 = this.y();
            UnitDim.Dim dim4 = rectData.y();
            if (dim3 == null) {
                if (dim4 != null) {
                    return false;
                }
            } else if (!dim3.equals(dim4)) return false;
            UnitDim.Dim dim5 = this.width();
            UnitDim.Dim dim6 = rectData.width();
            if (dim5 == null) {
                if (dim6 != null) {
                    return false;
                }
            } else if (!dim5.equals(dim6)) return false;
            UnitDim.Dim dim7 = this.height();
            UnitDim.Dim dim8 = rectData.height();
            if (dim7 == null) {
                if (dim8 == null) return true;
                return false;
            } else {
                if (!dim7.equals(dim8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RectData;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "RectData";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "x";
                }
                case 1: {
                    return "y";
                }
                case 2: {
                    return "width";
                }
                case 3: {
                    return "height";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UnitDim.Dim x() {
            return this.x;
        }

        public UnitDim.Dim y() {
            return this.y;
        }

        public UnitDim.Dim width() {
            return this.width;
        }

        public UnitDim.Dim height() {
            return this.height;
        }

        public UnitDim.Dim x2() {
            return this.x().$plus(this.width());
        }

        public UnitDim.Dim y2() {
            return this.y().$plus(this.height());
        }

        public RectData copy(UnitDim.Dim x, UnitDim.Dim y, UnitDim.Dim width, UnitDim.Dim height) {
            return new RectData(x, y, width, height);
        }

        public UnitDim.Dim copy$default$1() {
            return this.x();
        }

        public UnitDim.Dim copy$default$2() {
            return this.y();
        }

        public UnitDim.Dim copy$default$3() {
            return this.width();
        }

        public UnitDim.Dim copy$default$4() {
            return this.height();
        }

        public UnitDim.Dim _1() {
            return this.x();
        }

        public UnitDim.Dim _2() {
            return this.y();
        }

        public UnitDim.Dim _3() {
            return this.width();
        }

        public UnitDim.Dim _4() {
            return this.height();
        }
    }

    public static final class RelativePosition
    implements Product,
    Serializable {
        private final UnitDim.Dim left;
        private final UnitDim.Dim right;
        private final UnitDim.Dim top;
        private final UnitDim.Dim btm;

        public static RelativePosition apply(UnitDim.Dim dim, UnitDim.Dim dim2, UnitDim.Dim dim3, UnitDim.Dim dim4) {
            return PdfBuilder$RelativePosition$.MODULE$.apply(dim, dim2, dim3, dim4);
        }

        public static RelativePosition fromProduct(Product product) {
            return PdfBuilder$RelativePosition$.MODULE$.fromProduct(product);
        }

        public static RelativePosition unapply(RelativePosition relativePosition) {
            return PdfBuilder$RelativePosition$.MODULE$.unapply(relativePosition);
        }

        public RelativePosition(UnitDim.Dim left, UnitDim.Dim right, UnitDim.Dim top, UnitDim.Dim btm) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.btm = btm;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RelativePosition)) return false;
            RelativePosition relativePosition = (RelativePosition)object;
            UnitDim.Dim dim = this.left();
            UnitDim.Dim dim2 = relativePosition.left();
            if (dim == null) {
                if (dim2 != null) {
                    return false;
                }
            } else if (!dim.equals(dim2)) return false;
            UnitDim.Dim dim3 = this.right();
            UnitDim.Dim dim4 = relativePosition.right();
            if (dim3 == null) {
                if (dim4 != null) {
                    return false;
                }
            } else if (!dim3.equals(dim4)) return false;
            UnitDim.Dim dim5 = this.top();
            UnitDim.Dim dim6 = relativePosition.top();
            if (dim5 == null) {
                if (dim6 != null) {
                    return false;
                }
            } else if (!dim5.equals(dim6)) return false;
            UnitDim.Dim dim7 = this.btm();
            UnitDim.Dim dim8 = relativePosition.btm();
            if (dim7 == null) {
                if (dim8 == null) return true;
                return false;
            } else {
                if (!dim7.equals(dim8)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RelativePosition;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "RelativePosition";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "left";
                }
                case 1: {
                    return "right";
                }
                case 2: {
                    return "top";
                }
                case 3: {
                    return "btm";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UnitDim.Dim left() {
            return this.left;
        }

        public UnitDim.Dim right() {
            return this.right;
        }

        public UnitDim.Dim top() {
            return this.top;
        }

        public UnitDim.Dim btm() {
            return this.btm;
        }

        public RelativePosition copy(UnitDim.Dim left, UnitDim.Dim right, UnitDim.Dim top, UnitDim.Dim btm) {
            return new RelativePosition(left, right, top, btm);
        }

        public UnitDim.Dim copy$default$1() {
            return this.left();
        }

        public UnitDim.Dim copy$default$2() {
            return this.right();
        }

        public UnitDim.Dim copy$default$3() {
            return this.top();
        }

        public UnitDim.Dim copy$default$4() {
            return this.btm();
        }

        public UnitDim.Dim _1() {
            return this.left();
        }

        public UnitDim.Dim _2() {
            return this.right();
        }

        public UnitDim.Dim _3() {
            return this.top();
        }

        public UnitDim.Dim _4() {
            return this.btm();
        }
    }

    public static final class TextProperty
    implements Product,
    Serializable {
        private final Standard14Fonts.FontName font;
        private final UnitDim.Dim size;
        private final int weight;
        private final String align;
        private final Color color;
        private final RelativePosition padding;

        public static TextProperty apply(Standard14Fonts.FontName fontName, UnitDim.Dim dim, int n, String string, Color color, RelativePosition relativePosition) {
            return PdfBuilder$TextProperty$.MODULE$.apply(fontName, dim, n, string, color, relativePosition);
        }

        public static TextProperty fromProduct(Product product) {
            return PdfBuilder$TextProperty$.MODULE$.fromProduct(product);
        }

        public static TextProperty unapply(TextProperty textProperty) {
            return PdfBuilder$TextProperty$.MODULE$.unapply(textProperty);
        }

        public TextProperty(Standard14Fonts.FontName font, UnitDim.Dim size, int weight, String align, Color color, RelativePosition padding) {
            this.font = font;
            this.size = size;
            this.weight = weight;
            this.align = align;
            this.color = color;
            this.padding = padding;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.font()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.size()));
            n = Statics.mix((int)n, (int)this.weight());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.align()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.color()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.padding()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TextProperty)) return false;
            TextProperty textProperty = (TextProperty)object;
            if (this.weight() != textProperty.weight()) return false;
            Standard14Fonts.FontName fontName = this.font();
            Standard14Fonts.FontName fontName2 = textProperty.font();
            if (fontName == null) {
                if (fontName2 != null) {
                    return false;
                }
            } else if (!fontName.equals(fontName2)) return false;
            UnitDim.Dim dim = this.size();
            UnitDim.Dim dim2 = textProperty.size();
            if (dim == null) {
                if (dim2 != null) {
                    return false;
                }
            } else if (!dim.equals(dim2)) return false;
            String string = this.align();
            String string2 = textProperty.align();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Color color = this.color();
            Color color2 = textProperty.color();
            if (color == null) {
                if (color2 != null) {
                    return false;
                }
            } else if (!((Object)color).equals(color2)) return false;
            RelativePosition relativePosition = this.padding();
            RelativePosition relativePosition2 = textProperty.padding();
            if (relativePosition == null) {
                if (relativePosition2 == null) return true;
                return false;
            } else {
                if (!((Object)relativePosition).equals(relativePosition2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TextProperty;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "TextProperty";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "font";
                }
                case 1: {
                    return "size";
                }
                case 2: {
                    return "weight";
                }
                case 3: {
                    return "align";
                }
                case 4: {
                    return "color";
                }
                case 5: {
                    return "padding";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Standard14Fonts.FontName font() {
            return this.font;
        }

        public UnitDim.Dim size() {
            return this.size;
        }

        public int weight() {
            return this.weight;
        }

        public String align() {
            return this.align;
        }

        public Color color() {
            return this.color;
        }

        public RelativePosition padding() {
            return this.padding;
        }

        public TextProperty copy(Standard14Fonts.FontName font, UnitDim.Dim size, int weight, String align, Color color, RelativePosition padding) {
            return new TextProperty(font, size, weight, align, color, padding);
        }

        public Standard14Fonts.FontName copy$default$1() {
            return this.font();
        }

        public UnitDim.Dim copy$default$2() {
            return this.size();
        }

        public int copy$default$3() {
            return this.weight();
        }

        public String copy$default$4() {
            return this.align();
        }

        public Color copy$default$5() {
            return this.color();
        }

        public RelativePosition copy$default$6() {
            return this.padding();
        }

        public Standard14Fonts.FontName _1() {
            return this.font();
        }

        public UnitDim.Dim _2() {
            return this.size();
        }

        public int _3() {
            return this.weight();
        }

        public String _4() {
            return this.align();
        }

        public Color _5() {
            return this.color();
        }

        public RelativePosition _6() {
            return this.padding();
        }
    }
}

