/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.pdf.table.builder;

import ambience.adhocreport.export.Style$;
import ambience.adhocreport.export.UnitDim;
import ambience.adhocreport.export.pdf.Pdf$;
import ambience.adhocreport.export.pdf.PdfBuilder;
import ambience.adhocreport.export.pdf.PdfBuilder$BorderStyle$;
import ambience.adhocreport.export.pdf.PdfBuilder$RectData$;
import ambience.adhocreport.export.pdf.TableStructure;
import ambience.adhocreport.export.pdf.table.HFTextBuilder;
import ambience.adhocreport.export.pdf.table.HFTextBuilder$;
import ambience.adhocreport.export.pdf.table.RowExtractor;
import ambience.adhocreport.export.pdf.table.TextCellBuilder$;
import ambience.adhocreport.export.pdf.table.TextCellBuilder$Context$;
import com.elixirtech.json.JsonLens$;
import java.awt.Color;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class Block {
    private final PdfBuilder pdfBuilder;
    private UnitDim.Dim tableHeight;
    private UnitDim.Dim existingCellWidth;
    private final HFTextBuilder HFBuilder;
    private final Option limitColumnOpt;
    private final UnitDim.Dim tableWidthDim;

    public Block(PdfBuilder pdfBuilder) {
        this.pdfBuilder = pdfBuilder;
        this.tableHeight = Pdf$.MODULE$.ZeroDim();
        this.existingCellWidth = Pdf$.MODULE$.ZeroDim();
        this.HFBuilder = new HFTextBuilder(pdfBuilder);
        this.limitColumnOpt = JsonLens$.MODULE$.root().selectDynamic("limitColumn").int().getOption((Object)pdfBuilder.pageFormat().tableOption());
        this.tableWidthDim = (UnitDim.Dim)JsonLens$.MODULE$.root().selectDynamic("width").double().getOption((Object)pdfBuilder.pageFormat().tableOption()).map((Function1 & Serializable)d -> UnitDim.Dim$.MODULE$.apply((float)BoxesRunTime.unboxToDouble((Object)d))).getOrElse(Block::$init$$$anonfun$2);
    }

    public UnitDim.Dim tableHeight() {
        return this.tableHeight;
    }

    public void tableHeight_$eq(UnitDim.Dim x$1) {
        this.tableHeight = x$1;
    }

    public UnitDim.Dim existingCellWidth() {
        return this.existingCellWidth;
    }

    public void existingCellWidth_$eq(UnitDim.Dim x$1) {
        this.existingCellWidth = x$1;
    }

    public HFTextBuilder HFBuilder() {
        return this.HFBuilder;
    }

    public Option<Object> limitColumnOpt() {
        return this.limitColumnOpt;
    }

    public UnitDim.Dim tableWidthDim() {
        return this.tableWidthDim;
    }

    public void build(TableStructure.Table table) {
        this.pdfBuilder.startClip();
        this.HFBuilder().buildText();
        table.rows().foreach((Function1)(JProcedure1 & Serializable)row -> {
            RowExtractor rex = new RowExtractor(this.pdfBuilder.expRequest().styleInfo(), (TableStructure.Row)row);
            this.handleNewPage(rex);
            PdfBuilder.RectData rowRect = this.buildRowRect(rex);
            this.buildRowBackground((TableStructure.Row)row, rex, rowRect);
            UnitDim.Dim printableArea = this.pdfBuilder.bodyWidth().$minus(this.pdfBuilder.MarginRight().$plus(this.pdfBuilder.MarginLeft()));
            int limitColumn = BoxesRunTime.unboxToInt((Object)this.limitColumnOpt().getOrElse(() -> Block.$anonfun$1(row)));
            List cells = row.cells().take(limitColumn);
            ((List)cells.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                TableStructure.Cell cell = (TableStructure.Cell)x$1._1();
                int n = BoxesRunTime.unboxToInt((Object)x$1._2());
                this.buildCell(rex, cell, n);
            });
            this.existingCellWidth_$eq(Pdf$.MODULE$.ZeroDim());
            this.tableHeight_$eq(rowRect.y());
        });
    }

    public void buildRowBackground(TableStructure.Row row, RowExtractor rex, PdfBuilder.RectData rowRect) {
        Color color = rex.getRowColorBg();
        Color color2 = Color.WHITE;
        if (color == null ? color2 != null : !((Object)color).equals(color2)) {
            this.pdfBuilder.fillBox(rowRect, rex.getRowColorBg());
        }
        this.handleSetLine(row, rowRect, rex);
    }

    public void handleNewPage(RowExtractor rex) {
        UnitDim.Dim checkHeight = this.tableHeight().$plus(rex.getRowHeight());
        boolean isNewPage = this.pdfBuilder.isNewPage(checkHeight);
        if (isNewPage) {
            this.createSeparateLine(this.tableHeight());
            this.pdfBuilder.buildNewPage();
            this.pdfBuilder.startClip();
            this.HFBuilder().buildText();
            this.createSeparateLine(HFTextBuilder$.MODULE$.TopOrBottomMargin());
            this.tableHeight_$eq(Pdf$.MODULE$.ZeroDim().$plus(HFTextBuilder$.MODULE$.TopOrBottomMargin()));
            return;
        }
    }

    public void createSeparateLine(UnitDim.Dim yPosition) {
        PdfBuilder.BorderStyle borderStyle = PdfBuilder$BorderStyle$.MODULE$.apply(UnitDim.Dim$.MODULE$.pts(0.4f), "solid", new Color(234, 242, 250));
        this.pdfBuilder.setStroke(Pdf$.MODULE$.ZeroDim(), yPosition, this.tableWidthDim(), Pdf$.MODULE$.ZeroDim(), borderStyle);
    }

    public void handleSetLine(TableStructure.Row row, PdfBuilder.RectData rowRect, RowExtractor rex) {
        boolean isFooter;
        boolean bl = isFooter = row.cls().contains((Object)"report-group-footer") || row.cls().contains((Object)"report-all-footer");
        if (isFooter) {
            PdfBuilder.BorderStyle borderStyle = rex.getBorderTopStyle(Style$.MODULE$.BORDER_TOP());
            this.pdfBuilder.setStroke(rowRect, borderStyle);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void buildCell(RowExtractor rex, TableStructure.Cell cell, int idx) {
        block8: {
            cellRect = this.buildCellRect(rex, idx);
            textProperty = rex.getTextProperty(idx);
            cxt = TextCellBuilder$Context$.MODULE$.apply(this.cellText(cell), textProperty, cellRect);
            var7_7 = textProperty.align();
            switch (var7_7 == null ? 0 : var7_7.hashCode()) {
                case -1364013995: {
                    if (!"center".equals(var7_7)) ** break;
                    TextCellBuilder$.MODULE$.centerAlign(cxt, this.pdfBuilder);
                    break block8;
                }
                case 100571: {
                    if ("end".equals(var7_7)) break;
                    ** break;
                }
                case 3317767: {
                    if (!"left".equals(var7_7)) {
                        ** break;
                    }
                    ** GOTO lbl22
                }
                case 108511772: {
                    if ("right".equals(var7_7)) break;
                    ** break;
                }
                case 109757538: {
                    if (!"start".equals(var7_7)) ** break;
lbl22:
                    // 2 sources

                    TextCellBuilder$.MODULE$.leftAlign(cxt, this.pdfBuilder);
                    break block8;
                }
            }
            TextCellBuilder$.MODULE$.rightAlign(cxt, this.pdfBuilder);
            break block8;
lbl26:
            // 6 sources

            other = var7_7;
            Predef$.MODULE$.println((Object)("UNSUPPORTED ALIGN: " + other));
        }
        this.existingCellWidth_$eq(this.existingCellWidth().$plus(cellRect.width()));
    }

    public String cellText(TableStructure.Cell cell) {
        String string = cell.text();
        if ("&nbsp;".equals(string)) {
            return "";
        }
        String text = string;
        return text;
    }

    public PdfBuilder.RectData buildCellRect(RowExtractor rex, int idx) {
        UnitDim.Dim posY = this.tableHeight().$plus(rex.getCellHeight(idx));
        UnitDim.Dim posX = this.existingCellWidth();
        UnitDim.Dim h = rex.getCellHeight(idx);
        UnitDim.Dim w = rex.getCellWidth(idx);
        return PdfBuilder$RectData$.MODULE$.apply(posX, posY, w, h);
    }

    public PdfBuilder.RectData buildRowRect(RowExtractor rex) {
        UnitDim.Dim h = rex.getRowHeight();
        UnitDim.Dim y = this.tableHeight().$plus(h);
        return PdfBuilder$RectData$.MODULE$.apply(Pdf$.MODULE$.ZeroDim(), y, this.tableWidthDim(), h);
    }

    private static final UnitDim.Dim $init$$$anonfun$2() {
        return Pdf$.MODULE$.ZeroDim();
    }

    private static final int $anonfun$1(TableStructure.Row row$1) {
        return row$1.cells().length();
    }
}

