/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.xlsx.builder;

import ambience.adhocreport.CellType;
import ambience.adhocreport.Model;
import ambience.adhocreport.export.ExportXlsx;
import ambience.adhocreport.export.xlsx.RowExtract;
import ambience.adhocreport.export.xlsx.RowExtract$CellContent$;
import ambience.adhocreport.export.xlsx.RowExtract$CellContentImage$;
import ambience.adhocreport.export.xlsx.XlsxBuilder;
import ambience.adhocreport.export.xlsx.XlsxBuilder$CellProperties$;
import ambience.adhocreport.export.xlsx.builder.BaseExtractor$SheetTable$;
import com.elixirtech.coredata.Data;
import com.elixirtech.vdom.AttrKey$;
import com.elixirtech.vdom.VElement;
import com.elixirtech.vdom.VNode;
import com.elixirtech.vdom.VText;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class BaseExtractor {
    public abstract List<XlsxBuilder.CellProperties> AllCellProperties();

    public abstract ExportXlsx.Context ExportCxt();

    public abstract RowExtract.BaseRow buildRow(VElement var1);

    public abstract List<RowExtract.BaseCellContent> getCellContents(VNode var1);

    public XlsxBuilder.CellProperties extractGroupCellProp(Model.DimGroup group) {
        Model.ColumnProperties prop = group.columnProperties();
        return XlsxBuilder$CellProperties$.MODULE$.apply(this.dataType(group.name()), prop.alignment(), prop.format(), XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$4());
    }

    public XlsxBuilder.CellProperties extractFieldCellProp(Model.DimField field) {
        Model.ColumnProperties prop = field.columnProperties();
        XlsxBuilder.CellProperties cell = XlsxBuilder$CellProperties$.MODULE$.apply(this.dataType(field.name()), prop.alignment(), prop.format(), XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$4());
        Option option = field.cellProperties().as(Model.CellProperties$.MODULE$.decoder()).toOption();
        if (option instanceof Some) {
            Model.CellProperties cellProp = (Model.CellProperties)((Some)option).value();
            return cell.copy(cell.copy$default$1(), cell.copy$default$2(), cell.copy$default$3(), cellProp.type());
        }
        if (None$.MODULE$.equals(option)) {
            return cell;
        }
        throw new MatchError((Object)option);
    }

    public Data.Type dataType(String fieldName) {
        Option option = this.ExportCxt().schema().fields().find((Function1 & Serializable)_$1 -> {
            String string = _$1.name();
            String string2 = fieldName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        if (option instanceof Some) {
            Data.Field v = (Data.Field)((Some)option).value();
            return v.dataType();
        }
        return Data.Unknown$.MODULE$;
    }

    public RowExtract.BaseCellContent getCellContent(VElement cell, CellType cellType, boolean isColumnHeader) {
        CellType cellType2 = cellType;
        if (CellType.Image$.MODULE$.equals(cellType2)) {
            return (RowExtract.BaseCellContent)this.getCellContentImage(cell).getOrElse(() -> this.getCellContent$$anonfun$1(cell));
        }
        if (CellType.Text$.MODULE$.equals(cellType2)) {
            return RowExtract$CellContent$.MODULE$.apply(this.text((VNode)cell));
        }
        if (CellType.Blank$.MODULE$.equals(cellType2)) {
            if (isColumnHeader) {
                return RowExtract$CellContent$.MODULE$.apply(this.text((VNode)cell));
            }
            return RowExtract$CellContent$.MODULE$.apply("");
        }
        return RowExtract$CellContent$.MODULE$.apply("");
    }

    public boolean getCellContent$default$3() {
        return false;
    }

    public Option<RowExtract.CellContentImage> getCellContentImage(VElement cell) {
        return this.firstChildElem((VNode)cell).flatMap((Function1 & Serializable)c -> this.getAttr((VElement)c, "src")).map((Function1 & Serializable)content -> RowExtract$CellContentImage$.MODULE$.apply((String)content));
    }

    public List<Model.RowStyle> rowStyles(String rowClassName) {
        return this.ExportCxt().styleInfo().rows().find((Function1 & Serializable)_$2 -> {
            String string = _$2.className();
            String string2 = rowClassName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
    }

    public String getCssClassName(VElement e) {
        return (String)e.attributes().getOrElse((Object)AttrKey$.MODULE$.apply("class", AttrKey$.MODULE$.$lessinit$greater$default$2()), BaseExtractor::getCssClassName$$anonfun$1);
    }

    public String text(VNode vNode) {
        String string = this.text(new StringBuilder(), vNode).toString();
        if ("&nbsp;".equals(string)) {
            return "";
        }
        String text = string;
        return text;
    }

    private StringBuilder text(StringBuilder sb, VNode n) {
        VNode vNode = n;
        if (vNode instanceof VElement) {
            VElement e = (VElement)vNode;
            return (StringBuilder)e.children().foldLeft((Object)sb, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    StringBuilder s = (StringBuilder)tuple2._1();
                    VNode n = (VNode)tuple2._2();
                    return this.text(s, n);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        if (vNode instanceof VText) {
            VText t = (VText)vNode;
            return sb.append(t.text());
        }
        return sb;
    }

    public List<VElement> childrenVElem(VNode vNode) {
        VNode vNode2 = vNode;
        if (vNode2 instanceof VElement) {
            VElement v = (VElement)vNode2;
            return ((IterableOnceOps)v.children().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(VNode x) {
                    VNode vNode = x;
                    if (vNode instanceof VElement) {
                        VElement c = (VElement)vNode;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(VNode x, Function1 function1) {
                    VNode vNode = x;
                    if (vNode instanceof VElement) {
                        VElement c = (VElement)vNode;
                        return c;
                    }
                    return function1.apply((Object)x);
                }
            })).toList();
        }
        return package$.MODULE$.Nil();
    }

    public Option<VElement> firstChildElem(VNode vNode) {
        VNode vNode2 = vNode;
        if (vNode2 instanceof VElement) {
            VElement v = (VElement)vNode2;
            return v.children().headOption().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(VNode x) {
                    VNode vNode = x;
                    if (vNode instanceof VElement) {
                        VElement v2 = (VElement)vNode;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(VNode x, Function1 function1) {
                    VNode vNode = x;
                    if (vNode instanceof VElement) {
                        VElement v2 = (VElement)vNode;
                        return v2;
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return None$.MODULE$;
    }

    public boolean isReportColumnHeader(VNode rowNode) {
        return this.getAttr(rowNode, "class").exists((Function1 & Serializable)_$3 -> _$3.contains("report-column-header"));
    }

    public Option<String> getAttr(VElement vElem, String attr) {
        return vElem.attributes().get((Object)AttrKey$.MODULE$.apply(attr, AttrKey$.MODULE$.$lessinit$greater$default$2()));
    }

    public Option<String> getAttr(VNode vNode, String attr) {
        VNode vNode2 = vNode;
        if (vNode2 instanceof VElement) {
            VElement vElem = (VElement)vNode2;
            return this.getAttr(vElem, attr);
        }
        return None$.MODULE$;
    }

    public Tuple2<String, Object> showClsLvl(String clsName, int lvl, boolean show, int lvlJump) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)(clsName + " level-" + (lvl + lvlJump)));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)show));
    }

    public int showClsLvl$default$4() {
        return 1;
    }

    public CellType getCellType(int idx) {
        return (CellType)((Option)this.AllCellProperties().lift().apply((Object)BoxesRunTime.boxToInteger((int)idx))).map((Function1 & Serializable)_$4 -> _$4.cellType()).getOrElse(BaseExtractor::getCellType$$anonfun$2);
    }

    private final RowExtract.BaseCellContent getCellContent$$anonfun$1(VElement cell$1) {
        return RowExtract$CellContent$.MODULE$.apply(this.text((VNode)cell$1));
    }

    private static final String getCssClassName$$anonfun$1() {
        return "";
    }

    private static final CellType getCellType$$anonfun$2() {
        return CellType.Text$.MODULE$;
    }

    public static final class SheetTable
    implements Product,
    Serializable {
        private final List rows;

        public static SheetTable apply(List<RowExtract.BaseRow> list) {
            return BaseExtractor$SheetTable$.MODULE$.apply(list);
        }

        public static SheetTable fromProduct(Product product) {
            return BaseExtractor$SheetTable$.MODULE$.fromProduct(product);
        }

        public static SheetTable unapply(SheetTable sheetTable) {
            return BaseExtractor$SheetTable$.MODULE$.unapply(sheetTable);
        }

        public SheetTable(List<RowExtract.BaseRow> rows) {
            this.rows = rows;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SheetTable)) return false;
            SheetTable sheetTable = (SheetTable)object;
            List<RowExtract.BaseRow> list = this.rows();
            List<RowExtract.BaseRow> list2 = sheetTable.rows();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SheetTable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SheetTable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "rows";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<RowExtract.BaseRow> rows() {
            return this.rows;
        }

        public SheetTable copy(List<RowExtract.BaseRow> rows) {
            return new SheetTable(rows);
        }

        public List<RowExtract.BaseRow> copy$default$1() {
            return this.rows();
        }

        public List<RowExtract.BaseRow> _1() {
            return this.rows();
        }
    }
}

