/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.xlsx.builder.block;

import ambience.adhocreport.export.xlsx.RowExtract;
import ambience.adhocreport.export.xlsx.XlsxBuilder;
import ambience.adhocreport.export.xlsx.XlsxSheet;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder$RowContext$;
import ambience.adhocreport.export.xlsx.builder.block.BlockExtractor;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder;
import java.io.Serializable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class BlockBuilder
extends BaseBuilder {
    private final XlsxBuilder.XlsxContext xlsxCxt;
    private final BlockExtractor Extractor;
    private final XlsxBuilder xlsxBuilder;

    public BlockBuilder(XlsxBuilder.XlsxContext xlsxCxt) {
        this.xlsxCxt = xlsxCxt;
        this.Extractor = new BlockExtractor(xlsxCxt);
        this.xlsxBuilder = new XlsxBuilder();
    }

    @Override
    public XlsxBuilder.XlsxContext xlsxCxt() {
        return this.xlsxCxt;
    }

    @Override
    public BlockExtractor Extractor() {
        return this.Extractor;
    }

    @Override
    public XlsxBuilder xlsxBuilder() {
        return this.xlsxBuilder;
    }

    @Override
    public byte[] getReportBytes() {
        Iterator RowGroupedIdx = this.Extractor().sheetTable().rows().grouped(this.RowPerSheetLimit()).zipWithIndex();
        RowGroupedIdx.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                List rows = (List)tuple2._1();
                int sheetIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.buildSheet((List<RowExtract.BaseRow>)rows, sheetIdx);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return this.xlsxBuilder().getBytes();
    }

    public void buildSheet(List<RowExtract.BaseRow> rows, int sheetIdx) {
        XlsxSheet sheet = this.xlsxBuilder().newSheet("Sheet " + (sheetIdx + 1));
        List cellCompletions = ((List)rows.zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseRow row = (RowExtract.BaseRow)tuple2._1();
                int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.buildRow(BaseBuilder$RowContext$.MODULE$.apply(sheet, row, rowIdx));
            }
            throw new MatchError((Object)tuple2);
        });
        sheet.autoSize();
        this.handleCellSize((List<BaseBuilder.CellResult>)cellCompletions, sheet.currentSheet());
    }

    public List<BaseBuilder.CellResult> buildRow(BaseBuilder.RowContext cxt) {
        XlsxStyleBuilder xStyle = this.getXlsxStyleBuilder(cxt.row(), this.xlsxCxt().exportCxt());
        this.setRowStyles(cxt.rowX(), xStyle.RowStyleMap());
        return this.fillCells(cxt, xStyle);
    }

    public List<BaseBuilder.CellResult> fillCells(BaseBuilder.RowContext cxt, XlsxStyleBuilder xStyle) {
        return ((List)cxt.row().cellContents().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseCellContent cellContent = (RowExtract.BaseCellContent)tuple2._1();
                int cellIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                XSSFCell cellX = cxt.rowX().addCell(cellIdx);
                xStyle.setCellStyle(cellX, cellIdx);
                return this.setCellContent(cxt, cellContent, cellX, cellIdx);
            }
            throw new MatchError((Object)tuple2);
        });
    }
}

