/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.xlsx.builder.drilldown;

import ambience.adhocreport.Model;
import ambience.adhocreport.export.xlsx.RowExtract;
import ambience.adhocreport.export.xlsx.XlsxBuilder;
import ambience.adhocreport.export.xlsx.XlsxSheet;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder$CellFinish$;
import ambience.adhocreport.export.xlsx.builder.BaseBuilder$RowContext$;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownBuilder$;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownBuilder$ReportVNode$;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownExtractor;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownLink;
import ambience.adhocreport.export.xlsx.builder.drilldown.DrillDownLink$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.coredata.Data;
import com.elixirtech.vdom.VNode;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;

public class DrillDownBuilder
extends BaseBuilder {
    private final ReportVNode reportNode;
    private final XlsxBuilder.XlsxContext xlsxCxt;
    private final XlsxBuilder xlsxBuilder;
    private final DrillDownExtractor Extractor;

    public static Model.Path IndexPath() {
        return DrillDownBuilder$.MODULE$.IndexPath();
    }

    public static String IndexSheet() {
        return DrillDownBuilder$.MODULE$.IndexSheet();
    }

    public static Task<Either<LogMessage, List<Document>>> fetchUniqueGroups(UserDB.User user, Model.ReportRequest reportRequest) {
        return DrillDownBuilder$.MODULE$.fetchUniqueGroups(user, reportRequest);
    }

    public static Task<Either<LogMessage, List<Model.Path>>> generateUniquePaths(List<Model.DimGroup> list, List<Document> list2) {
        return DrillDownBuilder$.MODULE$.generateUniquePaths(list, list2);
    }

    public static Task<Either<LogMessage, byte[]>> renderMultipleReports(UserDB.User user, Model.ExportRequest exportRequest, DrillDownLink drillDownLink) {
        return DrillDownBuilder$.MODULE$.renderMultipleReports(user, exportRequest, drillDownLink);
    }

    public static Task<Either<LogMessage, byte[]>> renderNoGroupReport(UserDB.User user, Model.ExportRequest exportRequest) {
        return DrillDownBuilder$.MODULE$.renderNoGroupReport(user, exportRequest);
    }

    public static Task<Either<LogMessage, byte[]>> renderXlsx(List<ReportVNode> list, Model.ExportRequest exportRequest, Data.Schema schema, DrillDownLink drillDownLink) {
        return DrillDownBuilder$.MODULE$.renderXlsx(list, exportRequest, schema, drillDownLink);
    }

    public static Task<Either<LogMessage, byte[]>> renderXlsx(VNode vNode, Model.ExportRequest exportRequest, Data.Schema schema) {
        return DrillDownBuilder$.MODULE$.renderXlsx(vNode, exportRequest, schema);
    }

    public DrillDownBuilder(ReportVNode reportNode, Data.Schema schema, XlsxBuilder.XlsxContext xlsxCxt, XlsxBuilder xlsxBuilder) {
        this.reportNode = reportNode;
        this.xlsxCxt = xlsxCxt;
        this.xlsxBuilder = xlsxBuilder;
        this.Extractor = new DrillDownExtractor(reportNode.vNode(), xlsxCxt.exportCxt());
    }

    @Override
    public XlsxBuilder.XlsxContext xlsxCxt() {
        return this.xlsxCxt;
    }

    @Override
    public XlsxBuilder xlsxBuilder() {
        return this.xlsxBuilder;
    }

    @Override
    public DrillDownExtractor Extractor() {
        return this.Extractor;
    }

    public void run() {
        String sheetName = this.generateName(this.reportNode.path());
        XlsxSheet sheet = this.xlsxBuilder().newSheet(sheetName);
        List filteredRows = this.Extractor().sheetTable().rows().filterNot((Function1 & Serializable)_$3 -> _$3.properties().className().contains("style-ref-row"));
        int totalColumns = this.getMaxTotalColumn((List<RowExtract.BaseRow>)filteredRows);
        List cellCompletions = ((List)filteredRows.zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseRow row = (RowExtract.BaseRow)tuple2._1();
                int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                BaseBuilder.RowContext rowCxt = BaseBuilder$RowContext$.MODULE$.apply(sheet, row, rowIdx);
                RowExtract.BaseRow baseRow = row;
                if (baseRow instanceof RowExtract.Row) {
                    RowExtract.Row d = (RowExtract.Row)baseRow;
                    return this.buildRow(rowCxt, this.reportNode.path(), totalColumns);
                }
                if (baseRow instanceof RowExtract.BreadCrumbRow) {
                    RowExtract.BreadCrumbRow row2 = (RowExtract.BreadCrumbRow)baseRow;
                    return this.buildBreadcrumbRow(row2, rowCxt, totalColumns);
                }
                throw new MatchError((Object)baseRow);
            }
            throw new MatchError((Object)tuple2);
        });
        sheet.autoSize();
        this.setReporttTittleCellFixAlignment(sheet);
        this.handleCellSize((List<BaseBuilder.CellResult>)cellCompletions, sheet.currentSheet());
    }

    private int getMaxTotalColumn(List<RowExtract.BaseRow> filteredRows) {
        int totalCellBC;
        int totalCellCH = BoxesRunTime.unboxToInt((Object)DrillDownBuilder.getTotalCellOpt$1(filteredRows, "report-column-header").getOrElse(DrillDownBuilder::$anonfun$3));
        if (totalCellCH > (totalCellBC = BoxesRunTime.unboxToInt((Object)filteredRows.filter((Function1 & Serializable)_$6 -> {
            String string = _$6.properties().className();
            String string2 = "breadcrumb-holder";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$7 -> _$7.cellContents().filterNot((Function1 & Serializable)_$8 -> {
            String string = _$8.content();
            String string2 = ":";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).length()).headOption().getOrElse(DrillDownBuilder::$anonfun$6)))) {
            return totalCellCH;
        }
        return totalCellBC;
    }

    public List<BaseBuilder.CellResult> buildRow(BaseBuilder.RowContext cxt, Model.Path path, int totalColumns) {
        XlsxStyleBuilder xStyle = this.getXlsxStyleBuilder(cxt.row(), this.xlsxCxt().exportCxt());
        this.setRowStyles(cxt.rowX(), xStyle.RowStyleMap());
        this.handleMerge(cxt, totalColumns);
        return ((List)cxt.row().cellContents().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                RowExtract.BaseCellContent cellContent = (RowExtract.BaseCellContent)tuple2._1();
                int cellIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                XSSFCell cellX = cxt.rowX().addCell(cellIdx);
                xStyle.setCellStyle(cellX, cellIdx);
                return this.setCellContent(cxt, cellContent, cellX, cellIdx);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void handleMerge(BaseBuilder.RowContext cxt, int totalColumns) {
        if (cxt.rowIdx() == 0) {
            this.handleMergeTitle(cxt, totalColumns);
            return;
        }
        int totalCell = cxt.row().cellContents().length();
        if (totalCell < totalColumns) {
            try {
                cxt.sheetX().currentSheet().addMergedRegion(new CellRangeAddress(cxt.rowIdx(), cxt.rowIdx(), totalCell - 1, totalColumns - 1));
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("MergeFailed2: " + e.getMessage()));
            }
            return;
        }
    }

    private void handleMergeCell(BaseBuilder.RowContext cxt, Model.Path path, int cellIdx, int totalColumns) {
        if (cxt.rowIdx() == 0) {
            this.handleMergeTitle(cxt, totalColumns);
            return;
        }
    }

    public void handleMergeTitle(BaseBuilder.RowContext cxt, int totalColumns) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            DrillDownBuilder.handleMergeTitle$$anonfun$1(cxt, totalColumns);
            return BoxedUnit.UNIT;
        });
    }

    private List<BaseBuilder.CellResult> buildBreadcrumbRow(RowExtract.BreadCrumbRow row, BaseBuilder.RowContext cxt, int totalColumns) {
        XlsxStyleBuilder xStyle = this.getXlsxStyleBuilder(cxt.row(), this.xlsxCxt().exportCxt());
        this.setRowStyles(cxt.rowX(), xStyle.RowStyleMap());
        List cellContents = row.cellContents().filterNot((Function1 & Serializable)_$9 -> {
            String string = _$9.content();
            String string2 = ":";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
        this.mergeLastCellBreadcrumbRow(cxt, cellContents.length(), totalColumns);
        return ((List)cellContents.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            RowExtract.BaseCellContent baseCellContent = (RowExtract.BaseCellContent)x$1._1();
            int n = BoxesRunTime.unboxToInt((Object)x$1._2());
            XSSFCell cellX = cxt.rowX().addCell(n);
            RowExtract.BaseCellContent baseCellContent2 = baseCellContent;
            if (baseCellContent2 instanceof RowExtract.CellContentLink) {
                RowExtract.CellContentLink cell = (RowExtract.CellContentLink)baseCellContent2;
                v0 = this.setCellWithHyperlink(cellX, cell.content() + " :", this.buildPath(n, (List<RowExtract.BaseCellContent>)cellContents));
            } else {
                RowExtract.BaseCellContent cell = baseCellContent2;
                cellX.setCellValue(cell.content());
                v0 = BoxedUnit.UNIT;
            }
            xStyle.setCellStyle(cellX, n);
            cellX.getCellStyle().setAlignment(HorizontalAlignment.LEFT);
            return BaseBuilder$CellFinish$.MODULE$;
        });
    }

    private void mergeLastCellBreadcrumbRow(BaseBuilder.RowContext cxt, int totalCell, int totalColumns) {
        try {
            CellRangeAddress range = new CellRangeAddress(cxt.rowIdx(), cxt.rowIdx(), totalCell - 1, totalColumns - 1);
            cxt.sheetX().currentSheet().addMergedRegion(range);
        }
        catch (Throwable e) {}
    }

    public Model.Path buildPath(int idx, List<RowExtract.BaseCellContent> lsContent) {
        if (idx == 0) {
            return DrillDownBuilder$.MODULE$.IndexPath();
        }
        return Model.Path$.MODULE$.apply(((List)((StrictOptimizedIterableOps)lsContent.drop(1)).dropRight(1)).map((Function1 & Serializable)_$10 -> _$10.content()).map((Function1 & Serializable)value -> Json$.MODULE$.fromString(value)));
    }

    @Override
    public BaseBuilder.CellResult setCellWithHyperlink(XSSFCell cellX, String value, Model.Path path) {
        String link = this.getLink(path);
        XSSFHyperlink hyperLink = this.xlsxBuilder().wb().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        hyperLink.setAddress(link + "!A1");
        cellX.setHyperlink((Hyperlink)hyperLink);
        cellX.setCellValue(value);
        return BaseBuilder$CellFinish$.MODULE$;
    }

    private String getLink(Model.Path path) {
        Option<DrillDownLink> option = this.xlsxCxt().dLinkOpt();
        if (option instanceof Some) {
            DrillDownLink dLink = (DrillDownLink)((Some)option).value();
            return dLink.fetchSheetLink(path);
        }
        if (None$.MODULE$.equals(option)) {
            return DrillDownLink$.MODULE$.buildGroupName(path);
        }
        throw new MatchError(option);
    }

    private void setCellWithHyperlink(XSSFCell cellX, String value, String link) {
        XSSFHyperlink hyperLink = this.xlsxBuilder().wb().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
        hyperLink.setAddress(link + "!A1");
        cellX.setHyperlink((Hyperlink)hyperLink);
        cellX.setCellValue(value);
    }

    @Override
    public byte[] getReportBytes() {
        return new byte[0];
    }

    public String generateName(Model.Path path) {
        if (path.isEmpty()) {
            return DrillDownBuilder$.MODULE$.IndexSheet();
        }
        Option generatedNameOpt = this.xlsxCxt().dLinkOpt().map((Function1 & Serializable)dLink -> dLink.fetchOrCreateSheetName(path));
        Option option = generatedNameOpt;
        if (option instanceof Some) {
            String name = (String)((Some)option).value();
            return name;
        }
        if (None$.MODULE$.equals(option)) {
            return "<empty>";
        }
        throw new MatchError((Object)option);
    }

    public void setReporttTittleCellFixAlignment(XlsxSheet sheet) {
        sheet.currentSheet().getRow(0).getCell(0).getCellStyle().setAlignment(HorizontalAlignment.LEFT);
    }

    private static final Option getTotalCellOpt$1(List filteredRows$1, String clsName) {
        return filteredRows$1.find((Function1 & Serializable)_$4 -> {
            String string = _$4.properties().className();
            String string2 = clsName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$5 -> _$5.cellContents().length());
    }

    private static final int $anonfun$3() {
        return 0;
    }

    private static final int $anonfun$6() {
        return 0;
    }

    private static final void handleMergeTitle$$anonfun$1(BaseBuilder.RowContext cxt$2, int totalColumns$2) {
        cxt$2.sheetX().currentSheet().addMergedRegion(new CellRangeAddress(0, 0, 0, totalColumns$2 - 1));
    }

    public static final class ReportVNode
    implements Product,
    Serializable {
        private final VNode vNode;
        private final Model.Path path;

        public static ReportVNode apply(VNode vNode, Model.Path path) {
            return DrillDownBuilder$ReportVNode$.MODULE$.apply(vNode, path);
        }

        public static ReportVNode fromProduct(Product product) {
            return DrillDownBuilder$ReportVNode$.MODULE$.fromProduct(product);
        }

        public static ReportVNode unapply(ReportVNode reportVNode) {
            return DrillDownBuilder$ReportVNode$.MODULE$.unapply(reportVNode);
        }

        public ReportVNode(VNode vNode, Model.Path path) {
            this.vNode = vNode;
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReportVNode)) return false;
            ReportVNode reportVNode = (ReportVNode)object;
            VNode vNode = this.vNode();
            VNode vNode2 = reportVNode.vNode();
            if (vNode == null) {
                if (vNode2 != null) {
                    return false;
                }
            } else if (!vNode.equals(vNode2)) return false;
            Model.Path path = this.path();
            Model.Path path2 = reportVNode.path();
            if (path == null) {
                if (path2 == null) return true;
                return false;
            } else {
                if (!path.equals(path2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReportVNode;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ReportVNode";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "vNode";
            }
            if (1 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public VNode vNode() {
            return this.vNode;
        }

        public Model.Path path() {
            return this.path;
        }

        public ReportVNode copy(VNode vNode, Model.Path path) {
            return new ReportVNode(vNode, path);
        }

        public VNode copy$default$1() {
            return this.vNode();
        }

        public Model.Path copy$default$2() {
            return this.path();
        }

        public VNode _1() {
            return this.vNode();
        }

        public Model.Path _2() {
            return this.path();
        }
    }
}

