/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.xlsx.builder.util;

import ambience.adhocreport.Model;
import ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil;
import ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil$Context$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.package$;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import scala.Array$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class XlsxImageUtil$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(XlsxImageUtil$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final XlsxImageUtil$Context$ Context;
    public static final XlsxImageUtil$ MODULE$;

    private XlsxImageUtil$() {
    }

    static {
        MODULE$ = new XlsxImageUtil$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XlsxImageUtil$.class);
    }

    public void setImageCell(XlsxImageUtil.Context cxt) {
        byte[] bytes = this.imageDataToByte(cxt.cellImg().imageData());
        Model.CellProperties.Properties cellProp = this.getCellImageProp(bytes, cxt);
        this.cratePicture(bytes, cellProp, cxt);
        this.setColumnWidth(cellProp, cxt);
        this.setRowHeight(cellProp, cxt);
    }

    private void cratePicture(byte[] bytes, Model.CellProperties.Properties cellProp, XlsxImageUtil.Context cxt) {
        XSSFDrawing drawing = cxt.sheet().createDrawingPatriarch();
        XSSFClientAnchor anchor = this.prepareAnchor(cellProp, cxt);
        int imageIdx = cxt.wb().addPicture(bytes, 6);
        drawing.createPicture(anchor, imageIdx);
    }

    private XSSFClientAnchor prepareAnchor(Model.CellProperties.Properties cellProp, XlsxImageUtil.Context cxt) {
        double padLeft = cellProp.paddingLeft();
        double xPos = padLeft + this.getXPos(cxt);
        double padTop = cellProp.paddingTop();
        double yPos = padTop + this.getYPos(cxt);
        return this.buildAnchor(cxt.wb(), xPos, yPos, cellProp);
    }

    public double getXPos(XlsxImageUtil.Context cxt) {
        Range range = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cxt.cellImg().cellPos().col());
        return BoxesRunTime.unboxToFloat((Object)range.map((Function1)(JFunction1.mcFI.sp & Serializable)x$0 -> cxt.sheet().getColumnWidthInPixels(x$0)).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    public double getYPos(XlsxImageUtil.Context cxt) {
        Range range = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cxt.cellImg().cellPos().row());
        return Float$.MODULE$.float2double(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)range.map((Function1 & Serializable)x$0 -> XlsxImageUtil$.getYPos$$anonfun$1(cxt, BoxesRunTime.unboxToInt((Object)x$0))).map((Function1 & Serializable)_$1 -> _$1.getHeightInPoints())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
    }

    private XSSFClientAnchor buildAnchor(XSSFWorkbook wb, double xPosPx, double yPosPt, Model.CellProperties.Properties cellProp) {
        XSSFClientAnchor anchor = wb.getCreationHelper().createClientAnchor();
        int width = this.getX2Pos(xPosPx, cellProp.width());
        anchor.setDx1(Units.toEMU((double)xPosPx));
        anchor.setDx2(width);
        anchor.setDy1(Units.toEMU((double)yPosPt));
        anchor.setDy2(Units.toEMU((double)(yPosPt + cellProp.height())));
        return anchor;
    }

    public int getX2Pos(double xPosPx, double imgWidth) {
        int widthX;
        int width = widthX = Units.toEMU((double)(xPosPx + imgWidth));
        return Math.toIntExact(width);
    }

    private void setColumnWidth(Model.CellProperties.Properties cellProp, XlsxImageUtil.Context cxt) {
        double widthPx = cellProp.width() + cellProp.paddingLeft() + cellProp.paddingRight();
        double widthPt = Units.pixelToPoints((double)widthPx);
        double widthColumn = Math.rint((double)Units.toEMU((double)widthPt) / 256.0 * 0.98);
        cxt.sheet().setColumnWidth(cxt.cellImg().cellPos().col(), (int)widthColumn);
    }

    private void setRowHeight(Model.CellProperties.Properties cellProp, XlsxImageUtil.Context cxt) {
        double height = cellProp.paddingTop() + cellProp.height() + cellProp.paddingBottom();
        int heightTp = Units.pointsToPixel((double)height) * 15;
        cxt.sheet().getRow(cxt.cellImg().cellPos().row()).setHeight((short)heightTp);
    }

    private Model.CellProperties.Properties getCellImageProp(byte[] bytes, XlsxImageUtil.Context cxt) {
        Option<Model.CellProperties> option = this.getCellProp(cxt);
        if (option instanceof Some) {
            Model.CellProperties prop = (Model.CellProperties)((Some)option).value();
            return this.cellProp$1(prop.properties(), this.getImageSize(bytes, prop.properties()));
        }
        if (None$.MODULE$.equals(option)) {
            return this.cellProp$1(Model.CellProperties$.Properties$.MODULE$.apply(Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$1(), Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$2(), Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$3(), Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$4(), Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$5(), Model.CellProperties$.Properties$.MODULE$.$lessinit$greater$default$6()), this.getActualBinaryImageDim(bytes));
        }
        throw new MatchError(option);
    }

    private Option<Model.CellProperties> getCellProp(XlsxImageUtil.Context cxt) {
        int idx = cxt.cellImg().cellPos().col() - cxt.exportCxt().groups().length();
        return ((Option)cxt.exportCxt().fields().lift().apply((Object)BoxesRunTime.boxToInteger((int)idx))).flatMap((Function1 & Serializable)_$2 -> _$2.cellProperties().as(Model.CellProperties$.MODULE$.decoder()).toOption());
    }

    private Tuple2<Object, Object> getImageSize(byte[] bytes, Model.CellProperties.Properties prop) {
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(prop.width(), prop.height());
        if (sp2 != null) {
            double d = sp2._1$mcD$sp();
            double d2 = sp2._2$mcD$sp();
            if (0.0 == d && 0.0 == d2) {
                return this.getActualBinaryImageDim(bytes);
            }
            double width = d;
            if (0.0 == d2) {
                return this.sizeNoHeight(width, bytes);
            }
            if (0.0 == d) {
                double height = d2;
                return this.sizeNoWidth(height, bytes);
            }
        }
        Tuple2.mcDD.sp customSize = sp2;
        return customSize;
    }

    private Tuple2<Object, Object> sizeNoHeight(double width, byte[] bytes) {
        Tuple2<Object, Object> imgSize = this.getActualBinaryImageDim(bytes);
        double height = width * imgSize._2$mcD$sp() / imgSize._1$mcD$sp();
        return new Tuple2.mcDD.sp(width, height);
    }

    private Tuple2<Object, Object> sizeNoWidth(double height, byte[] bytes) {
        Tuple2<Object, Object> imgSize = this.getActualBinaryImageDim(bytes);
        double width = height * imgSize._1$mcD$sp() / imgSize._2$mcD$sp();
        return new Tuple2.mcDD.sp(width, height);
    }

    private Tuple2<Object, Object> getActualBinaryImageDim(byte[] bytes) {
        BufferedImage buf = ImageIO.read(new ByteArrayInputStream(bytes));
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(buf.getWidth())), (Object)BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(buf.getHeight())));
    }

    private byte[] imageDataToByte(String imageData) {
        Option<byte[]> bytesOpt = this.isImageBase64$1(imageData) ? this.base64Decoder(imageData) : this.imageFromUrl(imageData);
        return (byte[])bytesOpt.getOrElse(XlsxImageUtil$::imageDataToByte$$anonfun$1);
    }

    private Option<byte[]> base64Decoder(String base64Str) {
        String imageData = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(base64Str), base64Str.indexOf(",") + 1);
        return Some$.MODULE$.apply((Object)Base64.getDecoder().decode(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(imageData), imageData.indexOf(",") + 1)));
    }

    private Option<byte[]> imageFromUrl(String urlStr) {
        Some some;
        try {
            some = Some$.MODULE$.apply(ARM$.MODULE$.run((Function1 & Serializable)_$3 -> new URL(urlStr).openStream().readAllBytes()));
        }
        catch (IOException e) {
            this.log().error(() -> XlsxImageUtil$.imageFromUrl$$anonfun$2(e), Line$.MODULE$.apply(139), FullName$.MODULE$.apply("ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil.imageFromUrl"));
            some = None$.MODULE$;
        }
        catch (Throwable throwable) {
            this.log().error(XlsxImageUtil$::imageFromUrl$$anonfun$3, Line$.MODULE$.apply(140), FullName$.MODULE$.apply("ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil.imageFromUrl"));
            some = None$.MODULE$;
        }
        return some;
    }

    private byte[] noImageAvailable() {
        byte[] byArray;
        block3: {
            try {
                File file = new File("./web/adhoc-report/noImageAvailable.jpeg");
                if (file.exists()) {
                    byArray = package$.MODULE$.enrichFile(file).data();
                    break block3;
                }
                this.log().error(() -> XlsxImageUtil$.noImageAvailable$$anonfun$1(file), Line$.MODULE$.apply(147), FullName$.MODULE$.apply("ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil.noImageAvailable"));
                byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
            }
            catch (Exception ex) {
                this.log().error(() -> XlsxImageUtil$.noImageAvailable$$anonfun$2(ex), Line$.MODULE$.apply(150), FullName$.MODULE$.apply("ambience.adhocreport.export.xlsx.builder.util.XlsxImageUtil.noImageAvailable"));
                byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE));
            }
        }
        return byArray;
    }

    private static final /* synthetic */ XSSFRow getYPos$$anonfun$1(XlsxImageUtil.Context cxt$2, int x$0) {
        return cxt$2.sheet().getRow(x$0);
    }

    private final Model.CellProperties.Properties cellProp$1(Model.CellProperties.Properties cellProp, Tuple2 size) {
        return cellProp.copy(cellProp.copy$default$1(), cellProp.copy$default$2(), cellProp.copy$default$3(), cellProp.copy$default$4(), size._1$mcD$sp(), size._2$mcD$sp());
    }

    private final boolean isImageBase64$1(String imageData$1) {
        String string = StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(imageData$1), 10);
        String string2 = "data:image";
        return !(string != null ? !string.equals(string2) : string2 != null) && imageData$1.contains("base64");
    }

    private static final byte[] imageDataToByte$$anonfun$1() {
        return MODULE$.noImageAvailable();
    }

    private static final Object imageFromUrl$$anonfun$2(IOException e$1) {
        return "Error: IO exception occurred. " + e$1.getMessage();
    }

    private static final Object imageFromUrl$$anonfun$3() {
        return "An unexpected error occurred.";
    }

    private static final Object noImageAvailable$$anonfun$1(File file$1) {
        return "File " + file$1.getPath() + " does not exist.";
    }

    private static final Object noImageAvailable$$anonfun$2(Exception ex$1) {
        return "Error loading image: " + ex$1.getMessage();
    }
}

