/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.export.xlsx.builder.util;

import ambience.adhocreport.Model;
import ambience.adhocreport.export.ExportXlsx;
import ambience.adhocreport.export.Style$;
import ambience.adhocreport.export.xlsx.RowExtract;
import ambience.adhocreport.export.xlsx.XlsxBuilder;
import ambience.adhocreport.export.xlsx.XlsxBuilder$CellProperties$;
import ambience.adhocreport.export.xlsx.XlsxCellFormat$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxBorderUtil$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxColorUtil;
import ambience.adhocreport.export.xlsx.builder.util.XlsxColorUtil$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxColorUtil$Context$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder$BorderInfo$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder$BorderStyleInfo$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder$Context$;
import ambience.adhocreport.export.xlsx.builder.util.XlsxStyleBuilder$RGB$;
import ambience.adhocreport.report.render.html.format.FormatHelper$;
import com.elixirtech.coredata.Data;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Short$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class XlsxStyleBuilder {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(XlsxStyleBuilder.class.getDeclaredField("RowStyleMap$lzy1"));
    private final Context xStyleCxt;
    private final XlsxBuilder xBuilder;
    private final List<Model.RowStyle> RelatedRowStyles;
    private volatile Object RowStyleMap$lzy1;
    private final Function1<Object, Map<String, String>> CellStyleMap;

    public XlsxStyleBuilder(Context xStyleCxt, XlsxBuilder xBuilder) {
        this.xStyleCxt = xStyleCxt;
        this.xBuilder = xBuilder;
        String clsName = xStyleCxt.row().properties().className();
        this.RelatedRowStyles = xStyleCxt.expContext().styleInfo().rows().find((Function1 & Serializable)_$1 -> {
            String string = _$1.className();
            String string2 = clsName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
        this.CellStyleMap = (Function1 & Serializable)colIdx -> this.$init$$$anonfun$2(BoxesRunTime.unboxToInt((Object)colIdx));
    }

    public Map<String, String> RowStyleMap() {
        Object object = this.RowStyleMap$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.RowStyleMap$lzyINIT1();
    }

    private Object RowStyleMap$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.RowStyleMap$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = (Map)this.RelatedRowStyles.map((Function1 & Serializable)_$2 -> _$2.style()).foldLeft(XlsxStyleBuilder$.ambience$adhocreport$export$xlsx$builder$util$XlsxStyleBuilder$$$EmptyMap, (Function2 & Serializable)(acc, r) -> (Map)acc.$plus$plus((IterableOnce)r));
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.RowStyleMap$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setCellStyle(XSSFCell cellX, int colIdx) {
        XSSFCellStyle cs = this.xBuilder.wb().createCellStyle();
        Map cellStyleMap = (Map)this.CellStyleMap.apply((Object)BoxesRunTime.boxToInteger((int)colIdx));
        this.setCellColor(cs, (Map<String, String>)cellStyleMap);
        this.setFontStyle(cs, (Map<String, String>)cellStyleMap);
        this.setCellBorders(cs, (Map<String, String>)cellStyleMap);
        XlsxBuilder.CellProperties celProp = (XlsxBuilder.CellProperties)((Option)this.xStyleCxt.cellProperties().lift().apply((Object)BoxesRunTime.boxToInteger((int)colIdx))).getOrElse(XlsxStyleBuilder::$anonfun$3);
        this.setAlignment(cs, celProp);
        this.setFormat(cs, celProp);
        cellX.setCellStyle((CellStyle)cs);
    }

    public void setCellColor(XSSFCellStyle cs, Map<String, String> cellStyles) {
        XlsxColorUtil.Context colorCxt = XlsxColorUtil$Context$.MODULE$.apply(Style$.MODULE$.BACKGROUND_COLOR(), cellStyles, this.xBuilder.colorMap());
        Option<XSSFColor> colorOpt = XlsxColorUtil$.MODULE$.getColor(colorCxt);
        colorOpt.foreach((Function1)(JProcedure1 & Serializable)color -> {
            cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs.setFillForegroundColor(color);
        });
    }

    public void setFontStyle(XSSFCellStyle cs, Map<String, String> cellStyles) {
        XSSFFont font = this.xBuilder.wb().createFont();
        XlsxColorUtil.Context colorCxt = XlsxColorUtil$Context$.MODULE$.apply(Style$.MODULE$.FOREGROUND_COLOR(), cellStyles, this.xBuilder.colorMap());
        XlsxColorUtil$.MODULE$.getColor(colorCxt).foreach((Function1)(JProcedure1 & Serializable)x$0 -> font.setColor(x$0));
        cellStyles.get((Object)Style$.MODULE$.FONT_FAMILY()).foreach((Function1)(JProcedure1 & Serializable)famFontStr -> {
            Object[] arr = famFontStr.split(",");
            Object object = Predef$.MODULE$.refArrayOps(arr);
            String fName = (String)ArrayOps$.MODULE$.headOption$extension(object).getOrElse(XlsxStyleBuilder::$anonfun$4);
            font.setFontName(fName);
        });
        cellStyles.get((Object)Style$.MODULE$.FONT_SIZE()).foreach((Function1)(JProcedure1 & Serializable)fontSize -> {
            Option fontSizeOpt = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(XlsxColorUtil$.MODULE$.removeLetters((String)fontSize)));
            fontSizeOpt.foreach((Function1)(JFunction1.mcVD.sp & Serializable)x$0 -> font.setFontHeight(x$0));
        });
        cellStyles.get((Object)Style$.MODULE$.FONT_WEIGHT()).foreach((Function1)(JProcedure1 & Serializable)fontWeightStr -> StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(XlsxColorUtil$.MODULE$.removeLetters((String)fontWeightStr))).foreach((Function1)(JFunction1.mcVD.sp & Serializable)value -> {
            if (value >= 700.0) {
                font.setBold(true);
                return;
            }
        }));
        cellStyles.get((Object)Style$.MODULE$.FONT_STYLE()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            String string = x$1;
            if ("italic".equals(string)) {
                font.setItalic(true);
                return;
            }
            if ("oblique".equals(string)) {
                font.setItalic(true);
                return;
            }
        });
        cs.setFont((Font)font);
    }

    public void setAlignment(XSSFCellStyle cs, XlsxBuilder.CellProperties cellProp) {
        String string = cellProp.align();
        HorizontalAlignment alignStyle = "center".equals(string) ? HorizontalAlignment.CENTER : ("right".equals(string) ? HorizontalAlignment.RIGHT : HorizontalAlignment.LEFT);
        cs.setAlignment(alignStyle);
        cs.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    public void setFormat(XSSFCellStyle cs, XlsxBuilder.CellProperties cellProperties) {
        String format = cellProperties.format().isEmpty() ? this.getDefaultFormat(cellProperties.dataType()) : (!this.isValidFormat(cellProperties.format(), cellProperties.dataType()) ? this.getDefaultFormat(cellProperties.dataType()) : cellProperties.format());
        String xlsxStandardFormat = XlsxCellFormat$.MODULE$.apply(format);
        cs.setDataFormat(this.lookupFormatCode(xlsxStandardFormat));
    }

    public void setCellBorders(XSSFCellStyle cs, Map<String, String> cellStyles) {
        this.applyStyle(Style$.MODULE$.BORDER_TOP(), cs, cellStyles);
        this.applyStyle(Style$.MODULE$.BORDER_BOTTOM(), cs, cellStyles);
        this.applyStyle(Style$.MODULE$.BORDER_LEFT(), cs, cellStyles);
        this.applyStyle(Style$.MODULE$.BORDER_RIGHT(), cs, cellStyles);
    }

    public void applyStyle(String borderName, XSSFCellStyle cs, Map<String, String> cellStyles) {
        this.getBorderInfo(borderName, cs, cellStyles).flatMap((Function1 & Serializable)info -> XlsxBorderUtil$.MODULE$.getBorderInfo(info.infoStr(), this.xBuilder.colorMap()).flatMap((Function1 & Serializable)borderInfo -> borderInfo.colorOpt().map((Function1)(JProcedure1 & Serializable)color -> {
            info.borderFn().apply((Object)borderInfo.style());
            cs.setBorderColor(info.borderSide(), color);
        })));
    }

    public Option<BorderStyleInfo> getBorderInfo(String borderName, XSSFCellStyle cs, Map<String, String> cellStyles) {
        Option option = cellStyles.get((Object)borderName);
        if (option instanceof Some) {
            String info = (String)((Some)option).value();
            String string = borderName;
            String string2 = Style$.MODULE$.BORDER_TOP();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return Some$.MODULE$.apply((Object)XlsxStyleBuilder$BorderStyleInfo$.MODULE$.apply(info, XSSFCellBorder.BorderSide.TOP, (Function1<BorderStyle, BoxedUnit>)(JProcedure1 & Serializable)x$0 -> cs.setBorderTop(x$0)));
            }
            String string4 = Style$.MODULE$.BORDER_BOTTOM();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return Some$.MODULE$.apply((Object)XlsxStyleBuilder$BorderStyleInfo$.MODULE$.apply(info, XSSFCellBorder.BorderSide.BOTTOM, (Function1<BorderStyle, BoxedUnit>)(JProcedure1 & Serializable)x$0 -> cs.setBorderBottom(x$0)));
            }
            String string6 = Style$.MODULE$.BORDER_LEFT();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return Some$.MODULE$.apply((Object)XlsxStyleBuilder$BorderStyleInfo$.MODULE$.apply(info, XSSFCellBorder.BorderSide.LEFT, (Function1<BorderStyle, BoxedUnit>)(JProcedure1 & Serializable)x$0 -> cs.setBorderLeft(x$0)));
            }
            String string8 = Style$.MODULE$.BORDER_RIGHT();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                return Some$.MODULE$.apply((Object)XlsxStyleBuilder$BorderStyleInfo$.MODULE$.apply(info, XSSFCellBorder.BorderSide.RIGHT, (Function1<BorderStyle, BoxedUnit>)(JProcedure1 & Serializable)x$0 -> cs.setBorderRight(x$0)));
            }
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    private String getDefaultFormat(Data.Type dataType) {
        Data.Type type = dataType;
        if (Data.IsoLocalTimeType$.MODULE$.equals(type)) {
            return "hh:mm:ss";
        }
        if (Data.IsoLocalDateType$.MODULE$.equals(type)) {
            return "yy-mm-dd";
        }
        if (Data.TimestampType$.MODULE$.equals(type)) {
            return "yy-mm-dd hh:mm:ss";
        }
        if (Data.DoubleType$.MODULE$.equals(type)) {
            return "0.0#";
        }
        if (Data.DecimalType$.MODULE$.equals(type)) {
            return "0.0#";
        }
        return "";
    }

    private boolean isValidFormat(String format, Data.Type dataType) {
        Data.Type type = dataType;
        if (Data.IsoLocalTimeType$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isTimeFormat(format);
        }
        if (Data.IsoLocalDateType$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isDateFormat(format);
        }
        if (Data.TimestampType$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isDateFormat(format) || FormatHelper$.MODULE$.isTimeFormat(format) || FormatHelper$.MODULE$.isDateTimeFormat(format);
        }
        if (Data.Int32Type$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isNumericFormat(format);
        }
        if (Data.Int64Type$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isNumericFormat(format);
        }
        if (Data.DoubleType$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isNumericFormat(format);
        }
        if (Data.DecimalType$.MODULE$.equals(type)) {
            return FormatHelper$.MODULE$.isNumericFormat(format);
        }
        return true;
    }

    private int lookupFormatCode(String xlsxStandardFormat) {
        return Short$.MODULE$.short2int(this.xBuilder.dataFormats().getFormat(xlsxStandardFormat));
    }

    private final /* synthetic */ Map $init$$$anonfun$2(int colIdx) {
        Map cellStyles = (Map)this.RelatedRowStyles.flatMap((Function1 & Serializable)_$3 -> (IterableOnce)_$3.cells().lift().apply((Object)BoxesRunTime.boxToInteger((int)colIdx))).foldLeft(XlsxStyleBuilder$.ambience$adhocreport$export$xlsx$builder$util$XlsxStyleBuilder$$$EmptyMap, (Function2 & Serializable)(acc, r) -> (Map)acc.$plus$plus((IterableOnce)r));
        return (Map)this.RowStyleMap().$plus$plus((IterableOnce)cellStyles);
    }

    private static final XlsxBuilder.CellProperties $anonfun$3() {
        return XlsxBuilder$CellProperties$.MODULE$.apply(XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$1(), XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$2(), XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$3(), XlsxBuilder$CellProperties$.MODULE$.$lessinit$greater$default$4());
    }

    private static final String $anonfun$4() {
        return "";
    }

    public static final class BorderInfo
    implements Product,
    Serializable {
        private final double width;
        private final String style;
        private final Option colorOpt;

        public static BorderInfo apply(double d, String string, Option<XSSFColor> option) {
            return XlsxStyleBuilder$BorderInfo$.MODULE$.apply(d, string, option);
        }

        public static BorderInfo fromProduct(Product product) {
            return XlsxStyleBuilder$BorderInfo$.MODULE$.fromProduct(product);
        }

        public static BorderInfo unapply(BorderInfo borderInfo) {
            return XlsxStyleBuilder$BorderInfo$.MODULE$.unapply(borderInfo);
        }

        public BorderInfo(double width, String style, Option<XSSFColor> colorOpt) {
            this.width = width;
            this.style = style;
            this.colorOpt = colorOpt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.width()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.style()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.colorOpt()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BorderInfo)) return false;
            BorderInfo borderInfo = (BorderInfo)object;
            if (this.width() != borderInfo.width()) return false;
            String string = this.style();
            String string2 = borderInfo.style();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<XSSFColor> option = this.colorOpt();
            Option<XSSFColor> option2 = borderInfo.colorOpt();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BorderInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "BorderInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToDouble((double)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "width";
                }
                case 1: {
                    return "style";
                }
                case 2: {
                    return "colorOpt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public double width() {
            return this.width;
        }

        public String style() {
            return this.style;
        }

        public Option<XSSFColor> colorOpt() {
            return this.colorOpt;
        }

        public BorderInfo copy(double width, String style, Option<XSSFColor> colorOpt) {
            return new BorderInfo(width, style, colorOpt);
        }

        public double copy$default$1() {
            return this.width();
        }

        public String copy$default$2() {
            return this.style();
        }

        public Option<XSSFColor> copy$default$3() {
            return this.colorOpt();
        }

        public double _1() {
            return this.width();
        }

        public String _2() {
            return this.style();
        }

        public Option<XSSFColor> _3() {
            return this.colorOpt();
        }
    }

    public static class BorderStyleInfo
    implements Product,
    Serializable {
        private final String infoStr;
        private final XSSFCellBorder.BorderSide borderSide;
        private final Function1 borderFn;

        public static BorderStyleInfo apply(String string, XSSFCellBorder.BorderSide borderSide, Function1<BorderStyle, BoxedUnit> function1) {
            return XlsxStyleBuilder$BorderStyleInfo$.MODULE$.apply(string, borderSide, function1);
        }

        public static BorderStyleInfo fromProduct(Product product) {
            return XlsxStyleBuilder$BorderStyleInfo$.MODULE$.fromProduct(product);
        }

        public static BorderStyleInfo unapply(BorderStyleInfo borderStyleInfo) {
            return XlsxStyleBuilder$BorderStyleInfo$.MODULE$.unapply(borderStyleInfo);
        }

        public BorderStyleInfo(String infoStr, XSSFCellBorder.BorderSide borderSide, Function1<BorderStyle, BoxedUnit> borderFn) {
            this.infoStr = infoStr;
            this.borderSide = borderSide;
            this.borderFn = borderFn;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BorderStyleInfo)) return false;
            BorderStyleInfo borderStyleInfo = (BorderStyleInfo)object;
            String string = this.infoStr();
            String string2 = borderStyleInfo.infoStr();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            XSSFCellBorder.BorderSide borderSide = this.borderSide();
            XSSFCellBorder.BorderSide borderSide2 = borderStyleInfo.borderSide();
            if (borderSide == null) {
                if (borderSide2 != null) {
                    return false;
                }
            } else if (!borderSide.equals(borderSide2)) return false;
            Function1<BorderStyle, BoxedUnit> function1 = this.borderFn();
            Function1<BorderStyle, BoxedUnit> function12 = borderStyleInfo.borderFn();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!borderStyleInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BorderStyleInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "BorderStyleInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "infoStr";
                }
                case 1: {
                    return "borderSide";
                }
                case 2: {
                    return "borderFn";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String infoStr() {
            return this.infoStr;
        }

        public XSSFCellBorder.BorderSide borderSide() {
            return this.borderSide;
        }

        public Function1<BorderStyle, BoxedUnit> borderFn() {
            return this.borderFn;
        }

        public BorderStyleInfo copy(String infoStr, XSSFCellBorder.BorderSide borderSide, Function1<BorderStyle, BoxedUnit> borderFn) {
            return new BorderStyleInfo(infoStr, borderSide, borderFn);
        }

        public String copy$default$1() {
            return this.infoStr();
        }

        public XSSFCellBorder.BorderSide copy$default$2() {
            return this.borderSide();
        }

        public Function1<BorderStyle, BoxedUnit> copy$default$3() {
            return this.borderFn();
        }

        public String _1() {
            return this.infoStr();
        }

        public XSSFCellBorder.BorderSide _2() {
            return this.borderSide();
        }

        public Function1<BorderStyle, BoxedUnit> _3() {
            return this.borderFn();
        }
    }

    public static final class Context
    implements Product,
    Serializable {
        private final RowExtract.BaseRow row;
        private final ExportXlsx.Context expContext;
        private final List cellProperties;

        public static Context apply(RowExtract.BaseRow baseRow, ExportXlsx.Context context, List<XlsxBuilder.CellProperties> list) {
            return XlsxStyleBuilder$Context$.MODULE$.apply(baseRow, context, list);
        }

        public static Context fromProduct(Product product) {
            return XlsxStyleBuilder$Context$.MODULE$.fromProduct(product);
        }

        public static Context unapply(Context context) {
            return XlsxStyleBuilder$Context$.MODULE$.unapply(context);
        }

        public Context(RowExtract.BaseRow row, ExportXlsx.Context expContext, List<XlsxBuilder.CellProperties> cellProperties) {
            this.row = row;
            this.expContext = expContext;
            this.cellProperties = cellProperties;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Context)) return false;
            Context context = (Context)object;
            RowExtract.BaseRow baseRow = this.row();
            RowExtract.BaseRow baseRow2 = context.row();
            if (baseRow == null) {
                if (baseRow2 != null) {
                    return false;
                }
            } else if (!baseRow.equals(baseRow2)) return false;
            ExportXlsx.Context context2 = this.expContext();
            ExportXlsx.Context context3 = context.expContext();
            if (context2 == null) {
                if (context3 != null) {
                    return false;
                }
            } else if (!((Object)context2).equals(context3)) return false;
            List<XlsxBuilder.CellProperties> list = this.cellProperties();
            List<XlsxBuilder.CellProperties> list2 = context.cellProperties();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Context;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Context";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "row";
                }
                case 1: {
                    return "expContext";
                }
                case 2: {
                    return "cellProperties";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RowExtract.BaseRow row() {
            return this.row;
        }

        public ExportXlsx.Context expContext() {
            return this.expContext;
        }

        public List<XlsxBuilder.CellProperties> cellProperties() {
            return this.cellProperties;
        }

        public Context copy(RowExtract.BaseRow row, ExportXlsx.Context expContext, List<XlsxBuilder.CellProperties> cellProperties) {
            return new Context(row, expContext, cellProperties);
        }

        public RowExtract.BaseRow copy$default$1() {
            return this.row();
        }

        public ExportXlsx.Context copy$default$2() {
            return this.expContext();
        }

        public List<XlsxBuilder.CellProperties> copy$default$3() {
            return this.cellProperties();
        }

        public RowExtract.BaseRow _1() {
            return this.row();
        }

        public ExportXlsx.Context _2() {
            return this.expContext();
        }

        public List<XlsxBuilder.CellProperties> _3() {
            return this.cellProperties();
        }
    }

    public static final class RGB
    implements Product,
    Serializable {
        private final int r;
        private final int g;
        private final int b;

        public static RGB apply(int n, int n2, int n3) {
            return XlsxStyleBuilder$RGB$.MODULE$.apply(n, n2, n3);
        }

        public static RGB fromProduct(Product product) {
            return XlsxStyleBuilder$RGB$.MODULE$.fromProduct(product);
        }

        public static RGB unapply(RGB rGB) {
            return XlsxStyleBuilder$RGB$.MODULE$.unapply(rGB);
        }

        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.r());
            n = Statics.mix((int)n, (int)this.g());
            n = Statics.mix((int)n, (int)this.b());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RGB)) return false;
            RGB rGB = (RGB)object;
            if (this.r() != rGB.r()) return false;
            if (this.g() != rGB.g()) return false;
            if (this.b() != rGB.b()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RGB;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RGB";
        }

        public Object productElement(int n) {
            int n2 = n;
            return BoxesRunTime.boxToInteger((int)(switch (n2) {
                case 0 -> this._1();
                case 1 -> this._2();
                case 2 -> this._3();
                default -> throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }));
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "r";
                }
                case 1: {
                    return "g";
                }
                case 2: {
                    return "b";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int r() {
            return this.r;
        }

        public int g() {
            return this.g;
        }

        public int b() {
            return this.b;
        }

        public RGB copy(int r, int g, int b) {
            return new RGB(r, g, b);
        }

        public int copy$default$1() {
            return this.r();
        }

        public int copy$default$2() {
            return this.g();
        }

        public int copy$default$3() {
            return this.b();
        }

        public int _1() {
            return this.r();
        }

        public int _2() {
            return this.g();
        }

        public int _3() {
            return this.b();
        }
    }
}

