/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.report.render;

import ambience.adhocreport.AdHocReportModule;
import ambience.adhocreport.Model;
import ambience.adhocreport.Util$;
import ambience.adhocreport.export.UnitDim;
import ambience.adhocreport.report.agg.pagination.PageManager;
import ambience.adhocreport.report.db.AdhocReportDB$;
import ambience.adhocreport.report.render.ReportRenderer$;
import ambience.adhocreport.report.render.ReportRenderer$RenderContext$;
import ambience.adhocreport.report.render.ReportRenderer$TextContentWidth$;
import ambience.adhocreport.report.render.TextWidthCalculator$;
import ambience.adhocreport.report.render.html.ReportBuilder;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.Format;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.vdom.VNode;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class ReportRenderer {
    private final AdHocReportModule.AdhocReportContext cxt;
    private final Data.Schema schema;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ReportRenderer$.class.getDeclaredField("log$lzy1"));

    public static Option<ReportBuilder> getReportBuilder(Model.LayoutType layoutType) {
        return ReportRenderer$.MODULE$.getReportBuilder(layoutType);
    }

    public static LoggingInterface log() {
        return ReportRenderer$.MODULE$.log();
    }

    public ReportRenderer(AdHocReportModule.AdhocReportContext cxt, Data.Schema schema) {
        this.cxt = cxt;
        this.schema = schema;
    }

    public Task<Either<LogMessage, VNode>> buildReport() {
        Option<ReportBuilder> option = ReportRenderer$.MODULE$.getReportBuilder(this.cxt.request().layoutType());
        if (option instanceof Some) {
            ReportBuilder reportBuilder = (ReportBuilder)((Some)option).value();
            return new PageManager(this.cxt.request(), reportBuilder, this.schema).getRowIndexingResult().flatMap((Function1 & Serializable)pageInfo -> this.getDocs(this.cxt.request(), reportBuilder, (PageManager.PageInfo)pageInfo, this.cxt.user()).flatMap((Function1 & Serializable)docs -> this.getLongContent(this.cxt.request(), reportBuilder, this.schema, this.cxt.user()).flatMap((Function1 & Serializable)longContents -> Task$.MODULE$.apply(() -> this.buildReport$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(docs, reportBuilder, pageInfo, longContents)).map((Function1 & Serializable)report -> report))));
        }
        if (None$.MODULE$.equals(option)) {
            return this.errGetReportBuilder(this.cxt.request().layoutType());
        }
        throw new MatchError(option);
    }

    public Task<List<TextContentWidth>> getLongContent(Model.ReportRequest request, ReportBuilder reportBuilder, Data.Schema schema, UserDB.User user) {
        List<ReportBuilder.LongTextAgg> lsAgg = reportBuilder.buildAggLongText(this.cxt.request(), schema);
        List allLongTextTasks = lsAgg.map((Function1 & Serializable)textAgg -> {
            Observable<Document> result = AdhocReportDB$.MODULE$.fetchReportData(request.cltnName(), textAgg.agg(), user);
            return result.toListL().map((Function1 & Serializable)docs -> {
                List contents = docs.flatMap((Function1 & Serializable)doc -> BsonUtils$.MODULE$.get(doc, "_id"));
                Tuple2<BsonValue, UnitDim.Dim> tuple2 = TextWidthCalculator$.MODULE$.getWidestText((List<BsonValue>)contents);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                BsonValue bson = (BsonValue)tuple2._1();
                UnitDim.Dim textWidth = (UnitDim.Dim)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)bson, (Object)textWidth);
                BsonValue bson2 = (BsonValue)tuple22._1();
                UnitDim.Dim textWidth2 = (UnitDim.Dim)tuple22._2();
                return ReportRenderer$TextContentWidth$.MODULE$.apply(textAgg.fieldName(), bson2, textWidth2);
            });
        });
        return Task$.MODULE$.sequence((Iterable)allLongTextTasks, BuildFrom$.MODULE$.buildFromIterableOps());
    }

    public Task<List<Document>> getDocs(Model.ReportRequest request, ReportBuilder reportBuilder, PageManager.PageInfo pageInfo, UserDB.User user) {
        List<Bson> agg = reportBuilder.buildAgg(request, pageInfo, this.schema);
        return AdhocReportDB$.MODULE$.fetchReportData(request.cltnName(), agg, user).toListL();
    }

    private Left<LogMessage.Error, VNode> errBuildReport(int docsLength, int limitRecords) {
        return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unable to render report. Total records(" + docsLength + ") over limit (" + limitRecords + ")"));
    }

    private Task<Left<LogMessage.Error, Nothing$>> errGetReportBuilder(Model.LayoutType layoutType) {
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unable to build report for layout type:" + layoutType)));
    }

    private Right<LogMessage.Error, VNode> buildReport(ReportBuilder builder, List<Document> docs, PageManager.PageInfo pageInfo, List<TextContentWidth> longContents) {
        RenderContext renderCxt = this.buildRenderContext(this.cxt.request(), this.schema, pageInfo, longContents);
        List docs2 = docs.map((Function1 & Serializable)doc -> this.handleId(this.cxt.request().hasOriginalId(), (Document)doc));
        return package$.MODULE$.Right().apply((Object)builder.buildReport((List<Document>)docs2, renderCxt));
    }

    private RenderContext buildRenderContext(Model.ReportRequest request, Data.Schema schema, PageManager.PageInfo rowIndexingResult, List<TextContentWidth> longContents) {
        return ReportRenderer$RenderContext$.MODULE$.apply((List<Model.AdhocField>)request.adhocFields(), (List<Model.DimGroup>)request.groups(), (List<Model.DimField>)request.fields(), schema, request.getDisplay(), request.preview(), request.tableProperties(), request.timeZone(), Format.Context$.MODULE$.apply(request.calendar()), rowIndexingResult, request.drillDownPath(), (List<Model.Derivative>)request.derivatives(), longContents);
    }

    private Document handleId(boolean hasOriginalId, Document doc) {
        if (hasOriginalId) {
            Option option = doc.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).get((Object)Util$.MODULE$.OriginalId());
            if (option instanceof Some) {
                BsonValue v = (BsonValue)((Some)option).value();
                return (Document)((BaseDocument)doc.filterKeys((Function1 & Serializable)_$7 -> {
                    String string = _$7;
                    String string2 = Util$.MODULE$.Id();
                    return string == null ? string2 != null : !string.equals(string2);
                })).updated(Util$.MODULE$.Id(), (Object)v, (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            }
            if (None$.MODULE$.equals(option)) {
                return doc;
            }
            throw new MatchError((Object)option);
        }
        return doc;
    }

    private final Either buildReport$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(List docs$2, ReportBuilder reportBuilder$4, PageManager.PageInfo pageInfo$3, List longContents$1) {
        if (docs$2.length() > this.cxt.limitRecords()) {
            return this.errBuildReport(docs$2.length(), this.cxt.limitRecords());
        }
        return this.buildReport(reportBuilder$4, (List<Document>)docs$2, pageInfo$3, (List<TextContentWidth>)longContents$1);
    }

    public static final class RenderContext
    implements Product,
    Serializable {
        private final List adhocFields;
        private final List groups;
        private final List fields;
        private final Data.Schema schema;
        private final Model.Display display;
        private final Model.Preview preview;
        private final Model.TableProperties tableProperties;
        private final String timeZone;
        private final Format.Context formatCxt;
        private final PageManager.PageInfo pageInfo;
        private final Model.Path drillDownPath;
        private final List derivatives;
        private final List longContents;

        public static RenderContext apply(List<Model.AdhocField> list, List<Model.DimGroup> list2, List<Model.DimField> list3, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String string, Format.Context context, PageManager.PageInfo pageInfo, Model.Path path, List<Model.Derivative> list4, List<TextContentWidth> list5) {
            return ReportRenderer$RenderContext$.MODULE$.apply(list, list2, list3, schema, display, preview, tableProperties, string, context, pageInfo, path, list4, list5);
        }

        public static RenderContext fromProduct(Product product) {
            return ReportRenderer$RenderContext$.MODULE$.fromProduct(product);
        }

        public static RenderContext unapply(RenderContext renderContext) {
            return ReportRenderer$RenderContext$.MODULE$.unapply(renderContext);
        }

        public RenderContext(List<Model.AdhocField> adhocFields, List<Model.DimGroup> groups, List<Model.DimField> fields, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String timeZone, Format.Context formatCxt, PageManager.PageInfo pageInfo, Model.Path drillDownPath, List<Model.Derivative> derivatives, List<TextContentWidth> longContents) {
            this.adhocFields = adhocFields;
            this.groups = groups;
            this.fields = fields;
            this.schema = schema;
            this.display = display;
            this.preview = preview;
            this.tableProperties = tableProperties;
            this.timeZone = timeZone;
            this.formatCxt = formatCxt;
            this.pageInfo = pageInfo;
            this.drillDownPath = drillDownPath;
            this.derivatives = derivatives;
            this.longContents = longContents;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RenderContext)) return false;
            RenderContext renderContext = (RenderContext)object;
            List<Model.AdhocField> list = this.adhocFields();
            List<Model.AdhocField> list2 = renderContext.adhocFields();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<Model.DimGroup> list3 = this.groups();
            List<Model.DimGroup> list4 = renderContext.groups();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            List<Model.DimField> list5 = this.fields();
            List<Model.DimField> list6 = renderContext.fields();
            if (list5 == null) {
                if (list6 != null) {
                    return false;
                }
            } else if (!list5.equals(list6)) return false;
            Data.Schema schema = this.schema();
            Data.Schema schema2 = renderContext.schema();
            if (schema == null) {
                if (schema2 != null) {
                    return false;
                }
            } else if (!schema.equals(schema2)) return false;
            Model.Display display = this.display();
            Model.Display display2 = renderContext.display();
            if (display == null) {
                if (display2 != null) {
                    return false;
                }
            } else if (!display.equals(display2)) return false;
            Model.Preview preview = this.preview();
            Model.Preview preview2 = renderContext.preview();
            if (preview == null) {
                if (preview2 != null) {
                    return false;
                }
            } else if (!preview.equals(preview2)) return false;
            Model.TableProperties tableProperties = this.tableProperties();
            Model.TableProperties tableProperties2 = renderContext.tableProperties();
            if (tableProperties == null) {
                if (tableProperties2 != null) {
                    return false;
                }
            } else if (!tableProperties.equals(tableProperties2)) return false;
            String string = this.timeZone();
            String string2 = renderContext.timeZone();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Format.Context context = this.formatCxt();
            Format.Context context2 = renderContext.formatCxt();
            if (context == null) {
                if (context2 != null) {
                    return false;
                }
            } else if (!context.equals(context2)) return false;
            PageManager.PageInfo pageInfo = this.pageInfo();
            PageManager.PageInfo pageInfo2 = renderContext.pageInfo();
            if (pageInfo == null) {
                if (pageInfo2 != null) {
                    return false;
                }
            } else if (!((Object)pageInfo).equals(pageInfo2)) return false;
            Model.Path path = this.drillDownPath();
            Model.Path path2 = renderContext.drillDownPath();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            List<Model.Derivative> list7 = this.derivatives();
            List<Model.Derivative> list8 = renderContext.derivatives();
            if (list7 == null) {
                if (list8 != null) {
                    return false;
                }
            } else if (!list7.equals(list8)) return false;
            List<TextContentWidth> list9 = this.longContents();
            List<TextContentWidth> list10 = renderContext.longContents();
            if (list9 == null) {
                if (list10 == null) return true;
                return false;
            } else {
                if (!list9.equals(list10)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RenderContext;
        }

        public int productArity() {
            return 13;
        }

        public String productPrefix() {
            return "RenderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return this._12();
                }
                case 12: {
                    return this._13();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "adhocFields";
                }
                case 1: {
                    return "groups";
                }
                case 2: {
                    return "fields";
                }
                case 3: {
                    return "schema";
                }
                case 4: {
                    return "display";
                }
                case 5: {
                    return "preview";
                }
                case 6: {
                    return "tableProperties";
                }
                case 7: {
                    return "timeZone";
                }
                case 8: {
                    return "formatCxt";
                }
                case 9: {
                    return "pageInfo";
                }
                case 10: {
                    return "drillDownPath";
                }
                case 11: {
                    return "derivatives";
                }
                case 12: {
                    return "longContents";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Model.AdhocField> adhocFields() {
            return this.adhocFields;
        }

        public List<Model.DimGroup> groups() {
            return this.groups;
        }

        public List<Model.DimField> fields() {
            return this.fields;
        }

        public Data.Schema schema() {
            return this.schema;
        }

        public Model.Display display() {
            return this.display;
        }

        public Model.Preview preview() {
            return this.preview;
        }

        public Model.TableProperties tableProperties() {
            return this.tableProperties;
        }

        public String timeZone() {
            return this.timeZone;
        }

        public Format.Context formatCxt() {
            return this.formatCxt;
        }

        public PageManager.PageInfo pageInfo() {
            return this.pageInfo;
        }

        public Model.Path drillDownPath() {
            return this.drillDownPath;
        }

        public List<Model.Derivative> derivatives() {
            return this.derivatives;
        }

        public List<TextContentWidth> longContents() {
            return this.longContents;
        }

        public Option<Model.AdhocField> getAdhocField(String fieldName) {
            return this.adhocFields().find(arg_0 -> ReportRenderer$.ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$getAdhocField$$anonfun$1(fieldName, arg_0));
        }

        public int totalColumns() {
            return this.groups().length() + this.fields().length();
        }

        public boolean isDisplay(Model.Display display) {
            Model.Display display2 = this.display();
            Model.Display display3 = display;
            return !(display2 != null ? !display2.equals(display3) : display3 != null);
        }

        public Option<Json> getFieldProp(int idx) {
            return ((Option)this.fields().lift().apply((Object)BoxesRunTime.boxToInteger((int)idx))).map(ReportRenderer$::ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$getFieldProp$$anonfun$1);
        }

        public Data.Type getFieldType(String fieldName) {
            Option dtOpt1 = this.schema().fields().find(arg_0 -> ReportRenderer$.ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$_$$anonfun$4(fieldName, arg_0)).map(ReportRenderer$::ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$_$$anonfun$5);
            Option dtOpt2 = this.derivatives().find(arg_0 -> ReportRenderer$.ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$_$$anonfun$6(fieldName, arg_0)).map(ReportRenderer$::ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$_$$anonfun$7);
            return (Data.Type)dtOpt1.getOrElse(() -> ReportRenderer$.ambience$adhocreport$report$render$ReportRenderer$RenderContext$$_$getFieldType$$anonfun$1(dtOpt2));
        }

        public RenderContext copy(List<Model.AdhocField> adhocFields, List<Model.DimGroup> groups, List<Model.DimField> fields, Data.Schema schema, Model.Display display, Model.Preview preview, Model.TableProperties tableProperties, String timeZone, Format.Context formatCxt, PageManager.PageInfo pageInfo, Model.Path drillDownPath, List<Model.Derivative> derivatives, List<TextContentWidth> longContents) {
            return new RenderContext(adhocFields, groups, fields, schema, display, preview, tableProperties, timeZone, formatCxt, pageInfo, drillDownPath, derivatives, longContents);
        }

        public List<Model.AdhocField> copy$default$1() {
            return this.adhocFields();
        }

        public List<Model.DimGroup> copy$default$2() {
            return this.groups();
        }

        public List<Model.DimField> copy$default$3() {
            return this.fields();
        }

        public Data.Schema copy$default$4() {
            return this.schema();
        }

        public Model.Display copy$default$5() {
            return this.display();
        }

        public Model.Preview copy$default$6() {
            return this.preview();
        }

        public Model.TableProperties copy$default$7() {
            return this.tableProperties();
        }

        public String copy$default$8() {
            return this.timeZone();
        }

        public Format.Context copy$default$9() {
            return this.formatCxt();
        }

        public PageManager.PageInfo copy$default$10() {
            return this.pageInfo();
        }

        public Model.Path copy$default$11() {
            return this.drillDownPath();
        }

        public List<Model.Derivative> copy$default$12() {
            return this.derivatives();
        }

        public List<TextContentWidth> copy$default$13() {
            return this.longContents();
        }

        public List<Model.AdhocField> _1() {
            return this.adhocFields();
        }

        public List<Model.DimGroup> _2() {
            return this.groups();
        }

        public List<Model.DimField> _3() {
            return this.fields();
        }

        public Data.Schema _4() {
            return this.schema();
        }

        public Model.Display _5() {
            return this.display();
        }

        public Model.Preview _6() {
            return this.preview();
        }

        public Model.TableProperties _7() {
            return this.tableProperties();
        }

        public String _8() {
            return this.timeZone();
        }

        public Format.Context _9() {
            return this.formatCxt();
        }

        public PageManager.PageInfo _10() {
            return this.pageInfo();
        }

        public Model.Path _11() {
            return this.drillDownPath();
        }

        public List<Model.Derivative> _12() {
            return this.derivatives();
        }

        public List<TextContentWidth> _13() {
            return this.longContents();
        }
    }

    public static final class TextContentWidth
    implements Product,
    Serializable {
        private final String fieldName;
        private final BsonValue bson;
        private final UnitDim.Dim width;

        public static TextContentWidth apply(String string, BsonValue bsonValue, UnitDim.Dim dim) {
            return ReportRenderer$TextContentWidth$.MODULE$.apply(string, bsonValue, dim);
        }

        public static TextContentWidth fromProduct(Product product) {
            return ReportRenderer$TextContentWidth$.MODULE$.fromProduct(product);
        }

        public static TextContentWidth unapply(TextContentWidth textContentWidth) {
            return ReportRenderer$TextContentWidth$.MODULE$.unapply(textContentWidth);
        }

        public TextContentWidth(String fieldName, BsonValue bson, UnitDim.Dim width) {
            this.fieldName = fieldName;
            this.bson = bson;
            this.width = width;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TextContentWidth)) return false;
            TextContentWidth textContentWidth = (TextContentWidth)object;
            String string = this.fieldName();
            String string2 = textContentWidth.fieldName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            BsonValue bsonValue = this.bson();
            BsonValue bsonValue2 = textContentWidth.bson();
            if (bsonValue == null) {
                if (bsonValue2 != null) {
                    return false;
                }
            } else if (!bsonValue.equals(bsonValue2)) return false;
            UnitDim.Dim dim = this.width();
            UnitDim.Dim dim2 = textContentWidth.width();
            if (dim == null) {
                if (dim2 == null) return true;
                return false;
            } else {
                if (!dim.equals(dim2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TextContentWidth;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "TextContentWidth";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return new Model.FieldName(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "fieldName";
                }
                case 1: {
                    return "bson";
                }
                case 2: {
                    return "width";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String fieldName() {
            return this.fieldName;
        }

        public BsonValue bson() {
            return this.bson;
        }

        public UnitDim.Dim width() {
            return this.width;
        }

        public TextContentWidth copy(String fieldName, BsonValue bson, UnitDim.Dim width) {
            return new TextContentWidth(fieldName, bson, width);
        }

        public String copy$default$1() {
            return this.fieldName();
        }

        public BsonValue copy$default$2() {
            return this.bson();
        }

        public UnitDim.Dim copy$default$3() {
            return this.width();
        }

        public String _1() {
            return this.fieldName();
        }

        public BsonValue _2() {
            return this.bson();
        }

        public UnitDim.Dim _3() {
            return this.width();
        }
    }
}

