/*
 * Decompiled with CFR 0.152.
 */
package ambience.adhocreport.report.render.html;

import ambience.adhocreport.CellType;
import ambience.adhocreport.Model;
import ambience.adhocreport.export.UnitDim;
import ambience.adhocreport.report.render.ReportRenderer;
import ambience.adhocreport.report.render.html.LayoutHelper$ColumnHeader$;
import ambience.adhocreport.report.render.html.rowrec.RecCell;
import ambience.adhocreport.report.stream.RowType;
import ambience.adhocreport.report.stream.RowType$AllHeader$;
import com.elixirtech.coredata.Data;
import com.elixirtech.vdom.mutable.VElement;
import com.elixirtech.vdom.mutable.VElement$;
import com.elixirtech.vdom.mutable.package$;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public interface LayoutHelper {
    public static void $init$(LayoutHelper $this) {
    }

    public static VElement buildTitle$(LayoutHelper $this, String text, Option colspan) {
        return $this.buildTitle(text, (Option<Object>)colspan);
    }

    default public VElement buildTitle(String text, Option<Object> colspan) {
        VElement vElement;
        Option<Object> option = colspan;
        if (option instanceof Some) {
            int v = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            vElement = this.buildCell(text, this.buildCell$default$2(), this.buildCell$default$3(), this.buildCell$default$4()).attr("colspan", BoxesRunTime.boxToInteger((int)v).toString());
        } else if (None$.MODULE$.equals(option)) {
            vElement = this.buildCell(text, this.buildCell$default$2(), this.buildCell$default$3(), this.buildCell$default$4());
        } else {
            throw new MatchError(option);
        }
        VElement titleCell = vElement;
        return this.buildTR((Seq<VElement>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new VElement[]{titleCell})).addClass("report-title");
    }

    public static Option buildTitle$default$2$(LayoutHelper $this) {
        return $this.buildTitle$default$2();
    }

    default public Option<Object> buildTitle$default$2() {
        return None$.MODULE$;
    }

    public static VElement buildColumnHeader$(LayoutHelper $this, List dimBase, ReportRenderer.RenderContext renderCxt) {
        return $this.buildColumnHeader((List<Model.DimFieldBase>)dimBase, renderCxt);
    }

    default public VElement buildColumnHeader(List<Model.DimFieldBase> dimBase, ReportRenderer.RenderContext renderCxt) {
        List columnHeaders = dimBase.map((Function1 & Serializable)field -> this.toColumnHeader((Model.DimFieldBase)field));
        List columnCells = columnHeaders.map((Function1 & Serializable)col -> {
            Option widthOpt = renderCxt.longContents().find((Function1 & Serializable)_$1 -> {
                String string = _$1.fieldName();
                String string2 = col.label();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).map((Function1 & Serializable)_$2 -> _$2.width());
            return this.buildCell(col.label(), col.align(), this.buildCell$default$3(), (Option<UnitDim.Dim>)widthOpt);
        });
        return this.buildTR((Seq<VElement>)columnCells).addClass("report-column-header");
    }

    public static ColumnHeader toColumnHeader$(LayoutHelper $this, Model.DimFieldBase field) {
        return $this.toColumnHeader(field);
    }

    default public ColumnHeader toColumnHeader(Model.DimFieldBase field) {
        String align = field.columnProperties().alignment();
        String label = field.columnProperties().label();
        return LayoutHelper$ColumnHeader$.MODULE$.apply(label, align);
    }

    public static String getAllHFCss$(LayoutHelper $this, RowType.RowType rType, int level) {
        return $this.getAllHFCss(rType, level);
    }

    default public String getAllHFCss(RowType.RowType rType, int level) {
        RowType.RowType rowType = rType;
        RowType$AllHeader$ rowType$AllHeader$ = RowType$AllHeader$.MODULE$;
        String hf = !(rowType != null ? !rowType.equals(rowType$AllHeader$) : rowType$AllHeader$ != null) ? "header" : "footer";
        return "report-all-" + hf;
    }

    public static String getAllFooterCss$(LayoutHelper $this) {
        return $this.getAllFooterCss();
    }

    default public String getAllFooterCss() {
        return "report-all-footer";
    }

    public static VElement buildHeader$(LayoutHelper $this, List groupCells, List fieldCells, int level) {
        return $this.buildHeader((List<RecCell>)groupCells, (List<RecCell>)fieldCells, level);
    }

    default public VElement buildHeader(List<RecCell> groupCells, List<RecCell> fieldCells, int level) {
        return this.buildHF(groupCells, fieldCells).addClass("report-group-header level-" + level);
    }

    public static VElement buildFooter$(LayoutHelper $this, List groupCells, List fieldCells, int level) {
        return $this.buildFooter((List<RecCell>)groupCells, (List<RecCell>)fieldCells, level);
    }

    default public VElement buildFooter(List<RecCell> groupCells, List<RecCell> fieldCells, int level) {
        return this.buildHF(groupCells, fieldCells).addClass("report-group-footer level-" + level);
    }

    public static VElement buildHF$(LayoutHelper $this, List groups, List fields) {
        return $this.buildHF((List<RecCell>)groups, (List<RecCell>)fields);
    }

    default public VElement buildHF(List<RecCell> groups, List<RecCell> fields) {
        List groupCells = groups.map((Function1 & Serializable)rec -> this.buildHFCell((RecCell)rec));
        List fnCells = fields.map((Function1 & Serializable)rec -> this.buildHFCell((RecCell)rec));
        List cells = (List)groupCells.$plus$plus((IterableOnce)fnCells);
        return this.buildTR((Seq<VElement>)cells);
    }

    public static VElement buildRow$(LayoutHelper $this, List fieldCells, int padding) {
        return $this.buildRow((List<RecCell>)fieldCells, padding);
    }

    default public VElement buildRow(List<RecCell> fieldCells, int padding) {
        List cells = (List)this.buildBlankCells(padding).$plus$plus((IterableOnce)fieldCells.map((Function1 & Serializable)rec -> this.buildCell((RecCell)rec)));
        return this.buildTR((Seq<VElement>)cells);
    }

    public static int buildRow$default$2$(LayoutHelper $this) {
        return $this.buildRow$default$2();
    }

    default public int buildRow$default$2() {
        return 0;
    }

    public static VElement buildCell$(LayoutHelper $this, RecCell rec) {
        return $this.buildCell(rec);
    }

    default public VElement buildCell(RecCell rec) {
        String string = rec.dataType();
        String string2 = Data.BinaryType$.MODULE$.id();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.buildCellForBinaryType(rec);
        }
        String string4 = Data.StringType$.MODULE$.id();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.buildCellForStringType(rec);
        }
        return this.buildCell(rec.value(), rec.align(), this.isBlankCell(rec), this.buildCell$default$4());
    }

    public static VElement buildCellForBinaryType$(LayoutHelper $this, RecCell rec) {
        return $this.buildCellForBinaryType(rec);
    }

    default public VElement buildCellForBinaryType(RecCell rec) {
        Option<Model.CellProperties> option = this.getCellPropOpt(rec);
        if (option instanceof Some) {
            Model.CellProperties cellProp = (Model.CellProperties)((Some)option).value();
            return this.buildCellImageBinary(rec.value(), cellProp);
        }
        return this.TD();
    }

    public static VElement buildCellForStringType$(LayoutHelper $this, RecCell rec) {
        return $this.buildCellForStringType(rec);
    }

    default public VElement buildCellForStringType(RecCell rec) {
        Option<Model.CellProperties> option = this.getCellPropOpt(rec);
        if (option instanceof Some) {
            Model.CellProperties cellProp = (Model.CellProperties)((Some)option).value();
            boolean isBlank = this.isBlankCell(cellProp);
            boolean isValidUrl = Try$.MODULE$.apply(() -> LayoutHelper.$anonfun$8(rec)).toOption().isDefined();
            if (isValidUrl) {
                return this.buildCellImageURL(rec.value(), cellProp);
            }
            return this.buildCell(rec.value(), rec.align(), isBlank, this.buildCell$default$4());
        }
        if (None$.MODULE$.equals(option)) {
            return this.buildCell(rec.value(), rec.align(), this.buildCell$default$3(), this.buildCell$default$4());
        }
        throw new MatchError(option);
    }

    public static VElement buildHFCell$(LayoutHelper $this, RecCell rec) {
        return $this.buildHFCell(rec);
    }

    default public VElement buildHFCell(RecCell rec) {
        return this.buildCell(rec.value(), rec.align(), this.isBlankCell(rec), this.buildCell$default$4());
    }

    public static boolean isBlankCell$(LayoutHelper $this, RecCell rec) {
        return $this.isBlankCell(rec);
    }

    default public boolean isBlankCell(RecCell rec) {
        return this.getCellPropOpt(rec).exists((Function1 & Serializable)cellProp -> this.isBlankCell((Model.CellProperties)cellProp));
    }

    public static boolean isBlankCell$(LayoutHelper $this, Model.CellProperties cellProp) {
        return $this.isBlankCell(cellProp);
    }

    default public boolean isBlankCell(Model.CellProperties cellProp) {
        CellType cellType = cellProp.type();
        CellType.Blank$ blank$ = CellType.Blank$.MODULE$;
        return !(cellType != null ? !cellType.equals(blank$) : blank$ != null);
    }

    public static Option getCellPropOpt$(LayoutHelper $this, RecCell rec) {
        return $this.getCellPropOpt(rec);
    }

    default public Option<Model.CellProperties> getCellPropOpt(RecCell rec) {
        return rec.cellProperties().as(Model.CellProperties$.MODULE$.decoder()).toOption();
    }

    public static VElement buildCell$(LayoutHelper $this, String value, String align, boolean isBlank, Option minWidthOpt) {
        return $this.buildCell(value, align, isBlank, (Option<UnitDim.Dim>)minWidthOpt);
    }

    default public VElement buildCell(String value, String align, boolean isBlank, Option<UnitDim.Dim> minWidthOpt) {
        if (isBlank) {
            return this.TD().text("&nbsp;");
        }
        VElement td = this.TD().addClass(this.alignClass(align));
        VElement textElem = this.textVElement(value).appendTo(td);
        minWidthOpt.foreach((Function1 & Serializable)minWidth -> textElem.css("min-width", minWidth.px() + "px"));
        return td;
    }

    public static String buildCell$default$2$(LayoutHelper $this) {
        return $this.buildCell$default$2();
    }

    default public String buildCell$default$2() {
        return "";
    }

    public static boolean buildCell$default$3$(LayoutHelper $this) {
        return $this.buildCell$default$3();
    }

    default public boolean buildCell$default$3() {
        return false;
    }

    public static Option buildCell$default$4$(LayoutHelper $this) {
        return $this.buildCell$default$4();
    }

    default public Option<UnitDim.Dim> buildCell$default$4() {
        return None$.MODULE$;
    }

    public static VElement buildCellImageBinary$(LayoutHelper $this, String value, Model.CellProperties cellProperties) {
        return $this.buildCellImageBinary(value, cellProperties);
    }

    default public VElement buildCellImageBinary(String value, Model.CellProperties cellProperties) {
        String value2;
        VElement td = this.TD();
        CellType cellType = cellProperties.type();
        Object object = CellType.Image$.MODULE$.equals(cellType) ? this.buildImageVElem(value, cellProperties).appendTo(td) : (CellType.Text$.MODULE$.equals(cellType) ? (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value2 = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(":([^;]+);")).findAllIn((CharSequence)value).mkString("")), 1))) ? package$.MODULE$.Div().text("&ltbinary" + value2 + "&gt").appendTo(td) : package$.MODULE$.Div()) : (CellType.Blank$.MODULE$.equals(cellType) ? td.text("&nbsp;") : BoxedUnit.UNIT));
        return td;
    }

    public static VElement buildCellImageURL$(LayoutHelper $this, String value, Model.CellProperties cellProperties) {
        return $this.buildCellImageURL(value, cellProperties);
    }

    default public VElement buildCellImageURL(String value, Model.CellProperties cellProperties) {
        VElement td = this.TD();
        CellType cellType = cellProperties.type();
        Object object = CellType.Image$.MODULE$.equals(cellType) ? this.buildImageVElem(value, cellProperties).appendTo(td) : (CellType.Text$.MODULE$.equals(cellType) ? this.textVElement(value).appendTo(td) : (CellType.Blank$.MODULE$.equals(cellType) ? td.text("&nbsp;") : BoxedUnit.UNIT));
        return td;
    }

    public static VElement buildImageVElem$(LayoutHelper $this, String value, Model.CellProperties cellProperties) {
        return $this.buildImageVElem(value, cellProperties);
    }

    default public VElement buildImageVElem(String value, Model.CellProperties cellProperties) {
        Model.CellProperties.Properties prop = cellProperties.properties();
        VElement elem = VElement$.MODULE$.apply("img");
        elem.attr("src", value).css("padding-top", prop.paddingTop() + "px").css("padding-right", prop.paddingRight() + "px").css("padding-bottom", prop.paddingBottom() + "px").css("padding-left", prop.paddingLeft() + "px");
        if (prop.width() > 0.0) {
            elem.css("width", prop.width() + "px");
        }
        if (prop.height() > 0.0) {
            elem.css("height", prop.height() + "px");
        }
        return elem;
    }

    public static List buildBlankCells$(LayoutHelper $this, int total) {
        return $this.buildBlankCells(total);
    }

    default public List<VElement> buildBlankCells(int total) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), total).map((Function1 & Serializable)_$3 -> this.buildBlankCells$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$3))).toList();
    }

    public static VElement buildTR$(LayoutHelper $this, Seq elems) {
        return $this.buildTR((Seq<VElement>)elems);
    }

    default public VElement buildTR(Seq<VElement> elems) {
        VElement tr = VElement$.MODULE$.apply("tr");
        elems.foreach((Function1 & Serializable)_$4 -> _$4.appendTo(tr));
        return tr;
    }

    public static VElement TD$(LayoutHelper $this) {
        return $this.TD();
    }

    default public VElement TD() {
        return VElement$.MODULE$.apply("td");
    }

    public static VElement TD$(LayoutHelper $this, String cls) {
        return $this.TD(cls);
    }

    default public VElement TD(String cls) {
        return VElement$.MODULE$.apply("td").addClass(cls);
    }

    public static VElement DIV$(LayoutHelper $this) {
        return $this.DIV();
    }

    default public VElement DIV() {
        return VElement$.MODULE$.apply("div");
    }

    public static VElement Span$(LayoutHelper $this) {
        return $this.Span();
    }

    default public VElement Span() {
        return VElement$.MODULE$.apply("span");
    }

    public static String rowStripeClass$(LayoutHelper $this, int idx) {
        return $this.rowStripeClass(idx);
    }

    default public String rowStripeClass(int idx) {
        return this.rowStripeClass(idx % 2 == 0);
    }

    public static String rowStripeClass$(LayoutHelper $this, boolean isStripe) {
        return $this.rowStripeClass(isStripe);
    }

    default public String rowStripeClass(boolean isStripe) {
        if (isStripe) {
            return "report-row-stripe";
        }
        return "report-row";
    }

    public static String alignClass$(LayoutHelper $this, String align) {
        return $this.alignClass(align);
    }

    default public String alignClass(String align) {
        if (align.isEmpty()) {
            return "";
        }
        return "cell-" + align;
    }

    public static VElement textVElement$(LayoutHelper $this, String value) {
        return $this.textVElement(value);
    }

    default public VElement textVElement(String value) {
        return package$.MODULE$.Div().text(value).addClass("text-url").attr("title", value);
    }

    private static URI $anonfun$8(RecCell rec$1) {
        return new URL(rec$1.value()).toURI();
    }

    private /* synthetic */ VElement buildBlankCells$$anonfun$1(int _$3) {
        return this.TD();
    }

    public static final class ColumnHeader
    implements Product,
    Serializable {
        private final String label;
        private final String align;

        public static ColumnHeader apply(String string, String string2) {
            return LayoutHelper$ColumnHeader$.MODULE$.apply(string, string2);
        }

        public static ColumnHeader fromProduct(Product product) {
            return LayoutHelper$ColumnHeader$.MODULE$.fromProduct(product);
        }

        public static ColumnHeader unapply(ColumnHeader columnHeader) {
            return LayoutHelper$ColumnHeader$.MODULE$.unapply(columnHeader);
        }

        public ColumnHeader(String label, String align) {
            this.label = label;
            this.align = align;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ColumnHeader)) return false;
            ColumnHeader columnHeader = (ColumnHeader)object;
            String string = this.label();
            String string2 = columnHeader.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.align();
            String string4 = columnHeader.align();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ColumnHeader;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ColumnHeader";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "label";
            }
            if (1 == n2) {
                return "align";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String label() {
            return this.label;
        }

        public String align() {
            return this.align;
        }

        public ColumnHeader copy(String label, String align) {
            return new ColumnHeader(label, align);
        }

        public String copy$default$1() {
            return this.label();
        }

        public String copy$default$2() {
            return this.align();
        }

        public String _1() {
            return this.label();
        }

        public String _2() {
            return this.align();
        }
    }
}

