/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.render.AbstractOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.MarkerData;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.StrutMetrics;
import java.awt.RenderingHints;

public class ListItemPainter {
    public static void paint(RenderingContext c, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        if (markerData == null || !c.isInPageMargins() && !ListItemPainter.isInVisiblePageArea(c, c.getPage(), markerData.getStructMetrics(), box)) {
            return;
        }
        if (markerData.getImageMarker() != null) {
            ListItemPainter.drawImage(c, box, markerData);
        } else {
            CalculatedStyle style = box.getStyle();
            IdentValue listStyle = style.getIdent(CSSName.LIST_STYLE_TYPE);
            c.getOutputDevice().setColor(style.getColor());
            if (markerData.getGlyphMarker() != null) {
                ListItemPainter.drawGlyph(c, box, style, listStyle);
            } else if (markerData.getTextMarker() != null) {
                ListItemPainter.drawText(c, box, listStyle);
            }
        }
    }

    private static void drawImage(RenderingContext c, BlockBox box, MarkerData markerData) {
        FSImage img = null;
        MarkerData.ImageMarker marker = markerData.getImageMarker();
        img = marker.getImage();
        if (img != null) {
            StrutMetrics strutMetrics = box.getMarkerData().getStructMetrics();
            int x = ListItemPainter.getReferenceX(c, box);
            c.getOutputDevice().drawImage(img, x += -marker.getLayoutWidth() + (marker.getLayoutWidth() / 2 - img.getWidth() / 2), (int)((float)ListItemPainter.getReferenceBaseline(c, box) - strutMetrics.getAscent() / 2.0f - (float)(img.getHeight() / 2)), box.getStyle().isImageRenderingInterpolate());
        }
    }

    private static int getReferenceX(RenderingContext c, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsX();
        }
        return box.getAbsX() + (int)box.getMargin(c).left();
    }

    private static int getReferenceBaseline(RenderingContext c, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        StrutMetrics strutMetrics = box.getMarkerData().getStructMetrics();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsY() + strutMetrics.getBaseline();
        }
        return box.getAbsY() + box.getTy() + strutMetrics.getBaseline();
    }

    private static void drawGlyph(RenderingContext c, BlockBox box, CalculatedStyle style, IdentValue listStyle) {
        Object aa_key = c.getOutputDevice().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        c.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MarkerData markerData = box.getMarkerData();
        StrutMetrics strutMetrics = markerData.getStructMetrics();
        MarkerData.GlyphMarker marker = markerData.getGlyphMarker();
        int x = ListItemPainter.getReferenceX(c, box);
        if (style.getDirection() == IdentValue.LTR) {
            x = (int)((double)x + ((double)(-marker.getLayoutWidth()) + (double)marker.getDiameter() * 1.1));
        }
        if (style.getDirection() == IdentValue.RTL) {
            x = (int)((double)x + ((double)markerData.getReferenceLine().getWidth() + (double)marker.getDiameter() * 1.1));
        }
        int bottomLine = ListItemPainter.getReferenceBaseline(c, box);
        int top = bottomLine - (int)((double)strutMetrics.getAscent() / 1.5);
        int y = bottomLine - (bottomLine - top) / 2 - marker.getDiameter() / 2;
        if (listStyle == IdentValue.DISC) {
            c.getOutputDevice().fillOval(x, y, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.SQUARE) {
            c.getOutputDevice().fillRect(x, y, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.CIRCLE) {
            c.getOutputDevice().drawOval(x, y, marker.getDiameter(), marker.getDiameter());
        }
        c.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa_key == null ? RenderingHints.VALUE_ANTIALIAS_DEFAULT : aa_key);
    }

    private static boolean isInVisiblePageArea(RenderingContext c, PageBox page, StrutMetrics metrics, BlockBox box) {
        float bs = ListItemPainter.getReferenceBaseline(c, box);
        float topY = bs - metrics.getAscent();
        float bottomY = bs + metrics.getDescent();
        float pageTop = page.getPaintingTop();
        float pageBottom = page.getPaintingBottom();
        return topY >= pageTop && topY <= pageBottom || bottomY >= pageTop && bottomY <= pageBottom;
    }

    private static void drawText(RenderingContext c, BlockBox box, IdentValue listStyle) {
        MarkerData.TextMarker text = box.getMarkerData().getTextMarker();
        int x = ListItemPainter.getReferenceX(c, box);
        int y = ListItemPainter.getReferenceBaseline(c, box);
        MarkerData markerData = box.getMarkerData();
        IdentValue direction = box.getParent().getStyle().getDirection();
        if (direction == IdentValue.RTL) {
            x = markerData.getReferenceLine() != null ? x + markerData.getReferenceLine().getWidth() : box.getParent().getAbsX() + box.getParent().getWidth() - (int)box.getParent().getPadding(c).right();
        } else {
            assert (direction == IdentValue.LTR || direction == IdentValue.AUTO);
            x += -text.getLayoutWidth();
        }
        c.getOutputDevice().setColor(box.getStyle().getColor());
        if (c.getOutputDevice() instanceof AbstractOutputDevice) {
            ((AbstractOutputDevice)c.getOutputDevice()).setFontSpecification(box.getStyle().getFontSpecification());
        }
        c.getOutputDevice().setFont(box.getStyle().getFSFont(c));
        c.getTextRenderer().drawString(c.getOutputDevice(), text.getText(), x, y);
    }
}

