/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.batches;

import monix.tail.batches.Batch;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.collection.immutable.Seq;

public final class SeqBatch<A>
extends Batch<A> {
    private final Seq<A> ref;
    private final int recommendedBatchSize;

    public SeqBatch(Seq<A> ref, int recommendedBatchSize) {
        this.ref = ref;
        this.recommendedBatchSize = recommendedBatchSize;
    }

    @Override
    public BatchCursor<A> cursor() {
        return BatchCursor$.MODULE$.fromSeq(this.ref, this.recommendedBatchSize);
    }

    @Override
    public Batch<A> take(int n) {
        return new SeqBatch<A>((Seq)this.ref.take(n), this.recommendedBatchSize);
    }

    @Override
    public Batch<A> drop(int n) {
        return new SeqBatch<A>((Seq)this.ref.drop(n), this.recommendedBatchSize);
    }

    @Override
    public Batch<A> slice(int from, int until) {
        return new SeqBatch<A>((Seq)this.ref.slice(from, until), this.recommendedBatchSize);
    }

    @Override
    public <B> Batch<B> map(Function1<A, B> f) {
        return new SeqBatch<A>((Seq)this.ref.map(f), this.recommendedBatchSize);
    }

    @Override
    public Batch<A> filter(Function1<A, Object> p) {
        return new SeqBatch<A>((Seq)this.ref.filter(p), this.recommendedBatchSize);
    }

    @Override
    public <B> Batch<B> collect(PartialFunction<A, B> pf) {
        return new SeqBatch<A>((Seq)this.ref.collect(pf), this.recommendedBatchSize);
    }

    @Override
    public <R> R foldLeft(R initial, Function2<R, A, R> op) {
        return (R)this.ref.foldLeft(initial, op);
    }
}

