/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Last$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.batches.BatchCursor$;
import monix.tail.internal.IterantScan$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;

public final class IterantScan {
    public static <F, A, S> Iterant<F, S> apply(Iterant<F, A> iterant, Function0<S> function0, Function2<S, A, S> function2, Sync<F> sync) {
        return IterantScan$.MODULE$.apply(iterant, function0, function2, sync);
    }

    public static class Loop<F, A, S>
    extends Iterant.Visitor<F, A, Iterant<F, S>> {
        private final Function2<S, A, S> f;
        private final Sync<F> F;
        private S state;
        private ChunkedArrayStack<F> stackRef;

        public Loop(S initial, Function2<S, A, S> f, Sync<F> F) {
            this.f = f;
            this.F = F;
            this.state = initial;
        }

        private void stackPush(F item) {
            if (this.stackRef == null) {
                this.stackRef = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
            }
            this.stackRef.push(item);
        }

        private F stackPop() {
            return (F)(this.stackRef != null ? this.stackRef.pop() : null);
        }

        @Override
        public Iterant<F, S> visit(Iterant.Next<F, A> ref) {
            this.state = this.f.apply(this.state, ref.item());
            return Iterant$Next$.MODULE$.apply(this.state, package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, S> visit(Iterant.NextBatch<F, A> ref) {
            return this.processCursor(ref.batch().cursor(), ref.rest());
        }

        @Override
        public Iterant<F, S> visit(Iterant.NextCursor<F, A> ref) {
            return this.processCursor(ref.cursor(), ref.rest());
        }

        @Override
        public Iterant<F, S> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, S> visit(Iterant.Concat<F, A> ref) {
            this.stackPush(ref.rh());
            return Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this));
        }

        @Override
        public <R> Iterant<F, S> visit(Iterant.Scope<F, R, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, S> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            this.state = this.f.apply(this.state, ref.item());
            F f = this.stackPop();
            if (f == null) {
                iterant = Iterant$Last$.MODULE$.apply(this.state);
            } else {
                F next = f;
                iterant = Iterant$Next$.MODULE$.apply(this.state, package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
            }
            return iterant;
        }

        @Override
        public Iterant<F, S> visit(Iterant.Halt<F, A> ref) {
            Iterant.Suspend suspend;
            Option<Throwable> option = ref.e();
            if (option instanceof Some) {
                suspend = (Iterant.Suspend)((Object)ref);
            } else if (None$.MODULE$.equals(option)) {
                F f = this.stackPop();
                if (f == null) {
                    suspend = ref;
                } else {
                    F next = f;
                    suspend = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
                }
            } else {
                throw new MatchError(option);
            }
            return suspend;
        }

        @Override
        public Iterant<F, S> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }

        private Iterant<F, S> processCursor(BatchCursor<A> cursor, F rest) {
            Iterant iterant;
            if (!cursor.hasNext()) {
                iterant = Iterant$Suspend$.MODULE$.apply(package.all$.MODULE$.toFunctorOps(rest, this.F).map((Function1)this));
            } else if (cursor.recommendedBatchSize() <= 1) {
                this.state = this.f.apply(this.state, cursor.next());
                F next = cursor.hasNext() ? this.F.pure(Iterant$NextCursor$.MODULE$.apply(cursor, rest)) : rest;
                iterant = Iterant$Next$.MODULE$.apply(this.state, package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
            } else {
                ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
                for (int toProcess = cursor.recommendedBatchSize(); toProcess > 0 && cursor.hasNext(); --toProcess) {
                    this.state = this.f.apply(this.state, cursor.next());
                    buffer.$plus$eq(this.state);
                }
                F next = cursor.hasNext() ? this.F.pure(Iterant$NextCursor$.MODULE$.apply(cursor, rest)) : rest;
                BatchCursor elems = BatchCursor$.MODULE$.fromArray(buffer.toArray(ClassTag$.MODULE$.Any()));
                iterant = Iterant$NextCursor$.MODULE$.apply(elems, package.all$.MODULE$.toFunctorOps(next, this.F).map((Function1)this));
            }
            return iterant;
        }
    }
}

