/*
 * Decompiled with CFR 0.152.
 */
package monix.tail.internal;

import cats.effect.Sync;
import cats.syntax.package;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import monix.tail.Iterant;
import monix.tail.Iterant$;
import monix.tail.Iterant$Next$;
import monix.tail.Iterant$NextBatch$;
import monix.tail.Iterant$NextCursor$;
import monix.tail.Iterant$Suspend$;
import monix.tail.batches.BatchCursor;
import monix.tail.internal.IterantSwitchIfEmpty$;
import monix.tail.internal.package$;
import monix.tail.internal.package$ScopeExtensions$;
import scala.Function1;
import scala.None$;
import scala.Option;

public final class IterantSwitchIfEmpty {
    public static <F, A> Iterant<F, A> apply(Iterant<F, A> iterant, Iterant<F, A> iterant2, Sync<F> sync) {
        return IterantSwitchIfEmpty$.MODULE$.apply(iterant, iterant2, sync);
    }

    private static final class Loop<F, A>
    extends Iterant.Visitor<F, A, Iterant<F, A>> {
        private final Iterant<F, A> backup;
        private final Sync<F> F;
        private boolean isEmpty;
        private ChunkedArrayStack<F> stackRef;

        public Loop(Iterant<F, A> backup, Sync<F> F) {
            this.backup = backup;
            this.F = F;
            this.isEmpty = true;
        }

        private boolean isStackEmpty() {
            return this.stackRef == null || this.stackRef.isEmpty();
        }

        private void stackPush(F item) {
            if (this.stackRef == null) {
                this.stackRef = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
            }
            this.stackRef.push(item);
        }

        private F stackPop() {
            return (F)(this.stackRef != null ? this.stackRef.pop() : null);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Next<F, A> ref) {
            Iterant.Next<F, A> next;
            if (this.isStackEmpty()) {
                next = ref;
            } else {
                this.isEmpty = false;
                next = Iterant$Next$.MODULE$.apply(ref.item(), package.functor$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            }
            return next;
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextBatch<F, A> ref) {
            return !this.isEmpty ? (this.isStackEmpty() ? ref : Iterant$NextBatch$.MODULE$.apply(ref.batch(), package.functor$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this))) : this.visit((Iterant.NextCursor)ref.toNextCursor());
        }

        @Override
        public Iterant<F, A> visit(Iterant.NextCursor<F, A> ref) {
            Iterant iterant;
            BatchCursor<A> cursor = ref.cursor();
            if (!this.isEmpty || cursor.hasNext()) {
                if (this.isStackEmpty()) {
                    iterant = ref;
                } else {
                    this.isEmpty = false;
                    iterant = Iterant$NextCursor$.MODULE$.apply(cursor, package.functor$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
                }
            } else {
                iterant = Iterant$Suspend$.MODULE$.apply(package.functor$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Suspend<F, A> ref) {
            return Iterant$Suspend$.MODULE$.apply(package.functor$.MODULE$.toFunctorOps(ref.rest(), this.F).map((Function1)this));
        }

        @Override
        public Iterant<F, A> visit(Iterant.Concat<F, A> ref) {
            this.stackPush(ref.rh());
            return Iterant$Suspend$.MODULE$.apply(package.functor$.MODULE$.toFunctorOps(ref.lh(), this.F).map((Function1)this));
        }

        @Override
        public <S> Iterant<F, A> visit(Iterant.Scope<F, S, A> ref) {
            Iterant.Scope scope = package$.MODULE$.ScopeExtensions(ref);
            return package$ScopeExtensions$.MODULE$.runMap$extension(scope, this, this.F);
        }

        @Override
        public Iterant<F, A> visit(Iterant.Last<F, A> ref) {
            Iterant iterant;
            this.isEmpty = false;
            F f = this.stackPop();
            if (f == null) {
                iterant = ref;
            } else {
                F xs = f;
                iterant = Iterant$Next$.MODULE$.apply(ref.item(), package.functor$.MODULE$.toFunctorOps(xs, this.F).map((Function1)this));
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> visit(Iterant.Halt<F, A> ref) {
            Iterant iterant;
            Option<Throwable> option = ref.e();
            if (None$.MODULE$.equals(option)) {
                F f = this.stackPop();
                if (f == null) {
                    iterant = this.isEmpty ? this.backup : ref;
                } else {
                    F xs = f;
                    iterant = Iterant$Suspend$.MODULE$.apply(package.functor$.MODULE$.toFunctorOps(xs, this.F).map((Function1)this));
                }
            } else {
                iterant = ref;
            }
            return iterant;
        }

        @Override
        public Iterant<F, A> fail(Throwable e) {
            return Iterant$.MODULE$.raiseError(e);
        }
    }
}

