/*
 * Decompiled with CFR 0.152.
 */
package ambience.gitdeploy;

import ambience.cli.CommandProcessor;
import ambience.gitdeploy.ConsoleProcLogger$;
import ambience.gitdeploy.GitDeployModule$;
import ambience.gitdeploy.GitLogic;
import ambience.gitdeploy.GitLogic$;
import ambience.gitdeploy.GitLogic$Branch$;
import ambience.gitdeploy.Init$;
import ambience.gitdeploy.PLogger;
import ambience.gitdeploy.Repositories;
import ambience.gitdeploy.Repositories$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.DeleteResult;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import org.apache.commons.io.FileUtils;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GitPullCommandProcessor$
implements CommandProcessor,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitPullCommandProcessor$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final GitPullCommandProcessor$ MODULE$ = new GitPullCommandProcessor$();

    private GitPullCommandProcessor$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitPullCommandProcessor$.class);
    }

    public String name() {
        return "git-pull";
    }

    public String help() {
        return "Loads the contents of a git repository branch into MongoDB";
    }

    public String usage() {
        return "git-pull <repository-name> <branch>";
    }

    public int main(Seq<String> params) {
        Init$.MODULE$.runOnce();
        List list = params.toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String repName = (String)colon2.head();
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                List list3 = colon3.next$access$1();
                String branchName = (String)colon3.head();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    Option option = Repositories$.MODULE$.ChoiceMap().get((Object)repName);
                    if (option instanceof Some) {
                        Object object = ((Some)option).value();
                        String repository = object == null ? null : ((Repositories.Repository)object).value();
                        return this.pull(repository, GitLogic$Branch$.MODULE$.apply(branchName), ConsoleProcLogger$.MODULE$);
                    }
                    if (None$.MODULE$.equals(option)) {
                        this.log().warn(GitPullCommandProcessor$::main$$anonfun$1, Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.main"));
                        this.log().info(GitPullCommandProcessor$::main$$anonfun$2, Line$.MODULE$.apply(34), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.main"));
                        return -1;
                    }
                    throw new MatchError((Object)option);
                }
            }
        }
        this.log().warn(GitPullCommandProcessor$::main$$anonfun$3, Line$.MODULE$.apply(38), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.main"));
        this.log().info(GitPullCommandProcessor$::main$$anonfun$4, Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.main"));
        return -1;
    }

    public int pull(String repository, GitLogic.PullSource pullSource, PLogger proclog) {
        Either<Object, File> either = GitLogic$.MODULE$.clone(repository, pullSource, proclog);
        if (either instanceof Right) {
            int n;
            File tmpDir = (File)((Right)either).value();
            try {
                n = this.loadFrom(tmpDir, proclog);
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (Exception ex) {
                    this.log().warn(() -> GitPullCommandProcessor$.pull$$anonfun$1(tmpDir, ex), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.pull"));
                }
                throw throwable;
            }
            int n2 = n;
            try {
                FileUtils.deleteDirectory((File)tmpDir);
            }
            catch (Exception ex) {
                this.log().warn(() -> GitPullCommandProcessor$.pull$$anonfun$1(tmpDir, ex), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.pull"));
            }
            return n2;
        }
        if (either instanceof Left) {
            int errCode = BoxesRunTime.unboxToInt((Object)((Left)either).value());
            return errCode;
        }
        throw new MatchError(either);
    }

    public int loadFrom(File tmpDir, PLogger proclog) {
        List children;
        List list = children = Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)tmpDir.listFiles()).getOrElse(GitPullCommandProcessor$::$anonfun$1)).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            proclog.err((Function0<String>)((Function0 & Serializable)GitPullCommandProcessor$::loadFrom$$anonfun$1));
            this.log().error(GitPullCommandProcessor$::loadFrom$$anonfun$2, Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.loadFrom"));
            return -2;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            File root = (File)colon2.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                this.log().info(() -> GitPullCommandProcessor$.loadFrom$$anonfun$3(root), Line$.MODULE$.apply(70), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.loadFrom"));
                Await$.MODULE$.result((Awaitable)this.loadCollections(root, Repositories$.MODULE$.Collections(), proclog).runToFuture(Scheduler$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
                return 0;
            }
        }
        proclog.err((Function0<String>)((Function0 & Serializable)GitPullCommandProcessor$::loadFrom$$anonfun$4));
        this.log().error(GitPullCommandProcessor$::loadFrom$$anonfun$5, Line$.MODULE$.apply(75), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.loadFrom"));
        return -3;
    }

    public Task<BoxedUnit> loadCollections(File file, List<String> cltns, PLogger proclog) {
        List<String> list = cltns;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list3;
            return this.loadCollection(file, head, proclog).flatMap((Function1 & Serializable)_$1 -> MODULE$.loadCollections(file, (List<String>)tail, proclog));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> loadCollection(File file, String cltnName, PLogger proclog) {
        File base = new File(file, cltnName);
        if (base.exists()) {
            List children = Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)base.listFiles()).getOrElse(GitPullCommandProcessor$::$anonfun$2)).toList().filter((Function1 & Serializable)_$2 -> _$2.isFile());
            proclog.out((Function0<String>)((Function0 & Serializable)() -> GitPullCommandProcessor$.loadCollection$$anonfun$1(cltnName, children)));
            this.log().info(() -> GitPullCommandProcessor$.loadCollection$$anonfun$2(cltnName, children), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.loadCollection"));
            RichMongoCollection cltn = GitDeployModule$.MODULE$.getCollection(cltnName);
            return cltn.deleteManyT((Bson)BsonDocument$.MODULE$.apply()).flatMap((Function1 & Serializable)x$12 -> {
                DeleteResult deleteResult = x$12;
                return MODULE$.addRecord(cltn, (List<File>)children, proclog).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> addRecord(RichMongoCollection cltn, List<File> children, PLogger proclog) {
        List list;
        block3: {
            Option<Document> option;
            while (true) {
                list = children;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return Task$.MODULE$.unit();
                }
                if (!(list instanceof .colon.colon)) break block3;
                .colon.colon colon2 = (.colon.colon)list;
                List list3 = colon2.next$access$1();
                File head = (File)colon2.head();
                List tail = list3;
                option = this.buildDoc(head, proclog);
                if (option instanceof Some) {
                    Document doc = (Document)((Some)option).value();
                    return cltn.insertOneT(doc).map((Function1)(JProcedure1 & Serializable)_$3 -> {}).flatMap((Function1 & Serializable)_$4 -> MODULE$.addRecord(cltn, (List<File>)tail, proclog)).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> {
                        proclog.err((Function0<String>)((Function0 & Serializable)() -> GitPullCommandProcessor$.addRecord$$anonfun$3$$anonfun$1(ex)));
                        MODULE$.log().error(() -> GitPullCommandProcessor$.addRecord$$anonfun$3$$anonfun$2(ex), ex, Line$.MODULE$.apply(110), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.addRecord"));
                    });
                }
                if (!None$.MODULE$.equals(option)) break;
                children = tail;
            }
            throw new MatchError(option);
        }
        throw new MatchError(list);
    }

    public Option<Document> buildDoc(File file, PLogger proclog) {
        String jsonString = new String(com.elixirtech.arch.package$.MODULE$.enrichFile(file).data(), StandardCharsets.UTF_8);
        Try try_ = Try$.MODULE$.apply(() -> GitPullCommandProcessor$.buildDoc$$anonfun$1(jsonString));
        if (try_ instanceof Success) {
            Document doc = (Document)((Success)try_).value();
            return Some$.MODULE$.apply((Object)doc);
        }
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            proclog.out((Function0<String>)((Function0 & Serializable)() -> GitPullCommandProcessor$.buildDoc$$anonfun$2(file, err)));
            this.log().error(() -> GitPullCommandProcessor$.buildDoc$$anonfun$3(file, err), Line$.MODULE$.apply(123), FullName$.MODULE$.apply("ambience.gitdeploy.GitPullCommandProcessor.buildDoc"));
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private static final Object main$$anonfun$1() {
        return "Unknown repository";
    }

    private static final Object main$$anonfun$2() {
        return "Available repositories are: " + ((IterableOnceOps)Repositories$.MODULE$.ChoiceMap().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    private static final Object main$$anonfun$3() {
        return "Expected <repository-name> <branch>";
    }

    private static final Object main$$anonfun$4() {
        return "Available repositories are: " + ((IterableOnceOps)Repositories$.MODULE$.ChoiceMap().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
    }

    private static final Object pull$$anonfun$1(File tmpDir$1, Exception ex$1) {
        return "Can't delete " + tmpDir$1.getAbsolutePath() + ": " + ex$1;
    }

    private static final File[] $anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final String loadFrom$$anonfun$1() {
        return "Missing repository folder";
    }

    private static final Object loadFrom$$anonfun$2() {
        return "Missing repository folder";
    }

    private static final Object loadFrom$$anonfun$3(File root$1) {
        return "Loading from " + root$1.getAbsolutePath();
    }

    private static final String loadFrom$$anonfun$4() {
        return "More than one folder choice available";
    }

    private static final Object loadFrom$$anonfun$5() {
        return "More than one folder choice available";
    }

    private static final File[] $anonfun$2() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final String loadCollection$$anonfun$1(String cltnName$1, List children$1) {
        return "Loading collection " + cltnName$1 + " with " + children$1.length() + " files";
    }

    private static final Object loadCollection$$anonfun$2(String cltnName$2, List children$2) {
        return "Loading collection " + cltnName$2 + " with " + children$2.length() + " files";
    }

    private static final String addRecord$$anonfun$3$$anonfun$1(Throwable ex$2) {
        return ex$2.getMessage();
    }

    private static final Object addRecord$$anonfun$3$$anonfun$2(Throwable ex$3) {
        return "addRecord failed " + ex$3.getMessage();
    }

    private static final Document buildDoc$$anonfun$1(String jsonString$1) {
        return Document$.MODULE$.apply(jsonString$1);
    }

    private static final String buildDoc$$anonfun$2(File file$2, Throwable err$1) {
        return "Can't parse " + file$2.getAbsolutePath() + ": " + err$1;
    }

    private static final Object buildDoc$$anonfun$3(File file$3, Throwable err$2) {
        return "Can't parse " + file$3.getAbsolutePath() + ": " + err$2;
    }
}

