/*
 * Decompiled with CFR 0.152.
 */
package ambience.gitdeploy;

import ambience.framework.EventBus;
import ambience.gitdeploy.GitLogic;
import ambience.gitdeploy.GitLogic$Branch$;
import ambience.gitdeploy.GitLogic$Tag$;
import ambience.gitdeploy.GitPullCommandProcessor$;
import ambience.gitdeploy.GitPullRequest;
import ambience.gitdeploy.PublishLogger;
import ambience.gitdeploy.Repositories;
import ambience.gitdeploy.Repositories$;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import java.io.Serializable;
import java.time.ZoneId;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class StreamedPullLogic$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(StreamedPullLogic$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Scheduler scheduler;
    private static final AuditAPI.Component component;
    public static final StreamedPullLogic$ MODULE$;

    private StreamedPullLogic$() {
    }

    static {
        MODULE$ = new StreamedPullLogic$();
        scheduler = Scheduler$.MODULE$.global();
        component = AuditAPI.Component$.MODULE$.apply("git-deploy", "streamed-pull");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamedPullLogic$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public AuditAPI.Component component() {
        return component;
    }

    public GravityResponse apply(UserDB.User user, GitPullRequest gpr) {
        ZoneId zoneId = ZoneId.of(gpr.zoneId());
        PublishLogger publisher = new PublishLogger(zoneId);
        Observable source = Observable$.MODULE$.fromReactivePublisher((Publisher)publisher).map((Function1 & Serializable)s -> s.getBytes("UTF-8"));
        this.log().info(() -> StreamedPullLogic$.apply$$anonfun$1(user, gpr), Line$.MODULE$.apply(26), FullName$.MODULE$.apply("ambience.gitdeploy.StreamedPullLogic.apply"));
        this.run(gpr, publisher).executeAsync().runToFuture(this.scheduler()).map((Function1 & Serializable)v1 -> {
            StreamedPullLogic$.apply$$anonfun$2(publisher, user, BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.scheduler());
        DataBytes dataBytes = DataBytes$.MODULE$.apply(source);
        int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
        Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
        return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
    }

    public void notifyEventBus() {
        ((EventBus)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(EventBus.class))).addEvent("git-deploy/pull-complete", Document$.MODULE$.apply());
    }

    public Task<Object> run(GitPullRequest request, PublishLogger logger) {
        return Task$.MODULE$.apply(() -> StreamedPullLogic$.run$$anonfun$1(logger, request));
    }

    private static final Object apply$$anonfun$1(UserDB.User user$1, GitPullRequest gpr$1) {
        return "Preparing pull for " + user$1.name() + " with " + gpr$1;
    }

    private static final /* synthetic */ void apply$$anonfun$2(PublishLogger publisher$1, UserDB.User user$2, boolean ok) {
        publisher$1.close();
        AuditAPI.Action action = AuditAPI.Action$.MODULE$.apply(ok, "all", "pull");
        AuditAPI.AuditMessage msg = AuditAPI.AuditMessage$.MODULE$.apply(user$2.name(), MODULE$.component(), action);
        ((AuditAPI.AuditAppender)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(AuditAPI.AuditAppender.class))).append(msg);
        if (ok) {
            MODULE$.notifyEventBus();
            return;
        }
    }

    private static final String run$$anonfun$1$$anonfun$1() {
        return "Started";
    }

    private static final Option $anonfun$3(GitPullRequest request$2) {
        return request$2.tag().map((Function1 & Serializable)value -> GitLogic$Tag$.MODULE$.apply((String)value));
    }

    private static final Object run$$anonfun$1$$anonfun$2(int errorCode$1) {
        return "Completed with " + errorCode$1;
    }

    private static final String run$$anonfun$1$$anonfun$3() {
        return "No branch or tag specified";
    }

    private static final String run$$anonfun$1$$anonfun$4() {
        return "Repository not found";
    }

    private static final boolean run$$anonfun$1(PublishLogger logger$1, GitPullRequest request$1) {
        logger$1.out((Function0<String>)((Function0 & Serializable)StreamedPullLogic$::run$$anonfun$1$$anonfun$1));
        Option option = Repositories$.MODULE$.ChoiceMap().get((Object)request$1.repository());
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            String repository = object == null ? null : ((Repositories.Repository)object).value();
            Option optSource = request$1.branch().map((Function1 & Serializable)value -> GitLogic$Branch$.MODULE$.apply((String)value)).orElse(() -> StreamedPullLogic$.$anonfun$3(request$1));
            Option option2 = optSource;
            if (option2 instanceof Some) {
                GitLogic.PullSource source = (GitLogic.PullSource)((Some)option2).value();
                int errorCode = GitPullCommandProcessor$.MODULE$.pull(repository, source, logger$1);
                MODULE$.log().info(() -> StreamedPullLogic$.run$$anonfun$1$$anonfun$2(errorCode), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.gitdeploy.StreamedPullLogic.run"));
                return errorCode == 0;
            }
            if (None$.MODULE$.equals(option2)) {
                logger$1.err((Function0<String>)((Function0 & Serializable)StreamedPullLogic$::run$$anonfun$1$$anonfun$3));
                return false;
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            logger$1.err((Function0<String>)((Function0 & Serializable)StreamedPullLogic$::run$$anonfun$1$$anonfun$4));
            return false;
        }
        throw new MatchError((Object)option);
    }
}

