/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.validation;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.validation.ISODateRange;
import ambience.etl.validation.ISODateRange$Info$;
import ambience.etl.validation.ISODateRange$Struct$;
import ambience.etl.validation.Messages$;
import ambience.etl.validation.ValidationCategory$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple4$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ISODateRange$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    private static final HashMap formatters;
    private static final DateTimeFormatter ISO;
    public static final ISODateRange$Info$ Info;
    public static final ISODateRange$Struct$ Struct;
    public static final ISODateRange$ MODULE$;

    private ISODateRange$() {
    }

    static {
        MODULE$ = new ISODateRange$();
        stepType = ETLStepType$.MODULE$.apply("validation.ISODateRange");
        formatters = new HashMap();
        ISO = DateTimeFormatter.ISO_LOCAL_DATE;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ISODateRange$.class);
    }

    public String stepType() {
        return stepType;
    }

    public HashMap<String, DateTimeFormatter> formatters() {
        return formatters;
    }

    public DateTimeFormatter ISO() {
        return ISO;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        ISODateRange.Info info = (ISODateRange.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ISODateRange$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ISODateRange$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ISODateRange$::$anonfun$3))))).toOption().getOrElse(ISODateRange$::$anonfun$4);
        Panel.Item numberField = PanelItem$.MODULE$.text("field", "ISO Date Field", info.field(), PanelItem$.MODULE$.text$default$4());
        Panel.Item minField = PanelItem$.MODULE$.text("min", "Minimum (yyyy-MM-dd)", info.min(), PanelItem$.MODULE$.text$default$4());
        Panel.Item maxField = PanelItem$.MODULE$.text("max", "Maximum (yyyy-MM-dd)", info.max(), PanelItem$.MODULE$.text$default$4());
        Panel.Item format = PanelItem$.MODULE$.text("format", "Local Format", info.format(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> ISODateRange$.buildPanel$$anonfun$1(numberField, minField, maxField, format));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> ISODateRange$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        return step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ISODateRange$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ISODateRange$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ISODateRange$::build$$anonfun$3))))).left().map((Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err)).flatMap((Function1 & Serializable)info -> MODULE$.logError(step, "Can't parse format " + info.format(), () -> ISODateRange$.build$$anonfun$5$$anonfun$1(info)).flatMap((Function1 & Serializable)formatter -> MODULE$.logError(step, "Can't parse min " + info.min(), () -> ISODateRange$.build$$anonfun$5$$anonfun$2$$anonfun$1(info)).flatMap((Function1 & Serializable)min -> MODULE$.logError(step, "Can't parse max " + info.max(), () -> ISODateRange$.build$$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$1(info)).flatMap((Function1 & Serializable)max -> {
            ISODateRange.Struct struct = ISODateRange$Struct$.MODULE$.apply((DateTimeFormatter)formatter, (LocalDate)min, (LocalDate)max);
            return package$.MODULE$.Right().apply((Function1 & Serializable)from -> MODULE$.run((ISODateRange.Info)info, struct, (Observable<Document>)from)).map((Function1 & Serializable)ret -> ret);
        }))));
    }

    public Observable<Document> run(ISODateRange.Info info, ISODateRange.Struct struct, Observable<Document> from) {
        return from.map((Function1 & Serializable)doc -> {
            BsonValue bsonValue;
            Option option = BsonETL$.MODULE$.get(doc, info.field());
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
                Document document;
                BsonString n = (BsonString)bsonValue;
                try {
                    LocalDate v = LocalDate.parse(n.getValue(), this.ISO());
                    if (v.isBefore(struct.min()) || v.isAfter(struct.max())) {
                        String msg = Messages$.MODULE$.dateRangeExpected((Document)doc, info.field(), this.fmt$2(info, info.min()), this.fmt$2(info, info.max()), (Option<String>)Some$.MODULE$.apply((Object)this.fmt$2(info, n.getValue())));
                        document = ValidationCategory$.MODULE$.invalid((Document)doc, msg);
                    } else {
                        document = doc;
                    }
                }
                catch (DateTimeParseException dateTimeParseException) {
                    document = ValidationCategory$.MODULE$.invalid((Document)doc, Messages$.MODULE$.cannotParseIsoDate((Document)doc, info.field(), n.getValue()));
                }
                return document;
            }
            String msg = Messages$.MODULE$.dateRangeExpected((Document)doc, info.field(), this.fmt$2(info, info.min()), this.fmt$2(info, info.max()), (Option<String>)None$.MODULE$);
            return ValidationCategory$.MODULE$.invalid((Document)doc, msg);
        });
    }

    public Observable<Document> invalidRun(Observable<Document> from) {
        return from.map((Function1 & Serializable)doc -> ValidationCategory$.MODULE$.invalid((Document)doc, "Invalid ISODateRange configuration"));
    }

    public <T> Either<BuildError, T> logError(ETLStep step, String msg, Function0<T> fn) {
        Try try_ = Try$.MODULE$.apply(fn);
        if (try_ instanceof Success) {
            Object t = ((Success)try_).value();
            return package$.MODULE$.Right().apply(t);
        }
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            return package$.MODULE$.Left().apply((Object)BuildError$.MODULE$.apply(msg + ": " + err, (Option)Some$.MODULE$.apply((Object)step), (Option)None$.MODULE$));
        }
        throw new MatchError((Object)try_);
    }

    public String format(String fmt, String s) {
        return this.getFormatter(fmt).format(this.ISO().parse(s));
    }

    public DateTimeFormatter getFormatter(String fmt) {
        return (DateTimeFormatter)this.formatters().getOrElseUpdate((Object)fmt, () -> ISODateRange$.getFormatter$$anonfun$1(fmt));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        ISODateRange$Info$ iSODateRange$Info$ = ISODateRange$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ISODateRange.Info)iSODateRange$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final ISODateRange.Info $anonfun$4() {
        return ISODateRange$Info$.MODULE$.apply(ISODateRange$Info$.MODULE$.$lessinit$greater$default$1(), ISODateRange$Info$.MODULE$.$lessinit$greater$default$2(), ISODateRange$Info$.MODULE$.$lessinit$greater$default$3(), ISODateRange$Info$.MODULE$.$lessinit$greater$default$4());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item numberField$1, Panel.Item minField$1, Panel.Item maxField$1, Panel.Item format$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)numberField$1, (List)new .colon.colon((Object)minField$1, (List)new .colon.colon((Object)maxField$1, (List)new .colon.colon((Object)format$1, (List)Nil$.MODULE$)))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        ISODateRange$Info$ iSODateRange$Info$ = ISODateRange$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ISODateRange.Info)iSODateRange$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "field";
        String string2 = "min";
        String string3 = "max";
        String string4 = "format";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ISODateRange$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ISODateRange$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ISODateRange$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            ISODateRange.Info info2 = (ISODateRange.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "field";
            String string2 = "min";
            String string3 = "max";
            String string4 = "format";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ISODateRange$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string5 = step$1.copy$default$1();
            String string6 = step$1.copy$default$2();
            String string7 = step$1.copy$default$3();
            String string8 = step$1.copy$default$4();
            String string9 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        ISODateRange$Info$ iSODateRange$Info$ = ISODateRange$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ISODateRange.Info)iSODateRange$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ISODateRange$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final DateTimeFormatter build$$anonfun$5$$anonfun$1(ISODateRange.Info info$1) {
        return MODULE$.getFormatter(info$1.format());
    }

    private static final LocalDate build$$anonfun$5$$anonfun$2$$anonfun$1(ISODateRange.Info info$3) {
        return LocalDate.parse(info$3.min(), MODULE$.ISO());
    }

    private static final LocalDate build$$anonfun$5$$anonfun$2$$anonfun$2$$anonfun$1(ISODateRange.Info info$5) {
        return LocalDate.parse(info$5.max(), MODULE$.ISO());
    }

    private final String fmt$2(ISODateRange.Info info$8, String s) {
        return this.format(info$8.format(), s);
    }

    private static final DateTimeFormatter getFormatter$$anonfun$1(String fmt$1) {
        return DateTimeFormatter.ofPattern(fmt$1);
    }
}

