/*
 * Decompiled with CFR 0.152.
 */
package ambience.dsengine.datastore;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.repository.RMLFileObject;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;

public class CSVDataStore
implements DataListener {
    private static AtomicInteger m_SerialIds = new AtomicInteger(0);
    private PushContext m_Context;
    private int m_Serial = m_SerialIds.incrementAndGet();
    protected Writer m_Writer;
    private RMLFileObject m_FileObject;
    protected DataSchema m_Schema;
    private char m_SeparatorChar = (char)44;
    private char m_QualifierChar;
    private boolean m_Append;
    private String m_LineSeparator = "\r\n";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CSVDataStore.class);

    public CSVDataStore(Writer writer) {
        this.m_Writer = writer;
    }

    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    void setSeparatorChar(char c) {
        this.m_SeparatorChar = c;
    }

    char getSeparatorChar() {
        return this.m_SeparatorChar;
    }

    void setQualifierChar(char c) {
        this.m_QualifierChar = c;
    }

    char getQualifierChar() {
        return this.m_QualifierChar;
    }

    public void setSeparator(String string) {
        if ("Tab".equals(string)) {
            this.setSeparatorChar('\t');
        } else if ("Semicolon".equals(string)) {
            this.setSeparatorChar(';');
        } else if ("Comma".equals(string)) {
            this.setSeparatorChar(',');
        } else if ("Space".equals(string)) {
            this.setSeparatorChar(' ');
        } else if (string.length() > 0) {
            this.setSeparatorChar(string.charAt(0));
        }
    }

    public String getSeparator() {
        if (this.m_SeparatorChar == '\t') {
            return "Tab";
        }
        if (this.m_SeparatorChar == ';') {
            return "Semicolon";
        }
        if (this.m_SeparatorChar == ',') {
            return "Comma";
        }
        if (this.m_SeparatorChar == ' ') {
            return "Space";
        }
        return String.valueOf(this.m_SeparatorChar);
    }

    public void setQualifier(String string) {
        if (string == null || string.length() == 0 || "None".equals(string)) {
            this.setQualifierChar('\u0000');
        } else {
            this.setQualifierChar(string.charAt(0));
        }
    }

    public String getQualifier() {
        if (this.m_QualifierChar == '\u0000') {
            return "";
        }
        return String.valueOf(this.m_QualifierChar);
    }

    public void setAppend(boolean bl) {
        this.m_Append = bl;
    }

    public boolean getAppend() {
        return this.m_Append;
    }

    public void startData(IDataSource iDataSource) {
        this.m_Schema = iDataSource.getSchema();
        boolean bl = false;
        int n = this.m_Schema.getColumnCount();
        try {
            for (int i = 0; i < n; ++i) {
                this.m_Writer.write(this.m_Schema.getColumnName(i));
                if (i >= n - 1) continue;
                this.m_Writer.write(this.m_SeparatorChar);
            }
            this.m_Writer.write(this.m_LineSeparator);
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in startData", (Throwable)iOException);
        }
    }

    public void startGroup(DataGroup dataGroup) {
    }

    public boolean processRecord(DataRecord dataRecord) {
        Object[] objectArray = dataRecord.getData();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.m_QualifierChar != '\u0000') {
                    this.m_Writer.write(this.m_QualifierChar);
                }
                try {
                    boolean bl;
                    String string = this.m_Schema.format(this.m_Schema.getColumnType(i), objectArray[i]);
                    int n = this.m_QualifierChar != '\u0000' ? (int)this.m_QualifierChar : 34;
                    boolean bl2 = bl = string.indexOf(n) >= 0 || this.m_QualifierChar == '\u0000' && string.indexOf(this.m_SeparatorChar) >= 0;
                    if (bl) {
                        if (this.m_QualifierChar == '\u0000') {
                            this.m_Writer.write(34);
                            this.m_Writer.write(string.replace("\"", "\"\""));
                            this.m_Writer.write(34);
                        } else {
                            String string2 = "" + this.m_QualifierChar;
                            this.m_Writer.write(string.replace(string2, string2 + string2));
                        }
                    } else {
                        this.m_Writer.write(string);
                    }
                }
                catch (Exception exception) {
                    m_Log.error((Object)("Can't write field " + i + " with data " + objectArray[i]), (Throwable)exception);
                }
                if (this.m_QualifierChar != '\u0000') {
                    this.m_Writer.write(this.m_QualifierChar);
                }
                if (i >= objectArray.length - 1) continue;
                this.m_Writer.write(this.m_SeparatorChar);
            }
            this.m_Writer.write(this.m_LineSeparator);
            return this.m_Context != null ? !this.m_Context.isAborted() : true;
        }
        catch (IOException iOException) {
            m_Log.error((Object)"IOException in processRecord", (Throwable)iOException);
            throw new RuntimeException("IOException in processRecord", iOException);
        }
    }

    public void endGroup(DataGroup dataGroup) {
    }

    public void endData(IDataSource iDataSource) {
    }
}

