/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine;

import ambience.api.Datasets;
import ambience.module.ModuleControl;
import ambience.module.UserDB;
import ambience.rmlengine.AmbienceDataSource;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.coredata.Data;
import com.elixirtech.data.BsonUtils$;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.mongodb.BsonETL$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Try$;

public final class AmbienceDataSource$
implements Serializable {
    private static final DateTimeFormatter DateFormat;
    private static final DataSchema EmptySchema;
    private volatile Object isRepertoire$lzy1;
    private volatile Object datasetsAPI$lzy1;
    private volatile Object LoadTimeout$lzy1;
    public static final AmbienceDataSource$ MODULE$;

    private AmbienceDataSource$() {
    }

    static {
        MODULE$ = new AmbienceDataSource$();
        DateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        EmptySchema = new DataSchema();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AmbienceDataSource$.class);
    }

    public DateTimeFormatter DateFormat() {
        return DateFormat;
    }

    public DataSchema EmptySchema() {
        return EmptySchema;
    }

    public boolean isRepertoire() {
        Object object = this.isRepertoire$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isRepertoire$lzyINIT1());
    }

    private Object isRepertoire$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isRepertoire$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)((ModuleControl)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ModuleControl.class))).isRepertoire());
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isRepertoire$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Datasets datasetsAPI() {
        Object object = this.datasetsAPI$lzy1;
        if (object instanceof Datasets) {
            return (Datasets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Datasets)this.datasetsAPI$lzyINIT1();
    }

    private Object datasetsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.datasetsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Datasets datasets = null;
                    try {
                        datasets = (Datasets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Datasets.class));
                        object2 = datasets == null ? LazyVals.NullValue$.MODULE$ : datasets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.datasetsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return datasets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FiniteDuration LoadTimeout() {
        Object object = this.LoadTimeout$lzy1;
        if (object instanceof FiniteDuration) {
            return (FiniteDuration)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FiniteDuration)this.LoadTimeout$lzyINIT1();
    }

    private Object LoadTimeout$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.LoadTimeout$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FiniteDuration finiteDuration = null;
                    try {
                        finiteDuration = new FiniteDuration(((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getDuration("ambience.ds-engine.load-timeout", TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                        object2 = finiteDuration == null ? LazyVals.NullValue$.MODULE$ : finiteDuration;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.LoadTimeout$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return finiteDuration;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, AmbienceDataSource.OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Option<AmbienceDataSource>> load(UserDB.User user, String name) {
        if (this.isRepertoire()) {
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        return this.datasetsAPI().getDatasets(user).map((Function1 & Serializable)all -> {
            if (all.contains((Object)new Datasets.Name(Datasets.Name$.MODULE$.apply(name)))) {
                return Some$.MODULE$.apply((Object)new AmbienceDataSource(user, name));
            }
            return None$.MODULE$;
        });
    }

    public DataSchema buildSchema(Data.Schema dsSchema) {
        return new DataSchema(true, (SchemaItem[])dsSchema.fields().map((Function1 & Serializable)field -> MODULE$.buildSchemaItem((Data.Field)field)).toArray(ClassTag$.MODULE$.apply(SchemaItem.class)));
    }

    public SchemaItem buildSchemaItem(Data.Field field) {
        DataType dataType;
        Data.Type type = field.dataType();
        if (Data.StringType$.MODULE$.equals(type)) {
            dataType = DataType.STRING;
        } else if (Data.BooleanType$.MODULE$.equals(type)) {
            dataType = DataType.BOOLEAN;
        } else if (Data.Int32Type$.MODULE$.equals(type)) {
            dataType = DataType.LONG;
        } else if (Data.Int64Type$.MODULE$.equals(type)) {
            dataType = DataType.LONG;
        } else if (Data.DoubleType$.MODULE$.equals(type)) {
            dataType = DataType.DOUBLE;
        } else if (Data.DecimalType$.MODULE$.equals(type)) {
            dataType = DataType.DECIMAL;
        } else if (Data.IsoLocalDateType$.MODULE$.equals(type)) {
            dataType = DataType.DATE;
        } else if (Data.IsoLocalTimeType$.MODULE$.equals(type)) {
            dataType = DataType.TIME;
        } else if (Data.TimestampType$.MODULE$.equals(type)) {
            dataType = DataType.TIMESTAMP;
        } else if (Data.DocumentType$.MODULE$.equals(type)) {
            dataType = DataType.UNKNOWN;
        } else if (Data.ArrayType$.MODULE$.equals(type)) {
            dataType = DataType.UNKNOWN;
        } else if (Data.BinaryType$.MODULE$.equals(type)) {
            dataType = DataType.UNKNOWN;
        } else if (Data.IdType$.MODULE$.equals(type)) {
            dataType = DataType.UNKNOWN;
        } else if (Data.Unknown$.MODULE$.equals(type)) {
            dataType = DataType.UNKNOWN;
        } else {
            throw new MatchError((Object)type);
        }
        DataType dataType2 = dataType;
        return new SchemaItem(field.name(), dataType2);
    }

    public DataRecord buildRecord(DataSchema schema, Document doc) {
        int len = schema.getColumnCount();
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.buildValue(doc, schema.getColumn(i));
        }
        return new DataRecord(schema, array);
    }

    public Object buildValue(Document doc, SchemaItem si) {
        Option option = BsonETL$.MODULE$.get(doc, this.safe(si.name));
        if (option instanceof Some) {
            BsonValue bv = (BsonValue)((Some)option).value();
            return this.bsonToObject(bv, si.type);
        }
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        throw new MatchError((Object)option);
    }

    public Object bsonToObject(BsonValue bv, DataType dt) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)bv, (Object)dt);
        if (tuple2 != null) {
            BsonValue bsonValue = (BsonValue)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bsonValue instanceof BsonNull) {
                return null;
            }
            if (bsonValue instanceof BsonUndefined) {
                return null;
            }
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                DataType dataType2 = DataType.STRING;
                DataType dataType3 = dataType;
                if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                    return s.getValue();
                }
            }
            if (bsonValue instanceof BsonObjectId) {
                BsonObjectId s = (BsonObjectId)bsonValue;
                DataType dataType4 = DataType.STRING;
                DataType dataType5 = dataType;
                if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                    return s.getValue().toHexString();
                }
            }
            if (bsonValue instanceof BsonNumber) {
                BsonNumber bsonNumber;
                BsonNumber s = bsonNumber = (BsonNumber)bsonValue;
                DataType dataType6 = DataType.LONG;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    return BoxesRunTime.boxToLong((long)s.longValue());
                }
                BsonNumber s2 = bsonNumber;
                DataType dataType8 = DataType.DOUBLE;
                DataType dataType9 = dataType;
                if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                    return BoxesRunTime.boxToDouble((double)s2.doubleValue());
                }
                BsonNumber s3 = bsonNumber;
                DataType dataType10 = DataType.DECIMAL;
                DataType dataType11 = dataType;
                if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                    return Try$.MODULE$.apply(() -> AmbienceDataSource$.bsonToObject$$anonfun$1(s3)).toOption().getOrElse(() -> AmbienceDataSource$.bsonToObject$$anonfun$2(s3));
                }
            }
            if (bsonValue instanceof BsonBoolean) {
                BsonBoolean s = (BsonBoolean)bsonValue;
                DataType dataType12 = DataType.BOOLEAN;
                DataType dataType13 = dataType;
                if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                    return BoxesRunTime.boxToBoolean((boolean)s.getValue());
                }
            }
            if (bsonValue instanceof BsonString) {
                BsonString bsonString;
                BsonString s = bsonString = (BsonString)bsonValue;
                DataType dataType14 = DataType.DATE;
                DataType dataType15 = dataType;
                if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                    return Try$.MODULE$.apply(() -> AmbienceDataSource$.bsonToObject$$anonfun$3(s)).getOrElse(AmbienceDataSource$::bsonToObject$$anonfun$4);
                }
                BsonString s4 = bsonString;
                DataType dataType16 = DataType.TIME;
                DataType dataType17 = dataType;
                if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                    return Try$.MODULE$.apply(() -> AmbienceDataSource$.bsonToObject$$anonfun$5(s4)).getOrElse(AmbienceDataSource$::bsonToObject$$anonfun$6);
                }
            }
            if (bsonValue instanceof BsonDateTime) {
                BsonDateTime s = (BsonDateTime)bsonValue;
                DataType dataType18 = DataType.TIMESTAMP;
                DataType dataType19 = dataType;
                if (!(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null)) {
                    return new Date(s.getValue());
                }
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary s = (BsonBinary)bsonValue;
                DataType dataType20 = DataType.BYTE_ARRAY;
                DataType dataType21 = dataType;
                if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                    return s.getData();
                }
            }
            DataType dataType22 = DataType.STRING;
            DataType dataType23 = dataType;
            if (!(dataType22 != null ? !dataType22.equals(dataType23) : dataType23 != null)) {
                return BsonUtils$.MODULE$.asJson(bv);
            }
            return BsonUtils$.MODULE$.asString(bv);
        }
        throw new MatchError((Object)tuple2);
    }

    public BigDecimal forceDecimal(BsonNumber n) {
        return new BigDecimal(n.doubleValue());
    }

    public String safe(String s) {
        return StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)ch -> AmbienceDataSource$.safe$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
    }

    private static final BigDecimal bsonToObject$$anonfun$1(BsonNumber s$1) {
        return s$1.decimal128Value().bigDecimalValue();
    }

    private static final BigDecimal bsonToObject$$anonfun$2(BsonNumber s$2) {
        return MODULE$.forceDecimal(s$2);
    }

    private static final Date bsonToObject$$anonfun$3(BsonString s$3) {
        LocalDate localDate = LocalDate.parse(s$3.getValue(), MODULE$.DateFormat());
        return new Date(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    private static final Date bsonToObject$$anonfun$4() {
        return null;
    }

    private static final Date bsonToObject$$anonfun$5(BsonString s$4) {
        LocalTime localTime = LocalTime.parse(s$4.getValue());
        return new Date(localTime.toNanoOfDay() / 1000000L);
    }

    private static final Date bsonToObject$$anonfun$6() {
        return null;
    }

    private static final /* synthetic */ boolean safe$$anonfun$1(char ch) {
        return ch != '\ufeff';
    }
}

