/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine;

import ambience.api.Datasets;
import ambience.module.UserDB;
import ambience.rmlengine.AmbienceDataSource$;
import ambience.rmlengine.RMLEngineModule$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaItem;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonNumber;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AmbienceDataSource
implements IDataSource,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDataSource.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final UserDB.User user;
    private final String name;
    private Option optSchema;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDataSource$.class.getDeclaredField("LoadTimeout$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDataSource$.class.getDeclaredField("datasetsAPI$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AmbienceDataSource$.class.getDeclaredField("isRepertoire$lzy1"));

    public static DateTimeFormatter DateFormat() {
        return AmbienceDataSource$.MODULE$.DateFormat();
    }

    public static DataSchema EmptySchema() {
        return AmbienceDataSource$.MODULE$.EmptySchema();
    }

    public static FiniteDuration LoadTimeout() {
        return AmbienceDataSource$.MODULE$.LoadTimeout();
    }

    public static Object bsonToObject(BsonValue bsonValue, DataType dataType) {
        return AmbienceDataSource$.MODULE$.bsonToObject(bsonValue, dataType);
    }

    public static DataRecord buildRecord(DataSchema dataSchema, Document document) {
        return AmbienceDataSource$.MODULE$.buildRecord(dataSchema, document);
    }

    public static DataSchema buildSchema(Data.Schema schema) {
        return AmbienceDataSource$.MODULE$.buildSchema(schema);
    }

    public static SchemaItem buildSchemaItem(Data.Field field) {
        return AmbienceDataSource$.MODULE$.buildSchemaItem(field);
    }

    public static Object buildValue(Document document, SchemaItem schemaItem) {
        return AmbienceDataSource$.MODULE$.buildValue(document, schemaItem);
    }

    public static Datasets datasetsAPI() {
        return AmbienceDataSource$.MODULE$.datasetsAPI();
    }

    public static BigDecimal forceDecimal(BsonNumber bsonNumber) {
        return AmbienceDataSource$.MODULE$.forceDecimal(bsonNumber);
    }

    public static boolean isRepertoire() {
        return AmbienceDataSource$.MODULE$.isRepertoire();
    }

    public static String safe(String string) {
        return AmbienceDataSource$.MODULE$.safe(string);
    }

    public AmbienceDataSource(UserDB.User user, String name) {
        this.user = user;
        this.name = name;
        this.optSchema = None$.MODULE$;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<DataSchema> optSchema() {
        return this.optSchema;
    }

    public void optSchema_$eq(Option<DataSchema> x$1) {
        this.optSchema = x$1;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "";
    }

    public String getType() {
        return "Ambience";
    }

    public java.util.List<Parameter> getParameters() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Nil()).asJava();
    }

    public DataSchema getSchema() {
        Option<DataSchema> option = this.optSchema();
        if (option instanceof Some) {
            DataSchema schema = (DataSchema)((Some)option).value();
            return schema;
        }
        if (None$.MODULE$.equals(option)) {
            return (DataSchema)Await$.MODULE$.result((Awaitable)this.loadSchema().runToFuture((Scheduler)RMLEngineModule$.MODULE$.io()), (Duration)AmbienceDataSource$.MODULE$.LoadTimeout());
        }
        throw new MatchError(option);
    }

    public Task<DataSchema> loadSchema() {
        Option<DataSchema> option = this.optSchema();
        if (option instanceof Some) {
            DataSchema schema = (DataSchema)((Some)option).value();
            return Task$.MODULE$.now((Object)schema);
        }
        if (None$.MODULE$.equals(option)) {
            if (AmbienceDataSource$.MODULE$.isRepertoire()) {
                return Task$.MODULE$.now((Object)AmbienceDataSource$.MODULE$.EmptySchema());
            }
            String dsName = Datasets.Name$.MODULE$.apply(this.name);
            return AmbienceDataSource$.MODULE$.datasetsAPI().getSchema(this.user, dsName).map((Function1 & Serializable)dsSchema -> {
                DataSchema schema = AmbienceDataSource$.MODULE$.buildSchema((Data.Schema)dsSchema);
                this.optSchema_$eq((Option<DataSchema>)Some$.MODULE$.apply((Object)schema));
                this.log().info(() -> AmbienceDataSource.loadSchema$$anonfun$1$$anonfun$1(schema), Line$.MODULE$.apply(165), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDataSource.loadSchema"));
                return schema;
            });
        }
        throw new MatchError(option);
    }

    public void pushTo(PushContext cxt, DataListener dl) {
        Task task = Observable$.MODULE$.fromTask(this.loadSchema()).flatMap((Function1 & Serializable)schema -> this.load(cxt, (DataSchema)schema)).toListL();
        List records = (List)Await$.MODULE$.result((Awaitable)task.runToFuture((Scheduler)RMLEngineModule$.MODULE$.io()), (Duration)Duration$.MODULE$.Inf());
        this.log().info(AmbienceDataSource::pushTo$$anonfun$1, Line$.MODULE$.apply(175), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDataSource.pushTo"));
        dl.startData((IDataSource)this);
        this.log().info(() -> AmbienceDataSource.pushTo$$anonfun$2(records), Line$.MODULE$.apply(177), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDataSource.pushTo"));
        records.foreach((Function1 & Serializable)record -> dl.processRecord(record));
        this.log().info(AmbienceDataSource::pushTo$$anonfun$4, Line$.MODULE$.apply(179), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDataSource.pushTo"));
        dl.endData((IDataSource)this);
    }

    public <T> T getAdapter(Class<T> cls) {
        return null;
    }

    public Observable<DataRecord> load(PushContext cxt, DataSchema schema) {
        if (AmbienceDataSource$.MODULE$.isRepertoire()) {
            return Observable$.MODULE$.empty();
        }
        String dsName = Datasets.Name$.MODULE$.apply(this.name);
        Map params = cxt.getParameters();
        Json paramsJson = Json$.MODULE$.fromFields((Iterable)CollectionConverters$.MODULE$.MapHasAsScala(params).asScala().map((Function1 & Serializable)kv -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString((String)kv._2()));
        }));
        this.log().info(() -> AmbienceDataSource.load$$anonfun$1(dsName, paramsJson), Line$.MODULE$.apply(192), FullName$.MODULE$.apply("ambience.rmlengine.AmbienceDataSource.load"));
        return AmbienceDataSource$.MODULE$.datasetsAPI().buildRecords(this.user, dsName, Datasets.Parameters$.MODULE$.apply(paramsJson)).map((Function1 & Serializable)doc -> AmbienceDataSource$.MODULE$.buildRecord(schema, (Document)doc));
    }

    private static final Object loadSchema$$anonfun$1$$anonfun$1(DataSchema schema$1) {
        return "Loaded schema with " + schema$1.getColumnCount() + " columns";
    }

    private static final Object pushTo$$anonfun$1() {
        return "startData";
    }

    private static final Object pushTo$$anonfun$2(List records$1) {
        return "processing " + records$1.size() + " records";
    }

    private static final Object pushTo$$anonfun$4() {
        return "endData";
    }

    private static final Object load$$anonfun$1(String dsName$1, Json paramsJson$1) {
        return "Calling DatasetsAPI buildRecords(" + dsName$1 + "," + paramsJson$1.noSpaces() + ")";
    }
}

