/*
 * Decompiled with CFR 0.152.
 */
package ambience.rmlengine.local;

import ambience.api.ReportEngine;
import ambience.api.Repository;
import ambience.module.CurrentUser$;
import ambience.module.UserDB;
import ambience.rmlengine.RMLEngineModule$;
import ambience.rmlengine.local.RMLEngineFileObject;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLRepository;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import monix.eval.Task;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RMLEngineRepository$
implements RMLRepository,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(RMLEngineRepository$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RMLEngineRepository$.class.getDeclaredField("repository$lzy1"));
    private volatile Object log$lzy1;
    private static final long ReadTimeoutSecs;
    private static final String separator;
    private volatile Object repository$lzy1;
    public static final RMLEngineRepository$ MODULE$;

    private RMLEngineRepository$() {
    }

    static {
        MODULE$ = new RMLEngineRepository$();
        Config repositoryConfig = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getConfig("ambience.rml-engine.repository");
        ReadTimeoutSecs = repositoryConfig.getDuration("read-timeout", TimeUnit.SECONDS);
        separator = File.separator;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RMLEngineRepository$.class);
    }

    public String separator() {
        return separator;
    }

    public Repository repository() {
        Object object = this.repository$lzy1;
        if (object instanceof Repository) {
            return (Repository)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Repository)this.repository$lzyINIT1();
    }

    private Object repository$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repository$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Repository repository = null;
                    try {
                        repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
                        object2 = repository == null ? LazyVals.NullValue$.MODULE$ : repository;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repository$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return repository;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String fixSlashes(String in) {
        String string = this.separator();
        String string2 = "/";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return in;
        }
        return in.replace(this.separator(), "/");
    }

    public Option<RMLFileObject> getFile(String name) {
        Option option = CurrentUser$.MODULE$.get();
        if (option instanceof Some) {
            UserDB.User user = (UserDB.User)((Some)option).value();
            return this.getFile(user, Path$.MODULE$.apply(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(name), "repository:")));
        }
        if (None$.MODULE$.equals(option)) {
            throw new RuntimeException("CurrentUser is empty");
        }
        throw new MatchError((Object)option);
    }

    public Option<RMLFileObject> getFile(UserDB.User user, Path path) {
        this.log().debug(() -> RMLEngineRepository$.getFile$$anonfun$1(user, path), Line$.MODULE$.apply(38), FullName$.MODULE$.apply("ambience.rmlengine.local.RMLEngineRepository.getFile"));
        Task task = this.repository().getItemT(user, path).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Repository.RItem rItem = (Repository.RItem)((Some)option).value();
                return Some$.MODULE$.apply((Object)new RMLEngineFileObject(user, path, rItem));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
        Option ret = (Option)Await$.MODULE$.result((Awaitable)task.runToFuture((Scheduler)RMLEngineModule$.MODULE$.io()), (Duration)FiniteDuration$.MODULE$.apply(ReadTimeoutSecs, package$.MODULE$.SECONDS()));
        this.log().debug(() -> RMLEngineRepository$.getFile$$anonfun$2(user, path, ret), Line$.MODULE$.apply(46), FullName$.MODULE$.apply("ambience.rmlengine.local.RMLEngineRepository.getFile"));
        return ret;
    }

    public InputStream getInputStream(UserDB.User user, Path path) {
        this.log().debug(() -> RMLEngineRepository$.getInputStream$$anonfun$1(user, path), Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.rmlengine.local.RMLEngineRepository.getInputStream"));
        Task task = this.repository().readFileT(user, path).map((Function1 & Serializable)bytes -> new ByteArrayInputStream((byte[])bytes));
        ByteArrayInputStream ret = (ByteArrayInputStream)Await$.MODULE$.result((Awaitable)task.runToFuture((Scheduler)RMLEngineModule$.MODULE$.io()), (Duration)FiniteDuration$.MODULE$.apply(ReadTimeoutSecs, package$.MODULE$.SECONDS()));
        this.log().debug(() -> RMLEngineRepository$.getInputStream$$anonfun$2(user, path), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.rmlengine.local.RMLEngineRepository.getInputStream"));
        return ret;
    }

    public Observable<ReportEngine.TemplatePath> getRMLPaths(UserDB.User user) {
        return this.repository().getByExtensionO(user, "rml").map((Function1 & Serializable)path -> new ReportEngine.TemplatePath(ReportEngine.TemplatePath$.MODULE$.apply(path.toString())));
    }

    private static final Object getFile$$anonfun$1(UserDB.User user$1, Path path$1) {
        return "getFile(" + user$1.name() + " " + path$1.toString();
    }

    private static final Object getFile$$anonfun$2(UserDB.User user$3, Path path$3, Option ret$1) {
        return "getFile(" + user$3.name() + " " + path$3.toString() + " returns " + ret$1;
    }

    private static final Object getInputStream$$anonfun$1(UserDB.User user$4, Path path$4) {
        return "getInputStream(" + user$4.name() + " " + path$4.toString();
    }

    private static final Object getInputStream$$anonfun$2(UserDB.User user$5, Path path$5) {
        return "getInputStream(" + user$5.name() + " " + path$5.toString() + " completed";
    }
}

