/*
 * Decompiled with CFR 0.152.
 */
package ambience.simplesso.server;

import ambience.module.MaintenanceMode$;
import ambience.simplesso.SimpleSSOModule;
import ambience.simplesso.server.I18NHelper$;
import ambience.simplesso.server.ServerModel;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.typesafe.config.Config;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LoginForm
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LoginForm.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SimpleSSOModule module;
    private final Config ssoConfig;
    private final boolean Autocomplete;
    private final long MaxLoginDelay;

    public LoginForm(SimpleSSOModule module) {
        this.module = module;
        this.ssoConfig = module.config().getConfig("elixir.sso.server");
        this.Autocomplete = this.ssoConfig().getBoolean("login.autocomplete");
        this.MaxLoginDelay = this.ssoConfig().getDuration("max-login-delay", package$.MODULE$.MILLISECONDS());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config ssoConfig() {
        return this.ssoConfig;
    }

    public boolean Autocomplete() {
        return this.Autocomplete;
    }

    public long MaxLoginDelay() {
        return this.MaxLoginDelay;
    }

    public String loginHtml(String language) {
        Option option = this.module.webReply().buildHtml("simple-sso/login.html", language, I18NHelper$.MODULE$.lookup(language));
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return s;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(LoginForm::loginHtml$$anonfun$1, Line$.MODULE$.apply(24), FullName$.MODULE$.apply("ambience.simplesso.server.LoginForm.loginHtml"));
            return "!login.html not found!";
        }
        throw new MatchError((Object)option);
    }

    public String errorHtml(String language) {
        Option option = this.module.webReply().buildHtml("simple-sso/error.html", language, I18NHelper$.MODULE$.lookup(language));
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            return s;
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(LoginForm::errorHtml$$anonfun$1, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.simplesso.server.LoginForm.errorHtml"));
            return "!login.html not found!";
        }
        throw new MatchError((Object)option);
    }

    public Task<GravityResponse> buildForm(String language, ServerModel.ClientRecord crec, String rnd, boolean failedAlready) {
        return this.html(language, crec, rnd, failedAlready).map((Function1 & Serializable)s -> GravityResponse$.MODULE$.html(s));
    }

    public GravityResponse buildError(String language, String msg) {
        String reply = this.errorHtml(language).replace("@ERROR@", msg);
        return GravityResponse$.MODULE$.html(reply);
    }

    private Task<String> html(String language, ServerModel.ClientRecord crec, String rnd, boolean failedAlready) {
        return Task$.MODULE$.apply(() -> this.html$$anonfun$1(failedAlready, crec, language, rnd));
    }

    private static final Object loginHtml$$anonfun$1() {
        return "Can't find simple-sso/login.html";
    }

    private static final Object errorHtml$$anonfun$1() {
        return "Can't find simple-sso/error.html";
    }

    private static final String html$$anonfun$1$$anonfun$2() {
        return "";
    }

    private final String html$$anonfun$1(boolean failedAlready$1, ServerModel.ClientRecord crec$1, String language$1, String rnd$1) {
        None$ blockOpt = failedAlready$1 ? Some$.MODULE$.apply((Object)"failed-already") : None$.MODULE$;
        None$ mmOpt = MaintenanceMode$.MODULE$.isEnabled() ? Some$.MODULE$.apply((Object)"maintenance-mode") : None$.MODULE$;
        None$ totpOpt = crec$1.showTotpRow() ? Some$.MODULE$.apply((Object)"totp-row") : None$.MODULE$;
        String extraClasses = ((IterableOnceOps)((StrictOptimizedIterableOps)new .colon.colon((Object)blockOpt, (List)new .colon.colon((Object)mmOpt, (List)new .colon.colon((Object)totpOpt, (List)Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).mkString(" ");
        return this.loginHtml(language$1).replace("@CLIENTNAME@", crec$1.clientName()).replace("@CLIENTLANDING@", (CharSequence)crec$1.clientLandingPage().map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((ServerModel.ClientLandingPage)_$1).value()).getOrElse(LoginForm::html$$anonfun$1$$anonfun$2)).replace("@RNDVALUE@", rnd$1).replace("@AUTOCOMPLETE@", this.Autocomplete() ? "" : "autocomplete='off'").replace("@TIMEOUT@", BoxesRunTime.boxToLong((long)this.MaxLoginDelay()).toString()).replace("@EXTRA_CLASSES@", extraClasses);
    }
}

