/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.daemon;

import ambience.api.DaemonAPI;
import ambience.etl.daemon.AuditHelper$;
import ambience.etl.daemon.DaemonAPI$;
import ambience.etl.daemon.DaemonManager$;
import ambience.etl.daemon.Model;
import ambience.etl.daemon.action.KillAction;
import ambience.etl.daemon.action.RestartAction;
import ambience.etl.daemon.action.StartAction;
import ambience.etl.daemon.action.StopAction;
import ambience.etl.daemon.action.all.KillAllAction;
import ambience.etl.daemon.action.all.RestartAllAction;
import ambience.etl.daemon.action.all.StartAllAction;
import ambience.etl.daemon.action.all.StopAllAction;
import ambience.framework.SharedManager;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DaemonAPI
implements ambience.api.DaemonAPI,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaemonAPI.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public static DaemonAPI.Daemon fromDaemon(Model.Daemon daemon) {
        return DaemonAPI$.MODULE$.fromDaemon(daemon);
    }

    public static List<DaemonAPI.Daemon> fromDaemons(List<Model.Daemon> list) {
        return DaemonAPI$.MODULE$.fromDaemons(list);
    }

    public static Model.Daemon toDaemon(DaemonAPI.Daemon daemon) {
        return DaemonAPI$.MODULE$.toDaemon(daemon);
    }

    public static String toId(String string) {
        return DaemonAPI$.MODULE$.toId(string);
    }

    public static Set<Model.DaemonId> toIds(Set<DaemonAPI.DaemonId> set) {
        return DaemonAPI$.MODULE$.toIds(set);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<LogMessage, DaemonAPI.Daemon>> get(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> DaemonManager$.MODULE$.getDaemon(DaemonAPI$.MODULE$.toId(id)).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)lm);
            }
            if (either instanceof Right) {
                Model.Daemon d = (Model.Daemon)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)DaemonAPI$.MODULE$.fromDaemon(d));
            }
            throw new MatchError((Object)either);
        }));
    }

    public Task<Either<LogMessage, List<DaemonAPI.Daemon>>> getAll(UserDB.User user, Set<DaemonAPI.Status> statuses) {
        return this.withModUser(user, (Function0 & Serializable)() -> DaemonManager$.MODULE$.getByStatuses((Set<String>)((Set)statuses.map((Function1 & Serializable)_$3 -> _$3.value())))).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)lm);
            }
            if (either instanceof Right) {
                List list = (List)((Right)either).value();
                return package$.MODULE$.Right().apply(DaemonAPI$.MODULE$.fromDaemons((List<Model.Daemon>)list));
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> add(UserDB.User user, DaemonAPI.Daemon daemon) {
        return this.withModUser(user, (Function0 & Serializable)() -> {
            Model.Daemon daemon = (Model.Daemon)io.circe.syntax.package$.MODULE$.EncoderOps((Object)DaemonAPI$.MODULE$.toDaemon(daemon));
            String string = "_id";
            String string2 = "description";
            String string3 = "actual";
            String string4 = "preferred";
            String string5 = "autoplay";
            String string6 = "enabled";
            String string7 = "status";
            String string8 = "job";
            String string9 = "retryStrategy";
            return DaemonManager$.MODULE$.apply(SharedManager.Add$.MODULE$.apply(user, package.EncoderOps$.MODULE$.asJson$extension((Object)daemon, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(DaemonAPI::add$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string9).$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))))));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> delete(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> DaemonManager$.MODULE$.apply(SharedManager.Delete$.MODULE$.apply(user, id)));
    }

    public Task<Either<LogMessage, BoxedUnit>> start(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> new StartAction(DaemonAPI$.MODULE$.toId(id)).run().map((Function1 & Serializable)result -> this.audit(user, id, "API Started", (Either<LogMessage, BoxedUnit>)result)));
    }

    public Task<Either<LogMessage, BoxedUnit>> stop(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> new StopAction(DaemonAPI$.MODULE$.toId(id), true).run().map((Function1 & Serializable)result -> this.audit(user, id, "API Stopped", (Either<LogMessage, BoxedUnit>)result)));
    }

    public Task<Either<LogMessage, BoxedUnit>> restart(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> new RestartAction(DaemonAPI$.MODULE$.toId(id)).run().map((Function1 & Serializable)result -> this.audit(user, id, "API Restarted", (Either<LogMessage, BoxedUnit>)result)));
    }

    public Task<Either<LogMessage, BoxedUnit>> kill(UserDB.User user, String id) {
        return this.withModUser(user, (Function0 & Serializable)() -> new KillAction(DaemonAPI$.MODULE$.toId(id)).run().map((Function1 & Serializable)result -> this.audit(user, id, "API Killed", (Either<LogMessage, BoxedUnit>)result)));
    }

    public Task<Either<LogMessage, BoxedUnit>> startAll(UserDB.User user, Set<DaemonAPI.DaemonId> ids) {
        return this.withModUser(user, (Function0 & Serializable)() -> {
            String string = this.idsToString(ids);
            return new StartAllAction(DaemonAPI$.MODULE$.toIds(ids)).run().map((Function1 & Serializable)result -> this.audit(user, string, "API Started All", (Either<LogMessage, BoxedUnit>)result));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> stopAll(UserDB.User user, Set<DaemonAPI.DaemonId> ids) {
        return this.withModUser(user, (Function0 & Serializable)() -> {
            String string = this.idsToString(ids);
            return new StopAllAction(DaemonAPI$.MODULE$.toIds(ids), true).run().map((Function1 & Serializable)result -> this.audit(user, string, "API Stopped All", (Either<LogMessage, BoxedUnit>)result));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> restartAll(UserDB.User user, Set<DaemonAPI.DaemonId> ids) {
        return this.withModUser(user, (Function0 & Serializable)() -> {
            String string = this.idsToString(ids);
            return new RestartAllAction(DaemonAPI$.MODULE$.toIds(ids)).run().map((Function1 & Serializable)result -> this.audit(user, string, "API Restarted All", (Either<LogMessage, BoxedUnit>)result));
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> killAll(UserDB.User user, Set<DaemonAPI.DaemonId> ids) {
        return this.withModUser(user, (Function0 & Serializable)() -> {
            String string = this.idsToString(ids);
            return new KillAllAction(DaemonAPI$.MODULE$.toIds(ids)).run().map((Function1 & Serializable)result -> this.audit(user, string, "API Killed All", (Either<LogMessage, BoxedUnit>)result));
        });
    }

    public String idsToString(Set<DaemonAPI.DaemonId> ids) {
        return ((IterableOnceOps)ids.map((Function1 & Serializable)_$4 -> _$4 == null ? null : ((DaemonAPI.DaemonId)_$4).value())).mkString(",");
    }

    private Either<LogMessage, BoxedUnit> audit(UserDB.User user, String obj, String msg, Either<LogMessage, BoxedUnit> result) {
        Either<LogMessage, BoxedUnit> either = result;
        if (either instanceof Left) {
            LogMessage lm = (LogMessage)((Left)either).value();
            AuditHelper$.MODULE$.send(user, false, obj, msg, (Option<String>)Some$.MODULE$.apply((Object)lm.msg()));
            return ambience.arch.package$.MODULE$.left(lm);
        }
        if (either instanceof Right) {
            AuditHelper$.MODULE$.send(user, true, obj, msg, (Option<String>)None$.MODULE$);
            return ambience.arch.package$.MODULE$.RUnit();
        }
        throw new MatchError(either);
    }

    private <T> Task<Either<LogMessage, T>> withModUser(UserDB.User user, Function0<Task<Either<LogMessage, T>>> fn) {
        if (user.privileges().contains((Object)"mod-etl-daemon-api")) {
            return (Task)fn.apply();
        }
        return Task$.MODULE$.now((Object)ambience.arch.package$.MODULE$.leftError("User Doesn't have mod-etl-daemon-api privileges")).map((Function1 & Serializable)res -> {
            this.log().error(DaemonAPI::withModUser$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(148), FullName$.MODULE$.apply("ambience.etl.daemon.DaemonAPI.withModUser"));
            return res;
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeInt();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeInt();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeJson();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List add$$anonfun$1$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        Encoder encodeA6;
        Encoder encodeA7;
        void var3_2;
        void var1;
        Encoder encodeA8 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA9 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA7 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA6 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA5 = Encoder$.MODULE$.encodeBoolean();
        Encoder encoder4 = encodeA4 = Encoder$.MODULE$.encodeBoolean();
        Encoder encoder5 = encodeA3 = Encoder$.MODULE$.encodeString();
        String string = "chainset";
        String string2 = "chain";
        String string3 = "parameters";
        Encoder encoder6 = encodeA2 = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(DaemonAPI::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())));
        String string4 = "rtype";
        String string5 = "count";
        String string6 = "retriesRemaining";
        String string7 = "strategy";
        Encoder encoder7 = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(DaemonAPI::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4), Configuration$.MODULE$.default())));
        return package$.MODULE$.Nil().$colon$colon((Object)encoder7).$colon$colon((Object)encoder6).$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Object withModUser$$anonfun$1$$anonfun$1() {
        return "User Doesn't have mod-etl-daemon-api privileges";
    }
}

