/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.daemon;

import ambience.SystemScheduler$;
import ambience.etl.daemon.DaemonConfig$;
import ambience.etl.daemon.DaemonExecutor$;
import ambience.etl.daemon.DaemonLogger;
import ambience.etl.daemon.DaemonManager$;
import ambience.etl.daemon.Model;
import ambience.etl.daemon.SystemSettingsInfo;
import ambience.etl.daemon.sys.settings.SystemSettings$;
import ambience.framework.EventBus;
import ambience.framework.EventBus$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class DaemonLoop$
implements LoggingHelper2,
DaemonLogger,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DaemonLoop$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final long now;
    public static final DaemonLoop$ MODULE$;

    private DaemonLoop$() {
    }

    static {
        MODULE$ = new DaemonLoop$();
        now = System.currentTimeMillis();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DaemonLoop$.class);
    }

    public long now() {
        return now;
    }

    public boolean filterNow(EventBus.Message msg) {
        return msg.when() > this.now();
    }

    public boolean filterSystemId(EventBus.Message msg) {
        String string = msg.systemId();
        String string2 = DaemonConfig$.MODULE$.systemId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public void apply() {
        EventBus$.MODULE$.events((Function1 & Serializable)msg -> {
            if (!MODULE$.filterNow((EventBus.Message)msg)) return false;
            if (!MODULE$.filterSystemId((EventBus.Message)msg)) return false;
            String string = msg.eventType();
            String string2 = "kernel/ready";
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }, 100).take(1L).mapEval((Function1 & Serializable)_$1 -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            DaemonLoop$.apply$$anonfun$2$$anonfun$1();
            return BoxedUnit.UNIT;
        })).firstL().onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("loop event bus failed " + ex.getMessage())).runAsyncAndForget(SystemScheduler$.MODULE$.global());
    }

    private void run() {
        Task loopForeverTask = Task$.MODULE$.unit().delayExecution(DaemonConfig$.MODULE$.loopIntervalMs()).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.loopTask().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("loop failed " + ex.getMessage())).loopForever().onErrorRestartLoop((Object)BoxesRunTime.boxToInteger((int)10), (Function3 & Serializable)(ex, maxRetries, retry) -> DaemonLoop$.$anonfun$3((Throwable)ex, BoxesRunTime.unboxToInt((Object)maxRetries), (Function1)retry)).onErrorHandle((Function1 & Serializable)ex -> {
            MODULE$.error("loopForever failed " + ex.getMessage());
            return BoxedUnit.UNIT;
        });
        this.initTask().flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return loopForeverTask.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                Object object = x$1;
            });
        }).runAsyncAndForget(SystemScheduler$.MODULE$.global());
    }

    public Task<BoxedUnit> initTask() {
        return DaemonExecutor$.MODULE$.isDaemonRunner().flatMap((Function1 & Serializable)yesNo -> DaemonLoop$.initTask$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)yesNo)));
    }

    public Task<BoxedUnit> loopTask() {
        return DaemonExecutor$.MODULE$.isDaemonRunner().flatMap((Function1 & Serializable)yesNo -> DaemonLoop$.loopTask$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)yesNo)));
    }

    private Task<BoxedUnit> takeDaemons(boolean isStartup) {
        return this.takePreferredDaemons(isStartup).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.unit().delayExecution(DaemonConfig$.MODULE$.nonPreferredDaemonDelayMs()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.takeNonPreferredDaemons().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private Task<BoxedUnit> takePreferredDaemons(boolean isStartup) {
        return this.infoT("Taking Preferred Daemons isStartup:" + isStartup).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return DaemonExecutor$.MODULE$.startPreferredDaemons(isStartup).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("takePreferredDaemons failed " + ex.getMessage()));
    }

    private Task<BoxedUnit> takeNonPreferredDaemons() {
        return this.infoT("Taking Non Preferred Daemons").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.tailRecM((Object)new Model.DaemonId(Model.DaemonId$.MODULE$.apply("")), (Function1 & Serializable)id -> this.takeNonPreferredDaemons$$anonfun$1$$anonfun$1(id == null ? null : ((Model.DaemonId)id).value())).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("takeNonPreferredDaemons failed " + ex.getMessage()));
    }

    private Task<BoxedUnit> reclaimDaemons() {
        return this.infoT("Reclaiming Daemons").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return DaemonManager$.MODULE$.reclaimDaemons(DaemonExecutor$.MODULE$.getCurrentDaemonsIds()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("reclaimDaemons failed " + ex.getMessage()));
    }

    private Task<BoxedUnit> bumpAlive() {
        return this.infoT("Bumping Alive").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return DaemonManager$.MODULE$.bumpAlive(DaemonExecutor$.MODULE$.getCurrentDaemonsIds()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("bumpAlive failed " + ex.getMessage()));
    }

    private Task<BoxedUnit> resetRetries() {
        return this.infoT("Reset Retries").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return DaemonManager$.MODULE$.resetRetries(DaemonExecutor$.MODULE$.getCurrentDaemonsIds()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("resetRetries failed " + ex.getMessage()));
    }

    private Task<BoxedUnit> resetDaemons() {
        return this.infoT("ResetActualNotInDaemonRunners").flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return SystemSettings$.MODULE$.fetchSettings().map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    return package$.MODULE$.Nil();
                }
                if (either instanceof Right) {
                    SystemSettingsInfo settings = (SystemSettingsInfo)((Right)either).value();
                    return settings.daemonRunners();
                }
                throw new MatchError((Object)either);
            }).flatMap((Function1 & Serializable)list -> DaemonManager$.MODULE$.getNotInDaemonRunners((Set<String>)list.toSet()).flatMap((Function1 & Serializable)notInIds -> MODULE$.infoT("ResetActual list:" + notInIds.mkString(",")).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.sequence((Iterable)notInIds.map((Function1 & Serializable)id -> DaemonManager$.MODULE$.resetRetries(id == null ? null : ((Model.DaemonId)id).value(), true)), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)x$1 -> {
                    List list = x$1;
                    return DaemonManager$.MODULE$.getDaemonRunnersToReset().flatMap((Function1 & Serializable)resetIds -> MODULE$.infoT("Reset list:" + resetIds.mkString(",")).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return Task$.MODULE$.sequence((Iterable)resetIds.map((Function1 & Serializable)id -> DaemonManager$.MODULE$.resetRetries(id == null ? null : ((Model.DaemonId)id).value(), true)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            List list = x$1;
                        });
                    }));
                });
            })));
        }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("resetDaemons failed " + ex.getMessage()));
    }

    private static final void apply$$anonfun$2$$anonfun$1() {
        MODULE$.run();
    }

    private static final /* synthetic */ Task $anonfun$3(Throwable ex, int maxRetries, Function1 retry) {
        MODULE$.error("loop error failed " + ex.getMessage());
        if (maxRetries > 0) {
            return ((Task)retry.apply((Object)BoxesRunTime.boxToInteger((int)(maxRetries - 1)))).delayExecution(DaemonConfig$.MODULE$.loopRestartDelayMs());
        }
        return Task$.MODULE$.raiseError(ex);
    }

    private static final /* synthetic */ Task initTask$$anonfun$1(boolean yesNo) {
        if (yesNo) {
            return Task$.MODULE$.unit().delayExecution(DaemonConfig$.MODULE$.startDelayMs()).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.resetDaemons().flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.reclaimDaemons().flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return MODULE$.takeDaemons(true).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            });
        }
        return Task$.MODULE$.unit();
    }

    private static final Object loopTask$$anonfun$1$$anonfun$1(int count$1) {
        return "Running (" + count$1 + ") Daemons";
    }

    private static final Object loopTask$$anonfun$1$$anonfun$2(int count$2) {
        return "Running (" + count$2 + ") Daemons";
    }

    private static final /* synthetic */ Task loopTask$$anonfun$1(boolean yesNo) {
        if (yesNo) {
            BoxedUnit boxedUnit;
            int count = DaemonExecutor$.MODULE$.getCurrentDaemonsIds().size();
            if (count > 0) {
                MODULE$.log().info(() -> DaemonLoop$.loopTask$$anonfun$1$$anonfun$1(count), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.etl.daemon.DaemonLoop.loopTask"));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                MODULE$.log().debug(() -> DaemonLoop$.loopTask$$anonfun$1$$anonfun$2(count), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.etl.daemon.DaemonLoop.loopTask"));
                boxedUnit = BoxedUnit.UNIT;
            }
            return Task$.MODULE$.now((Object)boxedUnit).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.reclaimDaemons().flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.bumpAlive().flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return MODULE$.resetRetries().flatMap((Function1 & Serializable)x$12 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return MODULE$.takeDaemons(false).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            });
                        });
                    });
                });
            }).onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> MODULE$.error("loop failed " + ex.getMessage()));
        }
        return DaemonExecutor$.MODULE$.stopAllDaemons();
    }

    private final Task doTake$1(String id) {
        return DaemonExecutor$.MODULE$.startNonPreferredDaemon().onErrorHandle((Function1 & Serializable)ex -> {
            MODULE$.error("startNonPreferredDaemon failed " + ex.getMessage());
            return Some$.MODULE$.apply((Object)new Model.DaemonId(id));
        }).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Object object = ((Some)option).value();
                String id = object == null ? null : ((Model.DaemonId)object).value();
                MODULE$.debug("Non Preferred Daemons " + new Model.DaemonId(id) + " found");
                return package$.MODULE$.Left().apply((Object)new Model.DaemonId(id));
            }
            if (None$.MODULE$.equals(option)) {
                MODULE$.debug("No more Non Preferred Daemons found");
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            throw new MatchError((Object)option);
        }).delayExecution(DaemonConfig$.MODULE$.nonPreferredDaemonTakeIntervalMs());
    }

    private final /* synthetic */ Task takeNonPreferredDaemons$$anonfun$1$$anonfun$1(String id) {
        return this.doTake$1(id);
    }
}

